/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public abstract class NameReference
extends Reference
implements InvocationSite {
    public Binding binding;
    public TypeBinding actualReceiverType;

    public NameReference() {
        this.bits |= 7;
    }

    @Override
    public FieldBinding fieldBinding() {
        return (FieldBinding)this.binding;
    }

    @Override
    public FieldBinding lastFieldBinding() {
        if ((this.bits & 7) == 1) {
            return this.fieldBinding();
        }
        return null;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return this.binding == null || (this.binding.kind() & 4) != 0;
    }

    @Override
    public boolean isTypeReference() {
        return this.binding instanceof ReferenceBinding;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    @Override
    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    @Override
    public void setFieldIndex(int n) {
    }

    public abstract String unboundReferenceErrorName();

    public abstract char[][] getName();

    public boolean checkEffectiveFinality(VariableBinding variableBinding, Scope scope) {
        Predicate<VariableBinding> predicate = variableBinding2 -> !variableBinding.isFinal() && !variableBinding.isEffectivelyFinal();
        if ((this.bits & 0x80000) != 0) {
            if (predicate.test(variableBinding)) {
                scope.problemReporter().cannotReferToNonEffectivelyFinalOuterLocal(variableBinding, this);
                throw new AbortMethod(scope.referenceCompilationUnit().compilationResult, null);
            }
            return true;
        }
        if ((this.bits & 0x40) != 0 && predicate.test(variableBinding)) {
            scope.problemReporter().cannotReferToNonFinalLocalInGuard(variableBinding, this);
            throw new AbortMethod(scope.referenceCompilationUnit().compilationResult, null);
        }
        return false;
    }

    @Override
    public boolean isType() {
        return (this.bits & 4) != 0;
    }
}

