/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.util;

import java.util.Set;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteRequestType;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteCacheRequestFactory {
    private static final Log log = LogManager.getLog(RemoteCacheRequestFactory.class);

    private static <K, V> RemoteCacheRequest<K, V> createRequest(String cacheName, RemoteRequestType requestType, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setRequestType(requestType);
        request.setRequesterId(requesterId);
        log.debug("Created: {0}", request);
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createGetRequest(String cacheName, K key, long requesterId) {
        RemoteCacheRequest<K, V> request = RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.GET, requesterId);
        request.setKey(key);
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createGetMatchingRequest(String cacheName, String pattern, long requesterId) {
        RemoteCacheRequest<K, V> request = RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.GET_MATCHING, requesterId);
        request.setPattern(pattern);
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createGetMultipleRequest(String cacheName, Set<K> keys, long requesterId) {
        RemoteCacheRequest<K, V> request = RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.GET_MULTIPLE, requesterId);
        request.setKeySet(keys);
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createRemoveRequest(String cacheName, K key, long requesterId) {
        RemoteCacheRequest<K, V> request = RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.REMOVE, requesterId);
        request.setKey(key);
        return request;
    }

    public static RemoteCacheRequest<String, String> createGetKeySetRequest(String cacheName, long requesterId) {
        RemoteCacheRequest<String, String> request = RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.GET_KEYSET, requesterId);
        request.setKey(cacheName);
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createRemoveAllRequest(String cacheName, long requesterId) {
        return RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.REMOVE_ALL, requesterId);
    }

    public static <K, V> RemoteCacheRequest<K, V> createDisposeRequest(String cacheName, long requesterId) {
        return RemoteCacheRequestFactory.createRequest(cacheName, RemoteRequestType.DISPOSE, requesterId);
    }

    public static <K, V> RemoteCacheRequest<K, V> createUpdateRequest(ICacheElement<K, V> cacheElement, long requesterId) {
        RemoteCacheRequest<K, V> request = RemoteCacheRequestFactory.createRequest(null, RemoteRequestType.UPDATE, requesterId);
        if (cacheElement != null) {
            request.setCacheName(cacheElement.getCacheName());
            request.setCacheElement(cacheElement);
            request.setKey(cacheElement.getKey());
        } else {
            log.error("Can't create a proper update request for a null cache element.");
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createAliveCheckRequest(long requesterId) {
        return RemoteCacheRequestFactory.createRequest(null, RemoteRequestType.ALIVE_CHECK, requesterId);
    }
}

