<%
    import datetime
    [protover_major, protover_minor, *_] = config.rfnoc_version.split('.')
%>//
% if hasattr(config, 'copyright'):
// ${config.copyright}
//
% endif
% if hasattr(config, 'license'):
// ${config.license}
//
% endif
// Module: rfnoc_image_core (for ${config.device.type})
//
// Description:
//
//   The RFNoC Image Core contains the Verilog description of the RFNoC design
//   to be loaded onto the FPGA.
//
//   This file was automatically generated by the RFNoC image builder tool.
//   Re-running that tool will overwrite this file!
//
% if args.get('source'):
// Source: ${args.get('source')}
% endif
%if not args.get('no_date'):
// File generated on: ${datetime.datetime.now().isoformat()}
% endif
% if args.get('source_hash') and not args.get('no_hash'):
// Source SHA256: ${args.get('source_hash')}
% endif
//

`default_nettype none


module rfnoc_image_core #(
  parameter [31:0] CHDR_W     = ${config.chdr_width},
  parameter [31:0] PORT_W     = ${config.chdr_width},
%for port in config.device.transports:
  parameter [31:0] ${'{:<10}'.format(port["name"].upper() + "_W")} = ${port["width"]},
%endfor
  parameter        MTU        = 10,
  parameter [15:0] PROTOVER   = {8'd${protover_major}, 8'd${protover_minor}},
  parameter        RADIO_NIPC = 1
) (
  // Clocks
  input  wire         chdr_aclk,
  input  wire         ctrl_aclk,
  input  wire         core_arst,
%for clock in config.device.clocks:
  input  wire         ${clock["name"]}_clk,
%endfor
  // Basic
  input  wire [  15:0] device_id,

<%include file="/modules/device_io_ports.v.mako" args="io_ports=config.device.io_ports"/>\
<%include file="/modules/device_transport.v.mako" args="transports=config.device.transports"/>\
);

  localparam EDGE_TBL_FILE = `"`RFNOC_EDGE_TBL_FILE`";
  localparam BLOCK_CHDR_W  = ${config.block_chdr_width};
  localparam BYTE_MTU      = MTU + $clog2(CHDR_W/8);
  localparam BLOCK_MTU     = BYTE_MTU - $clog2(BLOCK_CHDR_W/8);
%for i, sep in enumerate(config.stream_endpoints):
<%
  ep_name = sep.upper()
%>\
  localparam ${ep_name + "_W"}   = ${config.stream_endpoints[sep]['chdr_width']};
  localparam ${ep_name + "_MTU"} = BYTE_MTU - $clog2(${ep_name + "_W"}/8);
%endfor

  wire rfnoc_chdr_clk, rfnoc_chdr_rst;
  wire rfnoc_ctrl_clk, rfnoc_ctrl_rst;


  //---------------------------------------------------------------------------
  // CHDR Crossbar
  //---------------------------------------------------------------------------

<%include file="/modules/sep_xb_wires.v.mako" args="seps=config.stream_endpoints"/>\
<%
  import numpy as np
  # Generate the list of CHDR widths for the crossbar ports
  cb_port_widths = "{"
  for sep in reversed(config.stream_endpoints):
    cb_port_widths += sep.upper() + "_W, "
  for transport in reversed(config.device.transports):
    cb_port_widths += transport["name"].upper() + "_W, "
  cb_port_widths = cb_port_widths[:-2] + "}"
  num_ports = len(config.stream_endpoints) + len(config.device.transports)
  # Convert the crossbar routes to a Verilog bit vector
  routes = np.flip(np.array(config.crossbar_routes).astype(int))
  routes_vector = "{ "
  indent = ""
  for row in range(num_ports):
    row_bits = "".join(str(b) for b in routes[row])
    routes_vector += f"{indent}{num_ports}'b{row_bits}"
    indent = 23*' '
    if row < num_ports-1:
      routes_vector += ",\n"
  routes_vector += " }"
%>\

  chdr_crossbar_nxn #(
    .PORT_W         (PORT_W),
    .NPORTS         (${num_ports}),
    .CHDR_WIDTHS    (${cb_port_widths}),
    .DEFAULT_PORT   (0),
    .ROUTES         (${routes_vector}),
    .BYTE_MTU       (BYTE_MTU),
    .ROUTE_TBL_SIZE (6),
    .MUX_ALLOC      ("ROUND-ROBIN"),
    .OPTIMIZE       ("AREA"),
    .NPORTS_MGMT    (${len(config.device.transports)}),
    .EXT_RTCFG_PORT (0),
    .PROTOVER       (PROTOVER)
  ) chdr_crossbar_nxn_i (
    .clk            (rfnoc_chdr_clk),
    .reset          (rfnoc_chdr_rst),
    .device_id      (device_id),
<%include file="/modules/chdr_xb_sep_transport.v.mako" args="seps=config.stream_endpoints, transports=config.device.transports, routes=routes"/>\
    .ext_rtcfg_stb  (1'h0),
    .ext_rtcfg_addr (16'h0),
    .ext_rtcfg_data (32'h0),
    .ext_rtcfg_ack  ()
  );


  //---------------------------------------------------------------------------
  // Stream Endpoints
  //---------------------------------------------------------------------------

<%include file="/modules/stream_endpoints.v.mako" args="seps=config.stream_endpoints"/>\
<%
    from collections import OrderedDict
    ctrl_seps = OrderedDict((k, v) for k, v in config.stream_endpoints.items() if v.get('ctrl'))
%>
  //---------------------------------------------------------------------------
  // Control Crossbar
  //---------------------------------------------------------------------------

  wire [31:0] m_core_ctrl_tdata,  s_core_ctrl_tdata;
  wire        m_core_ctrl_tlast,  s_core_ctrl_tlast;
  wire        m_core_ctrl_tvalid, s_core_ctrl_tvalid;
  wire        m_core_ctrl_tready, s_core_ctrl_tready;
<%include file="/modules/ctrl_crossbar.v.mako" args="seps=ctrl_seps, blocks=config.noc_blocks"/>\


  //---------------------------------------------------------------------------
  // RFNoC Core Kernel
  //---------------------------------------------------------------------------

  wire [(512*${len(config.noc_blocks)})-1:0] rfnoc_core_config, rfnoc_core_status;

  rfnoc_core_kernel #(
    .PROTOVER            (PROTOVER),
    .DEVICE_TYPE         (16'h${config.device.type_id}),
    .DEVICE_FAMILY       ("${config.device.family}"),
    .SAFE_START_CLKS     (0),
    .NUM_BLOCKS          (${len(config.noc_blocks)}),
    .NUM_STREAM_ENDPOINTS(${len(config.stream_endpoints)}),
    .NUM_ENDPOINTS_CTRL  (${len(ctrl_seps)}),
    .NUM_TRANSPORTS      (${len(config.device.transports)}),
    .NUM_EDGES           (${len(config.block_con)}),
    .CHDR_XBAR_PRESENT   (1),
    .EDGE_TBL_FILE       (EDGE_TBL_FILE)
  ) core_kernel_i (
    .chdr_aclk          (chdr_aclk),
    .chdr_aclk_locked   (1'b1),
    .ctrl_aclk          (ctrl_aclk),
    .ctrl_aclk_locked   (1'b1),
    .core_arst          (core_arst),
    .core_chdr_clk      (rfnoc_chdr_clk),
    .core_chdr_rst      (rfnoc_chdr_rst),
    .core_ctrl_clk      (rfnoc_ctrl_clk),
    .core_ctrl_rst      (rfnoc_ctrl_rst),
    .s_axis_ctrl_tdata  (s_core_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_core_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_core_ctrl_tvalid),
    .s_axis_ctrl_tready (s_core_ctrl_tready),
    .m_axis_ctrl_tdata  (m_core_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_core_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_core_ctrl_tvalid),
    .m_axis_ctrl_tready (m_core_ctrl_tready),
    .device_id          (device_id),
    .rfnoc_core_config  (rfnoc_core_config),
    .rfnoc_core_status  (rfnoc_core_status)
  );


  //---------------------------------------------------------------------------
  // Blocks
  //---------------------------------------------------------------------------
%for i, name in enumerate(config.noc_blocks):
<%include file="/modules/rfnoc_block.v.mako" args="block_id=i + len(ctrl_seps) + 1, block_number=i, block_name=name, block=config.blocks[config.noc_blocks[name]['block_desc']], block_params=config.noc_blocks[name]['parameters'], block_ports=config.block_ports"/>\
%endfor

  //---------------------------------------------------------------------------
  // Static Router
  //---------------------------------------------------------------------------

<%include file="/modules/static_router.v.mako" args="connections=config.block_con"/>\

  //---------------------------------------------------------------------------
  // Unused Ports
  //---------------------------------------------------------------------------

<%include file="/modules/drive_unused_ports.v.mako" args="connections=config.block_con, block_ports=config.block_ports"/>\


  //---------------------------------------------------------------------------
  // Clock Domains
  //---------------------------------------------------------------------------

<%include file="/modules/connect_clk_domains.v.mako" args="connections=config.clk_domain_con, clocks=config.clocks"/>\


  //---------------------------------------------------------------------------
  // IO Port Connection
  //---------------------------------------------------------------------------

  // Master/Slave Connections:
<%include file="/modules/connect_io_ports.v.mako" args="connections=config.io_port_con_ms, io_ports=config.io_ports, names=('master', 'slave')"/>\
  // Broadcaster/Listener Connections:
<%include file="/modules/connect_io_ports.v.mako" args="connections=config.io_port_con_bl, io_ports=config.io_ports, names=('broadcaster', 'listener')"/>\
endmodule


`default_nettype wire
