/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_rm extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestic";
        final String metaValue_ar = "arab";
        final String metaValue_bn = "bengal";
        final String metaValue_bo = "tibetan";
        final String metaValue_el = "grec";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraic";
        final String metaValue_hy = "armen";
        final String metaValue_ja = "giapunais";
        final String metaValue_jv = "javanais";
        final String metaValue_ka = "georgian";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "corean";
        final String metaValue_la = "latin";
        final String metaValue_lo = "laot";
        final String metaValue_mn = "mongolic";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singalais";
        final String metaValue_su = "sundanais";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandais";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinais";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "coptic";
        final String metaValue_got = "gotic";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_peo = "persian vegl";
        final String metaValue_phn = "fenizian";
        final String metaValue_syr = "siric";
        final String metaValue_uga = "ugaritic";
        final String metaValue_zbl = "simbols da Bliss";
        final Object[][] data = new Object[][] {
            { "Ogam", "ogham" },
            { "mwl", "mirandais" },
            { "Zsym", "simbols" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "dialect da Gniva" },
            { "egy", "egipzian vegl" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emirats Arabs Unids" },
            { "nl_BE", "flam" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentinia" },
            { "Prti", "partic dad inscripziuns" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "englais american" },
            { "AX", "Inslas Aland" },
            { "AZ", "Aserbaidschan" },
            { "%%AREVELA", "armen oriental" },
            { "BA", "Bosnia ed Erzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesch" },
            { "kum", "kumuk" },
            { "BE", "Belgia" },
            { "gmh", "tudestg mesaun" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Son Barth\u00e9lemy" },
            { "BM", "Bermudas" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BR", "Brasilia" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Insla Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "Visp", "alfabet visibel" },
            { "CA", "Canada" },
            { "CC", "Inslas Cocos" },
            { "CD", "Republica Democratica dal Congo" },
            { "CF", "Republica Centralafricana" },
            { "CG", "Congo" },
            { "CH", "Svizra" },
            { "CI", "Costa d\u2019Ivur" },
            { "CK", "Inslas Cook" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Columbia" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap Verd" },
            { "CX", "Insla da Christmas" },
            { "CY", "Cipra" },
            { "CZ", "Republica Tscheca" },
            { "eka", "ekajuk" },
            { "DE", "Germania" },
            { "goh", "vegl tudestg da scrittira" },
            { "ace", "aceh" },
            { "DJ", "Dschibuti" },
            { "DK", "Danemarc" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "scrittira da Braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meetei mayek" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "andangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Egipta" },
            { "EH", "Sahara Occidentala" },
            { "chg", "tschagataic" },
            { "pau", "palau" },
            { "chk", "chuukais" },
            { "chn", "patu\u00e0 chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Uniun europeica" },
            { "elx", "elamitic" },
            { "type.ca.gregorian", "chalender gregorian" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adygai" },
            { "FI", "Finlanda" },
            { "FJ", "Fidschi" },
            { "FK", "Inslas dal Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Inslas Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Frantscha" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "type.ca.indian", "chalender naziunal indic" },
            { "grc", "grec vegl" },
            { "GA", "Gabun" },
            { "vot", "votic" },
            { "GB", "Reginavel Un\u00ec" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Franzosa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nlanda" },
            { "enm", "englais mesaun" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Equatoriala" },
            { "GR", "Grezia" },
            { "GS", "Georgia dal Sid e las Inslas Sandwich dal Sid" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingonic" },
            { "Talu", "tai lue" },
            { "GY", "Guyana" },
            { "zxx", "nagins cuntegns linguistics" },
            { "de_AT", "tudestg austriac" },
            { "HK", "Regiun d\u2019administraziun speziala da Hongkong, China" },
            { "Vaii", "vaii" },
            { "HM", "Inslas da Heard e da McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croazia" },
            { "gsw", "tudestg svizzer" },
            { "HT", "Haiti" },
            { "HU", "Ungaria" },
            { "tmh", "tamasheq" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "nap", "neapolitan" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Insla da Man" },
            { "IN", "India" },
            { "IO", "Territori Britannic en l\u2019Ocean Indic" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "Zmth", "notaziun matematica" },
            { "%%POSIX", "computer" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "chalender islamic" },
            { "Beng", metaValue_bn },
            { "JM", "Giamaica" },
            { "JO", "Jordania" },
            { "JP", "Giapun" },
            { "%%1606NICT", "franzos mesaun tardiv (fin 1606)" },
            { "ain", "ainu" },
            { "tog", "lingua tsonga" },
            { "Kali", "kayah li" },
            { "type.ca.buddhist", "chalender budistic" },
            { "KE", "Kenia" },
            { "419", "America Latina" },
            { "KG", "Kirghisistan" },
            { "KH", "Cambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts e Nevis" },
            { "Zinh", "ert\u00e0" },
            { "fr_CA", "franzos canadais" },
            { "KP", "Corea dal Nord" },
            { "KR", "Corea dal Sid" },
            { "Plrd", "fonetica da Pollard" },
            { "fr_CH", "franzos svizzer" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Inslas Cayman" },
            { "KZ", "Kasachstan" },
            { "Cyrl", "cirillic" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "slav da baselgia vegl" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "bass tudestg" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "accadic" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlavi da cudeschs" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Lettonia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "Thaa", "thaana" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Inslas da Marshall" },
            { "ale", "aleutic" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Regiun d\u2019administraziun speziala Macao, China" },
            { "MP", "Inslas Mariannas dal Nord" },
            { "MQ", "Martinique" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "altaic dal sid" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "chalender giapunais" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambic" },
            { "Phli", "pahlavi dad inscripziuns" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "chalender ebraic" },
            { "NC", "Nova Caledonia" },
            { "NE", "Niger" },
            { "NF", "Insla Norfolk" },
            { "NG", "Nigeria" },
            { "Phlp", "pahlavi da psalms" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawn hmong" },
            { "NL", "Pajais Bass" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "tsi", "tsimshian" },
            { "NZ", "Nova Zelanda" },
            { "rom", "romani" },
            { "Mero", "meroitic" },
            { "crh", "tirc crimean" },
            { "ang", "englais vegl" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "chalender islamic civil" },
            { "csb", "kaschubic" },
            { "en_GB", "englais britannic" },
            { "PE", "Peru" },
            { "PF", "Polinesia Franzosa" },
            { "PG", "Papua Nova Guinea" },
            { "PH", "Filippinas" },
            { "PK", "Pakistan" },
            { "PL", "Pologna" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Territori Palestinais" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguai" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "%%SCOTLAND", "englais da standard scot" },
            { "niu", "niue" },
            { "QO", "Oceania Periferica" },
            { "lez", "lezghian" },
            { "%%FONUPA", "alfabet fonetic da l\u2019Ural (UPA)" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "mund" },
            { "002", "Africa" },
            { "003", "America dal Nord" },
            { "RE", "R\u00e9union" },
            { "005", "America dal Sid" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "RO", "Rumenia" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "manicheic" },
            { "Khar", "kharoshthi" },
            { "SA", "Arabia Saudita" },
            { "pon", "ponapean" },
            { "Mand", "mandaic" },
            { "SB", "Salomonas" },
            { "011", "Africa dal Vest" },
            { "SC", "Seychellas" },
            { "SD", "Sudan" },
            { "013", "America Centrala" },
            { "SE", "Svezia" },
            { "014", "Africa da l\u2019Ost" },
            { "arc", "arameic" },
            { "015", "Africa dal Nord" },
            { "SG", "Singapur" },
            { "SH", "Sontg\u2019Elena" },
            { "017", "Africa Centrala" },
            { "SI", "Slovenia" },
            { "018", "Africa Meridiunala" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "America dal Nord, America Centrala ed America dal Sid" },
            { "SK", "Slovachia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "araucanic" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "ST", "S\u00e3o Tom\u00e9 e Principe" },
            { "SV", "El Salvador" },
            { "SY", "Siria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "yap", "yapais" },
            { "TC", "Inslas Turks e Caicos" },
            { "TD", "Tschad" },
            { "TF", "Territoris Franzos Meridiunals" },
            { "TG", "Togo" },
            { "TH", "Tailanda" },
            { "TJ", "Tadschikistan" },
            { "029", "Caribica" },
            { "TK", "Tokelau" },
            { "TL", "Timor da l\u2019Ost" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "dialect boontling" },
            { "TN", "Tunesia" },
            { "TO", "Tonga" },
            { "TR", "Tirchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturian" },
            { "Orkh", "orkhon" },
            { "TZ", "Tansania" },
            { "Zzzz", "scrittira nunenconuschenta u nunvalaivla" },
            { "UA", "Ucraina" },
            { "rup", "aromunic" },
            { "030", "Asia da l\u2019Ost" },
            { "tyv", "tuvinian" },
            { "034", "Asia dal Sid" },
            { "hai", "haida" },
            { "035", "Asia dal Sidost" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinyin" },
            { "039", "Europa dal Sid" },
            { "Sinh", metaValue_si },
            { "UM", "Inslas pitschnas perifericas dals Stadis Unids da l\u2019America" },
            { "US", "Stadis Unids da l\u2019America" },
            { "haw", "hawaian" },
            { "type.co.gb2312han", "chinaisa simplifitgada - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "type.co.stroke", "urden dals stritgs" },
            { "VA", "Citad dal Vatican" },
            { "pro", "provenzal vegl" },
            { "VC", "Saint Vincent e las Grenadinas" },
            { "VE", "Venezuela" },
            { "VG", "Inslas Virginas Britannicas" },
            { "VI", "Inslas Virginas Americanas" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "non", "nordic vegl" },
            { "053", "Australia e Nova Zelanda" },
            { "%%AREVMDA", "armen occidental" },
            { "054", "Melanesia" },
            { "WF", "Wallis e Futuna" },
            { "type.co.traditional", "reglas tradiziunalas" },
            { "057", "Regiun Micronesica" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinesia" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "linguas na scrittas" },
            { "Olck", "ol chiki" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "fan", "fang" },
            { "%%ROZAJ", "dialect da Resia" },
            { "fat", "fanti" },
            { "Sgnw", "lingua da segns" },
            { "YT", "Mayotte" },
            { "ZA", "Africa dal Sid" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Regiun betg encouschenta u nunvalaivla" },
            { "Runr", "runic" },
            { "lol", "lomongo" },
            { "nso", "sotho dal nord" },
            { "loz", "lozi" },
            { "hil", "hiligaynon" },
            { "dak", "dakota" },
            { "hit", "ettitic" },
            { "dar", "dargwa" },
            { "Maya", "ieroglifas maya" },
            { "Copt", metaValue_cop },
            { "nwc", "newari classic" },
            { "udm", "udmurt" },
            { "Khmr", "khmer/cambodschan" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "jakut" },
            { "sam", "arameic samaritan" },
            { "%%SCOUSE", "dialect scouse" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "giudaic-persian" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "belutschi" },
            { "den", "slavey" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "bas", "basaa" },
            { "jrb", "giudaic-arab" },
            { "es_ES", "spagnol iberic" },
            { "nzi", "nzima" },
            { "sco", "scot" },
            { "scn", "sicilian" },
            { "aa", "afar" },
            { "ab", "abchasian" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amaric" },
            { "Arab", metaValue_ar },
            { "an", "aragonais" },
            { "%%SOLBA", "dialect da Stolvizza" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katanaka u hiragana" },
            { "as", "assami" },
            { "Lina", "linear A" },
            { "av", "avaric" },
            { "Linb", "linear B" },
            { "ay", "aymara" },
            { "az", "aserbeidschanic" },
            { "%%OSOJS", "dialect da Oscacco" },
            { "ba", "baschkir" },
            { "be", "bieloruss" },
            { "bg", "bulgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "breton" },
            { "bs", "bosniac" },
            { "Mymr", "burmais" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catalan" },
            { "ce", "tschetschen" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortografia revedida" },
            { "co", "cors" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tschec" },
            { "cu", "slav da baselgia" },
            { "cv", "tschuvasch" },
            { "cy", "kimric" },
            { "Yiii", "yi" },
            { "da", "danais" },
            { "pt_PT", "portugais iberian" },
            { "de", "tudestg" },
            { "bej", "bedscha" },
            { "din", "dinka" },
            { "Bugi", "buginais" },
            { "bem", "bemba" },
            { "sga", "irlandais vegl" },
            { "dv", "maledivic" },
            { "es_419", "spagnol latinamerican" },
            { "dz", "dzongkha" },
            { "type.ca.chinese", "chalender chinais" },
            { "ee", "ewe" },
            { "ro_MD", "moldav" },
            { "el", metaValue_el },
            { "en", "englais" },
            { "eo", "esperanto" },
            { "type.co.big5han", "chinaisa tradiziunala - Big5" },
            { "es", "spagnol" },
            { "et", "eston" },
            { "eu", "basc" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritan" },
            { "hsb", "aut sorb" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persian" },
            { "Hans", "scrittira chinaisa simplifitgada" },
            { "Hant", "scrittira chinaisa tradiziunala" },
            { "ff", "fulah" },
            { "fi", "finlandais" },
            { "fj", "fidschian" },
            { "fon", "fon" },
            { "fo", "ferrais" },
            { "umb", "mbundu" },
            { "fr", "franzos" },
            { "sid", "sidamo" },
            { "fy", "fris" },
            { "ga", "irlandais" },
            { "gd", "gaelic scot" },
            { "gl", "galician" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "linguas betg determinadas" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croat" },
            { "ht", "haitian" },
            { "hu", "ungarais" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "%%FONIPA", "alfabet fonetic internaziunal (IPA)" },
            { "ia", "interlingua" },
            { "id", "indonais" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "frm", "franzos mesaun" },
            { "ik", "inupiak" },
            { "fro", "franzos vegl" },
            { "io", "ido" },
            { "frs", "fris da l\u2019ost" },
            { "frr", "fris dal nord" },
            { "is", "islandais" },
            { "it", "talian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", "malaisian" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sma", "sami dal sid" },
            { "jv", metaValue_jv },
            { "Shaw", "shavian" },
            { "mad", "madurais" },
            { "smj", "sami lule" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "sami inari" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makassar" },
            { "sms", "sami skolt" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "casac" },
            { "kl", "gr\u00f6nlandais" },
            { "km", "cambodschan" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "curd" },
            { "kv", "komi" },
            { "kw", "cornic" },
            { "ky", "kirghis" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "luxemburgais" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgais" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulan" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "sog", "sogdian" },
            { "mg", "malagassi" },
            { "mh", "marschallais" },
            { "mi", "maori" },
            { "mk", "macedon" },
            { "ml", "malayalam" },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaic" },
            { "mt", "maltais" },
            { "my", "birman" },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "bass sorb" },
            { "Armi", "arameic imperial" },
            { "na", "nauru" },
            { "nb", "norvegais bokm\u00e5l" },
            { "nd", "ndebele dal nord" },
            { "ne", "nepalais" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "ollandais" },
            { "nn", "norvegiais nynorsk" },
            { "no", "norvegiais" },
            { "nr", "ndebele dal sid" },
            { "nv", "navajo" },
            { "kaa", "karakalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "%%POLYTON", "politonic" },
            { "oc", "occitan" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "ossetic" },
            { "kbd", "kabardic" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "dialect lipovaz da Resia" },
            { "pi", "pali" },
            { "pl", "polac" },
            { "dum", "ollandais mesaun" },
            { "ps", "paschto" },
            { "pt", "portugais" },
            { "mga", "irlandais mesaun" },
            { "key.co", "zavrada" },
            { "pt_BR", "portugais brasilian" },
            { "kcg", "tyap" },
            { "bra", "braj" },
            { "key.ca", "chalender" },
            { "Laoo", metaValue_lo },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "Lana", "lanna" },
            { "Ethi", "etiopic" },
            { "rm", "rumantsch" },
            { "rn", "rundi" },
            { "key.cu", "munaida" },
            { "ro", "rumen" },
            { "%%SAAHO", "Saho" },
            { "ru", "russ" },
            { "zbl", metaValue_zbl },
            { "rw", "kinyarwanda" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "englais australian" },
            { "sa", "sanscrit" },
            { "sc", "sard" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "sami dal nord" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbo-croat" },
            { "si", metaValue_si },
            { "sux", "sumeric" },
            { "sk", "slovac" },
            { "sl", "sloven" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanais" },
            { "sr", "serb" },
            { "ss", "swazi" },
            { "Java", metaValue_jv },
            { "st", "sotho dal sid" },
            { "su", metaValue_su },
            { "%%NEDIS", "dialect da Natisone" },
            { "sv", "svedais" },
            { "sw", "suahili" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "buriat" },
            { "143", "Asia Centrala" },
            { "te", metaValue_te },
            { "145", "Asia dal Vest" },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "bug", "bugi" },
            { "kfo", "koro" },
            { "en_CA", "englais canadais" },
            { "tk", "turkmen" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "tirc" },
            { "ts", "tsonga" },
            { "Cakm", "chakma" },
            { "tt", "tatar" },
            { "dyu", "diula" },
            { "tw", "twi" },
            { "ty", "tahitian" },
            { "%%BISKE", "dialect da San Giorgio" },
            { "150", "Europa" },
            { "151", "Europa Orientala" },
            { "154", "Europa dal Nord" },
            { "155", "Europa dal Vest" },
            { "ug", "uiguric" },
            { "Kore", metaValue_ko },
            { "Ital", "italic vegl" },
            { "Zyyy", "betg determin\u00e0" },
            { "uk", "ucranais" },
            { "ur", "urdu" },
            { "%%1994", "ortografia standardisada da Resia" },
            { "xal", "kalmuk" },
            { "zen", "zenaga" },
            { "uz", "usbec" },
            { "kha", "khasi" },
            { "%%1996", "nova ortografia tudestga" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "type.ca.roc", "chalendar da la republica chinaisa" },
            { "vi", "vietnamais" },
            { "kho", "khotanais" },
            { "%%TARASK", "ortografia taraskievica" },
            { "vo", "volapuk" },
            { "syc", "siric classic" },
            { "Osma", "osman" },
            { "gaa", "ga" },
            { "wa", "vallon" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "lidic" },
            { "Xsux", "scrittira a cugn sumeric-accadica" },
            { "wo", "wolof" },
            { "Cans", "simbols autoctons canadais unifitgads" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manchu" },
            { "Latf", "latin (scrittira gotica)" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "latin (scrittira gaelica)" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "Lyci", "lichic" },
            { "osa", "osage" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "%%1694ACAD", "franzos modern tempriv (a partir da 1694)" },
            { "Syrc", metaValue_syr },
            { "yi", "jiddic" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "Syrj", "siric dal vest" },
            { "ota", "tirc ottoman" },
            { "Syre", "siric estrangelo" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "Cari", "carian" },
            { "zh", "chinais" },
            { "Bopo", "bopomofo" },
            { "Perm", "permic vegl" },
            { "zu", "zulu" },
            { "type.co.phonebook", "cudesch da telefon" },
            { "%%MONOTON", "monotonic" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "Syrn", "siric da l\u2019ost" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egipzian demotic" },
            { "Egyh", "egipzian ieratic" },
            { "Egyp", "ieroglifas egipzianas" },
            { "Geok", "kutsuri" },
            { "zh_Hans", "chinais simplifitg\u00e0" },
            { "Hung", "ungarais vegl" },
            { "kok", "konkani" },
            { "%%1901", "ortografia tudestga tradiziunala" },
            { "kos", "kosraean" },
            { "zh_Hant", "chinais tradiziunal" },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "ilo", "ilocano" },
            { "%%VALENCIA", "valencian" },
            { "Cprt", "cipriot" },
            { "%%BAKU1926", "alfabet tirc unifitg\u00e0" },
            { "mul", "pluriling" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagolitic" },
            { "gil", "gilbertais" },
            { "Cher", metaValue_chr },
            { "car", "caribic" },
            { "krc", "karachay-balkar" },
            { "inh", "ingush" },
            { "krl", "carelian" },
            { "efi", "efik" },
            { "kru", "kurukh" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
