/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodHandleType;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaNameResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractHelperClassTransform
extends ContextTrackingVisitor<Void> {
    protected final int BOOTSTRAP_ARG_OFFSET = 3;
    protected static final String T_DESC_STRING = "java/lang/String";
    protected static final String T_DESC_CLASS = "java/lang/Class";
    protected static final String T_DESC_METHOD_TYPE = "java/lang/invoke/MethodType";
    protected static final String T_DESC_T_DESCRIPTOR = "java/lang/invoke/TypeDescriptor";
    protected static final String T_DESC_T_DESCRIPTOR_INNER_PREFIX = "java/lang/invoke/TypeDescriptor$";
    protected static final String T_DESC_METHOD_HANDLE = "java/lang/invoke/MethodHandle";
    protected static final String T_DESC_METHOD_HANDLES = "java/lang/invoke/MethodHandles";
    protected static final String T_DESC_LOOKUP = "java/lang/invoke/MethodHandles$Lookup";
    protected static final String M_SIGNATURE_LOOKUP = "()Ljava/lang/invoke/MethodHandles$Lookup;";
    protected static final String M_SIGNATURE_PRIVATE_LOOKUP = "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandles$Lookup;)Ljava/lang/invoke/MethodHandles$Lookup;";
    protected static final String M_DESC_METHOD_TYPE = "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/invoke/MethodType;";
    protected static final String T_DESC_THROWABLE = "java/lang/Throwable";
    protected static final String T_DESC_THROWABLE_WRAPPER = "java/lang/reflect/UndeclaredThrowableException";
    protected static final String T_DESC_REFLECTION_EXCEPTION = "java/lang/ReflectiveOperationException";
    protected static final String T_DESC_CALL_SITE = "java/lang/invoke/CallSite";
    protected static final String M_DESC_INVOKE_EXACT = "([Ljava/lang/Object;)Ljava/lang/Object;";
    protected static final String M_DESC_THROW_EXCEPTION = "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;";
    protected static final String M_DESC_INSERT_ARGUMENTS = "(Ljava/lang/invoke/MethodHandle;I[Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;";
    protected static final String M_DESC_PERMUTE_ARGUMENTS = "(Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;[I)Ljava/lang/invoke/MethodHandle;";
    protected static final String M_DESC_AS_TYPE = "(Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;";
    protected static final String M_DESC_RETURN_TYPE = "()Ljava/lang/Class;";
    protected static final String M_DESC_GET_CLASS = "()Ljava/lang/Class;";
    protected static final String M_DESC_DYNAMIC_INVOKER = "()Ljava/lang/invoke/MethodHandle;";
    protected final MetadataParser parser = new MetadataParser();
    protected TypeDeclaration currentType;
    protected IMetadataResolver resolver;
    private static final AtomicInteger NEXT_ID = new AtomicInteger();

    protected static int nextUniqueId() {
        return NEXT_ID.incrementAndGet();
    }

    public AbstractHelperClassTransform(DecompilerContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
        TypeDeclaration oldType = this.currentType;
        IMetadataResolver oldResolver = this.resolver;
        try {
            this.resolver = this.context.getCurrentType().getResolver();
            if (JavaNameResolver.isStaticContext(typeDeclaration, true, false)) {
                this.currentType = typeDeclaration;
            }
            super.visitTypeDeclarationOverride(typeDeclaration, p);
            Void void_ = null;
            return void_;
        }
        finally {
            this.resolver = oldResolver;
            this.currentType = oldType;
        }
    }

    protected static IMetadataResolver resolver(TypeReference parentType) {
        TypeDefinition r = parentType.resolve();
        return r != null ? r.getResolver() : MetadataSystem.instance();
    }

    protected TypeReference translateArgumentType(Object o) {
        if (o == null) {
            return BuiltinTypes.Null;
        }
        if (o instanceof MethodHandle) {
            return this.resolver.lookupType(T_DESC_METHOD_HANDLE);
        }
        return this.resolver.lookupType(o.getClass().getName().replace('.', '/'));
    }

    protected MethodDeclaration newMethod(MethodDefinition definition) {
        MethodDeclaration declaration = new MethodDeclaration();
        AstNodeCollection<JavaModifierToken> modifiers = declaration.getModifiers();
        AstNodeCollection<ParameterDeclaration> parameters = declaration.getParameters();
        modifiers.clear();
        for (Flags.Flag modifier : Flags.asFlagSet(0xD3FL & definition.getFlags())) {
            modifiers.add(new JavaModifierToken(TextLocation.EMPTY, modifier));
        }
        for (ParameterDefinition pd : definition.getParameters()) {
            ParameterDeclaration p = new ParameterDeclaration(pd.getName(), this.makeType(pd.getParameterType()));
            Variable v = new Variable();
            v.setOriginalParameter(pd);
            v.setName(pd.getName());
            v.setGenerated(false);
            v.setType(pd.getParameterType());
            p.putUserData(Keys.PARAMETER_DEFINITION, pd);
            p.putUserData(Keys.VARIABLE, v);
            parameters.add(p);
        }
        declaration.setName(definition.getName());
        declaration.setReturnType(this.makeType(definition.getReturnType()));
        declaration.putUserData(Keys.MEMBER_REFERENCE, definition);
        declaration.putUserData(Keys.METHOD_DEFINITION, definition);
        return declaration;
    }

    protected MemberReferenceExpression makeReference(MemberReference reference) {
        AstType type = this.makeType(reference.getDeclaringType());
        MemberReferenceExpression member = type.member(reference.getName());
        member.putUserData(Keys.MEMBER_REFERENCE, reference);
        if (reference instanceof FieldDefinition) {
            member.putUserData(Keys.FIELD_DEFINITION, (FieldDefinition)reference);
        } else if (reference instanceof MethodDefinition) {
            member.putUserData(Keys.METHOD_DEFINITION, (MethodDefinition)reference);
        }
        return member;
    }

    protected IdentifierExpression varReference(AstNode declaration) {
        Variable variable = declaration.getUserData(Keys.VARIABLE);
        IdentifierExpression id = new IdentifierExpression(-34, variable.getName());
        id.putUserData(Keys.VARIABLE, variable);
        return id;
    }

    protected IdentifierExpression varReference(Variable variable) {
        IdentifierExpression id = new IdentifierExpression(-34, variable.getName());
        id.putUserData(Keys.VARIABLE, variable);
        return id;
    }

    protected FieldDeclaration declareField(@NotNull FieldDefinition fd, @NotNull Expression initializer, int extraFlags) {
        FieldDeclaration field = new FieldDeclaration();
        AstNodeCollection<JavaModifierToken> modifiers = field.getModifiers();
        field.setReturnType(this.makeType(fd.getFieldType()));
        field.setName(fd.getName());
        field.putUserData(Keys.MEMBER_REFERENCE, fd);
        field.putUserData(Keys.FIELD_DEFINITION, fd);
        field.getVariables().add(new VariableInitializer(fd.getName(), initializer));
        for (Flags.Flag modifier : Flags.asFlagSet(0x40DF & (fd.getModifiers() | extraFlags))) {
            modifiers.add(new JavaModifierToken(TextLocation.EMPTY, modifier));
        }
        return field;
    }

    protected InvocationExpression makeMethodType(IMethodSignature methodSignature) {
        TypeReference mt = this.parser.parseTypeDescriptor(T_DESC_METHOD_TYPE);
        MethodReference methodType = this.parser.parseMethod(mt, "methodType", M_DESC_METHOD_TYPE);
        List<ParameterDefinition> parameters = methodSignature.getParameters();
        InvocationExpression invocation = this.makeType(mt).invoke(methodType, new Expression[0]);
        AstNodeCollection<Expression> arguments = invocation.getArguments();
        arguments.add(this.makeType(methodSignature.getReturnType()).classOf());
        for (ParameterDefinition parameter : parameters) {
            arguments.add(this.makeType(parameter.getParameterType()).classOf());
        }
        invocation.putUserData(Keys.MEMBER_REFERENCE, methodType);
        return invocation;
    }

    protected InvocationExpression makeMethodHandle(Expression lookup, MethodHandle handle) {
        return this.makeMethodHandle(lookup, handle, null, null);
    }

    protected InvocationExpression makeMethodHandle(Expression lookup, MethodHandle handle, @Nullable Expression methodType) {
        return this.makeMethodHandle(lookup, handle, methodType, null);
    }

    protected InvocationExpression makeMethodHandle(Expression lookup, MethodHandle handle, @Nullable Expression methodType, @Nullable TypeReference optionalSpecialCaller) {
        TypeReference lookupType = this.parser.parseTypeDescriptor(T_DESC_LOOKUP);
        MethodHandleType handleType = handle.getHandleType();
        MethodReference find = this.parser.parseMethod(lookupType, handleType.lookupMethodName(), handleType.lookupDescriptor());
        MethodReference method = handle.getMethod();
        InvocationExpression invocation = lookup.invoke(find, new Expression[0]);
        AstNodeCollection<Expression> arguments = invocation.getArguments();
        arguments.add(this.makeType(method.getDeclaringType()).classOf());
        if (handleType != MethodHandleType.NewInvokeSpecial) {
            arguments.add(new PrimitiveExpression(-34, (Object)method.getName()));
        }
        if (handleType.isField()) {
            arguments.add(this.makeType(method.getReturnType()).classOf());
        } else {
            arguments.add(methodType != null ? methodType : this.makeMethodType(method));
        }
        if (handleType == MethodHandleType.InvokeSpecial) {
            if (optionalSpecialCaller != null) {
                arguments.add(this.makeType(optionalSpecialCaller).classOf());
            } else {
                arguments.add(this.makeType(method.getDeclaringType()).classOf());
            }
        }
        invocation.putUserData(Keys.MEMBER_REFERENCE, find);
        return invocation;
    }

    protected MethodReference resolveLookupMethod(TypeReference lookupType, String methodName, String returnType) {
        return this.parser.parseMethod(lookupType, methodName, String.format("(L%s;L%s;L%s;)L%s;", T_DESC_CLASS, T_DESC_STRING, returnType, T_DESC_METHOD_HANDLE));
    }

    protected Variable makeCatchVariable(@NotNull String name, @NotNull TypeReference type) {
        Variable v = new Variable();
        v.setGenerated(false);
        v.setName(Objects.requireNonNull(name, "A name is required."));
        v.setType(Objects.requireNonNull(type, "A type is required."));
        return v;
    }

    protected InvocationExpression makeBootstrapCall(DynamicCallSite callSite, Variable lookupVariable) {
        AstType methodHandles = this.makeType(T_DESC_METHOD_HANDLES);
        MethodReference bootstrapMethod = callSite.getBootstrapMethod();
        MethodDefinition resolvedBootstrapMethod = bootstrapMethod.resolve();
        List<ParameterDefinition> parameters = bootstrapMethod.getParameters();
        List<Object> argumentValues = callSite.getBootstrapArguments();
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        boolean isVarArgs = resolvedBootstrapMethod != null && resolvedBootstrapMethod.isVarArgs();
        int n = Math.min(parameters.size(), argumentValues.size() + 3);
        for (int i = 0; i < n; ++i) {
            Expression convertedArgument;
            TypeReference argumentType;
            ParameterDefinition p = parameters.get(i);
            if (i == n - 1 && resolvedBootstrapMethod == null && p.getParameterType().isArray() && argumentValues.size() + 3 >= parameters.size() && (argumentType = this.translateArgumentType(argumentValues.get(i - 3))) != null && argumentType != BuiltinTypes.Null && MetadataHelper.isAssignableFrom(p.getParameterType().getElementType(), argumentType)) {
                isVarArgs = true;
            }
            if ((convertedArgument = this.tryConvertArgument(lookupVariable, methodHandles, p, callSite, i, isVarArgs)) == null) {
                return null;
            }
            arguments.add(convertedArgument);
        }
        if (isVarArgs) {
            ParameterDefinition varArgsParameter = parameters.get(parameters.size() - 1);
            int m = argumentValues.size() + 3;
            for (int i = n; i < m; ++i) {
                Expression expression = this.tryConvertArgument(lookupVariable, methodHandles, varArgsParameter, callSite, i, true);
                if (expression == null) {
                    return null;
                }
                arguments.add(expression);
            }
        }
        AstType bootstrapType = this.makeType(bootstrapMethod.getDeclaringType());
        InvocationExpression bootstrapCall = bootstrapType.invoke(bootstrapMethod, arguments);
        return bootstrapCall;
    }

    @Nullable
    protected Expression tryConvertArgument(Variable lookupVariable, AstType methodHandles, ParameterDefinition p, DynamicCallSite callSite, int argumentIndex, boolean isVarArgs) {
        Object o;
        List<Object> argumentValues = callSite.getBootstrapArguments();
        switch (argumentIndex) {
            case 0: {
                return this.varReference(lookupVariable);
            }
            case 1: {
                o = callSite.getMethodName();
                break;
            }
            case 2: {
                o = callSite.getMethodType();
                break;
            }
            default: {
                o = argumentValues.get(argumentIndex - 3);
            }
        }
        if (o instanceof TypeReference) {
            return new ClassOfExpression(-34, this.makeType((TypeReference)o));
        }
        TypeReference pType = p.getParameterType();
        if (isVarArgs && pType.isArray()) {
            pType = pType.getElementType();
        }
        MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(p.getParameterType());
        if (pType.isPrimitive() || T_DESC_STRING.equals(pType.getInternalName())) {
            return new PrimitiveExpression(-34, o);
        }
        String typeName = pType.getInternalName();
        if (T_DESC_METHOD_HANDLE.equals(typeName)) {
            if (o instanceof MethodHandle) {
                InvocationExpression invocation;
                MethodHandle mh = (MethodHandle)o;
                MethodHandleType hType = mh.getHandleType();
                PrimitiveExpression methodName = new PrimitiveExpression(-34, (Object)mh.getMethod().getName());
                AstType refType = this.makeType(mh.getMethod().getDeclaringType());
                AstType returnType = this.makeType(mh.getMethod().getReturnType());
                IdentifierExpression lookup = this.varReference(lookupVariable);
                TypeReference lookupType = lookupVariable.getType();
                switch (hType) {
                    case GetField: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findGetter", T_DESC_CLASS);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, returnType.classOf());
                        break;
                    }
                    case GetStatic: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findStaticGetter", T_DESC_CLASS);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, returnType.classOf());
                        break;
                    }
                    case PutField: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findSetter", T_DESC_CLASS);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, returnType.classOf());
                        break;
                    }
                    case PutStatic: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findStaticSetter", T_DESC_CLASS);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, returnType.classOf());
                        break;
                    }
                    case InvokeVirtual: 
                    case InvokeInterface: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findVirtual", T_DESC_METHOD_TYPE);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, this.makeMethodType(mh.getMethod()));
                        break;
                    }
                    case InvokeStatic: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findStatic", T_DESC_METHOD_TYPE);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, this.makeMethodType(mh.getMethod()));
                        break;
                    }
                    case InvokeSpecial: {
                        MethodReference findMethod = this.resolveLookupMethod(lookupType, "findSpecial", T_DESC_METHOD_TYPE);
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, this.makeMethodType(mh.getMethod()));
                        break;
                    }
                    case NewInvokeSpecial: {
                        MethodReference findMethod = this.parser.parseMethod(lookupType, "findConstructor", String.format("(L%s;L%s;)L%s;", T_DESC_CLASS, T_DESC_METHOD_TYPE, T_DESC_METHOD_HANDLE));
                        invocation = lookup.invoke(findMethod, refType.classOf(), methodName, this.makeMethodType(mh.getMethod()));
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return invocation;
            }
        } else if ((T_DESC_METHOD_TYPE.equals(typeName) || T_DESC_T_DESCRIPTOR.equals(typeName) || typeName.startsWith(T_DESC_T_DESCRIPTOR_INNER_PREFIX)) && o instanceof IMethodSignature) {
            return this.makeMethodType((IMethodSignature)o);
        }
        return null;
    }
}

