<!--
title: Serverless Framework - Apache OpenWhisk Events - Cloudant DB
menuText: Cloudant
menuOrder: 4
description: Follow database modification events from IBM Cloudant with Apache OpenWhisk via the Serverless Framework
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/providers/openwhisk/events/cloudant)

<!-- DOCS-SITE-LINK:END -->

# Cloudant

This event allows you to connect functions to [IBM Cloudant](https://cloudant.com/), a NoSQL database-as-a-service based upon [Apache CouchDB](http://couchdb.apache.org/). Functions are invoked for each database modification that occurs.

This event utilise the trigger feed provided by the [Cloudant package](https://github.com/openwhisk/openwhisk-package-cloudant).

## Setup

[IBM Cloudant](https://cloudant.com/) instances can be provisioned through the [IBM Bluemix](https://console.ng.bluemix.net) platform. OpenWhisk on Bluemix will export Cloudant service credentials bound to a package with the following name:

```
/${BLUEMIX_ORG}_${BLUEMIX_SPACE}/Bluemix_${SERVICE_NAME}_Credentials-1
```

## Configuration

Users need to pass the database credentials and the database name to listen to changes on when defining the event.

### Using Package Credentials

Rather than having to manually define all authentication properties needed by the Cloudant trigger feed, you can reference a package which provides these properties as default parameters.

Developers only need to add the database to listen to for each event.

```yaml
# serverless.yaml
functions:
  index:
    handler: users.main
    events:
      - cloudant:
          package: /${BLUEMIX_ORG}_${BLUEMIX_SPACE}/Bluemix_${SERVICE_NAME}_Credentials-1
          db: db_name
```

The configuration will create a trigger called `${serviceName}_${fnName}_cloudant_${db}` and a rule called `${serviceName}_${fnName}_cloudant_${db}_rule` to bind the function to the database update events.

The trigger and rule names created can be set explicitly using the `trigger` and `rule` parameters.

### Using Manual Parameters

Authentication credentials for the Cloudant event source can be defined explicitly, rather than using pulling credentials from a package.

```yaml
# serverless.yaml
functions:
  index:
    handler: users.main
    events:
      - cloudant:
          host: xxx-yyy-zzz-bluemix.cloudant.com
          username: USERNAME
          password: PASSWORD
          db: db_name
```

### Adding Optional Parameters

The following optional feed parameters are also supported:

- `max` - Maximum number of triggers to fire. Defaults to infinite.
- `filter` - Filter function defined on a design document.
- `query` - Optional query parameters for the filter function.

```yaml
# serverless.yaml
functions:
    index:
        handler: users.main
        events:
            - cloudant:
                ...
                max: 10000
                query:
                   status: new
                filter: mailbox/by_status
```

### Binding Multiple Functions

Other functions can bind to the same database event being fired using the inline `trigger` event and referencing this trigger name.

```yaml
# serverless.yaml
functions:
    index:
        handler: users.main
        events:
            - cloudant:
                package: /${BLUEMIX_ORG}_${BLUEMIX_SPACE}/Bluemix_${SERVICE_NAME}_Credentials-1
                db: my_db
                trigger: db_events
                rule: connect_index_to_db
     another:
        handler: users.another
        events:
            - trigger: db_events
```

## Event Details

Functions are invoked with the JSON object returned by the [CouchDB changes feed](http://guide.couchdb.org/draft/notifications.html) for each database modification. The contents of the generated events have the following parameters:

- `id`: The document ID.
- `seq`: The sequence identifier that is generated by Cloudant.
- `changes`: An array of objects, each of which has a `rev` field that contains the revision ID of the document.

The JSON representation of the trigger event is as follows:

```json
{
  "id": "6ca436c44074c4c2aa6a40c9a188b348",
  "seq": "2-g1AAAAL9aJyV-GJCaEuqx4-BktQkYp_dmIfC",
  "changes": [
    {
      "rev": "2-da3f80848a480379486fb4a2ad98fa16"
    }
  ]
}
```
