/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.TimeBucketCounter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ScheduledThreadPoolExecutor;

public class RateLimitFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BUCKET_DURATION = 60;
    public static final int DEFAULT_BUCKET_REQUESTS = 300;
    public static final boolean DEFAULT_ENFORCE = true;
    public static final int DEFAULT_STATUS_CODE = 429;
    public static final String DEFAULT_STATUS_MESSAGE = "Too many requests";
    public static final String RATE_LIMIT_ATTRIBUTE_COUNT = "org.apache.catalina.filters.RateLimitFilter.Count";
    public static final String PARAM_BUCKET_DURATION = "bucketDuration";
    public static final String PARAM_BUCKET_REQUESTS = "bucketRequests";
    public static final String PARAM_ENFORCE = "enforce";
    public static final String PARAM_STATUS_CODE = "statusCode";
    public static final String PARAM_STATUS_MESSAGE = "statusMessage";
    transient TimeBucketCounter bucketCounter;
    private int actualRequests;
    private int bucketRequests = 300;
    private int bucketDuration = 60;
    private boolean enforce = true;
    private int statusCode = 429;
    private String statusMessage = "Too many requests";
    private transient Log log = LogFactory.getLog(RateLimitFilter.class);
    private static final StringManager sm = StringManager.getManager(RateLimitFilter.class);

    public int getActualRequests() {
        return this.actualRequests;
    }

    public int getActualDurationInSeconds() {
        return this.bucketCounter.getActualDuration() / 1000;
    }

    public void init() throws ServletException {
        ScheduledExecutorService scheduledExecutorService;
        FilterConfig filterConfig = this.getFilterConfig();
        String string = filterConfig.getInitParameter(PARAM_BUCKET_DURATION);
        if (string != null) {
            this.bucketDuration = Integer.parseInt(string);
        }
        if ((string = filterConfig.getInitParameter(PARAM_BUCKET_REQUESTS)) != null) {
            this.bucketRequests = Integer.parseInt(string);
        }
        if ((string = filterConfig.getInitParameter(PARAM_ENFORCE)) != null) {
            this.enforce = Boolean.parseBoolean(string);
        }
        if ((string = filterConfig.getInitParameter(PARAM_STATUS_CODE)) != null) {
            this.statusCode = Integer.parseInt(string);
        }
        if ((string = filterConfig.getInitParameter(PARAM_STATUS_MESSAGE)) != null) {
            this.statusMessage = string;
        }
        if ((scheduledExecutorService = (ScheduledExecutorService)this.getServletContext().getAttribute(ScheduledThreadPoolExecutor.class.getName())) == null) {
            scheduledExecutorService = new java.util.concurrent.ScheduledThreadPoolExecutor(1);
        }
        this.bucketCounter = new TimeBucketCounter(this.bucketDuration, scheduledExecutorService);
        this.actualRequests = (int)Math.round(this.bucketCounter.getRatio() * (double)this.bucketRequests);
        this.log.info((Object)sm.getString("rateLimitFilter.initialized", new Object[]{super.getFilterName(), this.bucketRequests, this.bucketDuration, this.getActualRequests(), this.getActualDurationInSeconds(), (!this.enforce ? "Not " : "") + "enforcing"}));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string = servletRequest.getRemoteAddr();
        int n = this.bucketCounter.increment(string);
        servletRequest.setAttribute(RATE_LIMIT_ATTRIBUTE_COUNT, (Object)n);
        if (this.enforce && n > this.actualRequests) {
            ((HttpServletResponse)servletResponse).sendError(this.statusCode, this.statusMessage);
            this.log.warn((Object)sm.getString("rateLimitFilter.maxRequestsExceeded", new Object[]{super.getFilterName(), n, string, this.getActualRequests(), this.getActualDurationInSeconds()}));
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.bucketCounter.destroy();
        super.destroy();
    }
}

