"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const extend_1 = __importDefault(require("../lib/extend"));
const definitions = [
    {
        zigbeeModel: ['iStar DIM Light'],
        model: 'SCCV2401-1',
        vendor: 'iStar',
        description: 'Zigbee 3.0 LED controller, dimmable white 12-36V DC max. 5A',
        extend: extend_1.default.light_onoff_brightness(),
        meta: { turnsOffAtBrightness1: true },
    },
    {
        zigbeeModel: ['iStar CCT Light'],
        model: 'SCCV2403-2',
        vendor: 'iStar',
        description: 'Zigbee 3.0 LED controller, dimmable white spectrum',
        extend: extend_1.default.light_onoff_brightness_colortemp({ colorTempRange: [153, 370] }),
        meta: { turnsOffAtBrightness1: true },
    },
];
module.exports = definitions;
//# sourceMappingURL=istar.js.map