# Vulnerability Scanning
Trivy detects known vulnerabilities according to the versions of installed packages.

The following packages are supported.

- [OS packages](#os-packages)
- [Language-specific packages](#language-specific-packages)
- [Kubernetes components (control plane, node and addons)](#kubernetes-components-control-plane-node-and-addons)

Trivy also detects known vulnerabilities in Kubernetes components using KBOM (Kubernetes bill of Material) scanning. To learn more, see the [documentation for Kubernetes scanning](../target/kubernetes.md#KBOM).

## OS Packages
Trivy is capable of automatically detecting installed OS packages when scanning container images, VM images and running hosts.

!!! note
    Trivy doesn't support third-party/self-compiled packages/binaries, but official packages provided by vendors such as Red Hat and Debian.

### Supported OS
See [here](../coverage/os/index.md#supported-os) for the supported OSes.

### Data Sources

| OS            | Source                                                       |
| ------------- | ------------------------------------------------------------ |
| Arch Linux    | [Vulnerable Issues][arch]                                    |
| Alpine Linux  | [secdb][alpine]                                              |
| Wolfi Linux   | [secdb][wolfi]                                               |
| Chainguard    | [secdb][chainguard]                                          |
| Amazon Linux  | [Amazon Linux Security Center][amazon]                       |
| Debian        | [Security Bug Tracker][debian-tracker] / [OVAL][debian-oval] |
| Ubuntu        | [Ubuntu CVE Tracker][ubuntu]                                 |
| RHEL/CentOS   | [OVAL][rhel-oval] / [Security Data][rhel-api]                |
| AlmaLinux     | [AlmaLinux Product Errata][alma]                             |
| Rocky Linux   | [Rocky Linux UpdateInfo][rocky]                              |
| Oracle Linux  | [OVAL][oracle]                                               |
| CBL-Mariner   | [OVAL][mariner]                                              |
| OpenSUSE/SLES | [CVRF][suse]                                                 |
| Photon OS     | [Photon Security Advisory][photon]                           |

#### Data Source Selection
Trivy **only** consumes security advisories from the sources listed in the above table.

As for packages installed from OS package managers (`dpkg`, `yum`, `apk`, etc.), Trivy uses the advisory database from the appropriate **OS vendor**.

For example: for a python package installed from `yum` (Amazon linux), Trivy will only get advisories from [ALAS][amazon].
But for a python package installed from another source (e.g. `pip`), Trivy will get advisories from the `GitLab` and `GitHub` databases.

This advisory selection is essential to avoid getting false positives because OS vendors usually backport upstream fixes, and the fixed version can be different from the upstream fixed version.

#### Severity Selection
The severity is taken from the selected data source since the severity from vendors is more accurate.
Using CVE-2023-0464 as an example, while it is [rated as "HIGH" in NVD][nvd-CVE-2023-0464], Red Hat has marked its 'Impact' as ["Low"][redhat-CVE-2023-0464].
As a result, Trivy will display it as "Low".

The severity depends on the compile option, the default configuration, etc.
NVD doesn't know how the vendor distributes the software.
Red Hat evaluates the severity more accurately.
That's why Trivy prefers vendor scores over NVD.

If the data source does not provide a severity, the severity is determined based on the CVSS score as follows:

| Base Score Range | Severity |
| ---------------- | -------- |
| 0.1-3.9          | Low      |
| 4.0-6.9          | Medium   |
| 7.0-8.9          | High     |
| 9.0-10.0         | Critical |

If the CVSS score is also not provided, it falls back to [NVD][nvd], and if NVD does not have severity, it will be UNKNOWN.

### Unfixed Vulnerabilities
The unfixed/unfixable vulnerabilities mean that the patch has not yet been provided on their distribution.
To hide unfixed/unfixable vulnerabilities, you can use the `--ignore-unfixed` flag.

## Language-specific Packages

### Supported Languages
See [here](../coverage/language/index.md#supported-languages) for the supported languages.

### Data Sources

| Language | Source                                              | Commercial Use | Delay[^1] |
|----------|-----------------------------------------------------|:--------------:|:---------:|
| PHP      | [PHP Security Advisories Database][php]             |       ✅        |     -     |
|          | [GitHub Advisory Database (Composer)][php-ghsa]     |       ✅        |     -     |
| Python   | [GitHub Advisory Database (pip)][python-ghsa]       |       ✅        |     -     |
|          | [Open Source Vulnerabilities (PyPI)][python-osv]    |       ✅        |     -     |
| Ruby     | [Ruby Advisory Database][ruby]                      |       ✅        |     -     |
|          | [GitHub Advisory Database (RubyGems)][ruby-ghsa]    |       ✅        |     -     |
| Node.js  | [Ecosystem Security Working Group][nodejs]          |       ✅        |     -     |
|          | [GitHub Advisory Database (npm)][nodejs-ghsa]       |       ✅        |     -     |
| Java     | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
|          | [GitHub Advisory Database (Maven)][java-ghsa]       |       ✅        |     -     |
| Go       | [GitHub Advisory Database (Go)][go-ghsa]            |       ✅        |     -     |
| Rust     | [Open Source Vulnerabilities (crates.io)][rust-osv] |       ✅        |     -     |
| .NET     | [GitHub Advisory Database (NuGet)][dotnet-ghsa]     |       ✅        |     -     |
| C/C++    | [GitLab Advisories Community][gitlab]               |       ✅        |  1 month  |
| Dart     | [GitHub Advisory Database (Pub)][pub-ghsa]          |       ✅        |     -     |
| Elixir   | [GitHub Advisory Database (Erlang)][erlang-ghsa]    |       ✅        |     -     |
| Swift    | [GitHub Advisory Database (Swift)][swift-ghsa]      |       ✅        |     -     |

[^1]: Intentional delay between vulnerability disclosure and registration in the DB

## Kubernetes

Trivy can detect vulnerabilities in Kubernetes clusters and components.

### Data Sources

| Vendor        | Source                                      |
| ------------- |---------------------------------------------|
| Kubernetes    | [Kubernetes Official CVE feed][k8s-cve][^1] |

[^1]: Some manual triage and correction has been made.

## Database
Trivy downloads [the vulnerability database](https://github.com/aquasecurity/trivy-db) every 6 hours.
Trivy uses two types of databases for vulnerability detection:

- Vulnerability Database
- Java Index Database

This page provides detailed information about these databases.

### Vulnerability Database
Trivy utilizes a database containing vulnerability information.
This database is built every six hours on [GitHub](https://github.com/aquasecurity/trivy-db) and is distributed via [GitHub Container registry (GHCR)](https://ghcr.io/aquasecurity/trivy-db).
The database is cached and updated as needed.
As Trivy updates the database automatically during execution, users don't need to be concerned about it.

For CLI flags related to the database, please refer to [this page](../configuration/db.md).

#### Private Hosting
If you host the database on your own OCI registry, you can specify a different repository with the `--db-repository` flag.
The default is `ghcr.io/aquasecurity/trivy-db`.

```shell
$ trivy image --db-repository YOUR_REPO YOUR_IMAGE
```

If authentication is required, it can be configured in the same way as for private images.
Please refer to [the documentation](../advanced/private-registries/index.md) for more details.

### Java Index Database
This database is only downloaded when scanning JAR files so that Trivy can identify the groupId, artifactId, and version of JAR files.
It is built once a day on [GitHub](https://github.com/aquasecurity/trivy-java-db) and distributed via [GitHub Container registry (GHCR)](https://ghcr.io/aquasecurity/trivy-java-db).
Like the vulnerability database, it is automatically downloaded and updated when needed, so users don't need to worry about it.

#### Private Hosting
If you host the database on your own OCI registry, you can specify a different repository with the `--java-db-repository` flag.
The default is `ghcr.io/aquasecurity/trivy-java-db`.

If authentication is required, you need to run `docker login YOUR_REGISTRY`.
Currently, specifying a username and password is not supported.

[^1]: https://github.com/GoogleContainerTools/distroless

[nvd-CVE-2023-0464]: https://nvd.nist.gov/vuln/detail/CVE-2023-0464
[redhat-CVE-2023-0464]: https://access.redhat.com/security/cve/cve-2023-0464

[arch]: https://security.archlinux.org/
[alpine]: https://secdb.alpinelinux.org/
[wolfi]: https://packages.wolfi.dev/os/security.json
[chainguard]: https://packages.cgr.dev/chainguard/security.json
[amazon]: https://alas.aws.amazon.com/
[debian-tracker]: https://security-tracker.debian.org/tracker/
[debian-oval]: https://www.debian.org/security/oval/
[ubuntu]: https://ubuntu.com/security/cve
[rhel-oval]: https://www.redhat.com/security/data/oval/v2/
[rhel-api]: https://www.redhat.com/security/data/metrics/
[alma]: https://errata.almalinux.org/
[rocky]: https://download.rockylinux.org/pub/rocky/
[oracle]: https://linux.oracle.com/security/oval/
[suse]: http://ftp.suse.com/pub/projects/security/cvrf/
[photon]: https://packages.vmware.com/photon/photon_cve_metadata/
[mariner]: https://github.com/microsoft/CBL-MarinerVulnerabilityData/

[php-ghsa]: https://github.com/advisories?query=ecosystem%3Acomposer
[python-ghsa]: https://github.com/advisories?query=ecosystem%3Apip
[ruby-ghsa]: https://github.com/advisories?query=ecosystem%3Arubygems
[nodejs-ghsa]: https://github.com/advisories?query=ecosystem%3Anpm
[java-ghsa]: https://github.com/advisories?query=ecosystem%3Amaven
[dotnet-ghsa]: https://github.com/advisories?query=ecosystem%3Anuget
[pub-ghsa]: https://github.com/advisories?query=ecosystem%3Apub
[erlang-ghsa]: https://github.com/advisories?query=ecosystem%3Aerlang
[go-ghsa]: https://github.com/advisories?query=ecosystem%3Ago
[swift-ghsa]: https://github.com/advisories?query=ecosystem%3Aswift

[php]: https://github.com/FriendsOfPHP/security-advisories
[ruby]: https://github.com/rubysec/ruby-advisory-db
[nodejs]: https://github.com/nodejs/security-wg
[gitlab]: https://gitlab.com/gitlab-org/advisories-community

[python-osv]: https://osv.dev/list?q=&ecosystem=PyPI
[rust-osv]: https://osv.dev/list?q=&ecosystem=crates.io

[nvd]: https://nvd.nist.gov/vuln

[k8s-cve]: https://kubernetes.io/docs/reference/issues-security/official-cve-feed/
