/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KotlinModuleDependentsProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.providers.KotlinAnchorModuleProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dispose", "", "invalidate", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "invalidateAll", "includeLibraryModules", "", "subscribeToModificationEvents", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionInvalidationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionInvalidationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1855#2,2:110\n1855#2,2:112\n*S KotlinDebug\n*F\n+ 1 LLFirSessionInvalidationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService\n*L\n73#1:110,2\n95#1:112,2\n*E\n"})
public final class LLFirSessionInvalidationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public LLFirSessionInvalidationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void subscribeToModificationEvents() {
        MessageBusConnection messageBusConnection = KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)this.project).connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"connect(...)");
        MessageBusConnection busConnection = messageBusConnection;
        busConnection.subscribe(KotlinTopics.INSTANCE.getMODULE_STATE_MODIFICATION(), (arg_0, arg_1) -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$0(this, arg_0, arg_1));
        busConnection.subscribe(KotlinTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION(), arg_0 -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$1(this, arg_0));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$2(this));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$3(this));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$4(this));
    }

    public final void invalidate(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LLFirSessionCache sessionCache = LLFirSessionCache.Companion.getInstance(this.project);
        boolean didSessionExist = sessionCache.removeSession(module);
        if (!didSessionExist) {
            return;
        }
        Iterable $this$forEach$iv = KotlinModuleDependentsProvider.Companion.getInstance(this.project).getTransitiveDependents(module);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModule p0 = (KtModule)element$iv;
            boolean bl = false;
            sessionCache.removeSession(p0);
        }
        if (module instanceof KtScriptModule || module instanceof KtScriptDependencyModule || module instanceof KtLibraryModule) {
            sessionCache.removeAllScriptSessions();
        }
    }

    private final void invalidateAll(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!includeLibraryModules) {
            Collection anchorModules;
            KotlinAnchorModuleProvider kotlinAnchorModuleProvider = KotlinAnchorModuleProvider.Companion.getInstance(this.project);
            Collection collection = anchorModules = kotlinAnchorModuleProvider != null ? kotlinAnchorModuleProvider.getAllAnchorModules() : null;
            if (collection != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtModule p0 = (KtModule)element$iv;
                    boolean bl = false;
                    this.invalidate(p0);
                }
            }
        }
        LLFirSessionCache.Companion.getInstance(this.project).removeAllSessions(includeLibraryModules);
    }

    public void dispose() {
    }

    private static final void subscribeToModificationEvents$lambda$0(LLFirSessionInvalidationService this$0, KtModule module, KotlinModuleStateModificationKind kotlinModuleStateModificationKind) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kotlinModuleStateModificationKind, (String)"<anonymous parameter 1>");
        this$0.invalidate(module);
    }

    private static final void subscribeToModificationEvents$lambda$1(LLFirSessionInvalidationService this$0, KtModule module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this$0.invalidate(module);
    }

    private static final void subscribeToModificationEvents$lambda$2(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(true);
    }

    private static final void subscribeToModificationEvents$lambda$3(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(false);
    }

    private static final void subscribeToModificationEvents$lambda$4(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionInvalidationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LLFirSessionInvalidationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirSessionInvalidationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

