/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.UpdateResult;
import com.amazon.randomcutforest.store.IPointStore;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public abstract class AbstractForestUpdateExecutor<PointReference, Point> {
    protected final IStateCoordinator<PointReference, Point> updateCoordinator;
    protected final ComponentList<PointReference, Point> components;

    protected AbstractForestUpdateExecutor(IStateCoordinator<PointReference, Point> updateCoordinator, ComponentList<PointReference, Point> components) {
        this.updateCoordinator = updateCoordinator;
        this.components = components;
    }

    public void update(Point point) {
        long internalSequenceNumber = this.updateCoordinator.getTotalUpdates();
        IPointStore<PointReference, Point> store = this.updateCoordinator.getStore();
        if (store != null && store.isInternalShinglingEnabled()) {
            internalSequenceNumber -= (long)(store.getShingleSize() - 1);
        }
        this.update(point, internalSequenceNumber);
    }

    public void update(Point point, long sequenceNumber) {
        PointReference updateInput = this.updateCoordinator.initUpdate(point, sequenceNumber);
        List results = updateInput == null ? Collections.emptyList() : this.updateInternal(updateInput, sequenceNumber);
        this.updateCoordinator.completeUpdate(results, updateInput);
    }

    protected abstract List<UpdateResult<PointReference>> updateInternal(PointReference var1, long var2);

    @Generated
    public IStateCoordinator<PointReference, Point> getUpdateCoordinator() {
        return this.updateCoordinator;
    }

    @Generated
    public ComponentList<PointReference, Point> getComponents() {
        return this.components;
    }
}

