(window["indexManagementDashboards_bundle_jsonpfunction"]=window["indexManagementDashboards_bundle_jsonpfunction"]||[]).push([[6],{248:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return setupMode}));var STOP_WHEN_IDLE_FOR=2*60*1e3;var WorkerManager=function(){function WorkerManager(defaults){var _this=this;this._defaults=defaults;this._worker=null;this._idleCheckInterval=setInterval((function(){return _this._checkIfIdle()}),30*1e3);this._lastUsedTime=0;this._configChangeListener=this._defaults.onDidChange((function(){return _this._stopWorker()}))}WorkerManager.prototype._stopWorker=function(){if(this._worker){this._worker.dispose();this._worker=null}this._client=null};WorkerManager.prototype.dispose=function(){clearInterval(this._idleCheckInterval);this._configChangeListener.dispose();this._stopWorker()};WorkerManager.prototype._checkIfIdle=function(){if(!this._worker){return}var timePassedSinceLastUsed=Date.now()-this._lastUsedTime;if(timePassedSinceLastUsed>STOP_WHEN_IDLE_FOR){this._stopWorker()}};WorkerManager.prototype._getClient=function(){this._lastUsedTime=Date.now();if(!this._client){this._worker=monaco.editor.createWebWorker({moduleId:"vs/language/json/jsonWorker",label:this._defaults.languageId,createData:{languageSettings:this._defaults.diagnosticsOptions,languageId:this._defaults.languageId,enableSchemaRequest:this._defaults.diagnosticsOptions.enableSchemaRequest}});this._client=this._worker.getProxy()}return this._client};WorkerManager.prototype.getLanguageServiceWorker=function(){var _this=this;var resources=[];for(var _i=0;_i<arguments.length;_i++){resources[_i]=arguments[_i]}var _client;return this._getClient().then((function(client){_client=client})).then((function(_){return _this._worker.withSyncedResources(resources)})).then((function(_){return _client}))};return WorkerManager}();var Position;(function(Position){function create(line,character){return{line:line,character:character}}Position.create=create;function is(value){var candidate=value;return Is.objectLiteral(candidate)&&Is.number(candidate.line)&&Is.number(candidate.character)}Position.is=is})(Position||(Position={}));var Range;(function(Range){function create(one,two,three,four){if(Is.number(one)&&Is.number(two)&&Is.number(three)&&Is.number(four)){return{start:Position.create(one,two),end:Position.create(three,four)}}else if(Position.is(one)&&Position.is(two)){return{start:one,end:two}}else{throw new Error("Range#create called with invalid arguments["+one+", "+two+", "+three+", "+four+"]")}}Range.create=create;function is(value){var candidate=value;return Is.objectLiteral(candidate)&&Position.is(candidate.start)&&Position.is(candidate.end)}Range.is=is})(Range||(Range={}));var Location;(function(Location){function create(uri,range){return{uri:uri,range:range}}Location.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Range.is(candidate.range)&&(Is.string(candidate.uri)||Is.undefined(candidate.uri))}Location.is=is})(Location||(Location={}));var LocationLink;(function(LocationLink){function create(targetUri,targetRange,targetSelectionRange,originSelectionRange){return{targetUri:targetUri,targetRange:targetRange,targetSelectionRange:targetSelectionRange,originSelectionRange:originSelectionRange}}LocationLink.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Range.is(candidate.targetRange)&&Is.string(candidate.targetUri)&&(Range.is(candidate.targetSelectionRange)||Is.undefined(candidate.targetSelectionRange))&&(Range.is(candidate.originSelectionRange)||Is.undefined(candidate.originSelectionRange))}LocationLink.is=is})(LocationLink||(LocationLink={}));var Color;(function(Color){function create(red,green,blue,alpha){return{red:red,green:green,blue:blue,alpha:alpha}}Color.create=create;function is(value){var candidate=value;return Is.number(candidate.red)&&Is.number(candidate.green)&&Is.number(candidate.blue)&&Is.number(candidate.alpha)}Color.is=is})(Color||(Color={}));var ColorInformation;(function(ColorInformation){function create(range,color){return{range:range,color:color}}ColorInformation.create=create;function is(value){var candidate=value;return Range.is(candidate.range)&&Color.is(candidate.color)}ColorInformation.is=is})(ColorInformation||(ColorInformation={}));var ColorPresentation;(function(ColorPresentation){function create(label,textEdit,additionalTextEdits){return{label:label,textEdit:textEdit,additionalTextEdits:additionalTextEdits}}ColorPresentation.create=create;function is(value){var candidate=value;return Is.string(candidate.label)&&(Is.undefined(candidate.textEdit)||TextEdit.is(candidate))&&(Is.undefined(candidate.additionalTextEdits)||Is.typedArray(candidate.additionalTextEdits,TextEdit.is))}ColorPresentation.is=is})(ColorPresentation||(ColorPresentation={}));var FoldingRangeKind;(function(FoldingRangeKind){FoldingRangeKind["Comment"]="comment";FoldingRangeKind["Imports"]="imports";FoldingRangeKind["Region"]="region"})(FoldingRangeKind||(FoldingRangeKind={}));var FoldingRange;(function(FoldingRange){function create(startLine,endLine,startCharacter,endCharacter,kind){var result={startLine:startLine,endLine:endLine};if(Is.defined(startCharacter)){result.startCharacter=startCharacter}if(Is.defined(endCharacter)){result.endCharacter=endCharacter}if(Is.defined(kind)){result.kind=kind}return result}FoldingRange.create=create;function is(value){var candidate=value;return Is.number(candidate.startLine)&&Is.number(candidate.startLine)&&(Is.undefined(candidate.startCharacter)||Is.number(candidate.startCharacter))&&(Is.undefined(candidate.endCharacter)||Is.number(candidate.endCharacter))&&(Is.undefined(candidate.kind)||Is.string(candidate.kind))}FoldingRange.is=is})(FoldingRange||(FoldingRange={}));var DiagnosticRelatedInformation;(function(DiagnosticRelatedInformation){function create(location,message){return{location:location,message:message}}DiagnosticRelatedInformation.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Location.is(candidate.location)&&Is.string(candidate.message)}DiagnosticRelatedInformation.is=is})(DiagnosticRelatedInformation||(DiagnosticRelatedInformation={}));var DiagnosticSeverity;(function(DiagnosticSeverity){DiagnosticSeverity.Error=1;DiagnosticSeverity.Warning=2;DiagnosticSeverity.Information=3;DiagnosticSeverity.Hint=4})(DiagnosticSeverity||(DiagnosticSeverity={}));var Diagnostic;(function(Diagnostic){function create(range,message,severity,code,source,relatedInformation){var result={range:range,message:message};if(Is.defined(severity)){result.severity=severity}if(Is.defined(code)){result.code=code}if(Is.defined(source)){result.source=source}if(Is.defined(relatedInformation)){result.relatedInformation=relatedInformation}return result}Diagnostic.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Range.is(candidate.range)&&Is.string(candidate.message)&&(Is.number(candidate.severity)||Is.undefined(candidate.severity))&&(Is.number(candidate.code)||Is.string(candidate.code)||Is.undefined(candidate.code))&&(Is.string(candidate.source)||Is.undefined(candidate.source))&&(Is.undefined(candidate.relatedInformation)||Is.typedArray(candidate.relatedInformation,DiagnosticRelatedInformation.is))}Diagnostic.is=is})(Diagnostic||(Diagnostic={}));var Command;(function(Command){function create(title,command){var args=[];for(var _i=2;_i<arguments.length;_i++){args[_i-2]=arguments[_i]}var result={title:title,command:command};if(Is.defined(args)&&args.length>0){result.arguments=args}return result}Command.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.string(candidate.title)&&Is.string(candidate.command)}Command.is=is})(Command||(Command={}));var TextEdit;(function(TextEdit){function replace(range,newText){return{range:range,newText:newText}}TextEdit.replace=replace;function insert(position,newText){return{range:{start:position,end:position},newText:newText}}TextEdit.insert=insert;function del(range){return{range:range,newText:""}}TextEdit.del=del;function is(value){var candidate=value;return Is.objectLiteral(candidate)&&Is.string(candidate.newText)&&Range.is(candidate.range)}TextEdit.is=is})(TextEdit||(TextEdit={}));var TextDocumentEdit;(function(TextDocumentEdit){function create(textDocument,edits){return{textDocument:textDocument,edits:edits}}TextDocumentEdit.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&VersionedTextDocumentIdentifier.is(candidate.textDocument)&&Array.isArray(candidate.edits)}TextDocumentEdit.is=is})(TextDocumentEdit||(TextDocumentEdit={}));var CreateFile;(function(CreateFile){function create(uri,options){var result={kind:"create",uri:uri};if(options!==void 0&&(options.overwrite!==void 0||options.ignoreIfExists!==void 0)){result.options=options}return result}CreateFile.create=create;function is(value){var candidate=value;return candidate&&candidate.kind==="create"&&Is.string(candidate.uri)&&(candidate.options===void 0||(candidate.options.overwrite===void 0||Is.boolean(candidate.options.overwrite))&&(candidate.options.ignoreIfExists===void 0||Is.boolean(candidate.options.ignoreIfExists)))}CreateFile.is=is})(CreateFile||(CreateFile={}));var RenameFile;(function(RenameFile){function create(oldUri,newUri,options){var result={kind:"rename",oldUri:oldUri,newUri:newUri};if(options!==void 0&&(options.overwrite!==void 0||options.ignoreIfExists!==void 0)){result.options=options}return result}RenameFile.create=create;function is(value){var candidate=value;return candidate&&candidate.kind==="rename"&&Is.string(candidate.oldUri)&&Is.string(candidate.newUri)&&(candidate.options===void 0||(candidate.options.overwrite===void 0||Is.boolean(candidate.options.overwrite))&&(candidate.options.ignoreIfExists===void 0||Is.boolean(candidate.options.ignoreIfExists)))}RenameFile.is=is})(RenameFile||(RenameFile={}));var DeleteFile;(function(DeleteFile){function create(uri,options){var result={kind:"delete",uri:uri};if(options!==void 0&&(options.recursive!==void 0||options.ignoreIfNotExists!==void 0)){result.options=options}return result}DeleteFile.create=create;function is(value){var candidate=value;return candidate&&candidate.kind==="delete"&&Is.string(candidate.uri)&&(candidate.options===void 0||(candidate.options.recursive===void 0||Is.boolean(candidate.options.recursive))&&(candidate.options.ignoreIfNotExists===void 0||Is.boolean(candidate.options.ignoreIfNotExists)))}DeleteFile.is=is})(DeleteFile||(DeleteFile={}));var WorkspaceEdit;(function(WorkspaceEdit){function is(value){var candidate=value;return candidate&&(candidate.changes!==void 0||candidate.documentChanges!==void 0)&&(candidate.documentChanges===void 0||candidate.documentChanges.every((function(change){if(Is.string(change.kind)){return CreateFile.is(change)||RenameFile.is(change)||DeleteFile.is(change)}else{return TextDocumentEdit.is(change)}})))}WorkspaceEdit.is=is})(WorkspaceEdit||(WorkspaceEdit={}));var TextEditChangeImpl=function(){function TextEditChangeImpl(edits){this.edits=edits}TextEditChangeImpl.prototype.insert=function(position,newText){this.edits.push(TextEdit.insert(position,newText))};TextEditChangeImpl.prototype.replace=function(range,newText){this.edits.push(TextEdit.replace(range,newText))};TextEditChangeImpl.prototype.delete=function(range){this.edits.push(TextEdit.del(range))};TextEditChangeImpl.prototype.add=function(edit){this.edits.push(edit)};TextEditChangeImpl.prototype.all=function(){return this.edits};TextEditChangeImpl.prototype.clear=function(){this.edits.splice(0,this.edits.length)};return TextEditChangeImpl}();var WorkspaceChange=function(){function WorkspaceChange(workspaceEdit){var _this=this;this._textEditChanges=Object.create(null);if(workspaceEdit){this._workspaceEdit=workspaceEdit;if(workspaceEdit.documentChanges){workspaceEdit.documentChanges.forEach((function(change){if(TextDocumentEdit.is(change)){var textEditChange=new TextEditChangeImpl(change.edits);_this._textEditChanges[change.textDocument.uri]=textEditChange}}))}else if(workspaceEdit.changes){Object.keys(workspaceEdit.changes).forEach((function(key){var textEditChange=new TextEditChangeImpl(workspaceEdit.changes[key]);_this._textEditChanges[key]=textEditChange}))}}}Object.defineProperty(WorkspaceChange.prototype,"edit",{get:function(){return this._workspaceEdit},enumerable:true,configurable:true});WorkspaceChange.prototype.getTextEditChange=function(key){if(VersionedTextDocumentIdentifier.is(key)){if(!this._workspaceEdit){this._workspaceEdit={documentChanges:[]}}if(!this._workspaceEdit.documentChanges){throw new Error("Workspace edit is not configured for document changes.")}var textDocument=key;var result=this._textEditChanges[textDocument.uri];if(!result){var edits=[];var textDocumentEdit={textDocument:textDocument,edits:edits};this._workspaceEdit.documentChanges.push(textDocumentEdit);result=new TextEditChangeImpl(edits);this._textEditChanges[textDocument.uri]=result}return result}else{if(!this._workspaceEdit){this._workspaceEdit={changes:Object.create(null)}}if(!this._workspaceEdit.changes){throw new Error("Workspace edit is not configured for normal text edit changes.")}var result=this._textEditChanges[key];if(!result){var edits=[];this._workspaceEdit.changes[key]=edits;result=new TextEditChangeImpl(edits);this._textEditChanges[key]=result}return result}};WorkspaceChange.prototype.createFile=function(uri,options){this.checkDocumentChanges();this._workspaceEdit.documentChanges.push(CreateFile.create(uri,options))};WorkspaceChange.prototype.renameFile=function(oldUri,newUri,options){this.checkDocumentChanges();this._workspaceEdit.documentChanges.push(RenameFile.create(oldUri,newUri,options))};WorkspaceChange.prototype.deleteFile=function(uri,options){this.checkDocumentChanges();this._workspaceEdit.documentChanges.push(DeleteFile.create(uri,options))};WorkspaceChange.prototype.checkDocumentChanges=function(){if(!this._workspaceEdit||!this._workspaceEdit.documentChanges){throw new Error("Workspace edit is not configured for document changes.")}};return WorkspaceChange}();var TextDocumentIdentifier;(function(TextDocumentIdentifier){function create(uri){return{uri:uri}}TextDocumentIdentifier.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.string(candidate.uri)}TextDocumentIdentifier.is=is})(TextDocumentIdentifier||(TextDocumentIdentifier={}));var VersionedTextDocumentIdentifier;(function(VersionedTextDocumentIdentifier){function create(uri,version){return{uri:uri,version:version}}VersionedTextDocumentIdentifier.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.string(candidate.uri)&&(candidate.version===null||Is.number(candidate.version))}VersionedTextDocumentIdentifier.is=is})(VersionedTextDocumentIdentifier||(VersionedTextDocumentIdentifier={}));var TextDocumentItem;(function(TextDocumentItem){function create(uri,languageId,version,text){return{uri:uri,languageId:languageId,version:version,text:text}}TextDocumentItem.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.string(candidate.uri)&&Is.string(candidate.languageId)&&Is.number(candidate.version)&&Is.string(candidate.text)}TextDocumentItem.is=is})(TextDocumentItem||(TextDocumentItem={}));var MarkupKind;(function(MarkupKind){MarkupKind.PlainText="plaintext";MarkupKind.Markdown="markdown"})(MarkupKind||(MarkupKind={}));(function(MarkupKind){function is(value){var candidate=value;return candidate===MarkupKind.PlainText||candidate===MarkupKind.Markdown}MarkupKind.is=is})(MarkupKind||(MarkupKind={}));var MarkupContent;(function(MarkupContent){function is(value){var candidate=value;return Is.objectLiteral(value)&&MarkupKind.is(candidate.kind)&&Is.string(candidate.value)}MarkupContent.is=is})(MarkupContent||(MarkupContent={}));var CompletionItemKind;(function(CompletionItemKind){CompletionItemKind.Text=1;CompletionItemKind.Method=2;CompletionItemKind.Function=3;CompletionItemKind.Constructor=4;CompletionItemKind.Field=5;CompletionItemKind.Variable=6;CompletionItemKind.Class=7;CompletionItemKind.Interface=8;CompletionItemKind.Module=9;CompletionItemKind.Property=10;CompletionItemKind.Unit=11;CompletionItemKind.Value=12;CompletionItemKind.Enum=13;CompletionItemKind.Keyword=14;CompletionItemKind.Snippet=15;CompletionItemKind.Color=16;CompletionItemKind.File=17;CompletionItemKind.Reference=18;CompletionItemKind.Folder=19;CompletionItemKind.EnumMember=20;CompletionItemKind.Constant=21;CompletionItemKind.Struct=22;CompletionItemKind.Event=23;CompletionItemKind.Operator=24;CompletionItemKind.TypeParameter=25})(CompletionItemKind||(CompletionItemKind={}));var InsertTextFormat;(function(InsertTextFormat){InsertTextFormat.PlainText=1;InsertTextFormat.Snippet=2})(InsertTextFormat||(InsertTextFormat={}));var CompletionItem;(function(CompletionItem){function create(label){return{label:label}}CompletionItem.create=create})(CompletionItem||(CompletionItem={}));var CompletionList;(function(CompletionList){function create(items,isIncomplete){return{items:items?items:[],isIncomplete:!!isIncomplete}}CompletionList.create=create})(CompletionList||(CompletionList={}));var MarkedString;(function(MarkedString){function fromPlainText(plainText){return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}MarkedString.fromPlainText=fromPlainText;function is(value){var candidate=value;return Is.string(candidate)||Is.objectLiteral(candidate)&&Is.string(candidate.language)&&Is.string(candidate.value)}MarkedString.is=is})(MarkedString||(MarkedString={}));var Hover;(function(Hover){function is(value){var candidate=value;return!!candidate&&Is.objectLiteral(candidate)&&(MarkupContent.is(candidate.contents)||MarkedString.is(candidate.contents)||Is.typedArray(candidate.contents,MarkedString.is))&&(value.range===void 0||Range.is(value.range))}Hover.is=is})(Hover||(Hover={}));var ParameterInformation;(function(ParameterInformation){function create(label,documentation){return documentation?{label:label,documentation:documentation}:{label:label}}ParameterInformation.create=create})(ParameterInformation||(ParameterInformation={}));var SignatureInformation;(function(SignatureInformation){function create(label,documentation){var parameters=[];for(var _i=2;_i<arguments.length;_i++){parameters[_i-2]=arguments[_i]}var result={label:label};if(Is.defined(documentation)){result.documentation=documentation}if(Is.defined(parameters)){result.parameters=parameters}else{result.parameters=[]}return result}SignatureInformation.create=create})(SignatureInformation||(SignatureInformation={}));var DocumentHighlightKind;(function(DocumentHighlightKind){DocumentHighlightKind.Text=1;DocumentHighlightKind.Read=2;DocumentHighlightKind.Write=3})(DocumentHighlightKind||(DocumentHighlightKind={}));var DocumentHighlight;(function(DocumentHighlight){function create(range,kind){var result={range:range};if(Is.number(kind)){result.kind=kind}return result}DocumentHighlight.create=create})(DocumentHighlight||(DocumentHighlight={}));var SymbolKind;(function(SymbolKind){SymbolKind.File=1;SymbolKind.Module=2;SymbolKind.Namespace=3;SymbolKind.Package=4;SymbolKind.Class=5;SymbolKind.Method=6;SymbolKind.Property=7;SymbolKind.Field=8;SymbolKind.Constructor=9;SymbolKind.Enum=10;SymbolKind.Interface=11;SymbolKind.Function=12;SymbolKind.Variable=13;SymbolKind.Constant=14;SymbolKind.String=15;SymbolKind.Number=16;SymbolKind.Boolean=17;SymbolKind.Array=18;SymbolKind.Object=19;SymbolKind.Key=20;SymbolKind.Null=21;SymbolKind.EnumMember=22;SymbolKind.Struct=23;SymbolKind.Event=24;SymbolKind.Operator=25;SymbolKind.TypeParameter=26})(SymbolKind||(SymbolKind={}));var SymbolInformation;(function(SymbolInformation){function create(name,kind,range,uri,containerName){var result={name:name,kind:kind,location:{uri:uri,range:range}};if(containerName){result.containerName=containerName}return result}SymbolInformation.create=create})(SymbolInformation||(SymbolInformation={}));var DocumentSymbol=function(){function DocumentSymbol(){}return DocumentSymbol}();(function(DocumentSymbol){function create(name,detail,kind,range,selectionRange,children){var result={name:name,detail:detail,kind:kind,range:range,selectionRange:selectionRange};if(children!==void 0){result.children=children}return result}DocumentSymbol.create=create;function is(value){var candidate=value;return candidate&&Is.string(candidate.name)&&Is.number(candidate.kind)&&Range.is(candidate.range)&&Range.is(candidate.selectionRange)&&(candidate.detail===void 0||Is.string(candidate.detail))&&(candidate.deprecated===void 0||Is.boolean(candidate.deprecated))&&(candidate.children===void 0||Array.isArray(candidate.children))}DocumentSymbol.is=is})(DocumentSymbol||(DocumentSymbol={}));var CodeActionKind;(function(CodeActionKind){CodeActionKind.QuickFix="quickfix";CodeActionKind.Refactor="refactor";CodeActionKind.RefactorExtract="refactor.extract";CodeActionKind.RefactorInline="refactor.inline";CodeActionKind.RefactorRewrite="refactor.rewrite";CodeActionKind.Source="source";CodeActionKind.SourceOrganizeImports="source.organizeImports"})(CodeActionKind||(CodeActionKind={}));var CodeActionContext;(function(CodeActionContext){function create(diagnostics,only){var result={diagnostics:diagnostics};if(only!==void 0&&only!==null){result.only=only}return result}CodeActionContext.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.typedArray(candidate.diagnostics,Diagnostic.is)&&(candidate.only===void 0||Is.typedArray(candidate.only,Is.string))}CodeActionContext.is=is})(CodeActionContext||(CodeActionContext={}));var CodeAction;(function(CodeAction){function create(title,commandOrEdit,kind){var result={title:title};if(Command.is(commandOrEdit)){result.command=commandOrEdit}else{result.edit=commandOrEdit}if(kind!==void null){result.kind=kind}return result}CodeAction.create=create;function is(value){var candidate=value;return candidate&&Is.string(candidate.title)&&(candidate.diagnostics===void 0||Is.typedArray(candidate.diagnostics,Diagnostic.is))&&(candidate.kind===void 0||Is.string(candidate.kind))&&(candidate.edit!==void 0||candidate.command!==void 0)&&(candidate.command===void 0||Command.is(candidate.command))&&(candidate.edit===void 0||WorkspaceEdit.is(candidate.edit))}CodeAction.is=is})(CodeAction||(CodeAction={}));var CodeLens;(function(CodeLens){function create(range,data){var result={range:range};if(Is.defined(data))result.data=data;return result}CodeLens.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Range.is(candidate.range)&&(Is.undefined(candidate.command)||Command.is(candidate.command))}CodeLens.is=is})(CodeLens||(CodeLens={}));var FormattingOptions;(function(FormattingOptions){function create(tabSize,insertSpaces){return{tabSize:tabSize,insertSpaces:insertSpaces}}FormattingOptions.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.number(candidate.tabSize)&&Is.boolean(candidate.insertSpaces)}FormattingOptions.is=is})(FormattingOptions||(FormattingOptions={}));var DocumentLink=function(){function DocumentLink(){}return DocumentLink}();(function(DocumentLink){function create(range,target,data){return{range:range,target:target,data:data}}DocumentLink.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Range.is(candidate.range)&&(Is.undefined(candidate.target)||Is.string(candidate.target))}DocumentLink.is=is})(DocumentLink||(DocumentLink={}));var EOL=["\n","\r\n","\r"];var TextDocument;(function(TextDocument){function create(uri,languageId,version,content){return new FullTextDocument(uri,languageId,version,content)}TextDocument.create=create;function is(value){var candidate=value;return Is.defined(candidate)&&Is.string(candidate.uri)&&(Is.undefined(candidate.languageId)||Is.string(candidate.languageId))&&Is.number(candidate.lineCount)&&Is.func(candidate.getText)&&Is.func(candidate.positionAt)&&Is.func(candidate.offsetAt)?true:false}TextDocument.is=is;function applyEdits(document,edits){var text=document.getText();var sortedEdits=mergeSort(edits,(function(a,b){var diff=a.range.start.line-b.range.start.line;if(diff===0){return a.range.start.character-b.range.start.character}return diff}));var lastModifiedOffset=text.length;for(var i=sortedEdits.length-1;i>=0;i--){var e=sortedEdits[i];var startOffset=document.offsetAt(e.range.start);var endOffset=document.offsetAt(e.range.end);if(endOffset<=lastModifiedOffset){text=text.substring(0,startOffset)+e.newText+text.substring(endOffset,text.length)}else{throw new Error("Overlapping edit")}lastModifiedOffset=startOffset}return text}TextDocument.applyEdits=applyEdits;function mergeSort(data,compare){if(data.length<=1){return data}var p=data.length/2|0;var left=data.slice(0,p);var right=data.slice(p);mergeSort(left,compare);mergeSort(right,compare);var leftIdx=0;var rightIdx=0;var i=0;while(leftIdx<left.length&&rightIdx<right.length){var ret=compare(left[leftIdx],right[rightIdx]);if(ret<=0){data[i++]=left[leftIdx++]}else{data[i++]=right[rightIdx++]}}while(leftIdx<left.length){data[i++]=left[leftIdx++]}while(rightIdx<right.length){data[i++]=right[rightIdx++]}return data}})(TextDocument||(TextDocument={}));var TextDocumentSaveReason;(function(TextDocumentSaveReason){TextDocumentSaveReason.Manual=1;TextDocumentSaveReason.AfterDelay=2;TextDocumentSaveReason.FocusOut=3})(TextDocumentSaveReason||(TextDocumentSaveReason={}));var FullTextDocument=function(){function FullTextDocument(uri,languageId,version,content){this._uri=uri;this._languageId=languageId;this._version=version;this._content=content;this._lineOffsets=null}Object.defineProperty(FullTextDocument.prototype,"uri",{get:function(){return this._uri},enumerable:true,configurable:true});Object.defineProperty(FullTextDocument.prototype,"languageId",{get:function(){return this._languageId},enumerable:true,configurable:true});Object.defineProperty(FullTextDocument.prototype,"version",{get:function(){return this._version},enumerable:true,configurable:true});FullTextDocument.prototype.getText=function(range){if(range){var start=this.offsetAt(range.start);var end=this.offsetAt(range.end);return this._content.substring(start,end)}return this._content};FullTextDocument.prototype.update=function(event,version){this._content=event.text;this._version=version;this._lineOffsets=null};FullTextDocument.prototype.getLineOffsets=function(){if(this._lineOffsets===null){var lineOffsets=[];var text=this._content;var isLineStart=true;for(var i=0;i<text.length;i++){if(isLineStart){lineOffsets.push(i);isLineStart=false}var ch=text.charAt(i);isLineStart=ch==="\r"||ch==="\n";if(ch==="\r"&&i+1<text.length&&text.charAt(i+1)==="\n"){i++}}if(isLineStart&&text.length>0){lineOffsets.push(text.length)}this._lineOffsets=lineOffsets}return this._lineOffsets};FullTextDocument.prototype.positionAt=function(offset){offset=Math.max(Math.min(offset,this._content.length),0);var lineOffsets=this.getLineOffsets();var low=0,high=lineOffsets.length;if(high===0){return Position.create(0,offset)}while(low<high){var mid=Math.floor((low+high)/2);if(lineOffsets[mid]>offset){high=mid}else{low=mid+1}}var line=low-1;return Position.create(line,offset-lineOffsets[line])};FullTextDocument.prototype.offsetAt=function(position){var lineOffsets=this.getLineOffsets();if(position.line>=lineOffsets.length){return this._content.length}else if(position.line<0){return 0}var lineOffset=lineOffsets[position.line];var nextLineOffset=position.line+1<lineOffsets.length?lineOffsets[position.line+1]:this._content.length;return Math.max(Math.min(lineOffset+position.character,nextLineOffset),lineOffset)};Object.defineProperty(FullTextDocument.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:true,configurable:true});return FullTextDocument}();var Is;(function(Is){var toString=Object.prototype.toString;function defined(value){return typeof value!=="undefined"}Is.defined=defined;function undefined(value){return typeof value==="undefined"}Is.undefined=undefined;function boolean(value){return value===true||value===false}Is.boolean=boolean;function string(value){return toString.call(value)==="[object String]"}Is.string=string;function number(value){return toString.call(value)==="[object Number]"}Is.number=number;function func(value){return toString.call(value)==="[object Function]"}Is.func=func;function objectLiteral(value){return value!==null&&typeof value==="object"}Is.objectLiteral=objectLiteral;function typedArray(value,check){return Array.isArray(value)&&value.every(check)}Is.typedArray=typedArray})(Is||(Is={}));var Uri=monaco.Uri;var languageFeatures_Range=monaco.Range;var DiagnosticsAdapter=function(){function DiagnosticsAdapter(_languageId,_worker,defaults){var _this=this;this._languageId=_languageId;this._worker=_worker;this._disposables=[];this._listener=Object.create(null);var onModelAdd=function(model){var modeId=model.getModeId();if(modeId!==_this._languageId){return}var handle;_this._listener[model.uri.toString()]=model.onDidChangeContent((function(){clearTimeout(handle);handle=setTimeout((function(){return _this._doValidate(model.uri,modeId)}),500)}));_this._doValidate(model.uri,modeId)};var onModelRemoved=function(model){monaco.editor.setModelMarkers(model,_this._languageId,[]);var uriStr=model.uri.toString();var listener=_this._listener[uriStr];if(listener){listener.dispose();delete _this._listener[uriStr]}};this._disposables.push(monaco.editor.onDidCreateModel(onModelAdd));this._disposables.push(monaco.editor.onWillDisposeModel((function(model){onModelRemoved(model);_this._resetSchema(model.uri)})));this._disposables.push(monaco.editor.onDidChangeModelLanguage((function(event){onModelRemoved(event.model);onModelAdd(event.model);_this._resetSchema(event.model.uri)})));this._disposables.push(defaults.onDidChange((function(_){monaco.editor.getModels().forEach((function(model){if(model.getModeId()===_this._languageId){onModelRemoved(model);onModelAdd(model)}}))})));this._disposables.push({dispose:function(){monaco.editor.getModels().forEach(onModelRemoved);for(var key in _this._listener){_this._listener[key].dispose()}}});monaco.editor.getModels().forEach(onModelAdd)}DiagnosticsAdapter.prototype.dispose=function(){this._disposables.forEach((function(d){return d&&d.dispose()}));this._disposables=[]};DiagnosticsAdapter.prototype._resetSchema=function(resource){this._worker().then((function(worker){worker.resetSchema(resource.toString())}))};DiagnosticsAdapter.prototype._doValidate=function(resource,languageId){this._worker(resource).then((function(worker){return worker.doValidation(resource.toString()).then((function(diagnostics){var markers=diagnostics.map((function(d){return toDiagnostics(resource,d)}));var model=monaco.editor.getModel(resource);if(model&&model.getModeId()===languageId){monaco.editor.setModelMarkers(model,languageId,markers)}}))})).then(undefined,(function(err){console.error(err)}))};return DiagnosticsAdapter}();function toSeverity(lsSeverity){switch(lsSeverity){case DiagnosticSeverity.Error:return monaco.MarkerSeverity.Error;case DiagnosticSeverity.Warning:return monaco.MarkerSeverity.Warning;case DiagnosticSeverity.Information:return monaco.MarkerSeverity.Info;case DiagnosticSeverity.Hint:return monaco.MarkerSeverity.Hint;default:return monaco.MarkerSeverity.Info}}function toDiagnostics(resource,diag){var code=typeof diag.code==="number"?String(diag.code):diag.code;return{severity:toSeverity(diag.severity),startLineNumber:diag.range.start.line+1,startColumn:diag.range.start.character+1,endLineNumber:diag.range.end.line+1,endColumn:diag.range.end.character+1,message:diag.message,code:code,source:diag.source}}function fromPosition(position){if(!position){return void 0}return{character:position.column-1,line:position.lineNumber-1}}function fromRange(range){if(!range){return void 0}return{start:{line:range.startLineNumber-1,character:range.startColumn-1},end:{line:range.endLineNumber-1,character:range.endColumn-1}}}function toRange(range){if(!range){return void 0}return new languageFeatures_Range(range.start.line+1,range.start.character+1,range.end.line+1,range.end.character+1)}function toCompletionItemKind(kind){var mItemKind=monaco.languages.CompletionItemKind;switch(kind){case CompletionItemKind.Text:return mItemKind.Text;case CompletionItemKind.Method:return mItemKind.Method;case CompletionItemKind.Function:return mItemKind.Function;case CompletionItemKind.Constructor:return mItemKind.Constructor;case CompletionItemKind.Field:return mItemKind.Field;case CompletionItemKind.Variable:return mItemKind.Variable;case CompletionItemKind.Class:return mItemKind.Class;case CompletionItemKind.Interface:return mItemKind.Interface;case CompletionItemKind.Module:return mItemKind.Module;case CompletionItemKind.Property:return mItemKind.Property;case CompletionItemKind.Unit:return mItemKind.Unit;case CompletionItemKind.Value:return mItemKind.Value;case CompletionItemKind.Enum:return mItemKind.Enum;case CompletionItemKind.Keyword:return mItemKind.Keyword;case CompletionItemKind.Snippet:return mItemKind.Snippet;case CompletionItemKind.Color:return mItemKind.Color;case CompletionItemKind.File:return mItemKind.File;case CompletionItemKind.Reference:return mItemKind.Reference}return mItemKind.Property}function fromCompletionItemKind(kind){var mItemKind=monaco.languages.CompletionItemKind;switch(kind){case mItemKind.Text:return CompletionItemKind.Text;case mItemKind.Method:return CompletionItemKind.Method;case mItemKind.Function:return CompletionItemKind.Function;case mItemKind.Constructor:return CompletionItemKind.Constructor;case mItemKind.Field:return CompletionItemKind.Field;case mItemKind.Variable:return CompletionItemKind.Variable;case mItemKind.Class:return CompletionItemKind.Class;case mItemKind.Interface:return CompletionItemKind.Interface;case mItemKind.Module:return CompletionItemKind.Module;case mItemKind.Property:return CompletionItemKind.Property;case mItemKind.Unit:return CompletionItemKind.Unit;case mItemKind.Value:return CompletionItemKind.Value;case mItemKind.Enum:return CompletionItemKind.Enum;case mItemKind.Keyword:return CompletionItemKind.Keyword;case mItemKind.Snippet:return CompletionItemKind.Snippet;case mItemKind.Color:return CompletionItemKind.Color;case mItemKind.File:return CompletionItemKind.File;case mItemKind.Reference:return CompletionItemKind.Reference}return CompletionItemKind.Property}function toTextEdit(textEdit){if(!textEdit){return void 0}return{range:toRange(textEdit.range),text:textEdit.newText}}var languageFeatures_CompletionAdapter=function(){function CompletionAdapter(_worker){this._worker=_worker}Object.defineProperty(CompletionAdapter.prototype,"triggerCharacters",{get:function(){return[" ",":"]},enumerable:true,configurable:true});CompletionAdapter.prototype.provideCompletionItems=function(model,position,context,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.doComplete(resource.toString(),fromPosition(position))})).then((function(info){if(!info){return}var wordInfo=model.getWordUntilPosition(position);var wordRange=new languageFeatures_Range(position.lineNumber,wordInfo.startColumn,position.lineNumber,wordInfo.endColumn);var items=info.items.map((function(entry){var item={label:entry.label,insertText:entry.insertText||entry.label,sortText:entry.sortText,filterText:entry.filterText,documentation:entry.documentation,detail:entry.detail,range:wordRange,kind:toCompletionItemKind(entry.kind)};if(entry.textEdit){item.range=toRange(entry.textEdit.range);item.insertText=entry.textEdit.newText}if(entry.additionalTextEdits){item.additionalTextEdits=entry.additionalTextEdits.map(toTextEdit)}if(entry.insertTextFormat===InsertTextFormat.Snippet){item.insertTextRules=monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet}return item}));return{isIncomplete:info.isIncomplete,suggestions:items}}))};return CompletionAdapter}();function isMarkupContent(thing){return thing&&typeof thing==="object"&&typeof thing.kind==="string"}function toMarkdownString(entry){if(typeof entry==="string"){return{value:entry}}if(isMarkupContent(entry)){if(entry.kind==="plaintext"){return{value:entry.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}}return{value:entry.value}}return{value:"```"+entry.language+"\n"+entry.value+"\n```\n"}}function toMarkedStringArray(contents){if(!contents){return void 0}if(Array.isArray(contents)){return contents.map(toMarkdownString)}return[toMarkdownString(contents)]}var HoverAdapter=function(){function HoverAdapter(_worker){this._worker=_worker}HoverAdapter.prototype.provideHover=function(model,position,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.doHover(resource.toString(),fromPosition(position))})).then((function(info){if(!info){return}return{range:toRange(info.range),contents:toMarkedStringArray(info.contents)}}))};return HoverAdapter}();function toLocation(location){return{uri:Uri.parse(location.uri),range:toRange(location.range)}}function toSymbolKind(kind){var mKind=monaco.languages.SymbolKind;switch(kind){case SymbolKind.File:return mKind.Array;case SymbolKind.Module:return mKind.Module;case SymbolKind.Namespace:return mKind.Namespace;case SymbolKind.Package:return mKind.Package;case SymbolKind.Class:return mKind.Class;case SymbolKind.Method:return mKind.Method;case SymbolKind.Property:return mKind.Property;case SymbolKind.Field:return mKind.Field;case SymbolKind.Constructor:return mKind.Constructor;case SymbolKind.Enum:return mKind.Enum;case SymbolKind.Interface:return mKind.Interface;case SymbolKind.Function:return mKind.Function;case SymbolKind.Variable:return mKind.Variable;case SymbolKind.Constant:return mKind.Constant;case SymbolKind.String:return mKind.String;case SymbolKind.Number:return mKind.Number;case SymbolKind.Boolean:return mKind.Boolean;case SymbolKind.Array:return mKind.Array}return mKind.Function}var DocumentSymbolAdapter=function(){function DocumentSymbolAdapter(_worker){this._worker=_worker}DocumentSymbolAdapter.prototype.provideDocumentSymbols=function(model,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.findDocumentSymbols(resource.toString())})).then((function(items){if(!items){return}return items.map((function(item){return{name:item.name,detail:"",containerName:item.containerName,kind:toSymbolKind(item.kind),range:toRange(item.location.range),selectionRange:toRange(item.location.range)}}))}))};return DocumentSymbolAdapter}();function fromFormattingOptions(options){return{tabSize:options.tabSize,insertSpaces:options.insertSpaces}}var DocumentFormattingEditProvider=function(){function DocumentFormattingEditProvider(_worker){this._worker=_worker}DocumentFormattingEditProvider.prototype.provideDocumentFormattingEdits=function(model,options,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.format(resource.toString(),null,fromFormattingOptions(options)).then((function(edits){if(!edits||edits.length===0){return}return edits.map(toTextEdit)}))}))};return DocumentFormattingEditProvider}();var DocumentRangeFormattingEditProvider=function(){function DocumentRangeFormattingEditProvider(_worker){this._worker=_worker}DocumentRangeFormattingEditProvider.prototype.provideDocumentRangeFormattingEdits=function(model,range,options,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.format(resource.toString(),fromRange(range),fromFormattingOptions(options)).then((function(edits){if(!edits||edits.length===0){return}return edits.map(toTextEdit)}))}))};return DocumentRangeFormattingEditProvider}();var DocumentColorAdapter=function(){function DocumentColorAdapter(_worker){this._worker=_worker}DocumentColorAdapter.prototype.provideDocumentColors=function(model,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.findDocumentColors(resource.toString())})).then((function(infos){if(!infos){return}return infos.map((function(item){return{color:item.color,range:toRange(item.range)}}))}))};DocumentColorAdapter.prototype.provideColorPresentations=function(model,info,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.getColorPresentations(resource.toString(),info.color,fromRange(info.range))})).then((function(presentations){if(!presentations){return}return presentations.map((function(presentation){var item={label:presentation.label};if(presentation.textEdit){item.textEdit=toTextEdit(presentation.textEdit)}if(presentation.additionalTextEdits){item.additionalTextEdits=presentation.additionalTextEdits.map(toTextEdit)}return item}))}))};return DocumentColorAdapter}();var FoldingRangeAdapter=function(){function FoldingRangeAdapter(_worker){this._worker=_worker}FoldingRangeAdapter.prototype.provideFoldingRanges=function(model,context,token){var resource=model.uri;return this._worker(resource).then((function(worker){return worker.provideFoldingRanges(resource.toString(),context)})).then((function(ranges){if(!ranges){return}return ranges.map((function(range){var result={start:range.startLine+1,end:range.endLine+1};if(typeof range.kind!=="undefined"){result.kind=toFoldingRangeKind(range.kind)}return result}))}))};return FoldingRangeAdapter}();function toFoldingRangeKind(kind){switch(kind){case FoldingRangeKind.Comment:return monaco.languages.FoldingRangeKind.Comment;case FoldingRangeKind.Imports:return monaco.languages.FoldingRangeKind.Imports;case FoldingRangeKind.Region:return monaco.languages.FoldingRangeKind.Region}return void 0}function createScanner(text,ignoreTrivia){if(ignoreTrivia===void 0){ignoreTrivia=false}var pos=0,len=text.length,value="",tokenOffset=0,token=16,scanError=0;function scanHexDigits(count,exact){var digits=0;var value=0;while(digits<count||!exact){var ch=text.charCodeAt(pos);if(ch>=48&&ch<=57){value=value*16+ch-48}else if(ch>=65&&ch<=70){value=value*16+ch-65+10}else if(ch>=97&&ch<=102){value=value*16+ch-97+10}else{break}pos++;digits++}if(digits<count){value=-1}return value}function setPosition(newPosition){pos=newPosition;value="";tokenOffset=0;token=16;scanError=0}function scanNumber(){var start=pos;if(text.charCodeAt(pos)===48){pos++}else{pos++;while(pos<text.length&&isDigit(text.charCodeAt(pos))){pos++}}if(pos<text.length&&text.charCodeAt(pos)===46){pos++;if(pos<text.length&&isDigit(text.charCodeAt(pos))){pos++;while(pos<text.length&&isDigit(text.charCodeAt(pos))){pos++}}else{scanError=3;return text.substring(start,pos)}}var end=pos;if(pos<text.length&&(text.charCodeAt(pos)===69||text.charCodeAt(pos)===101)){pos++;if(pos<text.length&&text.charCodeAt(pos)===43||text.charCodeAt(pos)===45){pos++}if(pos<text.length&&isDigit(text.charCodeAt(pos))){pos++;while(pos<text.length&&isDigit(text.charCodeAt(pos))){pos++}end=pos}else{scanError=3}}return text.substring(start,end)}function scanString(){var result="",start=pos;while(true){if(pos>=len){result+=text.substring(start,pos);scanError=2;break}var ch=text.charCodeAt(pos);if(ch===34){result+=text.substring(start,pos);pos++;break}if(ch===92){result+=text.substring(start,pos);pos++;if(pos>=len){scanError=2;break}ch=text.charCodeAt(pos++);switch(ch){case 34:result+='"';break;case 92:result+="\\";break;case 47:result+="/";break;case 98:result+="\b";break;case 102:result+="\f";break;case 110:result+="\n";break;case 114:result+="\r";break;case 116:result+="\t";break;case 117:var ch_1=scanHexDigits(4,true);if(ch_1>=0){result+=String.fromCharCode(ch_1)}else{scanError=4}break;default:scanError=5}start=pos;continue}if(ch>=0&&ch<=31){if(isLineBreak(ch)){result+=text.substring(start,pos);scanError=2;break}else{scanError=6}}pos++}return result}function scanNext(){value="";scanError=0;tokenOffset=pos;if(pos>=len){tokenOffset=len;return token=17}var code=text.charCodeAt(pos);if(isWhiteSpace(code)){do{pos++;value+=String.fromCharCode(code);code=text.charCodeAt(pos)}while(isWhiteSpace(code));return token=15}if(isLineBreak(code)){pos++;value+=String.fromCharCode(code);if(code===13&&text.charCodeAt(pos)===10){pos++;value+="\n"}return token=14}switch(code){case 123:pos++;return token=1;case 125:pos++;return token=2;case 91:pos++;return token=3;case 93:pos++;return token=4;case 58:pos++;return token=6;case 44:pos++;return token=5;case 34:pos++;value=scanString();return token=10;case 47:var start=pos-1;if(text.charCodeAt(pos+1)===47){pos+=2;while(pos<len){if(isLineBreak(text.charCodeAt(pos))){break}pos++}value=text.substring(start,pos);return token=12}if(text.charCodeAt(pos+1)===42){pos+=2;var safeLength=len-1;var commentClosed=false;while(pos<safeLength){var ch=text.charCodeAt(pos);if(ch===42&&text.charCodeAt(pos+1)===47){pos+=2;commentClosed=true;break}pos++}if(!commentClosed){pos++;scanError=1}value=text.substring(start,pos);return token=13}value+=String.fromCharCode(code);pos++;return token=16;case 45:value+=String.fromCharCode(code);pos++;if(pos===len||!isDigit(text.charCodeAt(pos))){return token=16}case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:value+=scanNumber();return token=11;default:while(pos<len&&isUnknownContentCharacter(code)){pos++;code=text.charCodeAt(pos)}if(tokenOffset!==pos){value=text.substring(tokenOffset,pos);switch(value){case"true":return token=8;case"false":return token=9;case"null":return token=7}return token=16}value+=String.fromCharCode(code);pos++;return token=16}}function isUnknownContentCharacter(code){if(isWhiteSpace(code)||isLineBreak(code)){return false}switch(code){case 125:case 93:case 123:case 91:case 34:case 58:case 44:case 47:return false}return true}function scanNextNonTrivia(){var result;do{result=scanNext()}while(result>=12&&result<=15);return result}return{setPosition:setPosition,getPosition:function(){return pos},scan:ignoreTrivia?scanNextNonTrivia:scanNext,getToken:function(){return token},getTokenValue:function(){return value},getTokenOffset:function(){return tokenOffset},getTokenLength:function(){return pos-tokenOffset},getTokenError:function(){return scanError}}}function isWhiteSpace(ch){return ch===32||ch===9||ch===11||ch===12||ch===160||ch===5760||ch>=8192&&ch<=8203||ch===8239||ch===8287||ch===12288||ch===65279}function isLineBreak(ch){return ch===10||ch===13||ch===8232||ch===8233}function isDigit(ch){return ch>=48&&ch<=57}function format(documentText,range,options){var initialIndentLevel;var formatText;var formatTextStart;var rangeStart;var rangeEnd;if(range){rangeStart=range.offset;rangeEnd=rangeStart+range.length;formatTextStart=rangeStart;while(formatTextStart>0&&!isEOL(documentText,formatTextStart-1)){formatTextStart--}var endOffset=rangeEnd;while(endOffset<documentText.length&&!isEOL(documentText,endOffset)){endOffset++}formatText=documentText.substring(formatTextStart,endOffset);initialIndentLevel=computeIndentLevel(formatText,options)}else{formatText=documentText;initialIndentLevel=0;formatTextStart=0;rangeStart=0;rangeEnd=documentText.length}var eol=getEOL(options,documentText);var lineBreak=false;var indentLevel=0;var indentValue;if(options.insertSpaces){indentValue=repeat(" ",options.tabSize||4)}else{indentValue="\t"}var scanner=createScanner(formatText,false);var hasError=false;function newLineAndIndent(){return eol+repeat(indentValue,initialIndentLevel+indentLevel)}function scanNext(){var token=scanner.scan();lineBreak=false;while(token===15||token===14){lineBreak=lineBreak||token===14;token=scanner.scan()}hasError=token===16||scanner.getTokenError()!==0;return token}var editOperations=[];function addEdit(text,startOffset,endOffset){if(!hasError&&startOffset<rangeEnd&&endOffset>rangeStart&&documentText.substring(startOffset,endOffset)!==text){editOperations.push({offset:startOffset,length:endOffset-startOffset,content:text})}}var firstToken=scanNext();if(firstToken!==17){var firstTokenStart=scanner.getTokenOffset()+formatTextStart;var initialIndent=repeat(indentValue,initialIndentLevel);addEdit(initialIndent,formatTextStart,firstTokenStart)}while(firstToken!==17){var firstTokenEnd=scanner.getTokenOffset()+scanner.getTokenLength()+formatTextStart;var secondToken=scanNext();var replaceContent="";while(!lineBreak&&(secondToken===12||secondToken===13)){var commentTokenStart=scanner.getTokenOffset()+formatTextStart;addEdit(" ",firstTokenEnd,commentTokenStart);firstTokenEnd=scanner.getTokenOffset()+scanner.getTokenLength()+formatTextStart;replaceContent=secondToken===12?newLineAndIndent():"";secondToken=scanNext()}if(secondToken===2){if(firstToken!==1){indentLevel--;replaceContent=newLineAndIndent()}}else if(secondToken===4){if(firstToken!==3){indentLevel--;replaceContent=newLineAndIndent()}}else{switch(firstToken){case 3:case 1:indentLevel++;replaceContent=newLineAndIndent();break;case 5:case 12:replaceContent=newLineAndIndent();break;case 13:if(lineBreak){replaceContent=newLineAndIndent()}else{replaceContent=" "}break;case 6:replaceContent=" ";break;case 10:if(secondToken===6){replaceContent="";break}case 7:case 8:case 9:case 11:case 2:case 4:if(secondToken===12||secondToken===13){replaceContent=" "}else if(secondToken!==5&&secondToken!==17){hasError=true}break;case 16:hasError=true;break}if(lineBreak&&(secondToken===12||secondToken===13)){replaceContent=newLineAndIndent()}}var secondTokenStart=scanner.getTokenOffset()+formatTextStart;addEdit(replaceContent,firstTokenEnd,secondTokenStart);firstToken=secondToken}return editOperations}function repeat(s,count){var result="";for(var i=0;i<count;i++){result+=s}return result}function computeIndentLevel(content,options){var i=0;var nChars=0;var tabSize=options.tabSize||4;while(i<content.length){var ch=content.charAt(i);if(ch===" "){nChars++}else if(ch==="\t"){nChars+=tabSize}else{break}i++}return Math.floor(nChars/tabSize)}function getEOL(options,text){for(var i=0;i<text.length;i++){var ch=text.charAt(i);if(ch==="\r"){if(i+1<text.length&&text.charAt(i+1)==="\n"){return"\r\n"}return"\r"}else if(ch==="\n"){return"\n"}}return options&&options.eol||"\n"}function isEOL(text,offset){return"\r\n".indexOf(text.charAt(offset))!==-1}var ParseOptions;(function(ParseOptions){ParseOptions.DEFAULT={allowTrailingComma:false}})(ParseOptions||(ParseOptions={}));function getLocation(text,position){var segments=[];var earlyReturnException=new Object;var previousNode=void 0;var previousNodeInst={value:{},offset:0,length:0,type:"object",parent:void 0};var isAtPropertyKey=false;function setPreviousNode(value,offset,length,type){previousNodeInst.value=value;previousNodeInst.offset=offset;previousNodeInst.length=length;previousNodeInst.type=type;previousNodeInst.colonOffset=void 0;previousNode=previousNodeInst}try{visit(text,{onObjectBegin:function(offset,length){if(position<=offset){throw earlyReturnException}previousNode=void 0;isAtPropertyKey=position>offset;segments.push("")},onObjectProperty:function(name,offset,length){if(position<offset){throw earlyReturnException}setPreviousNode(name,offset,length,"property");segments[segments.length-1]=name;if(position<=offset+length){throw earlyReturnException}},onObjectEnd:function(offset,length){if(position<=offset){throw earlyReturnException}previousNode=void 0;segments.pop()},onArrayBegin:function(offset,length){if(position<=offset){throw earlyReturnException}previousNode=void 0;segments.push(0)},onArrayEnd:function(offset,length){if(position<=offset){throw earlyReturnException}previousNode=void 0;segments.pop()},onLiteralValue:function(value,offset,length){if(position<offset){throw earlyReturnException}setPreviousNode(value,offset,length,getLiteralNodeType(value));if(position<=offset+length){throw earlyReturnException}},onSeparator:function(sep,offset,length){if(position<=offset){throw earlyReturnException}if(sep===":"&&previousNode&&previousNode.type==="property"){previousNode.colonOffset=offset;isAtPropertyKey=false;previousNode=void 0}else if(sep===","){var last=segments[segments.length-1];if(typeof last==="number"){segments[segments.length-1]=last+1}else{isAtPropertyKey=true;segments[segments.length-1]=""}previousNode=void 0}}})}catch(e){if(e!==earlyReturnException){throw e}}return{path:segments,previousNode:previousNode,isAtPropertyKey:isAtPropertyKey,matches:function(pattern){var k=0;for(var i=0;k<pattern.length&&i<segments.length;i++){if(pattern[k]===segments[i]||pattern[k]==="*"){k++}else if(pattern[k]!=="**"){return false}}return k===pattern.length}}}function parse(text,errors,options){if(errors===void 0){errors=[]}if(options===void 0){options=ParseOptions.DEFAULT}var currentProperty=null;var currentParent=[];var previousParents=[];function onValue(value){if(Array.isArray(currentParent)){currentParent.push(value)}else if(currentProperty){currentParent[currentProperty]=value}}var visitor={onObjectBegin:function(){var object={};onValue(object);previousParents.push(currentParent);currentParent=object;currentProperty=null},onObjectProperty:function(name){currentProperty=name},onObjectEnd:function(){currentParent=previousParents.pop()},onArrayBegin:function(){var array=[];onValue(array);previousParents.push(currentParent);currentParent=array;currentProperty=null},onArrayEnd:function(){currentParent=previousParents.pop()},onLiteralValue:onValue,onError:function(error,offset,length){errors.push({error:error,offset:offset,length:length})}};visit(text,visitor,options);return currentParent[0]}function parseTree(text,errors,options){if(errors===void 0){errors=[]}if(options===void 0){options=ParseOptions.DEFAULT}var currentParent={type:"array",offset:-1,length:-1,children:[],parent:void 0};function ensurePropertyComplete(endOffset){if(currentParent.type==="property"){currentParent.length=endOffset-currentParent.offset;currentParent=currentParent.parent}}function onValue(valueNode){currentParent.children.push(valueNode);return valueNode}var visitor={onObjectBegin:function(offset){currentParent=onValue({type:"object",offset:offset,length:-1,parent:currentParent,children:[]})},onObjectProperty:function(name,offset,length){currentParent=onValue({type:"property",offset:offset,length:-1,parent:currentParent,children:[]});currentParent.children.push({type:"string",value:name,offset:offset,length:length,parent:currentParent})},onObjectEnd:function(offset,length){currentParent.length=offset+length-currentParent.offset;currentParent=currentParent.parent;ensurePropertyComplete(offset+length)},onArrayBegin:function(offset,length){currentParent=onValue({type:"array",offset:offset,length:-1,parent:currentParent,children:[]})},onArrayEnd:function(offset,length){currentParent.length=offset+length-currentParent.offset;currentParent=currentParent.parent;ensurePropertyComplete(offset+length)},onLiteralValue:function(value,offset,length){onValue({type:getLiteralNodeType(value),offset:offset,length:length,parent:currentParent,value:value});ensurePropertyComplete(offset+length)},onSeparator:function(sep,offset,length){if(currentParent.type==="property"){if(sep===":"){currentParent.colonOffset=offset}else if(sep===","){ensurePropertyComplete(offset)}}},onError:function(error,offset,length){errors.push({error:error,offset:offset,length:length})}};visit(text,visitor,options);var result=currentParent.children[0];if(result){delete result.parent}return result}function findNodeAtLocation(root,path){if(!root){return void 0}var node=root;for(var _i=0,path_1=path;_i<path_1.length;_i++){var segment=path_1[_i];if(typeof segment==="string"){if(node.type!=="object"||!Array.isArray(node.children)){return void 0}var found=false;for(var _a=0,_b=node.children;_a<_b.length;_a++){var propertyNode=_b[_a];if(Array.isArray(propertyNode.children)&&propertyNode.children[0].value===segment){node=propertyNode.children[1];found=true;break}}if(!found){return void 0}}else{var index=segment;if(node.type!=="array"||index<0||!Array.isArray(node.children)||index>=node.children.length){return void 0}node=node.children[index]}}return node}function getNodePath(node){if(!node.parent||!node.parent.children){return[]}var path=getNodePath(node.parent);if(node.parent.type==="property"){var key=node.parent.children[0].value;path.push(key)}else if(node.parent.type==="array"){var index=node.parent.children.indexOf(node);if(index!==-1){path.push(index)}}return path}function getNodeValue(node){switch(node.type){case"array":return node.children.map(getNodeValue);case"object":var obj=Object.create(null);for(var _i=0,_a=node.children;_i<_a.length;_i++){var prop=_a[_i];var valueNode=prop.children[1];if(valueNode){obj[prop.children[0].value]=getNodeValue(valueNode)}}return obj;case"null":case"string":case"number":case"boolean":return node.value;default:return void 0}}function contains(node,offset,includeRightBound){if(includeRightBound===void 0){includeRightBound=false}return offset>=node.offset&&offset<node.offset+node.length||includeRightBound&&offset===node.offset+node.length}function findNodeAtOffset(node,offset,includeRightBound){if(includeRightBound===void 0){includeRightBound=false}if(contains(node,offset,includeRightBound)){var children=node.children;if(Array.isArray(children)){for(var i=0;i<children.length&&children[i].offset<=offset;i++){var item=findNodeAtOffset(children[i],offset,includeRightBound);if(item){return item}}}return node}return void 0}function visit(text,visitor,options){if(options===void 0){options=ParseOptions.DEFAULT}var _scanner=createScanner(text,false);function toNoArgVisit(visitFunction){return visitFunction?function(){return visitFunction(_scanner.getTokenOffset(),_scanner.getTokenLength())}:function(){return true}}function toOneArgVisit(visitFunction){return visitFunction?function(arg){return visitFunction(arg,_scanner.getTokenOffset(),_scanner.getTokenLength())}:function(){return true}}var onObjectBegin=toNoArgVisit(visitor.onObjectBegin),onObjectProperty=toOneArgVisit(visitor.onObjectProperty),onObjectEnd=toNoArgVisit(visitor.onObjectEnd),onArrayBegin=toNoArgVisit(visitor.onArrayBegin),onArrayEnd=toNoArgVisit(visitor.onArrayEnd),onLiteralValue=toOneArgVisit(visitor.onLiteralValue),onSeparator=toOneArgVisit(visitor.onSeparator),onComment=toNoArgVisit(visitor.onComment),onError=toOneArgVisit(visitor.onError);var disallowComments=options&&options.disallowComments;var allowTrailingComma=options&&options.allowTrailingComma;function scanNext(){while(true){var token=_scanner.scan();switch(_scanner.getTokenError()){case 4:handleError(14);break;case 5:handleError(15);break;case 3:handleError(13);break;case 1:if(!disallowComments){handleError(11)}break;case 2:handleError(12);break;case 6:handleError(16);break}switch(token){case 12:case 13:if(disallowComments){handleError(10)}else{onComment()}break;case 16:handleError(1);break;case 15:case 14:break;default:return token}}}function handleError(error,skipUntilAfter,skipUntil){if(skipUntilAfter===void 0){skipUntilAfter=[]}if(skipUntil===void 0){skipUntil=[]}onError(error);if(skipUntilAfter.length+skipUntil.length>0){var token=_scanner.getToken();while(token!==17){if(skipUntilAfter.indexOf(token)!==-1){scanNext();break}else if(skipUntil.indexOf(token)!==-1){break}token=scanNext()}}}function parseString(isValue){var value=_scanner.getTokenValue();if(isValue){onLiteralValue(value)}else{onObjectProperty(value)}scanNext();return true}function parseLiteral(){switch(_scanner.getToken()){case 11:var value=0;try{value=JSON.parse(_scanner.getTokenValue());if(typeof value!=="number"){handleError(2);value=0}}catch(e){handleError(2)}onLiteralValue(value);break;case 7:onLiteralValue(null);break;case 8:onLiteralValue(true);break;case 9:onLiteralValue(false);break;default:return false}scanNext();return true}function parseProperty(){if(_scanner.getToken()!==10){handleError(3,[],[2,5]);return false}parseString(false);if(_scanner.getToken()===6){onSeparator(":");scanNext();if(!parseValue()){handleError(4,[],[2,5])}}else{handleError(5,[],[2,5])}return true}function parseObject(){onObjectBegin();scanNext();var needsComma=false;while(_scanner.getToken()!==2&&_scanner.getToken()!==17){if(_scanner.getToken()===5){if(!needsComma){handleError(4,[],[])}onSeparator(",");scanNext();if(_scanner.getToken()===2&&allowTrailingComma){break}}else if(needsComma){handleError(6,[],[])}if(!parseProperty()){handleError(4,[],[2,5])}needsComma=true}onObjectEnd();if(_scanner.getToken()!==2){handleError(7,[2],[])}else{scanNext()}return true}function parseArray(){onArrayBegin();scanNext();var needsComma=false;while(_scanner.getToken()!==4&&_scanner.getToken()!==17){if(_scanner.getToken()===5){if(!needsComma){handleError(4,[],[])}onSeparator(",");scanNext();if(_scanner.getToken()===4&&allowTrailingComma){break}}else if(needsComma){handleError(6,[],[])}if(!parseValue()){handleError(4,[],[4,5])}needsComma=true}onArrayEnd();if(_scanner.getToken()!==4){handleError(8,[4],[])}else{scanNext()}return true}function parseValue(){switch(_scanner.getToken()){case 3:return parseArray();case 1:return parseObject();case 10:return parseString(true);default:return parseLiteral()}}scanNext();if(_scanner.getToken()===17){return true}if(!parseValue()){handleError(4,[],[]);return false}if(_scanner.getToken()!==17){handleError(9,[],[])}return true}function stripComments(text,replaceCh){var _scanner=createScanner(text),parts=[],kind,offset=0,pos;do{pos=_scanner.getPosition();kind=_scanner.scan();switch(kind){case 12:case 13:case 17:if(offset!==pos){parts.push(text.substring(offset,pos))}if(replaceCh!==void 0){parts.push(_scanner.getTokenValue().replace(/[^\r\n]/g,replaceCh))}offset=_scanner.getPosition();break}}while(kind!==17);return parts.join("")}function getLiteralNodeType(value){switch(typeof value){case"boolean":return"boolean";case"number":return"number";case"string":return"string";default:return"null"}}function removeProperty(text,path,formattingOptions){return setProperty(text,path,void 0,formattingOptions)}function setProperty(text,originalPath,value,formattingOptions,getInsertionIndex){var _a;var path=originalPath.slice();var errors=[];var root=parseTree(text,errors);var parent=void 0;var lastSegment=void 0;while(path.length>0){lastSegment=path.pop();parent=findNodeAtLocation(root,path);if(parent===void 0&&value!==void 0){if(typeof lastSegment==="string"){value=(_a={},_a[lastSegment]=value,_a)}else{value=[value]}}else{break}}if(!parent){if(value===void 0){throw new Error("Can not delete in empty document")}return withFormatting(text,{offset:root?root.offset:0,length:root?root.length:0,content:JSON.stringify(value)},formattingOptions)}else if(parent.type==="object"&&typeof lastSegment==="string"&&Array.isArray(parent.children)){var existing=findNodeAtLocation(parent,[lastSegment]);if(existing!==void 0){if(value===void 0){if(!existing.parent){throw new Error("Malformed AST")}var propertyIndex=parent.children.indexOf(existing.parent);var removeBegin=void 0;var removeEnd=existing.parent.offset+existing.parent.length;if(propertyIndex>0){var previous=parent.children[propertyIndex-1];removeBegin=previous.offset+previous.length}else{removeBegin=parent.offset+1;if(parent.children.length>1){var next=parent.children[1];removeEnd=next.offset}}return withFormatting(text,{offset:removeBegin,length:removeEnd-removeBegin,content:""},formattingOptions)}else{return withFormatting(text,{offset:existing.offset,length:existing.length,content:JSON.stringify(value)},formattingOptions)}}else{if(value===void 0){return[]}var newProperty=JSON.stringify(lastSegment)+": "+JSON.stringify(value);var index=getInsertionIndex?getInsertionIndex(parent.children.map((function(p){return p.children[0].value}))):parent.children.length;var edit=void 0;if(index>0){var previous=parent.children[index-1];edit={offset:previous.offset+previous.length,length:0,content:","+newProperty}}else if(parent.children.length===0){edit={offset:parent.offset+1,length:0,content:newProperty}}else{edit={offset:parent.offset+1,length:0,content:newProperty+","}}return withFormatting(text,edit,formattingOptions)}}else if(parent.type==="array"&&typeof lastSegment==="number"&&Array.isArray(parent.children)){var insertIndex=lastSegment;if(insertIndex===-1){var newProperty=""+JSON.stringify(value);var edit=void 0;if(parent.children.length===0){edit={offset:parent.offset+1,length:0,content:newProperty}}else{var previous=parent.children[parent.children.length-1];edit={offset:previous.offset+previous.length,length:0,content:","+newProperty}}return withFormatting(text,edit,formattingOptions)}else{if(value===void 0&&parent.children.length>=0){var removalIndex=lastSegment;var toRemove=parent.children[removalIndex];var edit=void 0;if(parent.children.length===1){edit={offset:parent.offset+1,length:parent.length-2,content:""}}else if(parent.children.length-1===removalIndex){var previous=parent.children[removalIndex-1];var offset=previous.offset+previous.length;var parentEndOffset=parent.offset+parent.length;edit={offset:offset,length:parentEndOffset-2-offset,content:""}}else{edit={offset:toRemove.offset,length:parent.children[removalIndex+1].offset-toRemove.offset,content:""}}return withFormatting(text,edit,formattingOptions)}else{throw new Error("Array modification not supported yet")}}}else{throw new Error("Can not add "+(typeof lastSegment!=="number"?"index":"property")+" to parent of type "+parent.type)}}function withFormatting(text,edit,formattingOptions){var newText=applyEdit(text,edit);var begin=edit.offset;var end=edit.offset+edit.content.length;if(edit.length===0||edit.content.length===0){while(begin>0&&!isEOL(newText,begin-1)){begin--}while(end<newText.length&&!isEOL(newText,end)){end++}}var edits=format(newText,{offset:begin,length:end-begin},formattingOptions);for(var i=edits.length-1;i>=0;i--){var edit_1=edits[i];newText=applyEdit(newText,edit_1);begin=Math.min(begin,edit_1.offset);end=Math.max(end,edit_1.offset+edit_1.length);end+=edit_1.content.length-edit_1.length}var editLength=text.length-(newText.length-end)-begin;return[{offset:begin,length:editLength,content:newText.substring(begin,end)}]}function applyEdit(text,edit){return text.substring(0,edit.offset)+edit.content+text.substring(edit.offset+edit.length)}function isWS(text,offset){return"\r\n \t".indexOf(text.charAt(offset))!==-1}var main_createScanner=createScanner;var main_getLocation=getLocation;var main_parse=parse;var main_parseTree=parseTree;var main_findNodeAtLocation=findNodeAtLocation;var main_findNodeAtOffset=findNodeAtOffset;var main_getNodePath=getNodePath;var main_getNodeValue=getNodeValue;var main_visit=visit;var main_stripComments=stripComments;function printParseErrorCode(code){switch(code){case 1:return"InvalidSymbol";case 2:return"InvalidNumberFormat";case 3:return"PropertyNameExpected";case 4:return"ValueExpected";case 5:return"ColonExpected";case 6:return"CommaExpected";case 7:return"CloseBraceExpected";case 8:return"CloseBracketExpected";case 9:return"EndOfFileExpected";case 10:return"InvalidCommentToken";case 11:return"UnexpectedEndOfComment";case 12:return"UnexpectedEndOfString";case 13:return"UnexpectedEndOfNumber";case 14:return"InvalidUnicode";case 15:return"InvalidEscapeCharacter";case 16:return"InvalidCharacter"}return"<unknown ParseErrorCode>"}function main_format(documentText,range,options){return format(documentText,range,options)}function modify(text,path,value,options){return setProperty(text,path,value,options.formattingOptions,options.getInsertionIndex)}function applyEdits(text,edits){for(var i=edits.length-1;i>=0;i--){text=applyEdit(text,edits[i])}return text}function createTokenizationSupport(supportComments){return{getInitialState:function(){return new JSONState(null,null,false)},tokenize:function(line,state,offsetDelta,stopAtOffset){return tokenize(supportComments,line,state,offsetDelta,stopAtOffset)}}}var TOKEN_DELIM_OBJECT="delimiter.bracket.json";var TOKEN_DELIM_ARRAY="delimiter.array.json";var TOKEN_DELIM_COLON="delimiter.colon.json";var TOKEN_DELIM_COMMA="delimiter.comma.json";var TOKEN_VALUE_BOOLEAN="keyword.json";var TOKEN_VALUE_NULL="keyword.json";var TOKEN_VALUE_STRING="string.value.json";var TOKEN_VALUE_NUMBER="number.json";var TOKEN_PROPERTY_NAME="string.key.json";var TOKEN_COMMENT_BLOCK="comment.block.json";var TOKEN_COMMENT_LINE="comment.line.json";var JSONState=function(){function JSONState(state,scanError,lastWasColon){this._state=state;this.scanError=scanError;this.lastWasColon=lastWasColon}JSONState.prototype.clone=function(){return new JSONState(this._state,this.scanError,this.lastWasColon)};JSONState.prototype.equals=function(other){if(other===this){return true}if(!other||!(other instanceof JSONState)){return false}return this.scanError===other.scanError&&this.lastWasColon===other.lastWasColon};JSONState.prototype.getStateData=function(){return this._state};JSONState.prototype.setStateData=function(state){this._state=state};return JSONState}();function tokenize(comments,line,state,offsetDelta,stopAtOffset){if(offsetDelta===void 0){offsetDelta=0}var numberOfInsertedCharacters=0,adjustOffset=false;switch(state.scanError){case 2:line='"'+line;numberOfInsertedCharacters=1;break;case 1:line="/*"+line;numberOfInsertedCharacters=2;break}var scanner=main_createScanner(line),kind,ret,lastWasColon=state.lastWasColon;ret={tokens:[],endState:state.clone()};while(true){var offset=offsetDelta+scanner.getPosition(),type="";kind=scanner.scan();if(kind===17){break}if(offset===offsetDelta+scanner.getPosition()){throw new Error("Scanner did not advance, next 3 characters are: "+line.substr(scanner.getPosition(),3))}if(adjustOffset){offset-=numberOfInsertedCharacters}adjustOffset=numberOfInsertedCharacters>0;switch(kind){case 1:type=TOKEN_DELIM_OBJECT;lastWasColon=false;break;case 2:type=TOKEN_DELIM_OBJECT;lastWasColon=false;break;case 3:type=TOKEN_DELIM_ARRAY;lastWasColon=false;break;case 4:type=TOKEN_DELIM_ARRAY;lastWasColon=false;break;case 6:type=TOKEN_DELIM_COLON;lastWasColon=true;break;case 5:type=TOKEN_DELIM_COMMA;lastWasColon=false;break;case 8:case 9:type=TOKEN_VALUE_BOOLEAN;lastWasColon=false;break;case 7:type=TOKEN_VALUE_NULL;lastWasColon=false;break;case 10:type=lastWasColon?TOKEN_VALUE_STRING:TOKEN_PROPERTY_NAME;lastWasColon=false;break;case 11:type=TOKEN_VALUE_NUMBER;lastWasColon=false;break}if(comments){switch(kind){case 12:type=TOKEN_COMMENT_LINE;break;case 13:type=TOKEN_COMMENT_BLOCK;break}}ret.endState=new JSONState(state.getStateData(),scanner.getTokenError(),lastWasColon);ret.tokens.push({startIndex:offset,scopes:type})}return ret}function setupMode(defaults){var disposables=[];var client=new WorkerManager(defaults);disposables.push(client);var worker=function(){var uris=[];for(var _i=0;_i<arguments.length;_i++){uris[_i]=arguments[_i]}return client.getLanguageServiceWorker.apply(client,uris)};var languageId=defaults.languageId;disposables.push(monaco.languages.registerCompletionItemProvider(languageId,new languageFeatures_CompletionAdapter(worker)));disposables.push(monaco.languages.registerHoverProvider(languageId,new HoverAdapter(worker)));disposables.push(monaco.languages.registerDocumentSymbolProvider(languageId,new DocumentSymbolAdapter(worker)));disposables.push(monaco.languages.registerDocumentFormattingEditProvider(languageId,new DocumentFormattingEditProvider(worker)));disposables.push(monaco.languages.registerDocumentRangeFormattingEditProvider(languageId,new DocumentRangeFormattingEditProvider(worker)));disposables.push(new DiagnosticsAdapter(languageId,worker,defaults));disposables.push(monaco.languages.setTokensProvider(languageId,createTokenizationSupport(true)));disposables.push(monaco.languages.setLanguageConfiguration(languageId,richEditConfiguration));disposables.push(monaco.languages.registerColorProvider(languageId,new DocumentColorAdapter(worker)));disposables.push(monaco.languages.registerFoldingRangeProvider(languageId,new FoldingRangeAdapter(worker)))}var richEditConfiguration={wordPattern:/(-?\d*\.\d\w*)|([^\[\{\]\}\:\"\,\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"]],autoClosingPairs:[{open:"{",close:"}",notIn:["string"]},{open:"[",close:"]",notIn:["string"]},{open:'"',close:'"',notIn:["string"]}]}},69:function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(78)()}},70:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.processSize=processSize;exports.noop=noop;function processSize(size){return!/^\d+$/.test(size)?size:"".concat(size,"px")}function noop(){}},76:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"default",{enumerable:true,get:function get(){return _editor["default"]}});Object.defineProperty(exports,"MonacoDiffEditor",{enumerable:true,get:function get(){return _diff["default"]}});var _editor=_interopRequireDefault(__webpack_require__(77));var _diff=_interopRequireDefault(__webpack_require__(80));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}},77:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports["default"]=void 0;var monaco=_interopRequireWildcard(__webpack_require__(60));var _propTypes=_interopRequireDefault(__webpack_require__(69));var _react=_interopRequireDefault(__webpack_require__(0));var _utils=__webpack_require__(70);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}else{var newObj={};if(obj!=null){for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):{};if(desc.get||desc.set){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}}newObj["default"]=obj;return newObj}}function _typeof(obj){if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){_typeof=function _typeof(obj){return typeof obj}}else{_typeof=function _typeof(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly)symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}));keys.push.apply(keys,symbols)}return keys}function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};if(i%2){ownKeys(source,true).forEach((function(key){_defineProperty(target,key,source[key])}))}else if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source))}else{ownKeys(source).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))}))}}return target}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);return Constructor}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call}return _assertThisInitialized(self)}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o)};return _getPrototypeOf(o)}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function")}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});if(superClass)_setPrototypeOf(subClass,superClass)}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf||function _setPrototypeOf(o,p){o.__proto__=p;return o};return _setPrototypeOf(o,p)}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}var MonacoEditor=function(_React$Component){_inherits(MonacoEditor,_React$Component);function MonacoEditor(props){var _this;_classCallCheck(this,MonacoEditor);_this=_possibleConstructorReturn(this,_getPrototypeOf(MonacoEditor).call(this,props));_defineProperty(_assertThisInitialized(_this),"assignRef",(function(component){_this.containerElement=component}));_this.containerElement=undefined;return _this}_createClass(MonacoEditor,[{key:"componentDidMount",value:function componentDidMount(){this.initMonaco()}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var _this$props=this.props,value=_this$props.value,language=_this$props.language,theme=_this$props.theme,height=_this$props.height,options=_this$props.options,width=_this$props.width;var editor=this.editor;var model=editor.getModel();if(this.props.value!==model.getValue()){this.editor.pushUndoStop();model.pushEditOperations([],[{range:model.getFullModelRange(),text:value}]);this.editor.pushUndoStop()}if(prevProps.language!==language){monaco.editor.setModelLanguage(model,language)}if(prevProps.theme!==theme){monaco.editor.setTheme(theme)}if(editor&&(width!==prevProps.width||height!==prevProps.height)){editor.layout()}if(prevProps.options!==options){editor.updateOptions(options)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){this.destroyMonaco()}},{key:"destroyMonaco",value:function destroyMonaco(){if(this.editor){this.editor.dispose()}if(this._subscription){this._subscription.dispose()}}},{key:"initMonaco",value:function initMonaco(){var value=this.props.value!==null?this.props.value:this.props.defaultValue;var _this$props2=this.props,language=_this$props2.language,theme=_this$props2.theme,options=_this$props2.options,overrideServices=_this$props2.overrideServices;if(this.containerElement){Object.assign(options,this.editorWillMount());this.editor=monaco.editor.create(this.containerElement,_objectSpread({value:value,language:language},options,{},theme?{theme:theme}:{}),overrideServices);this.editorDidMount(this.editor)}}},{key:"editorWillMount",value:function editorWillMount(){var editorWillMount=this.props.editorWillMount;var options=editorWillMount(monaco);return options||{}}},{key:"editorDidMount",value:function editorDidMount(editor){var _this2=this;this.props.editorDidMount(editor,monaco);this._subscription=editor.onDidChangeModelContent((function(){_this2.props.onChange(editor.getValue())}))}},{key:"render",value:function render(){var _this$props3=this.props,width=_this$props3.width,height=_this$props3.height;var fixedWidth=(0,_utils.processSize)(width);var fixedHeight=(0,_utils.processSize)(height);var style={width:fixedWidth,height:fixedHeight};return _react["default"].createElement("div",{ref:this.assignRef,style:style,className:"react-monaco-editor-container"})}}]);return MonacoEditor}(_react["default"].Component);MonacoEditor.propTypes={width:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].number]),height:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].number]),value:_propTypes["default"].string,defaultValue:_propTypes["default"].string,language:_propTypes["default"].string,theme:_propTypes["default"].string,options:_propTypes["default"].object,overrideServices:_propTypes["default"].object,editorDidMount:_propTypes["default"].func,editorWillMount:_propTypes["default"].func,onChange:_propTypes["default"].func};MonacoEditor.defaultProps={width:"100%",height:"100%",value:null,defaultValue:"",language:"javascript",theme:null,options:{},overrideServices:{},editorDidMount:_utils.noop,editorWillMount:_utils.noop,onChange:_utils.noop};var _default=MonacoEditor;exports["default"]=_default},78:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(79);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bigint:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},79:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},80:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports["default"]=void 0;var monaco=_interopRequireWildcard(__webpack_require__(60));var _react=_interopRequireDefault(__webpack_require__(0));var _propTypes=_interopRequireDefault(__webpack_require__(69));var _utils=__webpack_require__(70);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}else{var newObj={};if(obj!=null){for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):{};if(desc.get||desc.set){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}}newObj["default"]=obj;return newObj}}function _typeof(obj){if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){_typeof=function _typeof(obj){return typeof obj}}else{_typeof=function _typeof(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly)symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}));keys.push.apply(keys,symbols)}return keys}function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};if(i%2){ownKeys(source,true).forEach((function(key){_defineProperty(target,key,source[key])}))}else if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source))}else{ownKeys(source).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))}))}}return target}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);return Constructor}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call}return _assertThisInitialized(self)}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o)};return _getPrototypeOf(o)}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function")}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});if(superClass)_setPrototypeOf(subClass,superClass)}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf||function _setPrototypeOf(o,p){o.__proto__=p;return o};return _setPrototypeOf(o,p)}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}var MonacoDiffEditor=function(_React$Component){_inherits(MonacoDiffEditor,_React$Component);function MonacoDiffEditor(props){var _this;_classCallCheck(this,MonacoDiffEditor);_this=_possibleConstructorReturn(this,_getPrototypeOf(MonacoDiffEditor).call(this,props));_defineProperty(_assertThisInitialized(_this),"assignRef",(function(component){_this.containerElement=component}));_this.containerElement=undefined;return _this}_createClass(MonacoDiffEditor,[{key:"componentDidMount",value:function componentDidMount(){this.initMonaco()}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var _this$props=this.props,language=_this$props.language,theme=_this$props.theme,height=_this$props.height,options=_this$props.options,width=_this$props.width;var _this$editor$getModel=this.editor.getModel(),original=_this$editor$getModel.original,modified=_this$editor$getModel.modified;if(this.props.original!==original.getValue()){original.setValue(this.props.original)}if(this.props.value!==modified.getValue()){modified.pushEditOperations([],[{range:modified.getFullModelRange(),text:this.props.value}])}if(prevProps.language!==language){monaco.editor.setModelLanguage(original,language);monaco.editor.setModelLanguage(modified,language)}if(prevProps.theme!==theme){monaco.editor.setTheme(theme)}if(this.editor&&(width!==prevProps.width||height!==prevProps.height)){this.editor.layout()}if(prevProps.options!==options){this.editor.updateOptions(options)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){this.destroyMonaco()}},{key:"editorWillMount",value:function editorWillMount(){var editorWillMount=this.props.editorWillMount;var options=editorWillMount(monaco);return options||{}}},{key:"editorDidMount",value:function editorDidMount(editor){var _this2=this;this.props.editorDidMount(editor,monaco);var _editor$getModel=editor.getModel(),modified=_editor$getModel.modified;this._subscription=modified.onDidChangeContent((function(){_this2.props.onChange(modified.getValue())}))}},{key:"initModels",value:function initModels(value,original){var language=this.props.language;var originalModel=monaco.editor.createModel(original,language);var modifiedModel=monaco.editor.createModel(value,language);this.editor.setModel({original:originalModel,modified:modifiedModel})}},{key:"initMonaco",value:function initMonaco(){var value=this.props.value!==null?this.props.value:this.props.defaultValue;var _this$props2=this.props,original=_this$props2.original,theme=_this$props2.theme,options=_this$props2.options,overrideServices=_this$props2.overrideServices;if(this.containerElement){this.editorWillMount();this.editor=monaco.editor.createDiffEditor(this.containerElement,_objectSpread({},options,{},theme?{theme:theme}:{}),overrideServices);this.initModels(value,original);this.editorDidMount(this.editor)}}},{key:"destroyMonaco",value:function destroyMonaco(){if(this.editor){this.editor.dispose()}if(this._subscription){this._subscription.dispose()}}},{key:"render",value:function render(){var _this$props3=this.props,width=_this$props3.width,height=_this$props3.height;var fixedWidth=(0,_utils.processSize)(width);var fixedHeight=(0,_utils.processSize)(height);var style={width:fixedWidth,height:fixedHeight};return _react["default"].createElement("div",{ref:this.assignRef,style:style,className:"react-monaco-editor-container"})}}]);return MonacoDiffEditor}(_react["default"].Component);MonacoDiffEditor.propTypes={width:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].number]),height:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].number]),original:_propTypes["default"].string,value:_propTypes["default"].string,defaultValue:_propTypes["default"].string,language:_propTypes["default"].string,theme:_propTypes["default"].string,options:_propTypes["default"].object,overrideServices:_propTypes["default"].object,editorDidMount:_propTypes["default"].func,editorWillMount:_propTypes["default"].func,onChange:_propTypes["default"].func};MonacoDiffEditor.defaultProps={width:"100%",height:"100%",original:null,value:null,defaultValue:"",language:"javascript",theme:null,options:{},overrideServices:{},editorDidMount:_utils.noop,editorWillMount:_utils.noop,onChange:_utils.noop};var _default=MonacoDiffEditor;exports["default"]=_default}}]);