/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncompatibleVersionErrorData<T> {
    private final T actualVersion;
    private final T expectedVersion;
    @NotNull
    private final String filePath;
    @NotNull
    private final ClassId classId;

    public IncompatibleVersionErrorData(T actualVersion, T expectedVersion, @NotNull String filePath, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this.actualVersion = actualVersion;
        this.expectedVersion = expectedVersion;
        this.filePath = filePath;
        this.classId = classId;
    }

    @NotNull
    public String toString() {
        return "IncompatibleVersionErrorData(actualVersion=" + this.actualVersion + ", expectedVersion=" + this.expectedVersion + ", filePath=" + this.filePath + ", classId=" + this.classId + ')';
    }

    public int hashCode() {
        int result2 = this.actualVersion == null ? 0 : this.actualVersion.hashCode();
        result2 = result2 * 31 + (this.expectedVersion == null ? 0 : this.expectedVersion.hashCode());
        result2 = result2 * 31 + this.filePath.hashCode();
        result2 = result2 * 31 + this.classId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IncompatibleVersionErrorData)) {
            return false;
        }
        IncompatibleVersionErrorData incompatibleVersionErrorData = (IncompatibleVersionErrorData)other;
        if (!Intrinsics.areEqual(this.actualVersion, incompatibleVersionErrorData.actualVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expectedVersion, incompatibleVersionErrorData.expectedVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)incompatibleVersionErrorData.filePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.classId, (Object)incompatibleVersionErrorData.classId);
    }
}

