/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.util.Map;
import lombok.Generated;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.sql.spark.dispatcher.model.IndexDetails;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexMetadataReader;

public class FlintIndexMetadataReaderImpl
implements FlintIndexMetadataReader {
    private final Client client;

    @Override
    public FlintIndexMetadata getFlintIndexMetadata(IndexDetails indexDetails) {
        String indexName = indexDetails.openSearchIndexName();
        GetMappingsResponse mappingsResponse = (GetMappingsResponse)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).get();
        try {
            MappingMetadata mappingMetadata = (MappingMetadata)mappingsResponse.mappings().get(indexName);
            Map mappingSourceMap = mappingMetadata.getSourceAsMap();
            return FlintIndexMetadata.fromMetatdata((Map)mappingSourceMap.get("_meta"));
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Provided Index doesn't exist");
        }
    }

    @Generated
    public FlintIndexMetadataReaderImpl(Client client) {
        this.client = client;
    }
}

