/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.rest.model;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.rest.model.LangType;

public class CreateAsyncQueryRequest {
    private String query;
    private String datasource;
    private LangType lang;

    public CreateAsyncQueryRequest(String query, String datasource, LangType lang) {
        this.query = (String)Validate.notNull((Object)query, (String)"Query can't be null", (Object[])new Object[0]);
        this.datasource = (String)Validate.notNull((Object)datasource, (String)"Datasource can't be null", (Object[])new Object[0]);
        this.lang = (LangType)((Object)Validate.notNull((Object)((Object)lang), (String)"lang can't be null", (Object[])new Object[0]));
    }

    public static CreateAsyncQueryRequest fromXContentParser(XContentParser parser) throws IOException {
        String query = null;
        LangType lang = null;
        String datasource = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName.equals("query")) {
                query = parser.textOrNull();
                continue;
            }
            if (fieldName.equals("lang")) {
                String langString = parser.textOrNull();
                lang = LangType.fromString(langString);
                continue;
            }
            if (fieldName.equals("datasource")) {
                datasource = parser.textOrNull();
                continue;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        return new CreateAsyncQueryRequest(query, datasource, lang);
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getDatasource() {
        return this.datasource;
    }

    @Generated
    public LangType getLang() {
        return this.lang;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    @Generated
    public void setLang(LangType lang) {
        this.lang = lang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAsyncQueryRequest)) {
            return false;
        }
        CreateAsyncQueryRequest other = (CreateAsyncQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        LangType this$lang = this.getLang();
        LangType other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !((Object)((Object)this$lang)).equals((Object)other$lang));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateAsyncQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        LangType $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)((Object)$lang)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateAsyncQueryRequest(query=" + this.getQuery() + ", datasource=" + this.getDatasource() + ", lang=" + this.getLang() + ")";
    }
}

