# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 120, 0, 120, 0, 92, 
	0, 120, 0, 120, 0, 
	45, 0, 120, 0, 120, 
	67, 99, 45, 45, 0, 92, 
	0, 120, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 120, 
	0, 120, 0, 92, 0, 
	120, 0, 120, 0, 45, 
	0, 120, 0, 120, 67, 99, 
	45, 45, 0, 92, 0, 
	120, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 46, 
	46, 58, 58, 58, 58, 
	0, 127, 60, 60, 62, 62, 
	0, 127, 58, 58, 10, 
	10, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	115, 115, 99, 99, 117, 117, 
	101, 101, 108, 116, 101, 
	101, 115, 115, 115, 115, 
	105, 105, 108, 108, 105, 105, 
	108, 108, 0, 127, 58, 
	58, 10, 10, 0, 127, 
	98, 98, 101, 101, 103, 103, 
	105, 105, 110, 110, 0, 
	127, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 92, 
	9, 92, 10, 10, 0, 
	127, 0, 127, 61, 126, 
	93, 93, 0, 127, 34, 34, 
	10, 10, 10, 10, 39, 
	39, 0, 127, 0, 127, 
	10, 96, 96, 96, 0, 45, 
	0, 120, 0, 120, 0, 
	92, 0, 120, 0, 120, 
	0, 45, 0, 120, 0, 120, 
	67, 99, 45, 45, 0, 
	92, 0, 120, 0, 102, 
	58, 58, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 9, 92, 10, 10, 
	9, 92, 58, 58, 58, 58, 
	0, 127, 0, 127, 43, 
	57, 48, 57, 48, 57, 
	48, 57, 48, 57, 115, 115, 
	99, 99, 117, 117, 101, 
	101, 99, 99, 117, 117, 
	101, 101, 0, 127, 58, 58, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 60, 60, 10, 10, 
	9, 92, 9, 92, 10, 
	10, 10, 10, 10, 10, 
	10, 10, 46, 46, 0, 95, 
	9, 32, 0, 0, 10, 
	10, 10, 10, 98, 98, 
	9, 32, 10, 10, 95, 95, 
	0, 92, 9, 32, 36, 
	123, 48, 57, 0, 127, 
	0, 127, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 48, 102, 
	48, 102, 0, 0, 48, 
	102, 48, 102, 0, 0, 
	0, 45, 0, 92, 0, 92, 
	0, 0, 0, 0, 0, 
	92, 48, 102, 48, 102, 
	0, 0, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 
	102, 48, 102, 48, 102, 
	0, 0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 0, 
	48, 102, 0, 0, 0, 
	92, 36, 123, 48, 57, 
	0, 127, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 
	55, 48, 55, 0, 0, 
	0, 0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 
	92, 45, 45, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 
	0, 48, 102, 48, 102, 
	0, 0, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	10, 10, 0, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 
	0, 0, 92, 9, 32, 
	0, 26, 0, 92, 0, 26, 
	0, 35, 36, 123, 48, 
	57, 0, 127, 0, 127, 
	0, 26, 0, 35, 9, 32, 
	36, 123, 48, 57, 0, 
	127, 0, 127, 0, 32, 
	9, 32, 65, 122, 65, 122, 
	36, 64, 48, 57, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 0, 127, 48, 57, 
	0, 127, 115, 115, 38, 38, 
	42, 42, 64, 64, 58, 
	58, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 62, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 93, 93, 
	10, 10, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	124, 124, 0, 127, 9, 32, 
	10, 10, 10, 10, 46, 
	46, 0, 127, 10, 10, 
	0, 0, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 
	10, 10, 10, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 126, 61, 
	61, 61, 62, 0, 127, 
	61, 61, 0, 0, 93, 93, 
	10, 10, 0, 127, 124, 
	124, 0, 126, 0, 127, 
	0, 61, 9, 61, 9, 61, 
	0, 0, 9, 61, 9, 
	62, 46, 46, 46, 46, 
	58, 58, 9, 32, 0, 0, 
	0, 127, 0, 0, 9, 
	124, 0, 0, 10, 10, 
	10, 10, 0, 0, 9, 61, 
	58, 58, 60, 60, 62, 
	62, 9, 32, 10, 10, 
	0, 127, 102, 102, 101, 101, 
	110, 110, 104, 104, 0, 
	127, 0, 127, 0, 0, 
	0, 127, 0, 127, 10, 10, 
	0, 123, 9, 32, 10, 
	10, 10, 10, 10, 10, 
	0, 0, 111, 111, 0, 0, 
	0, 127, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	0, 127, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 9, 32, 61, 
	61, 9, 32, 61, 126, 
	10, 10, 10, 10, 0, 127, 
	38, 61, 0, 0, 42, 
	61, 61, 61, 9, 92, 
	9, 92, 9, 92, 46, 46, 
	46, 46, 10, 10, 0, 
	26, 0, 127, 61, 126, 
	48, 57, 0, 127, 38, 38, 
	42, 42, 64, 64, 60, 
	61, 62, 62, 61, 61, 
	61, 62, 0, 127, 48, 57, 
	0, 127, 0, 127, 61, 
	61, 0, 0, 61, 126, 
	61, 62, 0, 0, 0, 0, 
	0, 0, 0, 0, 124, 
	124, 64, 64, 60, 61, 
	10, 34, 0, 0, 10, 39, 
	96, 96, 62, 62, 61, 
	126, 61, 62, 0, 122, 
	0, 0, 0, 127, 0, 127, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 48, 102, 48, 
	102, 0, 0, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 0, 
	0, 45, 10, 10, 0, 
	92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 0, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 102, 
	0, 0, 0, 127, 58, 
	61, 0, 0, 61, 126, 
	61, 61, 0, 0, 0, 0, 
	0, 0, 0, 127, 0, 
	127, 0, 0, 10, 10, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 61, 126, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 124, 
	0, 92, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 127, 
	9, 32, 0, 0, 10, 
	10, 10, 10, 0, 127, 
	10, 10, 0, 0, 0, 127, 
	9, 32, 0, 0, 61, 
	126, 10, 10, 10, 10, 
	0, 127, 48, 57, 0, 127, 
	61, 61, 38, 61, 0, 
	0, 0, 0, 42, 61, 
	61, 62, 46, 57, 46, 46, 
	10, 10, 48, 101, 48, 
	95, 46, 120, 48, 114, 
	43, 57, 48, 105, 102, 102, 
	0, 0, 101, 105, 0, 
	0, 0, 0, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	105, 114, 102, 102, 0, 
	0, 101, 105, 115, 115, 
	0, 0, 0, 0, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 46, 114, 
	48, 114, 46, 114, 48, 
	114, 58, 58, 60, 61, 
	62, 62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 
	127, 61, 61, 0, 0, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 0, 
	10, 10, 0, 0, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 9, 92, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 61, 124, 0, 
	0, 9, 92, 9, 92, 
	9, 92, 46, 46, 46, 46, 
	10, 10, 46, 46, 10, 
	10, 10, 61, 10, 10, 
	10, 101, 10, 110, 10, 100, 
	10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	121, 121, 93, 121, 121, 46, 121, 121, 
	33, 1, 93, 121, 103, 128, 128, 128, 
	128, 46, 121, 121, 93, 121, 121, 46, 
	121, 121, 33, 1, 93, 121, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 1, 1, 1, 
	128, 1, 1, 128, 1, 1, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 1, 1, 9, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 1, 128, 
	1, 1, 1, 1, 1, 128, 1, 84, 
	84, 84, 84, 84, 1, 128, 128, 66, 
	1, 128, 1, 1, 1, 1, 128, 128, 
	87, 1, 46, 121, 121, 93, 121, 121, 
	46, 121, 121, 33, 1, 93, 121, 103, 
	1, 128, 128, 128, 128, 128, 84, 1, 
	84, 1, 1, 128, 128, 15, 10, 10, 
	10, 10, 1, 1, 1, 1, 1, 1, 
	1, 128, 1, 84, 84, 84, 84, 84, 
	84, 1, 1, 84, 84, 1, 1, 1, 
	1, 1, 96, 24, 0, 1, 1, 1, 
	24, 1, 1, 93, 24, 88, 10, 128, 
	128, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 55, 55, 0, 55, 55, 0, 
	46, 93, 93, 0, 0, 93, 55, 55, 
	0, 46, 1, 93, 76, 55, 55, 55, 
	0, 126, 0, 126, 126, 0, 126, 126, 
	126, 126, 0, 126, 126, 126, 126, 126, 
	126, 0, 0, 55, 0, 93, 88, 10, 
	128, 128, 121, 0, 0, 8, 8, 0, 
	0, 93, 0, 0, 0, 93, 1, 0, 
	0, 0, 93, 55, 55, 0, 55, 55, 
	0, 46, 93, 93, 0, 0, 93, 55, 
	55, 0, 46, 1, 93, 76, 55, 55, 
	55, 0, 126, 0, 126, 126, 0, 126, 
	126, 126, 126, 0, 126, 126, 126, 126, 
	126, 126, 0, 0, 55, 0, 93, 24, 
	27, 93, 27, 36, 88, 10, 128, 128, 
	27, 36, 24, 88, 10, 128, 128, 33, 
	24, 58, 58, 29, 10, 128, 128, 128, 
	128, 24, 0, 66, 1, 1, 128, 10, 
	128, 1, 1, 1, 1, 1, 2, 1, 
	66, 1, 2, 128, 128, 128, 128, 128, 
	128, 128, 1, 1, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	1, 128, 24, 1, 1, 1, 128, 1, 
	0, 128, 24, 0, 66, 1, 1, 1, 
	1, 1, 2, 1, 66, 1, 2, 128, 
	1, 0, 1, 1, 128, 1, 127, 128, 
	62, 53, 53, 0, 53, 54, 1, 1, 
	1, 24, 0, 128, 0, 116, 0, 1, 
	1, 0, 53, 1, 1, 1, 24, 1, 
	128, 1, 1, 1, 1, 128, 128, 0, 
	128, 128, 1, 124, 24, 1, 1, 1, 
	0, 1, 0, 128, 24, 0, 1, 1, 
	128, 1, 0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 24, 1, 24, 66, 
	1, 1, 128, 24, 0, 20, 1, 84, 
	84, 84, 1, 1, 1, 27, 128, 66, 
	10, 128, 1, 1, 1, 2, 1, 1, 
	2, 128, 10, 128, 128, 1, 0, 66, 
	2, 0, 0, 0, 0, 1, 1, 2, 
	25, 0, 30, 1, 1, 66, 2, 123, 
	0, 128, 128, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 55, 55, 0, 55, 
	55, 0, 46, 93, 93, 0, 0, 93, 
	55, 55, 0, 46, 1, 93, 76, 55, 
	55, 55, 0, 126, 0, 126, 126, 0, 
	126, 126, 126, 126, 0, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	0, 0, 55, 0, 128, 4, 0, 66, 
	1, 0, 0, 0, 128, 128, 0, 1, 
	0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 66, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 0, 64, 93, 24, 0, 1, 1, 
	1, 0, 128, 24, 0, 1, 1, 128, 
	1, 0, 128, 24, 0, 66, 1, 1, 
	128, 10, 128, 1, 24, 0, 0, 20, 
	2, 12, 1, 1, 54, 48, 75, 67, 
	15, 58, 1, 0, 5, 0, 0, 67, 
	67, 67, 67, 10, 1, 0, 5, 1, 
	0, 0, 67, 67, 67, 67, 67, 67, 
	67, 67, 69, 67, 69, 67, 1, 2, 
	1, 66, 1, 2, 128, 128, 1, 0, 
	0, 128, 128, 128, 128, 128, 128, 0, 
	1, 0, 0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 84, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 0, 64, 0, 84, 84, 
	84, 1, 1, 1, 1, 1, 52, 1, 
	92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 731, 853, 947, 1069, 1191, 1238, 1360, 
	1482, 1516, 1518, 1612, 1734, 1838, 1967, 2096, 
	2225, 2354, 2401, 2523, 2645, 2739, 2861, 2983, 
	3030, 3152, 3274, 3308, 3310, 3404, 3526, 3630, 
	3759, 3888, 4017, 4146, 4275, 4404, 4533, 4662, 
	4791, 4920, 5049, 5178, 5307, 5436, 5438, 5440, 
	5442, 5571, 5573, 5575, 5704, 5706, 5708, 5837, 
	5966, 6095, 6224, 6353, 6482, 6611, 6740, 6869, 
	6998, 7127, 7256, 7385, 7514, 7643, 7772, 7901, 
	8030, 8032, 8034, 8036, 8038, 8048, 8050, 8052, 
	8054, 8056, 8058, 8060, 8062, 8191, 8193, 8195, 
	8324, 8326, 8328, 8330, 8332, 8334, 8463, 8465, 
	8550, 8635, 8720, 8805, 8890, 8892, 9021, 9150, 
	9217, 9219, 9348, 9350, 9352, 9354, 9356, 9485, 
	9614, 9702, 9704, 9751, 9873, 9995, 10089, 10211, 
	10333, 10380, 10502, 10624, 10658, 10660, 10754, 10876, 
	10980, 10982, 11111, 11240, 11369, 11498, 11627, 11712, 
	11714, 11799, 11801, 11803, 11932, 12061, 12077, 12088, 
	12099, 12110, 12121, 12123, 12125, 12127, 12129, 12131, 
	12133, 12135, 12264, 12266, 12351, 12436, 12521, 12606, 
	12691, 12776, 12778, 12780, 12865, 12950, 12952, 12954, 
	12956, 12958, 12960, 13057, 13082, 13083, 13085, 13087, 
	13089, 13114, 13116, 13118, 13212, 13237, 13326, 13337, 
	13466, 13595, 13717, 13718, 13719, 13728, 13737, 13738, 
	13739, 13833, 13834, 13835, 13836, 13930, 13932, 13933, 
	13934, 13935, 14029, 14085, 14141, 14142, 14198, 14254, 
	14255, 14302, 14396, 14490, 14491, 14492, 14586, 14642, 
	14698, 14699, 14746, 14748, 14842, 14919, 14975, 15031, 
	15087, 15088, 15215, 15216, 15343, 15470, 15471, 15598, 
	15725, 15852, 15979, 15980, 16107, 16234, 16361, 16488, 
	16615, 16742, 16743, 16744, 16800, 16801, 16895, 16984, 
	16995, 17124, 17253, 17375, 17376, 17377, 17386, 17395, 
	17396, 17397, 17491, 17492, 17493, 17494, 17588, 17590, 
	17591, 17592, 17593, 17687, 17743, 17799, 17800, 17856, 
	17912, 17913, 17960, 18054, 18148, 18149, 18150, 18244, 
	18300, 18356, 18357, 18404, 18406, 18500, 18577, 18633, 
	18689, 18745, 18746, 18873, 18874, 19001, 19128, 19129, 
	19256, 19383, 19510, 19637, 19638, 19765, 19892, 20019, 
	20146, 20273, 20400, 20401, 20402, 20458, 20459, 20553, 
	20578, 20606, 20700, 20728, 20765, 20854, 20865, 20994, 
	21123, 21151, 21188, 21213, 21302, 21313, 21442, 21571, 
	21605, 21630, 21689, 21748, 21778, 21789, 21918, 22047, 
	22176, 22305, 22330, 22331, 22398, 22400, 22402, 22531, 
	22542, 22671, 22673, 22675, 22677, 22679, 22681, 22684, 
	22686, 22753, 22755, 22758, 22887, 23016, 23145, 23274, 
	23403, 23532, 23661, 23663, 23665, 23794, 23923, 24052, 
	24181, 24310, 24439, 24568, 24697, 24826, 24955, 25084, 
	25213, 25342, 25471, 25600, 25729, 25858, 25987, 26116, 
	26245, 26374, 26503, 26632, 26761, 26890, 27019, 27148, 
	27277, 27406, 27535, 27664, 27793, 27922, 28051, 28180, 
	28309, 28438, 28567, 28696, 28825, 28954, 29083, 29212, 
	29341, 29470, 29599, 29728, 29857, 29986, 30115, 30244, 
	30373, 30502, 30631, 30760, 30889, 31018, 31147, 31276, 
	31405, 31534, 31663, 31792, 31921, 32050, 32179, 32308, 
	32437, 32566, 32695, 32824, 32953, 33082, 33211, 33340, 
	33469, 33598, 33727, 33856, 33985, 34114, 34243, 34372, 
	34501, 34503, 34632, 34657, 34659, 34661, 34663, 34792, 
	34794, 34795, 34924, 34949, 34950, 35017, 35019, 35021, 
	35023, 35025, 35027, 35030, 35032, 35099, 35101, 35104, 
	35233, 35235, 35236, 35238, 35240, 35369, 35371, 35499, 
	35628, 35691, 35745, 35799, 35800, 35854, 35909, 35911, 
	35913, 35915, 35940, 35941, 36070, 36071, 36188, 36189, 
	36191, 36193, 36194, 36248, 36250, 36252, 36254, 36279, 
	36281, 36410, 36412, 36414, 36416, 36418, 36547, 36676, 
	36677, 36806, 36935, 36937, 37062, 37087, 37089, 37091, 
	37093, 37094, 37096, 37097, 37226, 37251, 37252, 37254, 
	37256, 37385, 37387, 37388, 37517, 37646, 37775, 37904, 
	38033, 38162, 38291, 38420, 38549, 38678, 38807, 38936, 
	39065, 39194, 39323, 39452, 39581, 39606, 39608, 39633, 
	39700, 39702, 39704, 39833, 39858, 39859, 39880, 39882, 
	39967, 40052, 40137, 40139, 40141, 40143, 40171, 40300, 
	40367, 40378, 40507, 40509, 40511, 40513, 40516, 40518, 
	40520, 40523, 40652, 40663, 40792, 40921, 40923, 40924, 
	40991, 40994, 40995, 40996, 40997, 40998, 41000, 41002, 
	41005, 41031, 41032, 41063, 41065, 41067, 41134, 41137, 
	41261, 41262, 41391, 41520, 41642, 41643, 41644, 41653, 
	41662, 41663, 41664, 41758, 41759, 41760, 41761, 41855, 
	41857, 41858, 41859, 41860, 41954, 42010, 42066, 42067, 
	42123, 42179, 42180, 42227, 42321, 42415, 42416, 42417, 
	42511, 42567, 42623, 42624, 42671, 42673, 42767, 42844, 
	42900, 42956, 43012, 43013, 43140, 43141, 43268, 43395, 
	43396, 43523, 43650, 43777, 43904, 43905, 44032, 44159, 
	44286, 44413, 44540, 44667, 44794, 44921, 45048, 45175, 
	45302, 45429, 45556, 45683, 45810, 45937, 46064, 46191, 
	46318, 46319, 46320, 46376, 46377, 46506, 46511, 46512, 
	46579, 46581, 46582, 46583, 46584, 46713, 46842, 46843, 
	46845, 46846, 46975, 47104, 47233, 47362, 47491, 47620, 
	47749, 47878, 48007, 48136, 48265, 48394, 48523, 48652, 
	48781, 48910, 49039, 49168, 49297, 49426, 49555, 49684, 
	49813, 49942, 50071, 50200, 50329, 50458, 50587, 50716, 
	50845, 50974, 51103, 51232, 51361, 51490, 51619, 51748, 
	51877, 52006, 52135, 52264, 52393, 52522, 52651, 52780, 
	52909, 53038, 53167, 53296, 53425, 53554, 53683, 53812, 
	53941, 54070, 54199, 54328, 54457, 54586, 54715, 54844, 
	54911, 55040, 55169, 55298, 55427, 55556, 55685, 55814, 
	55943, 56072, 56201, 56330, 56459, 56588, 56717, 56846, 
	56975, 57104, 57233, 57362, 57491, 57620, 57749, 57878, 
	58007, 58136, 58137, 58202, 58296, 58321, 58322, 58324, 
	58326, 58328, 58329, 58458, 58483, 58484, 58486, 58488, 
	58617, 58619, 58620, 58749, 58774, 58775, 58842, 58844, 
	58846, 58975, 58986, 59115, 59117, 59142, 59143, 59144, 
	59165, 59168, 59181, 59183, 59185, 59240, 59289, 59365, 
	59433, 59449, 59508, 59510, 59511, 59517, 59518, 59519, 
	59587, 59655, 59723, 59791, 59802, 59804, 59805, 59811, 
	59813, 59814, 59815, 59883, 59951, 60019, 60087, 60155, 
	60223, 60291, 60359, 60429, 60497, 60567, 60635, 60637, 
	60640, 60642, 60709, 60711, 60714, 60843, 60972, 60974, 
	60975, 60976, 61105, 61234, 61363, 61492, 61621, 61750, 
	61751, 61753, 61754, 61755, 61884, 62013, 62142, 62271, 
	62400, 62529, 62658, 62787, 62916, 63045, 63174, 63303, 
	63432, 63561, 63690, 63819, 63948, 64077, 64206, 64335, 
	64464, 64593, 64722, 64851, 64980, 65109, 65238, 65367, 
	65496, 65625, 65754, 65883, 66012, 66141, 66270, 66399, 
	66528, 66657, 66742, 66871, 67000, 67129, 67258, 67387, 
	67516, 67645, 67774, 67903, 68032, 68161, 68290, 68419, 
	68548, 68677, 68806, 68935, 69064, 69193, 69322, 69451, 
	69580, 69709, 69838, 69967, 70096, 70225, 70354, 70483, 
	70612, 70741, 70870, 70999, 71128, 71257, 71386, 71515, 
	71644, 71773, 71902, 72031, 72160, 72289, 72418, 72547, 
	72676, 72805, 72934, 73063, 73192, 73321, 73450, 73579, 
	73708, 73837, 73966, 74095, 74224, 74353, 74482, 74611, 
	74740, 74869, 74998, 75127, 75128, 75193, 75194, 75279, 
	75364, 75449, 75451, 75453, 75455, 75457, 75459, 75512, 
	75514, 75607, 75709, 75801
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 13, 
	13, 12, 13, 12, 13, 13, 12, 12, 
	13, 13, 13, 14, 13, 13, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	13, 13, 13, 13, 13, 13, 13, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 12, 13, 12, 12, 16, 13, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 12, 12, 12, 13, 12, 16, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 13, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 12, 13, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 12, 12, 12, 12, 12, 12, 
	18, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 12, 12, 12, 12, 16, 
	12, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 12, 12, 12, 12, 12, 
	16, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 12, 12, 12, 12, 12, 
	12, 12, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 12, 12, 12, 12, 
	16, 12, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 12, 12, 12, 12, 
	12, 16, 19, 20, 20, 20, 19, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 19, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 21, 
	20, 19, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 23, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 24, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 25, 22, 19, 22, 22, 22, 19, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	26, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 25, 22, 19, 27, 27, 
	27, 19, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 19, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 28, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 29, 27, 19, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 31, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 19, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 32, 30, 19, 30, 30, 
	30, 19, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 32, 30, 19, 
	20, 20, 20, 19, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 19, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 33, 20, 19, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	35, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	19, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 36, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 37, 34, 34, 34, 34, 34, 
	34, 38, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 39, 34, 
	19, 34, 34, 34, 19, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	39, 34, 40, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 41, 19, 41, 19, 19, 42, 
	42, 42, 19, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	19, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 43, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 44, 42, 19, 22, 22, 22, 
	19, 22, 22, 22, 22, 22, 23, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 19, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 26, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 25, 22, 19, 45, 
	45, 45, 19, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	19, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 48, 
	48, 47, 48, 47, 48, 48, 47, 47, 
	48, 48, 48, 49, 48, 48, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	48, 48, 48, 48, 48, 48, 48, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 47, 48, 47, 47, 51, 48, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 47, 47, 47, 48, 47, 51, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 47, 47, 47, 47, 47, 47, 47, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 47, 47, 47, 47, 48, 47, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 47, 47, 47, 47, 47, 48, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 47, 47, 47, 47, 47, 47, 
	53, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 47, 47, 47, 47, 51, 
	47, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 47, 47, 47, 47, 47, 
	51, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 47, 47, 47, 47, 47, 
	47, 47, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 47, 47, 47, 47, 
	51, 47, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 47, 47, 47, 47, 
	47, 51, 54, 55, 55, 55, 54, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 54, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 56, 
	55, 54, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 58, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 54, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 59, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 60, 57, 54, 57, 57, 57, 54, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	61, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 60, 57, 54, 62, 62, 
	62, 54, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 54, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 63, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 64, 62, 54, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 66, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 54, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 67, 65, 54, 65, 65, 
	65, 54, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 67, 65, 54, 
	55, 55, 55, 54, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 54, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 68, 55, 54, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	54, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 72, 69, 69, 69, 69, 69, 
	69, 73, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 74, 69, 
	54, 69, 69, 69, 54, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	74, 69, 75, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 76, 54, 76, 54, 54, 77, 
	77, 77, 54, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	54, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 78, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 79, 77, 54, 57, 57, 57, 
	54, 57, 57, 57, 57, 57, 58, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 54, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 61, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 60, 57, 54, 80, 
	80, 80, 54, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	54, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 83, 
	83, 82, 83, 82, 83, 83, 82, 82, 
	83, 83, 83, 84, 83, 83, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	83, 83, 83, 83, 83, 83, 83, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 82, 83, 82, 82, 86, 83, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 82, 82, 82, 83, 82, 86, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 82, 82, 82, 82, 82, 82, 82, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 82, 82, 82, 82, 83, 82, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 82, 82, 82, 82, 82, 83, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 82, 82, 82, 82, 82, 82, 
	88, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 82, 82, 82, 82, 86, 
	82, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 82, 82, 82, 82, 82, 
	86, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 82, 82, 82, 82, 82, 
	82, 82, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 82, 82, 82, 82, 
	86, 82, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 82, 82, 82, 82, 
	82, 86, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 90, 90, 89, 90, 89, 
	90, 90, 89, 89, 90, 90, 90, 91, 
	90, 90, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 90, 90, 90, 90, 
	90, 90, 90, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 89, 90, 89, 
	89, 93, 90, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 89, 89, 89, 
	90, 89, 93, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 89, 89, 89, 
	89, 89, 89, 89, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 89, 89, 
	89, 89, 90, 89, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 89, 89, 
	89, 89, 89, 90, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 89, 89, 
	89, 89, 89, 89, 95, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 89, 
	89, 89, 89, 93, 89, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 89, 
	89, 89, 89, 89, 93, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 89, 
	89, 89, 89, 89, 89, 89, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	89, 89, 89, 89, 93, 89, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	89, 89, 89, 89, 89, 93, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 96, 
	96, 97, 96, 97, 96, 96, 97, 97, 
	96, 96, 96, 98, 96, 96, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	96, 96, 96, 96, 96, 96, 96, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 97, 96, 97, 97, 100, 96, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 97, 97, 97, 96, 97, 100, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 97, 97, 97, 97, 97, 97, 97, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 97, 97, 97, 97, 96, 97, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 97, 97, 97, 97, 97, 96, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 97, 97, 97, 97, 97, 97, 
	102, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 97, 97, 97, 97, 101, 
	97, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 97, 97, 97, 97, 97, 
	101, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 97, 97, 97, 97, 97, 
	97, 97, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 97, 97, 97, 97, 
	103, 97, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 97, 97, 97, 97, 
	97, 103, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 104, 104, 104, 104, 
	104, 104, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 105, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 104, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 107, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 106, 109, 108, 110, 108, 
	108, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 112, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 110, 108, 108, 108, 
	108, 112, 108, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 108, 108, 108, 
	108, 113, 108, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 108, 108, 108, 
	108, 108, 113, 115, 114, 116, 114, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	118, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 120, 117, 117, 117, 117, 118, 117, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 117, 117, 117, 117, 119, 117, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 117, 117, 117, 117, 117, 119, 
	120, 117, 121, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 122, 114, 122, 
	122, 122, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 122, 114, 114, 114, 
	114, 123, 124, 114, 125, 114, 126, 127, 
	128, 129, 130, 123, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 131, 114, 
	132, 128, 133, 134, 114, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 136, 
	137, 128, 138, 135, 114, 135, 135, 135, 
	135, 135, 135, 135, 135, 139, 135, 135, 
	135, 135, 135, 135, 135, 135, 140, 135, 
	135, 141, 135, 142, 135, 135, 135, 143, 
	144, 114, 138, 114, 135, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 145, 114, 
	145, 145, 145, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 145, 114, 114, 
	114, 114, 146, 147, 114, 148, 114, 149, 
	150, 151, 152, 153, 146, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 154, 
	114, 155, 151, 156, 157, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	158, 159, 151, 116, 119, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 160, 119, 
	119, 119, 119, 119, 119, 119, 119, 161, 
	119, 119, 162, 119, 163, 119, 119, 119, 
	164, 165, 114, 116, 114, 119, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 118, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	120, 114, 114, 114, 114, 118, 114, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 114, 114, 114, 114, 119, 114, 119, 
	119, 119, 119, 119, 166, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 114, 114, 114, 114, 114, 119, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	118, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 120, 114, 114, 114, 114, 118, 114, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 114, 114, 114, 114, 119, 114, 
	119, 119, 119, 119, 167, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 114, 114, 114, 114, 114, 119, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 118, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 120, 114, 114, 114, 114, 118, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 114, 114, 114, 114, 119, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 168, 119, 119, 119, 119, 
	119, 119, 119, 114, 114, 114, 114, 114, 
	119, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 118, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 120, 114, 114, 114, 114, 
	118, 114, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 114, 114, 114, 114, 
	119, 114, 119, 119, 169, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 114, 114, 114, 114, 
	114, 119, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 118, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 120, 114, 114, 114, 
	114, 118, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 114, 114, 114, 
	114, 119, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 170, 
	119, 119, 119, 119, 119, 114, 114, 114, 
	114, 114, 119, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 118, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 120, 114, 114, 
	114, 114, 118, 114, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 114, 114, 
	114, 114, 119, 114, 119, 119, 119, 119, 
	166, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 114, 114, 
	114, 114, 114, 119, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 118, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 120, 114, 
	114, 114, 114, 118, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 114, 
	114, 114, 114, 119, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 171, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 114, 
	114, 114, 114, 114, 119, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 118, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 120, 
	114, 114, 114, 114, 118, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	114, 114, 114, 114, 119, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 172, 119, 119, 119, 119, 119, 119, 
	119, 173, 119, 119, 119, 119, 119, 119, 
	114, 114, 114, 114, 114, 119, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 118, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	120, 114, 114, 114, 114, 118, 114, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 114, 114, 114, 114, 119, 114, 119, 
	119, 119, 119, 174, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 114, 114, 114, 114, 114, 119, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	118, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 120, 114, 114, 114, 114, 118, 114, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 114, 114, 114, 114, 119, 114, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 175, 119, 119, 119, 119, 119, 
	119, 119, 114, 114, 114, 114, 114, 119, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 118, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 120, 114, 114, 114, 114, 118, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 114, 114, 114, 114, 119, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 166, 119, 119, 119, 119, 
	119, 119, 119, 114, 114, 114, 114, 114, 
	119, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 118, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 120, 114, 114, 114, 114, 
	118, 114, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 114, 114, 114, 114, 
	119, 114, 119, 119, 119, 119, 119, 119, 
	119, 119, 176, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 114, 114, 114, 114, 
	114, 119, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 118, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 120, 114, 114, 114, 
	114, 118, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 114, 114, 114, 
	114, 119, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 166, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 114, 114, 114, 
	114, 114, 119, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 118, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 120, 114, 114, 
	114, 114, 118, 114, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 114, 114, 
	114, 114, 119, 114, 119, 119, 119, 119, 
	119, 119, 119, 177, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 114, 114, 
	114, 114, 114, 119, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 118, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 120, 114, 
	114, 114, 114, 118, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 114, 
	114, 114, 114, 119, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 178, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 114, 
	114, 114, 114, 114, 119, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 118, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 120, 
	114, 114, 114, 114, 118, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	114, 114, 114, 114, 119, 114, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 170, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	114, 114, 114, 114, 114, 119, 180, 179, 
	181, 179, 182, 179, 151, 179, 183, 179, 
	179, 179, 179, 179, 179, 179, 184, 179, 
	185, 179, 186, 179, 151, 179, 187, 179, 
	151, 179, 188, 179, 182, 179, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 190, 
	189, 190, 190, 190, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 190, 189, 
	189, 189, 189, 189, 189, 189, 191, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 189, 193, 189, 189, 192, 189, 192, 
	192, 192, 194, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 189, 189, 189, 189, 189, 192, 196, 
	195, 197, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 198, 189, 198, 198, 
	198, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 198, 189, 189, 189, 189, 
	189, 189, 189, 199, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 189, 201, 
	189, 189, 200, 189, 200, 200, 200, 202, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 189, 189, 
	189, 189, 189, 200, 204, 203, 205, 203, 
	206, 203, 207, 203, 208, 203, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	210, 210, 210, 210, 210, 210, 210, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 210, 210, 210, 210, 210, 210, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 210, 210, 210, 210, 210, 209, 212, 
	211, 213, 214, 213, 213, 213, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	213, 211, 211, 215, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 217, 211, 218, 219, 
	218, 218, 218, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 218, 211, 211, 
	220, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 222, 211, 224, 225, 224, 224, 224, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 224, 223, 223, 226, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 228, 223, 
	230, 231, 230, 230, 230, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 230, 
	229, 229, 232, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 234, 229, 230, 235, 230, 
	230, 230, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 230, 229, 229, 232, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	234, 229, 214, 211, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 237, 237, 236, 
	237, 236, 237, 237, 236, 236, 237, 237, 
	237, 238, 237, 237, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 237, 237, 
	237, 237, 237, 237, 237, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 236, 
	237, 236, 236, 240, 237, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 236, 
	236, 236, 237, 236, 240, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 236, 
	236, 236, 236, 236, 236, 236, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	236, 236, 236, 236, 237, 236, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	236, 236, 236, 236, 236, 237, 241, 237, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 237, 
	236, 241, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 242, 236, 236, 
	236, 236, 243, 236, 236, 236, 236, 236, 
	244, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	212, 236, 236, 236, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 236, 236, 
	236, 236, 245, 246, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 236, 236, 
	236, 244, 236, 245, 249, 248, 251, 250, 
	253, 252, 249, 254, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 242, 236, 
	236, 236, 236, 243, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 236, 
	236, 236, 236, 245, 246, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 236, 
	236, 236, 236, 236, 245, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 251, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 250, 
	250, 250, 250, 250, 250, 250, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	250, 250, 250, 250, 255, 250, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	250, 250, 250, 250, 250, 255, 257, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 249, 256, 249, 257, 
	258, 259, 259, 259, 258, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 258, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 260, 259, 258, 
	261, 261, 261, 258, 261, 261, 261, 261, 
	261, 262, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 258, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 263, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 264, 
	261, 258, 261, 261, 261, 258, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 258, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 265, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 264, 261, 258, 266, 266, 266, 258, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 258, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 267, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 268, 
	266, 258, 269, 269, 269, 258, 269, 269, 
	269, 269, 269, 270, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 258, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 271, 269, 258, 269, 269, 269, 258, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 258, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 271, 269, 258, 259, 259, 
	259, 258, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 258, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 272, 259, 258, 273, 273, 273, 
	258, 273, 273, 273, 273, 273, 274, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 258, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 275, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	276, 273, 273, 273, 273, 273, 273, 277, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 278, 273, 258, 273, 
	273, 273, 258, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	258, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 278, 273, 
	279, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	280, 258, 280, 258, 258, 281, 281, 281, 
	258, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 258, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 282, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	283, 281, 258, 261, 261, 261, 258, 261, 
	261, 261, 261, 261, 262, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 258, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 265, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 264, 261, 258, 284, 284, 284, 
	258, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 258, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 284, 284, 
	284, 284, 284, 284, 284, 285, 285, 285, 
	285, 285, 285, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 285, 285, 285, 
	285, 285, 285, 284, 211, 286, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 287, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	289, 211, 211, 290, 211, 287, 211, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 211, 211, 211, 211, 288, 211, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 211, 211, 211, 211, 211, 288, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	287, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 289, 236, 236, 290, 236, 287, 236, 
	288, 288, 288, 288, 288, 288, 291, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 236, 236, 236, 236, 288, 236, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 236, 236, 236, 236, 236, 288, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 287, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 289, 236, 236, 290, 236, 287, 
	236, 288, 288, 288, 288, 288, 288, 288, 
	288, 292, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 236, 236, 236, 236, 288, 
	236, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 236, 236, 236, 236, 236, 
	288, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 287, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 289, 236, 236, 290, 236, 
	287, 236, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 293, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 236, 236, 236, 236, 
	288, 236, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 236, 236, 236, 236, 
	236, 288, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 287, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 289, 236, 236, 290, 
	236, 287, 236, 288, 288, 288, 293, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 236, 236, 236, 
	236, 288, 236, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 236, 236, 236, 
	236, 236, 288, 295, 294, 295, 295, 295, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 295, 294, 294, 294, 294, 294, 
	294, 294, 296, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 297, 294, 
	298, 294, 299, 294, 299, 299, 299, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 299, 294, 294, 294, 294, 294, 294, 
	294, 300, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 301, 294, 303, 
	302, 302, 304, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 305, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 303, 302, 302, 
	302, 302, 305, 302, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 302, 302, 
	302, 302, 306, 302, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 302, 302, 
	302, 302, 302, 306, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 307, 307, 
	307, 307, 307, 307, 307, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 307, 
	307, 307, 307, 308, 307, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 307, 
	307, 307, 307, 307, 308, 310, 309, 310, 
	309, 309, 311, 311, 311, 311, 311, 311, 
	311, 311, 311, 311, 309, 311, 311, 311, 
	311, 311, 311, 311, 311, 311, 311, 309, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 309, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 313, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	313, 317, 316, 318, 316, 319, 316, 320, 
	316, 322, 321, 323, 321, 324, 321, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 307, 307, 307, 307, 307, 307, 307, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 307, 307, 307, 307, 325, 307, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 307, 307, 307, 307, 307, 325, 
	326, 313, 327, 328, 327, 327, 327, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 327, 313, 313, 329, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 330, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 331, 313, 332, 
	333, 332, 332, 332, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 332, 313, 
	313, 334, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 335, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 336, 313, 338, 339, 338, 338, 
	338, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 338, 337, 337, 340, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 341, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 342, 
	337, 344, 345, 344, 344, 344, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	344, 343, 343, 346, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 347, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 348, 343, 344, 345, 
	344, 344, 344, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 344, 343, 343, 
	346, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 349, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 348, 343, 344, 350, 344, 344, 344, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 344, 343, 343, 346, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 347, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 348, 343, 
	351, 313, 328, 313, 353, 354, 353, 353, 
	353, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 353, 352, 352, 355, 352, 
	352, 356, 352, 352, 352, 352, 352, 352, 
	352, 357, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 358, 
	352, 360, 354, 360, 360, 360, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	360, 359, 359, 355, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 358, 359, 363, 362, 
	365, 364, 366, 361, 367, 361, 368, 352, 
	369, 370, 370, 370, 369, 370, 370, 370, 
	370, 371, 372, 371, 371, 371, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 369, 370, 370, 370, 370, 370, 
	371, 370, 370, 373, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 374, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 370, 375, 370, 370, 376, 
	370, 371, 377, 371, 371, 371, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	371, 377, 378, 379, 380, 381, 382, 384, 
	383, 386, 387, 386, 386, 386, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	386, 385, 372, 383, 388, 383, 389, 390, 
	390, 390, 389, 390, 390, 390, 390, 391, 
	392, 391, 391, 391, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	389, 390, 390, 390, 390, 390, 391, 390, 
	390, 393, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 394, 390, 391, 395, 391, 391, 
	391, 395, 395, 395, 395, 395, 395, 395, 
	395, 395, 395, 395, 395, 395, 395, 395, 
	395, 395, 395, 391, 395, 397, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 398, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 399, 396, 15, 15, 
	15, 15, 15, 15, 15, 15, 15, 15, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 400, 400, 400, 400, 400, 
	400, 400, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 400, 400, 400, 400, 
	16, 400, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 400, 400, 400, 400, 
	400, 16, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 401, 401, 401, 401, 
	401, 401, 401, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 401, 401, 401, 
	401, 17, 401, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 401, 401, 401, 
	401, 401, 17, 403, 404, 404, 404, 403, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 403, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 405, 405, 405, 405, 405, 
	405, 405, 405, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 406, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	407, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 408, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	409, 404, 404, 410, 404, 411, 412, 414, 
	414, 414, 414, 414, 414, 414, 414, 413, 
	415, 415, 415, 415, 415, 415, 415, 415, 
	413, 413, 416, 416, 42, 42, 42, 416, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 416, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 43, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 417, 
	42, 418, 419, 420, 420, 42, 42, 42, 
	420, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 420, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 43, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	421, 42, 41, 420, 422, 423, 424, 424, 
	27, 27, 27, 424, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 424, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 28, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 425, 27, 426, 426, 426, 
	426, 426, 426, 426, 426, 426, 426, 424, 
	424, 424, 424, 424, 424, 424, 426, 426, 
	426, 426, 426, 426, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 426, 426, 
	426, 426, 426, 426, 424, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 427, 
	427, 427, 427, 427, 427, 427, 428, 428, 
	428, 428, 428, 428, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 428, 428, 
	428, 428, 428, 428, 427, 427, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	420, 420, 420, 420, 420, 420, 420, 429, 
	429, 429, 429, 429, 429, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 429, 
	429, 429, 429, 429, 429, 420, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	430, 430, 430, 430, 430, 430, 430, 431, 
	431, 431, 431, 431, 431, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 431, 
	431, 431, 431, 431, 431, 430, 430, 420, 
	20, 20, 20, 420, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 420, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 432, 20, 416, 27, 
	27, 27, 416, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	416, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 28, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 29, 27, 416, 433, 433, 433, 
	416, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 416, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	434, 433, 435, 436, 436, 433, 433, 433, 
	436, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 436, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	437, 433, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 436, 436, 436, 436, 
	436, 436, 436, 438, 438, 438, 438, 438, 
	438, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 438, 438, 438, 438, 438, 
	438, 436, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 439, 439, 439, 439, 
	439, 439, 439, 440, 440, 440, 440, 440, 
	440, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 440, 440, 440, 440, 440, 
	440, 439, 439, 436, 20, 20, 20, 436, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 436, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	432, 20, 441, 436, 436, 27, 27, 27, 
	436, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 436, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 28, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	29, 27, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 442, 442, 442, 442, 
	442, 442, 442, 443, 443, 443, 443, 443, 
	443, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 443, 443, 443, 443, 443, 
	443, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 444, 442, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 442, 442, 442, 442, 442, 442, 442, 
	445, 445, 445, 445, 445, 445, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	445, 445, 445, 445, 445, 445, 442, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 442, 442, 442, 442, 442, 442, 442, 
	446, 446, 446, 446, 446, 446, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	446, 446, 446, 446, 446, 446, 442, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 442, 442, 442, 442, 442, 442, 442, 
	447, 447, 447, 447, 447, 447, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	447, 447, 447, 447, 447, 447, 442, 448, 
	450, 451, 451, 451, 450, 451, 451, 451, 
	451, 452, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 450, 451, 451, 451, 451, 451, 
	452, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	453, 453, 453, 453, 453, 453, 453, 453, 
	453, 453, 451, 451, 451, 451, 451, 451, 
	451, 453, 453, 453, 453, 453, 453, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 453, 453, 453, 453, 453, 453, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 454, 451, 449, 
	450, 451, 451, 451, 450, 451, 451, 451, 
	451, 449, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 450, 451, 451, 451, 451, 451, 
	449, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 451, 451, 451, 451, 451, 451, 
	451, 455, 455, 455, 455, 455, 455, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 455, 455, 455, 455, 455, 455, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 451, 456, 451, 450, 
	455, 455, 455, 450, 455, 455, 455, 455, 
	449, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 450, 455, 455, 455, 455, 455, 449, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 449, 455, 457, 450, 
	458, 458, 458, 450, 458, 458, 458, 458, 
	452, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 450, 458, 458, 458, 458, 458, 452, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 453, 
	453, 453, 453, 453, 453, 453, 453, 453, 
	453, 458, 458, 458, 458, 458, 458, 458, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 449, 458, 450, 458, 
	458, 458, 450, 458, 458, 458, 458, 449, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	450, 458, 458, 458, 458, 458, 449, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	458, 458, 458, 458, 458, 458, 458, 455, 
	455, 455, 455, 455, 455, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 455, 
	455, 455, 455, 455, 455, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 450, 458, 450, 458, 458, 
	458, 450, 458, 458, 458, 458, 459, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 450, 
	458, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 458, 
	458, 458, 458, 458, 458, 458, 460, 460, 
	460, 460, 460, 460, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 460, 460, 
	460, 460, 460, 460, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 461, 458, 450, 458, 458, 458, 
	450, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 450, 458, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 453, 453, 453, 453, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 453, 453, 453, 
	453, 453, 453, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 453, 453, 453, 
	453, 453, 453, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 461, 458, 462, 450, 458, 458, 458, 
	450, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 450, 458, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 458, 458, 
	458, 458, 458, 458, 458, 463, 463, 463, 
	463, 463, 463, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 463, 463, 463, 
	463, 463, 463, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 461, 458, 450, 458, 458, 458, 450, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 450, 458, 458, 
	458, 458, 458, 459, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 458, 458, 458, 
	458, 458, 458, 458, 464, 464, 464, 464, 
	464, 464, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 464, 464, 464, 464, 
	464, 464, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	461, 458, 450, 458, 458, 458, 450, 458, 
	458, 458, 458, 459, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 450, 458, 458, 458, 
	458, 458, 459, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 465, 465, 465, 465, 465, 465, 
	465, 465, 465, 465, 458, 458, 458, 458, 
	458, 458, 458, 465, 465, 465, 465, 465, 
	465, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 465, 465, 465, 465, 465, 
	465, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 461, 
	458, 450, 458, 458, 458, 450, 458, 458, 
	458, 458, 459, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 450, 458, 458, 458, 458, 
	458, 459, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 458, 458, 458, 458, 458, 
	458, 458, 466, 466, 466, 466, 466, 466, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 466, 466, 466, 466, 466, 466, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 461, 458, 
	450, 458, 458, 458, 450, 458, 458, 458, 
	458, 459, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 450, 458, 458, 458, 458, 458, 
	459, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 458, 458, 458, 458, 458, 458, 
	458, 467, 467, 467, 467, 467, 467, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 467, 467, 467, 467, 467, 467, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 461, 458, 450, 
	458, 458, 458, 450, 458, 458, 458, 458, 
	449, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 450, 458, 458, 458, 458, 458, 449, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 449, 458, 468, 469, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 470, 470, 470, 470, 470, 470, 
	470, 471, 471, 471, 471, 471, 471, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 471, 471, 471, 471, 471, 471, 470, 
	470, 472, 473, 473, 473, 472, 473, 473, 
	473, 473, 473, 474, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 472, 473, 473, 473, 473, 
	473, 473, 473, 473, 475, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 476, 473, 478, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 479, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 480, 477, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 481, 481, 481, 
	481, 481, 481, 481, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 481, 481, 
	481, 481, 51, 481, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 481, 481, 
	481, 481, 481, 51, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 482, 482, 
	482, 482, 482, 482, 482, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 482, 
	482, 482, 482, 52, 482, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 482, 
	482, 482, 482, 482, 52, 484, 485, 485, 
	485, 484, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 484, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 486, 486, 486, 
	486, 486, 486, 486, 486, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	487, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 488, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	489, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 490, 485, 485, 491, 485, 492, 
	493, 495, 495, 495, 495, 495, 495, 495, 
	495, 494, 496, 496, 496, 496, 496, 496, 
	496, 496, 494, 494, 497, 497, 77, 77, 
	77, 497, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 497, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 78, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 498, 77, 499, 500, 501, 501, 77, 
	77, 77, 501, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	501, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 78, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 502, 77, 76, 501, 503, 504, 
	505, 505, 62, 62, 62, 505, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 505, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	63, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 506, 62, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 505, 505, 505, 505, 505, 505, 505, 
	507, 507, 507, 507, 507, 507, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	507, 507, 507, 507, 507, 507, 505, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 508, 508, 508, 508, 508, 508, 508, 
	509, 509, 509, 509, 509, 509, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	509, 509, 509, 509, 509, 509, 508, 508, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 501, 501, 501, 501, 501, 501, 
	501, 510, 510, 510, 510, 510, 510, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 510, 510, 510, 510, 510, 510, 501, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 511, 511, 511, 511, 511, 511, 
	511, 512, 512, 512, 512, 512, 512, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 512, 512, 512, 512, 512, 512, 511, 
	511, 501, 55, 55, 55, 501, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 501, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 513, 55, 
	497, 62, 62, 62, 497, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 497, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 63, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 64, 62, 497, 514, 
	514, 514, 497, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	497, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 515, 514, 516, 517, 517, 514, 
	514, 514, 517, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	517, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 518, 514, 519, 519, 519, 519, 
	519, 519, 519, 519, 519, 519, 517, 517, 
	517, 517, 517, 517, 517, 519, 519, 519, 
	519, 519, 519, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 519, 519, 519, 
	519, 519, 519, 517, 521, 521, 521, 521, 
	521, 521, 521, 521, 521, 521, 520, 520, 
	520, 520, 520, 520, 520, 521, 521, 521, 
	521, 521, 521, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 521, 521, 521, 
	521, 521, 521, 520, 520, 517, 55, 55, 
	55, 517, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 517, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 513, 55, 522, 517, 517, 62, 
	62, 62, 517, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	517, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 63, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 64, 62, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 523, 523, 
	523, 523, 523, 523, 523, 524, 524, 524, 
	524, 524, 524, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 524, 524, 524, 
	524, 524, 524, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 525, 
	523, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 523, 523, 523, 523, 523, 
	523, 523, 526, 526, 526, 526, 526, 526, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 526, 526, 526, 526, 526, 526, 
	523, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 523, 523, 523, 523, 523, 
	523, 523, 527, 527, 527, 527, 527, 527, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 527, 527, 527, 527, 527, 527, 
	523, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 523, 523, 523, 523, 523, 
	523, 523, 528, 528, 528, 528, 528, 528, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 528, 528, 528, 528, 528, 528, 
	523, 529, 531, 532, 532, 532, 531, 532, 
	532, 532, 532, 533, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 531, 532, 532, 532, 
	532, 532, 533, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 532, 532, 532, 532, 
	532, 532, 532, 534, 534, 534, 534, 534, 
	534, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 534, 534, 534, 534, 534, 
	534, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 535, 
	532, 530, 531, 532, 532, 532, 531, 532, 
	532, 532, 532, 530, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 531, 532, 532, 532, 
	532, 532, 530, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 532, 532, 532, 532, 
	532, 532, 532, 536, 536, 536, 536, 536, 
	536, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 536, 536, 536, 536, 536, 
	536, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 532, 532, 537, 
	532, 531, 536, 536, 536, 531, 536, 536, 
	536, 536, 530, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 531, 536, 536, 536, 536, 
	536, 530, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 530, 536, 
	538, 531, 539, 539, 539, 531, 539, 539, 
	539, 539, 533, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 531, 539, 539, 539, 539, 
	539, 533, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 539, 539, 539, 539, 539, 
	539, 539, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 530, 539, 
	531, 539, 539, 539, 531, 539, 539, 539, 
	539, 530, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 531, 539, 539, 539, 539, 539, 
	530, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 539, 539, 539, 539, 539, 539, 
	539, 536, 536, 536, 536, 536, 536, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 536, 536, 536, 536, 536, 536, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 531, 539, 531, 
	539, 539, 539, 531, 539, 539, 539, 539, 
	540, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 531, 539, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 539, 539, 539, 539, 539, 539, 539, 
	541, 541, 541, 541, 541, 541, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	541, 541, 541, 541, 541, 541, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 542, 539, 531, 539, 
	539, 539, 531, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	531, 539, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 534, 
	534, 534, 534, 534, 534, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 534, 
	534, 534, 534, 534, 534, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 542, 539, 543, 531, 539, 
	539, 539, 531, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	531, 539, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 544, 544, 
	544, 544, 544, 544, 544, 544, 544, 544, 
	539, 539, 539, 539, 539, 539, 539, 544, 
	544, 544, 544, 544, 544, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 544, 
	544, 544, 544, 544, 544, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 542, 539, 531, 539, 539, 
	539, 531, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 531, 
	539, 539, 539, 539, 539, 540, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 539, 
	539, 539, 539, 539, 539, 539, 545, 545, 
	545, 545, 545, 545, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 545, 545, 
	545, 545, 545, 545, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 542, 539, 531, 539, 539, 539, 
	531, 539, 539, 539, 539, 540, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 531, 539, 
	539, 539, 539, 539, 540, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 546, 546, 546, 546, 
	546, 546, 546, 546, 546, 546, 539, 539, 
	539, 539, 539, 539, 539, 546, 546, 546, 
	546, 546, 546, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 546, 546, 546, 
	546, 546, 546, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 542, 539, 531, 539, 539, 539, 531, 
	539, 539, 539, 539, 540, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 531, 539, 539, 
	539, 539, 539, 540, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 539, 539, 539, 
	539, 539, 539, 539, 547, 547, 547, 547, 
	547, 547, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 547, 547, 547, 547, 
	547, 547, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	542, 539, 531, 539, 539, 539, 531, 539, 
	539, 539, 539, 540, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 531, 539, 539, 539, 
	539, 539, 540, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 539, 539, 539, 539, 
	539, 539, 539, 548, 548, 548, 548, 548, 
	548, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 548, 548, 548, 548, 548, 
	548, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 542, 
	539, 531, 539, 539, 539, 531, 539, 539, 
	539, 539, 530, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 531, 539, 539, 539, 539, 
	539, 530, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 530, 539, 
	549, 550, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 551, 551, 551, 551, 
	551, 551, 551, 552, 552, 552, 552, 552, 
	552, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 552, 552, 552, 552, 552, 
	552, 551, 551, 553, 554, 554, 554, 553, 
	554, 554, 554, 554, 555, 556, 555, 555, 
	555, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 553, 554, 554, 
	554, 554, 554, 555, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 557, 
	554, 555, 558, 555, 555, 555, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	555, 558, 559, 560, 560, 560, 559, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 559, 560, 561, 562, 
	562, 562, 561, 562, 562, 562, 562, 562, 
	563, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	561, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 562, 562, 562, 562, 562, 562, 
	562, 562, 564, 562, 565, 566, 566, 566, 
	565, 566, 566, 566, 566, 566, 567, 566, 
	566, 566, 566, 566, 566, 566, 566, 566, 
	566, 566, 566, 566, 566, 566, 565, 566, 
	568, 569, 569, 569, 568, 569, 569, 569, 
	569, 569, 570, 569, 569, 569, 569, 569, 
	569, 569, 569, 569, 569, 569, 569, 569, 
	569, 569, 568, 569, 569, 569, 569, 569, 
	569, 569, 569, 571, 569, 573, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 574, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 575, 572, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 576, 576, 576, 576, 576, 
	576, 576, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 576, 576, 576, 576, 
	86, 576, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 576, 576, 576, 576, 
	576, 86, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 577, 577, 577, 577, 
	577, 577, 577, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 577, 577, 577, 
	577, 87, 577, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 577, 577, 577, 
	577, 577, 87, 578, 579, 579, 579, 578, 
	579, 579, 579, 579, 579, 580, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 578, 579, 581, 
	582, 582, 582, 581, 582, 582, 582, 582, 
	583, 584, 583, 583, 583, 582, 582, 582, 
	582, 582, 582, 582, 582, 582, 582, 582, 
	582, 581, 582, 582, 582, 582, 582, 583, 
	582, 582, 585, 582, 583, 586, 583, 583, 
	583, 586, 586, 586, 586, 586, 586, 586, 
	586, 586, 586, 586, 586, 586, 586, 586, 
	586, 586, 586, 583, 586, 588, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 589, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 590, 587, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 591, 591, 591, 591, 591, 
	591, 591, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 591, 591, 591, 591, 
	93, 591, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 591, 591, 591, 591, 
	591, 93, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 592, 592, 592, 592, 
	592, 592, 592, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 592, 592, 592, 
	592, 94, 592, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 592, 592, 592, 
	592, 592, 94, 593, 594, 594, 594, 593, 
	594, 594, 594, 594, 595, 596, 595, 595, 
	595, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 593, 594, 594, 
	594, 594, 594, 595, 594, 595, 597, 595, 
	595, 595, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 595, 597, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	598, 598, 598, 598, 598, 598, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	598, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 600, 600, 600, 600, 600, 
	600, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 600, 601, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	602, 97, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 603, 
	603, 603, 603, 603, 603, 603, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	603, 603, 603, 603, 100, 603, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	603, 603, 603, 603, 603, 100, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	604, 604, 604, 604, 604, 604, 604, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 604, 604, 604, 604, 101, 604, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 604, 604, 604, 604, 604, 101, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 605, 605, 605, 605, 605, 605, 605, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 605, 605, 605, 605, 103, 605, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 605, 605, 605, 605, 605, 103, 
	606, 607, 607, 607, 606, 607, 607, 607, 
	607, 608, 609, 608, 608, 608, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 606, 607, 607, 607, 607, 607, 
	608, 610, 607, 611, 612, 613, 614, 607, 
	607, 607, 615, 616, 607, 616, 607, 617, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 618, 607, 619, 620, 621, 607, 
	607, 622, 623, 622, 622, 624, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 625, 626, 607, 617, 627, 
	617, 628, 629, 630, 631, 632, 633, 634, 
	634, 635, 634, 634, 634, 636, 637, 638, 
	634, 634, 639, 640, 641, 642, 634, 643, 
	634, 644, 634, 607, 645, 607, 616, 607, 
	634, 608, 646, 608, 608, 608, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	608, 646, 647, 617, 648, 648, 617, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 617, 648, 649, 650, 
	651, 652, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 105, 105, 653, 105, 653, 
	105, 105, 653, 653, 105, 105, 105, 654, 
	105, 105, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 105, 105, 105, 105, 
	105, 105, 105, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 653, 105, 653, 
	653, 656, 105, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 653, 653, 653, 
	105, 653, 656, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 657, 657, 
	657, 657, 657, 657, 657, 657, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	657, 657, 657, 657, 657, 657, 657, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 657, 657, 657, 657, 656, 657, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 657, 657, 657, 657, 657, 656, 658, 
	648, 617, 648, 617, 648, 617, 648, 660, 
	659, 617, 661, 648, 617, 648, 662, 617, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 617, 
	653, 617, 648, 617, 617, 648, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 664, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	663, 663, 663, 664, 663, 664, 663, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 663, 663, 663, 663, 622, 663, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 663, 663, 663, 663, 663, 622, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	664, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 665, 665, 665, 664, 665, 664, 665, 
	622, 622, 622, 622, 666, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 665, 665, 665, 665, 622, 665, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 665, 665, 665, 665, 665, 622, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 664, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 665, 665, 665, 664, 665, 664, 
	665, 622, 622, 622, 622, 622, 622, 667, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 665, 665, 665, 665, 622, 
	665, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 665, 665, 665, 665, 665, 
	622, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 664, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 665, 665, 665, 664, 665, 
	664, 665, 622, 622, 622, 622, 622, 622, 
	622, 622, 668, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 665, 665, 665, 665, 
	622, 665, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 665, 665, 665, 665, 
	665, 622, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 664, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 665, 665, 665, 664, 
	665, 664, 665, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	669, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 665, 665, 665, 
	665, 622, 665, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 665, 665, 665, 
	665, 665, 622, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 664, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 665, 665, 665, 
	664, 665, 664, 665, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 670, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 665, 665, 
	665, 665, 622, 665, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 665, 665, 
	665, 665, 665, 622, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 664, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 665, 665, 
	665, 664, 665, 664, 665, 622, 622, 622, 
	669, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 665, 
	665, 665, 665, 622, 665, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 665, 
	665, 665, 665, 665, 622, 662, 653, 609, 
	653, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	672, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 663, 664, 663, 663, 663, 663, 
	663, 663, 663, 663, 663, 663, 663, 663, 
	663, 663, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 663, 663, 663, 664, 
	663, 664, 663, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 663, 663, 663, 
	663, 634, 663, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 663, 663, 663, 
	663, 663, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	673, 674, 634, 634, 634, 634, 634, 675, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 676, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	677, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 678, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 679, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 680, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 681, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 682, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 683, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 684, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 685, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 686, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 682, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 687, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 686, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 688, 634, 
	689, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 690, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 691, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	684, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 684, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 692, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 693, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 694, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 695, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	684, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	696, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 697, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	684, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 698, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 699, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 700, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 684, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 701, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 691, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	702, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 684, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 703, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 664, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 704, 
	704, 704, 664, 704, 664, 704, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	704, 704, 704, 704, 634, 704, 634, 634, 
	634, 634, 634, 634, 634, 634, 705, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	704, 704, 704, 704, 704, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 706, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 707, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 708, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	709, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 710, 634, 
	711, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 712, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 684, 634, 634, 634, 713, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 684, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 684, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 714, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 715, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 700, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 716, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	638, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 698, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 684, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 684, 634, 634, 634, 634, 634, 
	634, 634, 684, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 717, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 718, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 719, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 700, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 720, 634, 
	634, 634, 721, 634, 634, 634, 634, 634, 
	722, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 722, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 684, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	684, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 723, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 724, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 725, 726, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 684, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 727, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 700, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 728, 634, 634, 729, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 684, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 695, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 730, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 731, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 713, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 732, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 638, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 634, 634, 
	634, 733, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 727, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 695, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 734, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	735, 634, 634, 634, 634, 634, 634, 634, 
	736, 634, 634, 634, 634, 634, 634, 634, 
	737, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 664, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 664, 671, 664, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 634, 671, 634, 634, 
	634, 634, 713, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 671, 671, 634, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 664, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	671, 671, 671, 664, 671, 664, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 634, 671, 634, 
	634, 634, 634, 701, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 671, 671, 634, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	664, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 671, 671, 671, 664, 671, 664, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 634, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	721, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 671, 671, 634, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 664, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 671, 671, 671, 664, 671, 664, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 634, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	738, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 671, 671, 
	634, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 664, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 671, 671, 671, 664, 671, 
	664, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	634, 671, 634, 634, 634, 634, 695, 634, 
	634, 634, 719, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 671, 
	671, 634, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 664, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 671, 671, 671, 664, 
	671, 664, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 634, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 739, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	671, 671, 634, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 664, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 671, 671, 671, 
	664, 671, 664, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 634, 671, 634, 634, 634, 634, 
	740, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 671, 671, 634, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 664, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 671, 671, 
	671, 664, 671, 664, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 634, 671, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 634, 
	689, 634, 634, 634, 634, 634, 634, 634, 
	634, 634, 634, 634, 634, 634, 634, 671, 
	671, 671, 671, 671, 634, 617, 648, 741, 
	742, 742, 742, 741, 742, 742, 742, 742, 
	743, 742, 743, 743, 743, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 741, 742, 742, 742, 742, 742, 743, 
	742, 742, 744, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 745, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 742, 747, 742, 742, 746, 742, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 742, 742, 742, 742, 742, 746, 
	743, 748, 743, 743, 743, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 743, 
	748, 749, 750, 751, 752, 754, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	112, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 110, 753, 753, 753, 753, 112, 753, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 753, 753, 753, 753, 113, 753, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 113, 
	113, 113, 753, 753, 753, 753, 753, 113, 
	755, 753, 756, 757, 758, 758, 758, 757, 
	758, 758, 758, 758, 759, 760, 759, 759, 
	759, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 757, 758, 758, 
	758, 758, 758, 759, 761, 758, 762, 758, 
	763, 764, 758, 758, 758, 765, 766, 758, 
	766, 758, 763, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 767, 
	768, 769, 758, 758, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 771, 772, 
	758, 763, 773, 763, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 758, 774, 
	758, 766, 758, 773, 759, 775, 759, 759, 
	759, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 759, 775, 776, 763, 777, 
	777, 763, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 777, 
	777, 777, 777, 777, 777, 777, 777, 763, 
	777, 778, 779, 780, 781, 763, 777, 763, 
	777, 763, 777, 763, 782, 777, 763, 777, 
	784, 763, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 783, 783, 783, 783, 783, 783, 783, 
	783, 763, 783, 763, 777, 763, 763, 777, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 786, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 785, 785, 785, 785, 785, 786, 
	785, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 785, 785, 785, 785, 770, 
	785, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 770, 770, 770, 770, 770, 
	770, 770, 770, 785, 785, 785, 785, 785, 
	770, 788, 787, 789, 784, 783, 760, 783, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 786, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 790, 790, 790, 790, 790, 786, 
	790, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 790, 790, 790, 790, 773, 
	790, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 773, 773, 773, 773, 773, 
	773, 773, 773, 790, 790, 790, 790, 790, 
	773, 763, 777, 791, 792, 792, 792, 791, 
	792, 792, 792, 792, 793, 794, 793, 793, 
	793, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 791, 792, 792, 
	792, 792, 792, 793, 792, 792, 795, 792, 
	116, 796, 792, 797, 792, 798, 116, 151, 
	799, 153, 116, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 800, 792, 801, 
	151, 802, 803, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 151, 804, 
	151, 116, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 805, 792, 792, 792, 
	792, 792, 792, 792, 792, 806, 792, 792, 
	807, 792, 808, 792, 792, 792, 164, 165, 
	792, 116, 792, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 793, 809, 793, 793, 
	793, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 793, 809, 809, 809, 809, 
	146, 147, 809, 148, 809, 149, 150, 151, 
	152, 153, 146, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 154, 809, 155, 
	151, 156, 157, 809, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 158, 159, 
	151, 116, 119, 809, 119, 119, 119, 119, 
	119, 119, 119, 119, 160, 119, 119, 119, 
	119, 119, 119, 119, 119, 161, 119, 119, 
	162, 119, 163, 119, 119, 119, 164, 165, 
	809, 116, 809, 119, 810, 811, 811, 811, 
	810, 811, 811, 811, 811, 151, 812, 151, 
	151, 151, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 810, 811, 
	811, 811, 811, 811, 151, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 151, 811, 151, 812, 151, 151, 151, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 151, 117, 117, 117, 117, 117, 
	116, 117, 117, 117, 117, 117, 117, 117, 
	151, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 151, 
	117, 151, 812, 151, 151, 151, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	151, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 151, 117, 813, 
	151, 812, 151, 151, 151, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 151, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 815, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 151, 814, 151, 812, 
	151, 151, 151, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 151, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 151, 151, 117, 816, 810, 151, 
	810, 818, 817, 820, 821, 820, 820, 820, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 820, 819, 822, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 118, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 120, 
	810, 810, 810, 810, 118, 810, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	810, 810, 810, 810, 119, 810, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	810, 810, 810, 810, 810, 119, 823, 151, 
	812, 151, 151, 151, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 151, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 151, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 116, 810, 824, 825, 826, 827, 
	828, 829, 151, 812, 151, 151, 151, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 151, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 116, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 151, 810, 
	151, 817, 116, 830, 116, 830, 831, 832, 
	831, 831, 831, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 831, 819, 833, 
	830, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 122, 834, 122, 122, 122, 834, 
	834, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 834, 834, 834, 834, 834, 834, 
	834, 122, 834, 834, 834, 834, 123, 124, 
	834, 125, 834, 126, 127, 128, 129, 130, 
	123, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 834, 131, 834, 132, 128, 133, 
	134, 834, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 136, 137, 128, 138, 
	135, 834, 135, 135, 135, 135, 135, 135, 
	135, 135, 139, 135, 135, 135, 135, 135, 
	135, 135, 135, 140, 135, 135, 141, 135, 
	142, 135, 135, 135, 143, 144, 834, 138, 
	834, 135, 151, 830, 835, 830, 836, 830, 
	837, 830, 838, 196, 196, 196, 838, 196, 
	196, 196, 196, 839, 196, 839, 839, 839, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 838, 196, 196, 196, 
	196, 196, 839, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 196, 840, 196, 
	196, 192, 196, 192, 192, 192, 194, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 196, 196, 196, 
	196, 196, 192, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 190, 841, 190, 190, 
	190, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 190, 841, 841, 841, 841, 
	841, 841, 841, 191, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 841, 193, 
	841, 841, 192, 841, 192, 192, 192, 194, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 841, 841, 
	841, 841, 841, 192, 842, 195, 195, 195, 
	195, 195, 195, 195, 195, 195, 195, 195, 
	195, 195, 195, 195, 195, 195, 195, 195, 
	195, 195, 195, 195, 195, 195, 195, 195, 
	195, 195, 195, 195, 195, 195, 843, 195, 
	195, 195, 195, 195, 195, 195, 195, 195, 
	195, 195, 195, 195, 195, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 196, 
	195, 195, 195, 195, 843, 195, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	195, 195, 195, 195, 192, 195, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	195, 195, 195, 195, 195, 192, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 841, 843, 
	841, 841, 841, 841, 841, 841, 841, 841, 
	841, 841, 841, 841, 841, 841, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	196, 841, 841, 841, 841, 843, 841, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 841, 841, 841, 841, 192, 841, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 844, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 841, 841, 841, 841, 841, 192, 197, 
	841, 845, 846, 846, 846, 845, 846, 846, 
	846, 846, 847, 846, 847, 847, 847, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 845, 846, 846, 846, 846, 
	846, 847, 846, 846, 848, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 849, 846, 846, 
	846, 846, 846, 846, 846, 850, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 846, 846, 846, 846, 
	846, 846, 846, 846, 851, 846, 847, 852, 
	847, 847, 847, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 847, 852, 853, 
	854, 855, 856, 858, 857, 859, 860, 857, 
	861, 862, 863, 863, 863, 862, 863, 863, 
	863, 863, 864, 865, 864, 864, 864, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 862, 863, 863, 863, 863, 
	863, 864, 863, 863, 866, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 863, 868, 863, 863, 
	867, 863, 867, 867, 867, 867, 867, 867, 
	867, 867, 869, 867, 867, 867, 867, 867, 
	867, 867, 867, 870, 867, 867, 871, 867, 
	872, 867, 867, 867, 863, 863, 863, 863, 
	863, 867, 864, 873, 864, 864, 864, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 864, 873, 874, 875, 876, 877, 878, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	879, 879, 879, 879, 879, 879, 879, 879, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 879, 879, 879, 879, 879, 879, 
	879, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 879, 879, 879, 879, 867, 
	879, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 879, 879, 879, 879, 879, 
	867, 881, 880, 882, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 883, 883, 883, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 867, 883, 867, 867, 867, 
	867, 867, 884, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 883, 867, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 883, 883, 883, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 867, 883, 867, 867, 
	867, 867, 885, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 883, 867, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 883, 883, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 867, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 886, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 883, 867, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 883, 883, 883, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 867, 883, 
	867, 867, 887, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 883, 867, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 883, 883, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 867, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 888, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 883, 
	867, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 883, 
	883, 883, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	867, 883, 867, 867, 867, 867, 884, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	883, 867, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	883, 883, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 867, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	889, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 883, 867, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 883, 883, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 867, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 890, 
	867, 867, 867, 867, 867, 867, 867, 891, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 883, 867, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 883, 883, 883, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 867, 883, 867, 867, 867, 
	867, 892, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 883, 867, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 883, 
	883, 883, 883, 883, 883, 883, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 867, 883, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	893, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 883, 867, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	883, 883, 883, 883, 883, 883, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 867, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 884, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 883, 867, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 883, 883, 883, 883, 883, 883, 883, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 867, 883, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	894, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 883, 867, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 883, 883, 883, 883, 883, 883, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 867, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 884, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 883, 
	867, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 883, 883, 883, 883, 883, 
	883, 883, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	867, 883, 867, 867, 867, 867, 867, 867, 
	867, 895, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	883, 867, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 883, 883, 883, 883, 
	883, 883, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 867, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 896, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 883, 867, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 883, 883, 883, 
	883, 883, 883, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 867, 883, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 867, 888, 
	867, 867, 867, 867, 867, 867, 867, 867, 
	867, 867, 867, 867, 867, 867, 883, 883, 
	883, 883, 883, 867, 897, 212, 212, 212, 
	897, 212, 212, 212, 212, 898, 899, 898, 
	898, 898, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 897, 212, 
	212, 212, 212, 212, 898, 900, 212, 901, 
	212, 902, 903, 212, 904, 212, 905, 906, 
	212, 907, 908, 909, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 910, 212, 
	911, 912, 913, 914, 212, 915, 916, 915, 
	915, 917, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 918, 
	919, 212, 920, 921, 212, 922, 923, 924, 
	925, 926, 927, 928, 928, 929, 928, 928, 
	928, 930, 931, 932, 928, 928, 933, 934, 
	935, 936, 928, 937, 928, 938, 928, 939, 
	940, 212, 920, 212, 928, 898, 941, 898, 
	898, 898, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 898, 941, 943, 942, 
	945, 946, 945, 945, 945, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 945, 
	944, 212, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 212, 947, 948, 949, 950, 951, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	952, 952, 952, 952, 952, 952, 952, 952, 
	952, 952, 953, 953, 953, 953, 953, 953, 
	953, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 953, 953, 953, 953, 953, 
	953, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 954, 954, 954, 954, 954, 
	954, 954, 954, 953, 953, 953, 953, 953, 
	952, 956, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	212, 955, 957, 959, 958, 958, 958, 958, 
	958, 958, 958, 958, 958, 958, 958, 958, 
	958, 958, 958, 958, 958, 958, 212, 958, 
	212, 211, 213, 214, 213, 213, 213, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 213, 955, 955, 215, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 955, 955, 955, 212, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 217, 955, 230, 
	231, 230, 230, 230, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 230, 229, 
	229, 232, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 234, 229, 213, 214, 213, 213, 
	213, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 213, 955, 955, 215, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 216, 955, 955, 955, 
	212, 212, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 955, 
	955, 955, 955, 955, 955, 955, 955, 217, 
	955, 961, 947, 963, 962, 965, 964, 947, 
	966, 966, 966, 947, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 947, 966, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 967, 968, 947, 969, 
	237, 970, 968, 947, 947, 971, 972, 947, 
	972, 947, 237, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 973, 947, 974, 
	975, 976, 947, 977, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 979, 947, 
	947, 237, 978, 237, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 947, 980, 
	947, 981, 947, 978, 237, 982, 982, 983, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 237, 982, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 982, 982, 982, 982, 
	982, 982, 982, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 982, 982, 982, 
	982, 240, 982, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 982, 982, 982, 
	982, 982, 240, 984, 982, 237, 982, 237, 
	982, 237, 985, 982, 237, 982, 237, 982, 
	237, 237, 982, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 987, 987, 987, 987, 987, 
	987, 987, 987, 987, 987, 986, 986, 986, 
	986, 986, 986, 988, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 986, 986, 
	986, 986, 989, 986, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 986, 986, 
	986, 986, 986, 989, 991, 991, 991, 991, 
	991, 991, 991, 991, 991, 991, 990, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 993, 
	993, 993, 993, 993, 993, 993, 993, 993, 
	993, 992, 992, 992, 992, 992, 992, 992, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 992, 992, 992, 992, 994, 992, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 992, 992, 992, 992, 992, 994, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 995, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 982, 982, 982, 996, 982, 995, 
	982, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 982, 982, 982, 982, 978, 
	982, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 982, 982, 982, 982, 982, 
	978, 998, 997, 999, 1001, 1002, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
	1000, 1000, 1000, 1000, 1000, 1003, 1000, 1005, 
	1006, 1004, 1007, 1008, 1009, 1010, 984, 982, 
	983, 982, 1011, 1012, 947, 248, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 249, 242, 1014, 
	254, 243, 243, 243, 243, 243, 243, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	243, 243, 243, 243, 243, 249, 243, 249, 
	257, 212, 947, 920, 212, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 212, 947, 212, 956, 
	947, 1016, 1017, 1017, 1017, 1016, 1017, 1017, 
	1017, 1017, 1018, 1019, 1018, 1018, 1018, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1016, 1017, 1017, 1017, 1017, 
	1017, 1018, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1017, 1021, 1017, 1017, 
	1020, 1017, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1017, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1022, 1022, 1022, 1022, 1023, 1022, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1022, 1022, 1022, 1022, 1022, 1023, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1024, 1024, 1024, 1024, 1025, 1024, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1024, 1024, 1024, 1024, 1024, 1025, 
	1027, 1028, 1028, 1028, 1027, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1027, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1030, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1031, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1032, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1028, 1033, 1028, 1028, 
	1034, 1028, 1035, 1036, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1037, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1037, 1037, 1040, 
	1040, 281, 281, 281, 1040, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 1040, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 282, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 1041, 281, 1042, 1043, 
	1044, 1044, 281, 281, 281, 1044, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 1044, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	282, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 1045, 281, 280, 
	1044, 1046, 1047, 1048, 1048, 266, 266, 266, 
	1048, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 1048, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 267, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	1049, 266, 1050, 1050, 1050, 1050, 1050, 1050, 
	1050, 1050, 1050, 1050, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1050, 1050, 1050, 1050, 1050, 
	1050, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1050, 1050, 1050, 1050, 1050, 
	1050, 1048, 1052, 1052, 1052, 1052, 1052, 1052, 
	1052, 1052, 1052, 1052, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1052, 1052, 1052, 1052, 1052, 
	1052, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1052, 1052, 1052, 1052, 1052, 
	1052, 1051, 1051, 1053, 1053, 1053, 1053, 1053, 
	1053, 1053, 1053, 1053, 1053, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1053, 1053, 1053, 1053, 
	1053, 1053, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1053, 1053, 1053, 1053, 
	1053, 1053, 1044, 1055, 1055, 1055, 1055, 1055, 
	1055, 1055, 1055, 1055, 1055, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1055, 1055, 1055, 1055, 
	1055, 1055, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1054, 1055, 1055, 1055, 1055, 
	1055, 1055, 1054, 1054, 1044, 259, 259, 259, 
	1044, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 1044, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 1056, 259, 1040, 266, 266, 266, 1040, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 1040, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 267, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 268, 
	266, 1040, 1057, 1057, 1057, 1040, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1040, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1058, 1057, 1059, 
	1060, 1060, 1057, 1057, 1057, 1060, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1060, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 
	1057, 1057, 1057, 1057, 1057, 1061, 1057, 1062, 
	1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 
	1062, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1062, 1062, 1062, 1062, 1062, 1062, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1062, 1062, 1062, 1062, 1062, 1062, 1060, 1064, 
	1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 
	1064, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 
	1064, 1064, 1064, 1064, 1064, 1064, 1063, 1063, 
	1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 
	1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 
	1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 
	1064, 1064, 1064, 1064, 1064, 1064, 1063, 1063, 
	1060, 259, 259, 259, 1060, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 1060, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 1056, 259, 1065, 
	1060, 1060, 266, 266, 266, 1060, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 1060, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	267, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 268, 266, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1067, 1067, 1067, 1067, 1067, 1067, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1067, 1067, 1067, 1067, 1067, 1067, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1068, 1066, 1069, 1069, 1069, 1069, 
	1069, 1069, 1069, 1069, 1069, 1069, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1069, 1069, 1069, 
	1069, 1069, 1069, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1069, 1069, 1069, 
	1069, 1069, 1069, 1066, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1070, 1070, 1070, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1070, 1070, 1070, 
	1070, 1070, 1070, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1070, 1070, 1070, 
	1070, 1070, 1070, 1066, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1071, 1071, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1071, 1071, 1071, 
	1071, 1071, 1071, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1071, 1071, 1071, 
	1071, 1071, 1071, 1066, 1072, 1074, 1075, 1075, 
	1075, 1074, 1075, 1075, 1075, 1075, 1076, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1074, 
	1075, 1075, 1075, 1075, 1075, 1076, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1077, 1077, 1077, 
	1077, 1077, 1077, 1077, 1077, 1077, 1077, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1077, 1077, 
	1077, 1077, 1077, 1077, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1077, 1077, 
	1077, 1077, 1077, 1077, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1078, 1075, 1073, 1074, 1075, 1075, 
	1075, 1074, 1075, 1075, 1075, 1075, 1073, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1074, 
	1075, 1075, 1075, 1075, 1075, 1073, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1079, 1079, 
	1079, 1079, 1079, 1079, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1079, 1079, 
	1079, 1079, 1079, 1079, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1080, 1075, 1074, 1079, 1079, 1079, 
	1074, 1079, 1079, 1079, 1079, 1073, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1074, 1079, 
	1079, 1079, 1079, 1079, 1073, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1073, 1079, 1081, 1074, 1082, 1082, 1082, 
	1074, 1082, 1082, 1082, 1082, 1076, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1082, 1076, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1083, 1083, 1083, 
	1083, 1083, 1083, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1083, 1083, 1083, 
	1083, 1083, 1083, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1073, 1082, 1074, 1082, 1082, 1082, 1074, 
	1082, 1082, 1082, 1082, 1073, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1082, 1073, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1079, 1079, 1079, 1079, 
	1079, 1079, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1079, 1079, 1079, 1079, 
	1079, 1079, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1074, 1082, 1074, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1084, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1082, 1084, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1085, 1085, 1085, 1085, 1085, 1085, 
	1085, 1085, 1085, 1085, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1085, 1085, 1085, 1085, 1085, 
	1085, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1085, 1085, 1085, 1085, 1085, 
	1085, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1086, 
	1082, 1074, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1084, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1082, 1084, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1083, 1083, 1083, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1083, 1083, 1083, 1083, 1083, 1083, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1083, 1083, 1083, 1083, 1083, 1083, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1086, 1082, 
	1087, 1074, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1084, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1082, 1084, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 
	1088, 1088, 1088, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1088, 1088, 1088, 1088, 1088, 1088, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1088, 1088, 1088, 1088, 1088, 1088, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1086, 1082, 
	1074, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1084, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1074, 1082, 1082, 1082, 1082, 1082, 
	1084, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1089, 1089, 1089, 1089, 1089, 1089, 1089, 1089, 
	1089, 1089, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1089, 1089, 1089, 1089, 1089, 1089, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1089, 1089, 1089, 1089, 1089, 1089, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1086, 1082, 1074, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1084, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1074, 1082, 1082, 1082, 1082, 1082, 1084, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1090, 1090, 1090, 1090, 1090, 1090, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1090, 1090, 1090, 1090, 1090, 1090, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1086, 1082, 1074, 1082, 
	1082, 1082, 1074, 1082, 1082, 1082, 1082, 1084, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1074, 1082, 1082, 1082, 1082, 1082, 1084, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1091, 1091, 
	1091, 1091, 1091, 1091, 1091, 1091, 1091, 1091, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1091, 
	1091, 1091, 1091, 1091, 1091, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1091, 
	1091, 1091, 1091, 1091, 1091, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1086, 1082, 1074, 1082, 1082, 
	1082, 1074, 1082, 1082, 1082, 1082, 1084, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1074, 
	1082, 1082, 1082, 1082, 1082, 1084, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1092, 1092, 1092, 
	1092, 1092, 1092, 1092, 1092, 1092, 1092, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1092, 1092, 
	1092, 1092, 1092, 1092, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1092, 1092, 
	1092, 1092, 1092, 1092, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1086, 1082, 1074, 1082, 1082, 1082, 
	1074, 1082, 1082, 1082, 1082, 1073, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1082, 1073, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1092, 1092, 1092, 1092, 
	1092, 1092, 1092, 1092, 1092, 1092, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1092, 1092, 1092, 
	1092, 1092, 1092, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1092, 1092, 1092, 
	1092, 1092, 1092, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1073, 1082, 1074, 1082, 1082, 1082, 1074, 
	1082, 1082, 1082, 1082, 1093, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1082, 1093, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1094, 1094, 1094, 1094, 1094, 
	1094, 1094, 1094, 1094, 1094, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1094, 1094, 1094, 1094, 
	1094, 1094, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1094, 1094, 1094, 1094, 
	1094, 1094, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1086, 1082, 1074, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1093, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1082, 1093, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1095, 1095, 1095, 1095, 1095, 
	1095, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1095, 1095, 1095, 1095, 1095, 
	1095, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1086, 
	1082, 1074, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1093, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1082, 1093, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
	1096, 1096, 1096, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1096, 1096, 1096, 1096, 1096, 1096, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1096, 1096, 1096, 1096, 1096, 1096, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1073, 1082, 
	1074, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1093, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1074, 1082, 1082, 1082, 1082, 1082, 
	1093, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1097, 1097, 1097, 1097, 1097, 1097, 1097, 1097, 
	1097, 1097, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1097, 1097, 1097, 1097, 1097, 1097, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1097, 1097, 1097, 1097, 1097, 1097, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1073, 1082, 1074, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1093, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1074, 1082, 1082, 1082, 1082, 1082, 1093, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1098, 1098, 1098, 1098, 1098, 1098, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1098, 1098, 1098, 1098, 1098, 1098, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1073, 1082, 1074, 1082, 
	1082, 1082, 1074, 1082, 1082, 1082, 1082, 1093, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1074, 1082, 1082, 1082, 1082, 1082, 1093, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1099, 
	1099, 1099, 1099, 1099, 1099, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1099, 
	1099, 1099, 1099, 1099, 1099, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1073, 1082, 1074, 1082, 1082, 
	1082, 1074, 1082, 1082, 1082, 1082, 1093, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1074, 
	1082, 1082, 1082, 1082, 1082, 1093, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1100, 1100, 1100, 
	1100, 1100, 1100, 1100, 1100, 1100, 1100, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1100, 1100, 
	1100, 1100, 1100, 1100, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1100, 1100, 
	1100, 1100, 1100, 1100, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1073, 1082, 1074, 1082, 1082, 1082, 
	1074, 1082, 1082, 1082, 1082, 1093, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1082, 1093, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1092, 1092, 1092, 1092, 
	1092, 1092, 1092, 1092, 1092, 1092, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1092, 1092, 1092, 
	1092, 1092, 1092, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1092, 1092, 1092, 
	1092, 1092, 1092, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1073, 1082, 1074, 1082, 1082, 1082, 1074, 
	1082, 1082, 1082, 1082, 1093, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1082, 1093, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1101, 1101, 1101, 1101, 
	1101, 1101, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1101, 1101, 1101, 1101, 
	1101, 1101, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1086, 1082, 1074, 1082, 1082, 1082, 1074, 1082, 
	1082, 1082, 1082, 1093, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1082, 1093, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1102, 1102, 1102, 1102, 1102, 1102, 
	1102, 1102, 1102, 1102, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1102, 1102, 1102, 1102, 1102, 
	1102, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1102, 1102, 1102, 1102, 1102, 
	1102, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1086, 
	1082, 1074, 1082, 1082, 1082, 1074, 1082, 1082, 
	1082, 1082, 1093, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1082, 1093, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1103, 1103, 1103, 1103, 1103, 1103, 1103, 
	1103, 1103, 1103, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1103, 1103, 1103, 1103, 1103, 1103, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1103, 1103, 1103, 1103, 1103, 1103, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1086, 1082, 
	1074, 1082, 1082, 1082, 1074, 1082, 1082, 1082, 
	1082, 1093, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1074, 1082, 1082, 1082, 1082, 1082, 
	1093, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 
	1104, 1104, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1104, 1104, 1104, 1104, 1104, 1104, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1104, 1104, 1104, 1104, 1104, 1104, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1086, 1082, 1074, 
	1082, 1082, 1082, 1074, 1082, 1082, 1082, 1082, 
	1093, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1074, 1082, 1082, 1082, 1082, 1082, 1093, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1092, 
	1092, 1092, 1092, 1092, 1092, 1092, 1092, 1092, 
	1092, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1092, 1092, 1092, 1092, 1092, 1092, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1092, 1092, 1092, 1092, 1092, 1092, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1086, 1082, 1105, 1106, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1108, 1108, 1108, 1108, 1108, 1108, 1107, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1108, 1108, 1108, 1108, 1108, 1108, 1107, 
	1107, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 287, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 289, 211, 211, 290, 211, 
	287, 211, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 211, 211, 211, 211, 
	288, 211, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 211, 211, 211, 211, 
	211, 288, 1110, 1109, 1109, 1111, 1109, 1112, 
	1114, 1115, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1116, 1113, 1118, 1117, 1119, 1120, 1121, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 287, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 289, 947, 947, 290, 947, 287, 
	947, 288, 288, 288, 288, 1122, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 947, 947, 947, 947, 288, 
	947, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 947, 947, 947, 947, 947, 
	288, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 287, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 289, 947, 947, 290, 947, 
	287, 947, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 1123, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 947, 947, 947, 947, 
	288, 947, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 947, 947, 947, 947, 
	947, 288, 1124, 1125, 947, 942, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 1129, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 1130, 1131, 928, 
	928, 928, 928, 928, 1132, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1133, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 1134, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1135, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	1136, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 1137, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1138, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 1139, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 1140, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	1141, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 287, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 211, 211, 290, 
	211, 287, 211, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 211, 211, 211, 
	211, 928, 211, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 211, 211, 211, 
	211, 211, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 1142, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1143, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 1139, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 1144, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1143, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1145, 928, 1146, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 1147, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 1148, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1141, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	1141, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 1149, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1150, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 928, 928, 1151, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1152, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1141, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 1153, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 1154, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1141, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 1155, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1156, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1157, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 1141, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	1158, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1148, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 1159, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1141, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 928, 
	1141, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1160, 
	928, 1161, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1162, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 1141, 928, 928, 928, 1159, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 1141, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1163, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1164, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1157, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 1165, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	932, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1155, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1141, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 1166, 928, 928, 928, 928, 928, 
	928, 928, 1141, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1167, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 1168, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1169, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1157, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 1170, 928, 
	928, 928, 1171, 928, 928, 928, 928, 928, 
	1172, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1172, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1141, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1141, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 1173, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 1174, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1175, 1176, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1141, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 1177, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1178, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 1179, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1181, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1183, 1180, 1180, 
	1184, 1180, 1181, 1180, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1180, 1180, 
	1180, 1180, 1182, 1180, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1180, 1180, 
	1180, 1180, 1180, 1182, 1114, 1185, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1113, 1113, 1113, 1113, 1116, 1113, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1186, 928, 928, 1187, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1141, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1152, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 1188, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1189, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1159, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1190, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 932, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 928, 928, 928, 1191, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1192, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 1152, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1157, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1193, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 1194, 928, 
	928, 928, 928, 928, 928, 928, 1195, 928, 
	928, 928, 928, 928, 928, 928, 1196, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	1159, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 1197, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1198, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1166, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1199, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 1126, 1127, 1127, 1127, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 287, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 289, 1126, 1126, 290, 1126, 287, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1128, 1126, 1126, 928, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1166, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1126, 1126, 1126, 1126, 1126, 
	928, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 1126, 1127, 1127, 1127, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1127, 287, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 289, 1126, 1126, 290, 1126, 
	287, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1128, 1126, 1126, 
	928, 1126, 928, 928, 928, 928, 928, 928, 
	928, 1200, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 1126, 1126, 1126, 1126, 
	1126, 928, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 1126, 1127, 1127, 1127, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1127, 287, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 289, 1126, 1126, 290, 
	1126, 287, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1128, 1126, 
	1126, 928, 1126, 928, 928, 928, 928, 1152, 
	928, 928, 928, 1201, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 1126, 1126, 1126, 
	1126, 1126, 928, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 1126, 1127, 1127, 
	1127, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1127, 287, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 289, 1126, 1126, 
	290, 1126, 287, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1128, 
	1126, 1126, 928, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1202, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 1126, 1126, 
	1126, 1126, 1126, 928, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 1126, 1127, 
	1127, 1127, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1127, 287, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 289, 1126, 
	1126, 290, 1126, 287, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1128, 1126, 1126, 928, 1126, 928, 928, 928, 
	928, 1166, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 1126, 
	1126, 1126, 1126, 1126, 928, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 1126, 
	1127, 1127, 1127, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1127, 287, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 289, 
	1126, 1126, 290, 1126, 287, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1128, 1126, 1126, 928, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 1203, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	1126, 1126, 1126, 1126, 1126, 928, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	1126, 1127, 1127, 1127, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1127, 287, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	289, 1126, 1126, 290, 1126, 287, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1128, 1126, 1126, 928, 1126, 928, 
	928, 928, 928, 1204, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 1126, 1126, 1126, 1126, 1126, 928, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1127, 1126, 1127, 1127, 1127, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 1127, 
	287, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 
	1126, 1126, 1126, 1126, 1126, 1126, 1126, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 289, 1126, 1126, 290, 1126, 287, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1128, 1126, 1126, 928, 1126, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 1146, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 1126, 1126, 1126, 1126, 1126, 928, 
	1205, 212, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	1206, 947, 1207, 1208, 1208, 1208, 1207, 1208, 
	1208, 1208, 1208, 1209, 1210, 1209, 1209, 1209, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1207, 1208, 1208, 1208, 
	1208, 1208, 1209, 1208, 1208, 1211, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1212, 1208, 
	1209, 1213, 1209, 1209, 1209, 1213, 1213, 1213, 
	1213, 1213, 1213, 1213, 1213, 1213, 1213, 1213, 
	1213, 1213, 1213, 1213, 1213, 1213, 1213, 1209, 
	1213, 1214, 1215, 1216, 1217, 1218, 1220, 1219, 
	1221, 1222, 1223, 1223, 1223, 1222, 1223, 1223, 
	1223, 1223, 1224, 1225, 1224, 1224, 1224, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1222, 1223, 1223, 1223, 1223, 
	1223, 1224, 1223, 1226, 1227, 1223, 1223, 1223, 
	1226, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1223, 1229, 1223, 1223, 
	1228, 1223, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1223, 1223, 1223, 1223, 
	1223, 1228, 1224, 1230, 1224, 1224, 1224, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1224, 1230, 1231, 1232, 1233, 1234, 1235, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 305, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 303, 1236, 1236, 1236, 1236, 305, 
	1236, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 1236, 1236, 1236, 1236, 306, 
	1236, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 1236, 1236, 1236, 1236, 1236, 
	306, 1237, 1236, 1238, 1239, 1240, 1240, 1240, 
	1239, 1240, 1240, 1240, 1240, 1241, 1242, 1241, 
	1241, 1241, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1239, 1240, 
	1240, 1240, 1240, 1240, 1241, 1243, 1244, 1245, 
	1246, 1247, 1248, 1244, 1249, 1250, 1251, 1247, 
	1252, 1253, 1254, 1247, 1255, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1256, 1256, 1257, 1258, 
	1259, 1260, 1261, 1262, 1263, 1264, 1265, 1264, 
	1264, 1266, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1267, 
	1268, 1269, 1247, 1270, 1244, 1271, 1272, 1273, 
	1274, 1275, 1276, 1277, 1277, 1278, 1277, 1277, 
	1277, 1279, 1280, 1281, 1277, 1277, 1282, 1283, 
	1284, 1285, 1277, 1286, 1277, 1287, 1277, 1288, 
	1289, 1290, 1291, 1240, 1277, 1241, 1292, 1241, 
	1241, 1241, 1292, 1292, 1292, 1292, 1292, 1292, 
	1292, 1292, 1292, 1292, 1292, 1292, 1292, 1292, 
	1292, 1292, 1292, 1292, 1241, 1292, 1293, 1295, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1295, 1294, 1296, 1297, 1298, 1299, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 308, 
	308, 1300, 308, 1300, 308, 308, 1300, 1300, 
	308, 308, 308, 1301, 308, 308, 1302, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	308, 308, 308, 308, 308, 308, 308, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 1300, 308, 1300, 1300, 325, 308, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 1300, 1300, 1300, 308, 1300, 325, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1302, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1303, 1303, 1303, 
	1303, 325, 1303, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1303, 1303, 1303, 
	1303, 1303, 325, 1304, 313, 1247, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1306, 1305, 1305, 
	1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 
	1305, 1305, 1305, 1305, 1304, 1305, 1307, 1308, 
	1247, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 
	1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 
	1309, 1309, 1309, 1304, 1309, 1304, 1310, 1305, 
	1312, 1311, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 1311, 1314, 1313, 1315, 
	1313, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1317, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1318, 1316, 1316, 1316, 1316, 1316, 1317, 1316, 
	311, 311, 311, 311, 311, 311, 311, 311, 
	311, 311, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 310, 
	1316, 1320, 1319, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1322, 1319, 1323, 
	1324, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1325, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1326, 1319, 1319, 1319, 1319, 
	1319, 1319, 1327, 1319, 1319, 1322, 1319, 1323, 
	1324, 1319, 1319, 1319, 1328, 1319, 1319, 1319, 
	1319, 1319, 1325, 1319, 1319, 1329, 1319, 1319, 
	1319, 1319, 1319, 1326, 1319, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 1330, 
	1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 
	1330, 1330, 1331, 1330, 1330, 1330, 1330, 1330, 
	1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 
	1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 
	1330, 1330, 1330, 1330, 1332, 1330, 1330, 1330, 
	1330, 1330, 1331, 1330, 1330, 1330, 1333, 1330, 
	1330, 1330, 1330, 1330, 1330, 1330, 1330, 1334, 
	1330, 1335, 313, 1335, 313, 313, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	313, 315, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1335, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1337, 1336, 1339, 1338, 1340, 1342, 
	1341, 1341, 1341, 1343, 1341, 1344, 1345, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1327, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1328, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1329, 1319, 1346, 1346, 1346, 1346, 1346, 
	1346, 1346, 1346, 1346, 1346, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1347, 1319, 1319, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1328, 1319, 1319, 1319, 
	1319, 1319, 1319, 1319, 1319, 1329, 1319, 1349, 
	1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 
	1349, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1350, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1351, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1352, 1348, 1349, 1349, 1349, 1349, 1349, 
	1349, 1349, 1349, 1349, 1349, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1353, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1351, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1352, 1348, 1351, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1352, 1348, 1355, 1354, 1356, 1358, 1357, 1357, 
	1357, 1359, 1357, 1361, 1360, 1362, 1363, 1365, 
	1365, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1366, 1364, 
	1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1367, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 
	1364, 1368, 1364, 1369, 1369, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1370, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1351, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1352, 1348, 1369, 
	1369, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1353, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1351, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1352, 1348, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 
	1371, 1371, 1373, 1371, 1371, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1374, 1371, 1371, 1371, 
	1371, 1371, 1371, 1371, 1371, 1375, 1371, 1377, 
	1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 
	1377, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1378, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1379, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1380, 1376, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1382, 1382, 1382, 1382, 
	1382, 1382, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1383, 1381, 1382, 1382, 1382, 1382, 
	1382, 1382, 1381, 1381, 1384, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1385, 1381, 1386, 
	1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 
	1386, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1386, 1386, 1386, 1386, 1386, 1386, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1387, 1348, 
	1386, 1386, 1386, 1386, 1386, 1386, 1348, 1348, 
	1351, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1352, 1348, 1386, 1386, 1386, 1386, 1386, 
	1386, 1386, 1386, 1386, 1386, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1386, 1386, 1386, 1386, 
	1386, 1386, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1353, 1348, 1386, 1386, 1386, 1386, 
	1386, 1386, 1348, 1348, 1351, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1352, 1348, 1389, 
	1388, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 
	1390, 1390, 1390, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1391, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1392, 1388, 1388, 1388, 1388, 1388, 1391, 1388, 
	1388, 1388, 1393, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1394, 1388, 1395, 1395, 1395, 
	1395, 1395, 1395, 1395, 1395, 1395, 1395, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1396, 1388, 1388, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1393, 1388, 
	1388, 1388, 1388, 1388, 1388, 1388, 1388, 1394, 
	1388, 1397, 1348, 1398, 1398, 1398, 1398, 1398, 
	1398, 1398, 1398, 1398, 1398, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1399, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1400, 1348, 1348, 1348, 1348, 1348, 
	1399, 1348, 1348, 1348, 1351, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1352, 1348, 1398, 
	1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 
	1398, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1353, 1348, 
	1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1351, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 
	1348, 1352, 1348, 1306, 1313, 1247, 1401, 1305, 
	1295, 1305, 1402, 1403, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1295, 1313, 1295, 1305, 1295, 
	1247, 1305, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 1300, 1300, 1300, 1300, 
	1300, 1300, 1404, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1300, 1300, 1300, 
	1300, 325, 1300, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1300, 1300, 1300, 
	1300, 1300, 325, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 1405, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1406, 313, 313, 
	313, 313, 1405, 313, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 313, 313, 
	313, 313, 1264, 313, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 313, 313, 
	313, 313, 313, 1264, 1408, 1407, 1409, 1410, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1405, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1406, 1411, 1411, 1411, 1411, 1405, 
	1411, 1264, 1264, 1264, 1264, 1412, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1411, 1411, 1411, 1411, 1264, 
	1411, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1411, 1411, 1411, 1411, 1411, 
	1264, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1405, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1406, 1411, 1411, 1411, 1411, 
	1405, 1411, 1264, 1264, 1264, 1264, 1264, 1264, 
	1413, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1411, 1411, 1411, 1411, 
	1264, 1411, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1411, 1411, 1411, 1411, 
	1411, 1264, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1405, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1406, 1411, 1411, 1411, 
	1411, 1405, 1411, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1414, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1411, 1411, 1411, 
	1411, 1264, 1411, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1411, 1411, 1411, 
	1411, 1411, 1264, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1405, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1406, 1411, 1411, 
	1411, 1411, 1405, 1411, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1415, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1411, 1411, 
	1411, 1411, 1264, 1411, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1411, 1411, 
	1411, 1411, 1411, 1264, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1405, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1406, 1411, 
	1411, 1411, 1411, 1405, 1411, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1416, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1411, 
	1411, 1411, 1411, 1264, 1411, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1411, 
	1411, 1411, 1411, 1411, 1264, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1405, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1406, 
	1411, 1411, 1411, 1411, 1405, 1411, 1264, 1264, 
	1264, 1415, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1411, 1411, 1411, 1411, 1264, 1411, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1411, 1411, 1411, 1411, 1411, 1264, 1417, 1419, 
	1418, 1420, 1421, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1423, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 1405, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 313, 313, 
	313, 313, 313, 1405, 313, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 313, 
	313, 313, 313, 1277, 313, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 313, 
	313, 313, 313, 313, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1424, 1425, 1277, 1277, 1277, 1277, 
	1277, 1426, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1427, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1428, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1429, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1430, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1431, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1432, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1433, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1434, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1435, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1436, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1437, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1438, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1439, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1440, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1441, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1437, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1442, 1277, 1443, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1444, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1445, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1446, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1447, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1448, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1449, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1450, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1451, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1447, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1452, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1453, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1454, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1455, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1456, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1457, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1447, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1458, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1459, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1460, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1461, 327, 328, 327, 327, 327, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	327, 1405, 1461, 329, 1461, 1461, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1461, 1461, 330, 1461, 1461, 1405, 
	1461, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1461, 331, 1461, 1461, 1277, 
	1461, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1461, 1461, 1461, 1461, 1461, 
	1277, 344, 345, 344, 344, 344, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	344, 343, 343, 346, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 349, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 348, 343, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1463, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1464, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1465, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1405, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1466, 1466, 1466, 1466, 1466, 1405, 
	1466, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1466, 1466, 1466, 1466, 1277, 
	1466, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1467, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1466, 1466, 1466, 1466, 1466, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1468, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1469, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1470, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1471, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1472, 1277, 1473, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1474, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1447, 1277, 1277, 1277, 
	1475, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1447, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1440, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1476, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1477, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1457, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1478, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1281, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1479, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1480, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1440, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1447, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1481, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1447, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1482, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1483, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1484, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1457, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1485, 1277, 1277, 1277, 1486, 
	1277, 1277, 1277, 1277, 1277, 1487, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1488, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1454, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1440, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1489, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1490, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1491, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1492, 
	1493, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1440, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1494, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1495, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1481, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1496, 1277, 1277, 1497, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1440, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1498, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1454, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1499, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1500, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1501, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1440, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1502, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1503, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1489, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1504, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1505, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1451, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1480, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1506, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1507, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1508, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1509, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1510, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1446, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1511, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1512, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1481, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1513, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1481, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1277, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1514, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1277, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1277, 
	1422, 1277, 1277, 1277, 1277, 1451, 1277, 1277, 
	1277, 1515, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1277, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1422, 1422, 1422, 1422, 1422, 
	1405, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1277, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1516, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1277, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1422, 1422, 1422, 1422, 
	1422, 1405, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1277, 1422, 1277, 1277, 1277, 1277, 1481, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1277, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1422, 1422, 1422, 
	1422, 1422, 1405, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1277, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1517, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1277, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1422, 1422, 
	1422, 1422, 1422, 1405, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1277, 1422, 1277, 1277, 1277, 
	1277, 1518, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1277, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1405, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1422, 
	1422, 1422, 1422, 1422, 1405, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1277, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1519, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1277, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1405, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1422, 1422, 1422, 1422, 1422, 1405, 1422, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1277, 1422, 1277, 
	1277, 1277, 1489, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1422, 1422, 1422, 1422, 1422, 1277, 1520, 
	1304, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1247, 
	1294, 1521, 1523, 1522, 1523, 1523, 1523, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1523, 1522, 1522, 1524, 1522, 1522, 1525, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 357, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1526, 1522, 353, 
	354, 353, 353, 353, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 353, 1527, 
	1527, 355, 1527, 1527, 356, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 357, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 358, 1527, 360, 1528, 360, 360, 
	360, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 360, 1528, 1528, 355, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 358, 
	1528, 1530, 1529, 1532, 1531, 363, 362, 368, 
	1527, 366, 1527, 1534, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1535, 1533, 
	1534, 1533, 1534, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1537, 1533, 1534, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1538, 1533, 1534, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1539, 
	1533, 1541, 1539, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	186, 2, 3, 4, 192, 6, 7, 8, 
	9, 10, 186, 186, 195, 195, 12, 198, 
	199, 200, 14, 195, 207, 208, 211, 212, 
	224, 221, 213, 214, 215, 19, 216, 217, 
	218, 226, 228, 229, 233, 234, 235, 230, 
	25, 18, 209, 210, 27, 258, 259, 261, 
	261, 30, 263, 264, 265, 32, 261, 272, 
	273, 276, 277, 289, 286, 278, 279, 280, 
	37, 281, 282, 283, 291, 293, 294, 298, 
	299, 300, 295, 43, 36, 274, 275, 45, 
	323, 324, 331, 331, 48, 333, 334, 335, 
	50, 337, 337, 52, 340, 341, 342, 54, 
	347, 0, 56, 348, 349, 350, 58, 351, 
	352, 352, 352, 352, 465, 465, 63, 465, 
	62, 64, 494, 498, 498, 494, 68, 67, 
	494, 70, 71, 496, 497, 499, 500, 498, 
	494, 501, 502, 504, 65, 66, 505, 67, 
	506, 69, 498, 72, 73, 78, 85, 508, 
	509, 71, 496, 497, 499, 500, 498, 494, 
	501, 502, 504, 65, 66, 505, 506, 69, 
	72, 73, 78, 85, 508, 509, 507, 74, 
	75, 76, 77, 79, 80, 83, 81, 82, 
	84, 86, 87, 494, 89, 90, 91, 93, 
	96, 94, 95, 97, 99, 525, 100, 527, 
	528, 102, 529, 525, 525, 103, 100, 527, 
	528, 102, 529, 563, 105, 106, 107, 108, 
	566, 563, 563, 563, 563, 111, 112, 113, 
	563, 116, 111, 112, 113, 563, 116, 114, 
	114, 112, 113, 576, 115, 114, 114, 112, 
	113, 576, 115, 112, 563, 563, 118, 584, 
	585, 591, 608, 610, 126, 127, 128, 563, 
	122, 123, 124, 609, 124, 609, 125, 127, 
	611, 129, 563, 625, 626, 629, 630, 642, 
	639, 631, 632, 633, 134, 634, 635, 636, 
	644, 646, 647, 651, 652, 653, 648, 140, 
	133, 627, 628, 142, 689, 690, 563, 693, 
	145, 144, 695, 147, 148, 692, 563, 150, 
	563, 151, 152, 150, 563, 151, 802, 154, 
	802, 153, 155, 810, 810, 810, 158, 829, 
	828, 810, 831, 833, 810, 163, 164, 165, 
	837, 810, 167, 168, 848, 818, 872, 171, 
	172, 173, 177, 178, 171, 172, 173, 177, 
	178, 174, 174, 172, 173, 175, 176, 174, 
	174, 172, 173, 175, 176, 921, 172, 810, 
	990, 179, 992, 181, 185, 993, 183, 990, 
	180, 990, 182, 992, 182, 992, 184, 992, 
	990, 186, 186, 187, 188, 189, 191, 193, 
	194, 186, 186, 186, 190, 186, 190, 186, 
	1, 186, 186, 186, 5, 195, 195, 196, 
	195, 197, 201, 195, 195, 11, 13, 195, 
	195, 195, 195, 202, 203, 204, 15, 21, 
	26, 236, 28, 195, 195, 195, 205, 206, 
	195, 16, 195, 195, 195, 17, 195, 195, 
	195, 20, 219, 195, 220, 222, 195, 223, 
	225, 227, 22, 195, 195, 23, 231, 195, 
	232, 24, 195, 237, 241, 238, 239, 240, 
	195, 195, 242, 243, 246, 248, 257, 244, 
	245, 195, 247, 249, 251, 250, 195, 252, 
	253, 254, 255, 256, 195, 195, 195, 260, 
	261, 261, 261, 262, 266, 261, 29, 31, 
	261, 261, 261, 261, 267, 268, 269, 33, 
	39, 44, 301, 46, 261, 261, 261, 270, 
	271, 261, 34, 261, 261, 261, 35, 261, 
	261, 261, 38, 284, 261, 285, 287, 261, 
	288, 290, 292, 40, 261, 261, 41, 296, 
	261, 297, 42, 261, 302, 306, 303, 304, 
	305, 261, 261, 307, 308, 311, 313, 322, 
	309, 310, 261, 312, 314, 316, 315, 261, 
	317, 318, 319, 320, 321, 261, 261, 261, 
	325, 326, 326, 327, 326, 328, 326, 326, 
	326, 329, 329, 329, 330, 329, 329, 329, 
	331, 331, 331, 332, 331, 47, 49, 331, 
	331, 331, 336, 336, 336, 337, 337, 338, 
	337, 339, 337, 337, 51, 53, 337, 337, 
	337, 343, 343, 344, 343, 343, 345, 346, 
	345, 55, 57, 347, 347, 347, 352, 352, 
	353, 354, 355, 356, 358, 361, 362, 363, 
	364, 352, 365, 366, 368, 370, 371, 372, 
	376, 378, 379, 380, 397, 402, 409, 414, 
	421, 428, 381, 431, 432, 436, 430, 440, 
	448, 452, 454, 459, 461, 464, 352, 352, 
	352, 352, 357, 352, 357, 352, 59, 359, 
	360, 352, 60, 352, 352, 367, 369, 352, 
	352, 352, 373, 374, 375, 371, 377, 352, 
	382, 383, 392, 395, 384, 385, 386, 387, 
	388, 389, 390, 391, 381, 393, 394, 396, 
	398, 401, 399, 400, 403, 406, 404, 405, 
	407, 408, 410, 412, 411, 413, 415, 416, 
	352, 417, 418, 419, 420, 352, 422, 425, 
	423, 424, 426, 427, 429, 433, 434, 435, 
	437, 439, 438, 441, 442, 443, 445, 444, 
	446, 447, 449, 450, 451, 453, 455, 456, 
	457, 458, 460, 462, 463, 465, 465, 466, 
	467, 469, 470, 471, 465, 465, 468, 465, 
	468, 465, 61, 472, 465, 473, 473, 474, 
	475, 476, 477, 473, 479, 480, 481, 482, 
	484, 486, 487, 490, 491, 492, 493, 473, 
	473, 473, 473, 478, 473, 478, 483, 473, 
	485, 473, 488, 473, 489, 473, 473, 494, 
	494, 495, 510, 511, 497, 513, 514, 501, 
	515, 516, 517, 518, 519, 521, 522, 523, 
	524, 494, 494, 494, 494, 494, 494, 498, 
	503, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 512, 494, 512, 494, 494, 494, 
	494, 520, 494, 88, 92, 98, 525, 526, 
	530, 525, 525, 101, 528, 531, 531, 532, 
	533, 535, 537, 538, 531, 531, 534, 531, 
	534, 531, 536, 531, 531, 531, 539, 539, 
	540, 541, 542, 544, 545, 547, 548, 553, 
	560, 539, 539, 539, 543, 539, 543, 539, 
	539, 546, 539, 539, 544, 549, 550, 551, 
	552, 554, 555, 558, 556, 557, 559, 561, 
	562, 563, 564, 565, 567, 568, 570, 571, 
	572, 573, 575, 577, 578, 581, 582, 607, 
	613, 614, 615, 692, 700, 701, 702, 703, 
	574, 705, 723, 728, 735, 740, 742, 748, 
	706, 751, 752, 756, 750, 760, 771, 775, 
	778, 786, 790, 793, 794, 563, 563, 104, 
	563, 563, 563, 563, 563, 569, 563, 569, 
	563, 563, 109, 563, 110, 563, 563, 574, 
	563, 579, 563, 580, 563, 563, 563, 583, 
	563, 117, 586, 587, 588, 563, 589, 119, 
	592, 593, 596, 120, 605, 606, 563, 563, 
	563, 590, 563, 594, 595, 585, 563, 594, 
	563, 594, 585, 597, 599, 563, 598, 563, 
	563, 600, 603, 604, 563, 601, 602, 563, 
	563, 563, 563, 121, 612, 563, 563, 563, 
	563, 616, 563, 563, 617, 619, 563, 618, 
	563, 618, 563, 620, 621, 622, 130, 136, 
	141, 654, 143, 563, 563, 563, 623, 624, 
	563, 131, 563, 563, 563, 132, 563, 563, 
	563, 135, 637, 563, 638, 640, 563, 641, 
	643, 645, 137, 563, 563, 138, 649, 563, 
	650, 139, 563, 655, 659, 656, 657, 658, 
	563, 563, 660, 661, 664, 675, 688, 662, 
	663, 563, 665, 666, 667, 669, 668, 563, 
	670, 671, 672, 673, 674, 676, 683, 677, 
	678, 679, 680, 681, 682, 684, 685, 686, 
	687, 563, 563, 563, 691, 563, 144, 694, 
	563, 563, 696, 698, 699, 563, 697, 563, 
	563, 563, 146, 149, 563, 704, 563, 150, 
	151, 707, 708, 718, 721, 709, 710, 711, 
	712, 713, 714, 715, 716, 717, 719, 720, 
	722, 724, 727, 725, 726, 729, 732, 730, 
	731, 733, 734, 736, 738, 737, 739, 741, 
	743, 745, 744, 746, 747, 749, 717, 753, 
	754, 755, 757, 759, 758, 761, 762, 763, 
	768, 764, 765, 766, 563, 693, 706, 144, 
	767, 698, 769, 770, 772, 773, 774, 776, 
	777, 779, 780, 781, 784, 782, 783, 785, 
	787, 788, 789, 791, 792, 563, 574, 795, 
	795, 796, 797, 798, 800, 795, 795, 795, 
	799, 795, 799, 795, 801, 795, 802, 802, 
	803, 804, 802, 805, 807, 808, 802, 802, 
	802, 806, 802, 806, 802, 809, 802, 810, 
	810, 811, 812, 813, 810, 814, 816, 819, 
	820, 821, 822, 823, 810, 824, 825, 830, 
	858, 862, 810, 863, 865, 867, 810, 868, 
	869, 873, 877, 879, 880, 882, 883, 902, 
	907, 914, 922, 929, 936, 884, 941, 942, 
	946, 940, 951, 961, 967, 970, 979, 983, 
	987, 988, 989, 819, 810, 810, 810, 810, 
	810, 815, 810, 815, 810, 156, 817, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	826, 810, 827, 810, 810, 157, 159, 810, 
	160, 839, 850, 853, 832, 854, 855, 840, 
	844, 846, 810, 832, 160, 834, 836, 161, 
	810, 834, 810, 835, 810, 810, 162, 838, 
	810, 810, 841, 843, 810, 841, 842, 844, 
	846, 843, 810, 845, 810, 810, 847, 849, 
	810, 166, 810, 810, 810, 851, 843, 844, 
	846, 851, 852, 810, 841, 843, 844, 846, 
	810, 841, 843, 844, 846, 810, 856, 843, 
	844, 846, 856, 857, 810, 160, 858, 832, 
	859, 844, 846, 860, 843, 160, 860, 832, 
	861, 864, 866, 810, 169, 870, 170, 810, 
	871, 810, 810, 810, 874, 875, 876, 869, 
	878, 810, 810, 881, 810, 810, 810, 885, 
	886, 895, 900, 887, 888, 889, 890, 891, 
	892, 893, 894, 884, 896, 897, 898, 899, 
	884, 901, 903, 906, 904, 905, 884, 884, 
	908, 911, 909, 910, 912, 913, 884, 915, 
	917, 916, 918, 919, 920, 810, 810, 923, 
	884, 924, 810, 925, 926, 927, 928, 870, 
	930, 933, 931, 932, 934, 935, 937, 938, 
	939, 884, 943, 944, 945, 947, 949, 950, 
	948, 884, 952, 953, 954, 957, 955, 956, 
	958, 959, 960, 962, 964, 963, 965, 966, 
	968, 969, 971, 972, 974, 977, 973, 975, 
	976, 978, 980, 981, 982, 984, 985, 986, 
	810, 810, 990, 991, 995, 996, 997, 990, 
	990, 990, 994, 990, 990, 999, 998, 1000, 
	998, 1001, 1002, 1003, 998, 998
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 5, 0, 0, 
	0, 0, 0, 6, 0, 7, 0, 8, 
	0, 0, 7, 0, 0, 0, 0, 8, 
	0, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 9, 
	10, 0, 0, 0, 0, 0, 11, 0, 
	7, 0, 8, 0, 0, 7, 0, 0, 
	0, 0, 8, 0, 7, 0, 8, 0, 
	7, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 12, 13, 0, 0, 0, 0, 
	0, 14, 15, 0, 0, 0, 0, 0, 
	16, 0, 0, 0, 0, 0, 0, 0, 
	17, 18, 19, 20, 21, 22, 0, 23, 
	0, 0, 24, 25, 26, 27, 0, 0, 
	28, 29, 30, 31, 32, 30, 33, 32, 
	34, 32, 30, 30, 31, 30, 35, 30, 
	30, 30, 36, 30, 30, 30, 30, 30, 
	30, 0, 37, 38, 0, 39, 38, 40, 
	38, 0, 0, 37, 0, 41, 0, 0, 
	0, 0, 0, 0, 0, 0, 26, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 42, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 0, 
	44, 0, 44, 45, 46, 29, 30, 30, 
	47, 30, 47, 48, 0, 0, 0, 0, 
	0, 49, 50, 51, 52, 0, 29, 0, 
	53, 0, 30, 54, 30, 55, 30, 56, 
	57, 58, 57, 59, 57, 0, 60, 61, 
	60, 62, 60, 63, 64, 65, 0, 0, 
	0, 0, 66, 66, 0, 0, 0, 67, 
	0, 0, 68, 69, 0, 29, 0, 68, 
	66, 0, 70, 0, 7, 0, 8, 0, 
	0, 7, 0, 0, 0, 0, 8, 0, 
	7, 0, 8, 0, 7, 7, 0, 0, 
	0, 0, 0, 0, 0, 0, 71, 72, 
	0, 0, 0, 0, 0, 72, 73, 0, 
	74, 0, 29, 30, 75, 30, 76, 0, 
	77, 0, 0, 78, 79, 80, 0, 7, 
	7, 81, 82, 82, 83, 0, 0, 0, 
	0, 84, 0, 0, 0, 0, 0, 0, 
	29, 0, 0, 0, 30, 54, 30, 30, 
	30, 56, 57, 58, 57, 57, 57, 0, 
	60, 61, 60, 60, 60, 85, 63, 86, 
	87, 0, 88, 0, 89, 89, 0, 90, 
	0, 91, 56, 92, 0, 93, 29, 94, 
	95, 98, 99, 0, 29, 0, 7, 0, 
	7, 100, 101, 102, 56, 103, 0, 104, 
	0, 105, 106, 107, 0, 108, 109, 0, 
	110, 7, 7, 111, 112, 0, 0, 113, 
	114, 115, 116, 117, 117, 117, 117, 117, 
	117, 117, 117, 118, 119, 120, 0, 0, 
	121, 0, 122, 123, 124, 0, 125, 126, 
	127, 0, 0, 128, 0, 0, 129, 0, 
	7, 0, 0, 130, 131, 0, 0, 132, 
	0, 29, 133, 0, 0, 0, 0, 0, 
	134, 135, 0, 0, 0, 0, 0, 0, 
	0, 136, 0, 0, 0, 0, 137, 0, 
	0, 0, 0, 0, 138, 139, 140, 0, 
	141, 142, 143, 7, 7, 144, 0, 0, 
	145, 146, 147, 148, 117, 117, 117, 117, 
	117, 117, 117, 117, 149, 150, 151, 0, 
	0, 152, 0, 153, 154, 155, 0, 156, 
	157, 158, 0, 0, 159, 0, 0, 160, 
	0, 7, 0, 0, 161, 162, 0, 0, 
	163, 0, 29, 164, 0, 0, 0, 0, 
	0, 165, 166, 0, 0, 0, 0, 0, 
	0, 0, 167, 0, 0, 0, 0, 168, 
	0, 0, 0, 0, 0, 169, 170, 171, 
	0, 172, 173, 0, 174, 0, 175, 176, 
	177, 178, 179, 180, 0, 181, 182, 183, 
	184, 185, 186, 7, 187, 0, 0, 188, 
	189, 190, 191, 192, 193, 194, 195, 0, 
	196, 7, 197, 198, 0, 0, 199, 200, 
	201, 202, 203, 0, 204, 205, 206, 0, 
	207, 0, 0, 208, 209, 210, 211, 212, 
	0, 29, 0, 0, 7, 7, 0, 0, 
	0, 213, 0, 0, 0, 0, 214, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 215, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 216, 217, 
	218, 219, 56, 220, 0, 221, 0, 0, 
	0, 222, 0, 223, 224, 0, 0, 225, 
	226, 227, 0, 0, 0, 228, 0, 229, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 228, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	230, 0, 0, 0, 0, 231, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 232, 233, 0, 
	0, 7, 7, 0, 234, 235, 56, 236, 
	0, 237, 0, 29, 238, 239, 240, 0, 
	29, 0, 0, 241, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 242, 
	243, 244, 245, 56, 246, 0, 0, 247, 
	0, 248, 0, 249, 0, 250, 251, 252, 
	253, 254, 29, 0, 26, 0, 0, 26, 
	0, 0, 0, 0, 0, 0, 7, 7, 
	7, 255, 256, 257, 258, 259, 260, 261, 
	0, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 56, 271, 0, 272, 273, 274, 
	275, 276, 277, 0, 0, 0, 278, 7, 
	7, 279, 280, 0, 281, 282, 283, 0, 
	0, 0, 0, 0, 284, 285, 56, 286, 
	0, 287, 29, 288, 289, 290, 291, 292, 
	0, 29, 0, 293, 0, 0, 0, 0, 
	0, 294, 295, 296, 56, 297, 0, 298, 
	299, 29, 300, 301, 302, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 303, 0, 8, 0, 0, 7, 304, 
	0, 0, 304, 304, 0, 0, 7, 305, 
	0, 305, 0, 305, 305, 305, 0, 0, 
	305, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 0, 0, 307, 308, 30, 
	309, 310, 311, 312, 313, 56, 314, 0, 
	315, 316, 0, 317, 0, 318, 319, 304, 
	320, 0, 321, 0, 322, 323, 324, 0, 
	325, 0, 0, 0, 0, 326, 0, 0, 
	0, 0, 0, 0, 0, 0, 327, 328, 
	329, 0, 330, 331, 0, 331, 332, 0, 
	333, 334, 334, 0, 0, 335, 0, 336, 
	337, 0, 0, 0, 338, 0, 0, 339, 
	340, 341, 342, 0, 0, 343, 344, 345, 
	346, 0, 347, 348, 0, 7, 349, 350, 
	351, 0, 352, 117, 117, 117, 117, 117, 
	117, 117, 117, 353, 354, 355, 0, 0, 
	356, 0, 357, 358, 359, 0, 360, 361, 
	362, 0, 0, 363, 0, 0, 364, 0, 
	7, 0, 0, 365, 366, 0, 0, 367, 
	0, 29, 368, 0, 0, 0, 0, 0, 
	369, 370, 0, 0, 0, 0, 0, 0, 
	0, 371, 0, 0, 0, 0, 0, 372, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 373, 374, 375, 0, 376, 377, 0, 
	378, 379, 0, 72, 0, 380, 0, 381, 
	382, 383, 0, 0, 384, 29, 385, 386, 
	386, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 72, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 387, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 388, 389, 390, 391, 392, 
	392, 388, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 306, 393, 394, 395, 
	396, 0, 29, 0, 0, 397, 398, 399, 
	56, 400, 0, 401, 29, 402, 403, 404, 
	0, 29, 405, 0, 7, 0, 406, 407, 
	408, 56, 409, 0, 410, 29, 411, 412, 
	413, 0, 29, 0, 414, 0, 7, 415, 
	0, 0, 0, 0, 416, 0, 0, 417, 
	417, 0, 418, 0, 0, 0, 419, 7, 
	420, 420, 420, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 421, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 422, 423, 424, 425, 426, 
	427, 56, 428, 0, 429, 0, 0, 430, 
	431, 432, 433, 434, 435, 436, 437, 438, 
	0, 439, 0, 440, 441, 0, 0, 442, 
	443, 444, 0, 0, 445, 0, 0, 444, 
	446, 446, 447, 448, 0, 449, 450, 0, 
	451, 452, 453, 0, 454, 455, 0, 0, 
	456, 457, 444, 444, 458, 0, 0, 459, 
	459, 0, 460, 0, 461, 462, 7, 0, 
	463, 0, 464, 465, 466, 467, 467, 468, 
	468, 0, 0, 469, 470, 470, 471, 471, 
	472, 473, 473, 474, 474, 475, 476, 476, 
	477, 477, 0, 0, 478, 479, 480, 481, 
	482, 483, 483, 480, 482, 484, 417, 485, 
	0, 0, 0, 486, 0, 487, 0, 488, 
	0, 489, 490, 491, 420, 420, 420, 492, 
	420, 493, 494, 29, 495, 496, 497, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 498, 0, 0, 0, 0, 
	492, 0, 0, 0, 0, 0, 499, 500, 
	0, 0, 0, 0, 0, 0, 501, 0, 
	0, 0, 0, 0, 500, 502, 503, 0, 
	504, 0, 505, 0, 0, 0, 0, 506, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 507, 0, 0, 0, 0, 0, 0, 
	0, 506, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	508, 509, 510, 511, 511, 89, 511, 512, 
	513, 514, 0, 515, 516, 0, 517, 0, 
	518, 0, 0, 0, 519, 520
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 96, 0, 96, 0, 0, 0, 0, 
	96, 96, 0, 0, 0, 0, 0, 96, 
	0, 96, 0, 96, 0, 0, 0, 0, 
	96, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 97, 0, 97, 0, 0, 0, 0, 
	97, 97, 0, 0, 0, 0, 0, 97, 
	0, 97, 0, 97, 0, 0, 0, 0, 
	97, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 48, 48, 48, 
	48, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 83, 
	83, 83, 83, 90, 90, 90, 90, 0, 
	0, 0, 0, 105, 107, 109, 109, 109, 
	109, 115, 115, 118, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 190, 196, 190, 190, 
	204, 204, 204, 204, 204, 210, 212, 212, 
	212, 212, 212, 212, 212, 237, 237, 237, 
	237, 237, 248, 212, 212, 248, 237, 237, 
	237, 212, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	212, 212, 237, 237, 237, 237, 295, 295, 
	295, 303, 303, 303, 308, 310, 310, 310, 
	314, 314, 317, 317, 317, 317, 322, 322, 
	322, 308, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 353, 360, 362, 362, 362, 
	362, 353, 0, 378, 379, 380, 382, 384, 
	386, 384, 384, 0, 396, 397, 401, 401, 
	402, 403, 412, 413, 414, 414, 414, 417, 
	417, 419, 420, 421, 421, 421, 423, 424, 
	425, 425, 425, 428, 428, 421, 431, 431, 
	421, 417, 417, 436, 437, 437, 437, 440, 
	440, 437, 437, 437, 443, 443, 443, 443, 
	449, 450, 450, 450, 450, 458, 450, 450, 
	450, 450, 463, 450, 450, 450, 450, 450, 
	450, 469, 470, 471, 471, 0, 478, 482, 
	482, 483, 484, 493, 494, 495, 495, 495, 
	498, 498, 500, 501, 502, 502, 502, 504, 
	505, 506, 506, 506, 509, 509, 502, 512, 
	512, 502, 498, 498, 517, 518, 518, 518, 
	521, 521, 518, 518, 518, 524, 524, 524, 
	524, 530, 531, 531, 531, 531, 539, 531, 
	531, 531, 531, 544, 531, 531, 531, 531, 
	531, 531, 550, 551, 552, 552, 0, 559, 
	560, 0, 566, 0, 573, 577, 577, 578, 
	0, 0, 587, 588, 592, 592, 593, 0, 
	598, 0, 601, 0, 604, 604, 605, 606, 
	0, 647, 648, 649, 650, 652, 654, 658, 
	658, 649, 649, 649, 649, 660, 649, 649, 
	654, 649, 649, 664, 666, 666, 666, 666, 
	666, 666, 654, 654, 672, 664, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	705, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	649, 0, 749, 750, 752, 754, 754, 754, 
	757, 0, 776, 777, 778, 779, 781, 778, 
	778, 778, 778, 778, 784, 778, 778, 786, 
	788, 790, 784, 784, 791, 778, 0, 810, 
	811, 118, 118, 814, 815, 118, 811, 811, 
	818, 820, 823, 811, 824, 811, 825, 826, 
	828, 830, 811, 818, 831, 831, 820, 831, 
	835, 831, 831, 831, 831, 0, 842, 843, 
	196, 842, 842, 0, 853, 854, 856, 858, 
	860, 858, 862, 0, 874, 875, 876, 878, 
	880, 881, 883, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 0, 942, 943, 945, 948, 
	949, 951, 953, 956, 958, 959, 212, 956, 
	961, 956, 948, 963, 965, 948, 948, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 987, 991, 993, 983, 998, 1000, 1001, 
	1005, 1008, 1009, 1010, 1011, 983, 983, 948, 
	1014, 1015, 1014, 1014, 948, 948, 948, 1016, 
	1023, 1023, 1025, 1027, 1036, 1037, 1038, 1038, 
	1038, 1041, 1041, 1043, 1044, 1045, 1045, 1045, 
	1047, 1048, 1049, 1049, 1049, 1052, 1052, 1045, 
	1055, 1055, 1045, 1041, 1041, 1060, 1061, 1061, 
	1061, 1064, 1064, 1061, 1061, 1061, 1067, 1067, 
	1067, 1067, 1073, 1074, 1074, 1074, 1074, 1082, 
	1074, 1074, 1074, 1074, 1088, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1074, 1074, 
	1106, 1107, 1108, 1108, 212, 1110, 1113, 1114, 
	1118, 1120, 1121, 1122, 948, 948, 1125, 948, 
	943, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 212, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1181, 1114, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1127, 1127, 1127, 1127, 1127, 1127, 1127, 
	1127, 1206, 948, 0, 1214, 1215, 1216, 1218, 
	1220, 1222, 0, 1231, 1232, 1233, 1235, 1237, 
	1237, 1239, 0, 1293, 1294, 1295, 1297, 1299, 
	1301, 1304, 1304, 314, 1306, 1308, 1309, 1310, 
	1306, 1312, 1314, 1314, 1317, 1317, 1320, 1331, 
	314, 1337, 1339, 1341, 1342, 1345, 1346, 1320, 
	1320, 1349, 1349, 1349, 1355, 1357, 1358, 1361, 
	1363, 1364, 1365, 1349, 1349, 1372, 1377, 1382, 
	1349, 1349, 1389, 1389, 1349, 1349, 1314, 1306, 
	1306, 1314, 1306, 1306, 1301, 314, 1408, 1410, 
	1411, 1412, 1412, 1412, 1412, 1412, 1412, 1418, 
	1301, 1421, 1422, 1423, 314, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1462, 1463, 1423, 1423, 1467, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1521, 1295, 1522, 0, 1528, 
	1529, 1530, 1532, 1528, 1528, 1528, 0, 1537, 
	1537, 1537, 1537, 1541
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 186;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 195;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 261;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 326;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 329;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 331;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 336;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 337;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 343;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 345;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 347;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 352;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 465;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 473;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 494;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 525;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 531;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 539;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 563;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 795;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 802;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 810;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 990;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 998;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 186;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :context, :command_start

  attr_accessor :tokens, :comments

  attr_reader :paren_nest, :cmdarg_stack, :cond_stack, :lambda_stack, :version

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 11327 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 97 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 11355 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 29 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 117 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 30 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 56 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 60 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 377 then
# line 1286 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 37 then
# line 1579 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 39 then
# line 1599 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 41 then
# line 1627 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 68 then
# line 1819 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 331 then
# line 1911 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 334 then
# line 1912 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 350 then
# line 1932 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 392 then
# line 2021 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 386 then
# line 2128 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 476 then
# line 2314 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 470 then
# line 2315 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 473 then
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 467 then
# line 2317 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 482 then
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 444 then
# line 2319 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 459 then
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 452 then
# line 2377 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 449 then
# line 2378 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 89 then
# line 2588 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 113 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 108 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 109 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 115 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 114 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 111 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 112 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 911 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 887 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 145 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 141 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 142 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 147 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 146 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 144 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 911 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 887 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 172 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 173 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 176 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 178 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 179 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 181 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 188 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 184 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 185 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 190 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 189 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 187 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 887 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 191 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 192 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 199 then
# line 1119 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 194 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 195 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 201 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 200 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 197 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 198 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 887 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 202 then
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 203 then
# line 887 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 205 then
# line 1032 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 206 then
# line 1216 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 207 then
# line 1203 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 810;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1355 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 208 then
# line 1355 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 210 then
# line 1368 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 209 then
# line 1378 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 231 then
# line 1399 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 226 then
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 810; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 213 then
# line 1420 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 224 then
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1430 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
       end
		end
	when 212 then
# line 1443 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 211 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 230 then
# line 1399 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 229 then
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 222 then
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 810; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 218 then
# line 1420 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 223 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 216 then
# line 1440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 221 then
# line 1443 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1420 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1443 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 225 then
# line 1 "NONE"
		begin
	case  @act
	when 43 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 44 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 45 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 23 then
# line 1455 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 795; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 22 then
# line 1459 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 31 && @context.in_argdef
          emit(:tBDOT3, '...'.freeze)
          # emit(:tNL, "\n".freeze, @te - 1, @te)
           @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 3;
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
       end
		end
	when 233 then
# line 1473 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 232 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 234 then
# line 1470 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 237 then
# line 1473 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1473 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 241 then
# line 1499 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 240 then
# line 1505 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 239 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 248 then
# line 1484 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 251 then
# line 1488 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 244 then
# line 1499 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 242 then
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 247 then
# line 1505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 274 then
# line 1565 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 257 then
# line 1583 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

       end
		end
	when 263 then
# line 1611 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 28 then
# line 1619 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 265 then
# line 1628 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 40 then
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 253 then
# line 1653 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 252 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 264 then
# line 1574 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 260 then
# line 1600 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

       end
		end
	when 262 then
# line 1616 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 256 then
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 255 then
# line 1644 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 273 then
# line 1653 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1644 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 42 then
# line 1653 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 27 then
# line 1 "NONE"
		begin
	case  @act
	when 72 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

      end
	when 78 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 46 then
# line 1689 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 278 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 279 then
# line 1689 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 43 then
# line 1689 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 45 then
# line 1 "NONE"
		begin
	case  @act
	when 85 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 86 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
 end
end 
			end
	when 289 then
# line 1725 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 283 then
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 282 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 284 then
# line 1728 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 287 then
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 292 then
# line 1755 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 291 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 301 then
# line 1747 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 294 then
# line 1749 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 299 then
# line 1755 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 298 then
# line 1 "NONE"
		begin
	case  @act
	when 93 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 94 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
 end
end 
			end
	when 53 then
# line 1770 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 324 then
# line 1787 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 316 then
# line 1794 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 50 then
# line 1801 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 329 then
# line 1876 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 352
		_goto_level = _again
		next
	end

       end
		end
	when 325 then
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 328 then
# line 1892 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 65 then
# line 1906 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 347 then
# line 1947 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 346 then
# line 1957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 326 then
# line 2016 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 71 then
# line 2037 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 810;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 795;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 74 then
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 465;
        else
           @cs = 525;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 310 then
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 52 then
# line 2165 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 303 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 320 then
# line 1770 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 319 then
# line 1777 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 315 then
# line 1807 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 343 then
# line 1867 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 327 then
# line 1906 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 332 then
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 345 then
# line 1957 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 351 then
# line 1963 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 317 then
# line 2016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 321 then
# line 2064 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 322 then
# line 2075 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 385 then
# line 1340 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 307 then
# line 2146 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 309 then
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 312 then
# line 2165 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 49 then
# line 1807 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 67 then
# line 1867 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 70 then
# line 1934 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 73 then
# line 1340 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 48 then
# line 2146 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 64 then
# line 2165 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 51 then
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
end 
			end
	when 396 then
# line 2185 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 395 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 397 then
# line 2173 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 2185 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 77 then
# line 2195 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 405 then
# line 2200 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 404 then
# line 2210 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 403 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 406 then
# line 2204 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 410 then
# line 2210 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 76 then
# line 2210 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 437 then
# line 2221 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 86 then
# line 2262 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 414 then
# line 2398 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 79 then
# line 2416 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 433 then
# line 2423 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 473; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 486 then
# line 2447 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 426 then
# line 2456 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 431 then
# line 2491 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 419 then
# line 2495 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 416 then
# line 2514 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 418 then
# line 2527 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 494 then
# line 2531 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 413 then
# line 2537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 412 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 505 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 503 then
# line 2262 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 502 then
# line 2273 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 441 then
# line 2348 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 491 then
# line 2408 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 430 then
# line 2416 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 438 then
# line 2423 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 473; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 497 then
# line 1340 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 436 then
# line 2447 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 432 then
# line 2456 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 425 then
# line 2462 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 439 then
# line 2514 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 423 then
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 429 then
# line 2537 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 84 then
# line 2321 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 80 then
# line 2348 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 83 then
# line 2380 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 78 then
# line 2537 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 81 then
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 516 then
# line 2578 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT3)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 95 then
# line 2589 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 510 then
# line 2592 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 513 then
# line 2553 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 515 then
# line 2567 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT2)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 514 then
# line 2589 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 512 then
# line 2592 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 90 then
# line 2553 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 87 then
# line 2592 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 91 then
# line 1 "NONE"
		begin
	case  @act
	when 181 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 185 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 519 then
# line 2602 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 518 then
# line 2610 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 106 then
# line 2620 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2624 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 99 then
# line 2627 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 98 then
# line 537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 100 then
# line 2617 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 105 then
# line 2620 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 104 then
# line 2627 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2627 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 63 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 110 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 143 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 186 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 193 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 196 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 204 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 275 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1565 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 266 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1628 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 258 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 348 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1947 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 323 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2075 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 311 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 440 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2503 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 520 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2602 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 517 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2607 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 107 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2620 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2624 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 462 then
# line 645 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 646 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 465 then
# line 647 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 463 then
# line 648 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 461 then
# line 649 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 464 then
# line 650 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 453 then
# line 654 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 454 then
# line 655 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 455 then
# line 659 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 457 then
# line 660 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 456 then
# line 661 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 137 then
# line 676 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 168 then
# line 676 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 372 then
# line 676 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 354 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 728 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 728 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 356 then
# line 728 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 358 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 764 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 764 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 355 then
# line 764 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 140 then
# line 768 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 171 then
# line 768 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 375 then
# line 768 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 139 then
# line 772 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 170 then
# line 772 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 374 then
# line 772 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 134 then
# line 778 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 165 then
# line 778 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 369 then
# line 778 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 133 then
# line 782 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 164 then
# line 782 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 368 then
# line 782 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 138 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 169 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 373 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 135 then
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 166 then
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 370 then
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 353 then
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 177 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 182 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 54 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 31 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1579 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 33 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1599 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 35 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1627 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 217 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 238 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1470 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 34 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 277 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1644 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 269 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1650 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 288 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1728 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 300 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1749 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 295 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1752 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 55 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1770 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 75 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 465;
        else
           @cs = 525;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 308 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2146 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 402 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2173 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 398 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2176 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @context.in_kwarg
        p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

      end
     end
		end
	when 411 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2204 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 407 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2207 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 186
		_goto_level = _again
		next
	end
  end
		end
	when 495 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 424 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2524 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 990
		_goto_level = _again
		next
	end
  end
		end
	when 101 then
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2617 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 268 then
# line 1084 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1546 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 290 then
# line 1084 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 393 then
# line 1084 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1992 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 508 then
# line 1084 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2229 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 509 then
# line 1093 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end

    @paren_nest -= 1
  		end
# line 2466 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 57 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 61 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 220 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 236 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1470 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 246 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 271 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1647 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1728 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 297 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1749 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 314 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2146 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 400 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2173 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 409 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2204 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 428 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 103 then
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2617 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 249 then
# line 1286 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1492 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 335 then
# line 1286 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 376 then
# line 1286 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 488 then
# line 1286 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 250 then
# line 1287 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1492 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 336 then
# line 1287 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 378 then
# line 1287 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 489 then
# line 1287 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2430 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 337 then
# line 1292 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 379 then
# line 1292 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 338 then
# line 1293 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 380 then
# line 1293 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 342 then
# line 1294 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 383 then
# line 1294 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 341 then
# line 1295 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 382 then
# line 1295 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
end 
			end
	when 339 then
# line 1296 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 381 then
# line 1296 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 340 then
# line 1301 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 490 then
# line 1306 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2412 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 267 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1540 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 384 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2006 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 493 then
# line 1312 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2499 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 496 then
# line 1318 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2466 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 259 then
# line 1325 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 272 then
# line 1325 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1534 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 280 then
# line 1325 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1666 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 318 then
# line 1325 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2011 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 434 then
# line 1325 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2462 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 435 then
# line 1335 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2466 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 69 then
# line 1819 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 344 then
# line 1820 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 330 then
# line 1911 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 333 then
# line 1912 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 349 then
# line 1932 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 389 then
# line 2021 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2022 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 477 then
# line 2314 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 471 then
# line 2315 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 474 then
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 468 then
# line 2317 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 483 then
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 446 then
# line 2319 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 484 then
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 450 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2378 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 228 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1399 "lib/parser/lexer.rl"
		begin
 @act = 43;		end
	when 214 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1403 "lib/parser/lexer.rl"
		begin
 @act = 44;		end
	when 215 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1407 "lib/parser/lexer.rl"
		begin
 @act = 45;		end
	when 25 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1583 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 261 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1600 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 254 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1644 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 281 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1676 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 44 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1689 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 302 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1743 "lib/parser/lexer.rl"
		begin
 @act = 93;		end
	when 293 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1747 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 66 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1867 "lib/parser/lexer.rl"
		begin
 @act = 106;		end
	when 394 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1975 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 304 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2016 "lib/parser/lexer.rl"
		begin
 @act = 121;		end
	when 388 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2022 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 387 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2028 "lib/parser/lexer.rl"
		begin
 @act = 123;		end
	when 72 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 306 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1340 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 305 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2165 "lib/parser/lexer.rl"
		begin
 @act = 132;		end
	when 504 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2229 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 499 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 507 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2268 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 500 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2273 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 501 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2278 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 506 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2282 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 498 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2293 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 492 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2307 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 417 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 448 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2365 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 82 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @act = 158;		end
	when 420 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2408 "lib/parser/lexer.rl"
		begin
 @act = 160;		end
	when 421 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1340 "lib/parser/lexer.rl"
		begin
 @act = 164;		end
	when 487 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2430 "lib/parser/lexer.rl"
		begin
 @act = 165;		end
	when 415 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2456 "lib/parser/lexer.rl"
		begin
 @act = 167;		end
	when 422 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2462 "lib/parser/lexer.rl"
		begin
 @act = 168;		end
	when 88 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2553 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 511 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2592 "lib/parser/lexer.rl"
		begin
 @act = 185;		end
	when 183 then
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 970 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 124 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 359 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 131 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 162 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 366 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 357 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 130 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 161 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 365 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 157 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 361 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 160 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 364 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 136 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 167 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 371 then
# line 790 "lib/parser/lexer.rl"
		begin

        if emit_invalid_escapes?
          diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
        end
      		end
# line 806 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 352 then
# line 838 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 832 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 58 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 219 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 235 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1470 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 245 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 270 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1647 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 285 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1728 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 296 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1749 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 313 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2146 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 399 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2173 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 408 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2204 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 427 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 102 then
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2617 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 479 then
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 443 then
# line 2319 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 458 then
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 451 then
# line 2377 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 653 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 447 then
# line 2378 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 653 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 276 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 510 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1644 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 36 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 47 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1689 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 94 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2553 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1770 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 85 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2262 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 93 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2553 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 38 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1599 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1600 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 390 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2021 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 391 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2021 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1340 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 480 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 127 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 158 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 362 then
# line 716 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 360 then
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 132 then
# line 750 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 163 then
# line 750 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 367 then
# line 750 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 911 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 363 then
# line 757 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 740 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 744 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1934 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 475 then
# line 2314 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 469 then
# line 2315 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 472 then
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 466 then
# line 2317 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 478 then
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 442 then
# line 2319 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2321 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 32 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 878 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1599 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1600 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 59 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1770 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 92 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1242 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1245 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2553 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 485 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2353 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 481 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2353 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 445 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2319 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2320 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 644 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2353 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
# line 24787 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 96 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 24797 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 283 "lib/parser/lexer.rl"
    # %

    # Ragel creates a local variable called `testEof` but it doesn't use
    # it in any assignment. This dead code is here to swallow the warning.
    # It has no runtime cost because Ruby doesn't produce any instructions from it.
    if false
      testEof
    end

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  def emit_invalid_escapes?
    # always true for old Rubies
    return true if @version < 32

    # in "?\u123" case we don't push any literals
    # but we always emit invalid escapes
    return true if literal.nil?

    # Ruby >= 32, regexp, exceptional case
    !literal.regexp?
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2632 "lib/parser/lexer.rl"

  # %
end
