/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import org.apache.catalina.TomcatPrincipal;
import org.ietf.jgss.GSSCredential;

public class GenericPrincipal
implements TomcatPrincipal,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final String[] roles;
    protected final Principal userPrincipal;
    protected final transient LoginContext loginContext;
    protected transient GSSCredential gssCredential = null;
    protected final Map<String, Object> attributes;

    public GenericPrincipal(String string) {
        this(string, null);
    }

    public GenericPrincipal(String string, List<String> list) {
        this(string, list, null);
    }

    @Deprecated
    public GenericPrincipal(String string, String string2, List<String> list) {
        this(string, list, null);
    }

    public GenericPrincipal(String string, List<String> list, Principal principal) {
        this(string, list, principal, null);
    }

    @Deprecated
    public GenericPrincipal(String string, String string2, List<String> list, Principal principal) {
        this(string, list, principal, null);
    }

    public GenericPrincipal(String string, List<String> list, Principal principal, LoginContext loginContext) {
        this(string, list, principal, loginContext, null, null);
    }

    @Deprecated
    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext) {
        this(string, list, principal, loginContext, null, null);
    }

    public GenericPrincipal(String string, List<String> list, Principal principal, LoginContext loginContext, GSSCredential gSSCredential, Map<String, Object> map) {
        this.name = string;
        this.userPrincipal = principal;
        if (list == null) {
            this.roles = new String[0];
        } else {
            this.roles = list.toArray(new String[0]);
            if (this.roles.length > 1) {
                Arrays.sort(this.roles);
            }
        }
        this.loginContext = loginContext;
        this.gssCredential = gSSCredential;
        this.attributes = map != null ? Collections.unmodifiableMap(map) : null;
    }

    @Deprecated
    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext, GSSCredential gSSCredential) {
        this(string, list, principal, loginContext, gSSCredential, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return (String[])this.roles.clone();
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this;
    }

    @Override
    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    protected void setGssCredential(GSSCredential gSSCredential) {
        this.gssCredential = gSSCredential;
    }

    public boolean hasRole(String string) {
        if ("*".equals(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, string) >= 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GenericPrincipal[");
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        for (String string : this.roles) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(")]");
        return stringBuilder.toString();
    }

    @Override
    public void logout() throws Exception {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
        if (this.gssCredential != null) {
            this.gssCredential.dispose();
        }
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null || string == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    private Object writeReplace() {
        return new SerializablePrincipal(this.name, this.roles, this.userPrincipal, this.attributes);
    }

    private static class SerializablePrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String[] roles;
        private final Principal principal;
        private final Map<String, Object> attributes;

        SerializablePrincipal(String string, String[] stringArray, Principal principal, Map<String, Object> map) {
            this.name = string;
            this.roles = stringArray;
            this.principal = principal instanceof Serializable ? principal : null;
            this.attributes = map;
        }

        private Object readResolve() {
            return new GenericPrincipal(this.name, Arrays.asList(this.roles), this.principal, null, null, this.attributes);
        }
    }
}

