/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.security.SecurityClassLoad;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.CatalinaBaseConfigurationSource;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class Tomcat {
    private static final StringManager sm = StringManager.getManager(Tomcat.class);
    private final Map<String, Logger> pinnedLoggers = new HashMap<String, Logger>();
    protected Server server;
    protected int port = 8080;
    protected String hostname = "localhost";
    protected String basedir;
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();
    private boolean addDefaultWebXmlToWebapp = true;
    static final String[] silences = new String[]{"org.apache.coyote.http11.Http11NioProtocol", "org.apache.catalina.core.StandardService", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.core.ApplicationContext", "org.apache.catalina.core.AprLifecycleListener"};
    private boolean silent = false;

    public Tomcat() {
        ExceptionUtils.preload();
    }

    public void setBaseDir(String string) {
        this.basedir = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public Context addWebapp(String string, String string2) {
        return this.addWebapp(this.getHost(), string, string2);
    }

    public Context addWebapp(String string, URL uRL) throws IOException {
        ContextName contextName = new ContextName(string, null);
        Host host = this.getHost();
        if (host.findChild(contextName.getName()) != null) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictChild", new Object[]{uRL, string, contextName.getName()}));
        }
        File file = new File(host.getAppBaseFile(), contextName.getBaseName() + ".war");
        File file2 = new File(host.getAppBaseFile(), contextName.getBaseName());
        if (file.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{uRL, string, file.getAbsolutePath()}));
        }
        if (file2.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{uRL, string, file2.getAbsolutePath()}));
        }
        URLConnection uRLConnection = uRL.openConnection();
        try (InputStream inputStream = uRLConnection.getInputStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOTools.flow(inputStream, fileOutputStream);
        }
        return this.addWebapp(string, file.getAbsolutePath());
    }

    public Context addContext(String string, String string2) {
        return this.addContext(this.getHost(), string, string2);
    }

    public Wrapper addServlet(String string, String string2, String string3) {
        Container container = this.getHost().findChild(string);
        return Tomcat.addServlet((Context)container, string2, string3);
    }

    public static Wrapper addServlet(Context context, String string, String string2) {
        Wrapper wrapper = context.createWrapper();
        if (wrapper == null) {
            return null;
        }
        wrapper.setServletClass(string2);
        wrapper.setName(string);
        context.addChild(wrapper);
        return wrapper;
    }

    public Wrapper addServlet(String string, String string2, Servlet servlet) {
        Container container = this.getHost().findChild(string);
        return Tomcat.addServlet((Context)container, string2, servlet);
    }

    public static Wrapper addServlet(Context context, String string, Servlet servlet) {
        ExistingStandardWrapper existingStandardWrapper = new ExistingStandardWrapper(servlet);
        existingStandardWrapper.setName(string);
        context.addChild(existingStandardWrapper);
        return existingStandardWrapper;
    }

    public void init(ConfigurationSource configurationSource) {
        this.init(configurationSource, null);
    }

    public void init(ConfigurationSource configurationSource, String[] stringArray) {
        ConfigFileLoader.setSource((ConfigurationSource)configurationSource);
        this.addDefaultWebXmlToWebapp = false;
        Catalina catalina = new Catalina();
        if (stringArray == null) {
            catalina.load();
        } else {
            catalina.load(stringArray);
        }
        this.server = catalina.getServer();
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.server.init();
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        this.getServer();
        this.server.stop();
    }

    public void destroy() throws LifecycleException {
        this.getServer();
        this.server.destroy();
    }

    public void addUser(String string, String string2) {
        this.userPass.put(string, string2);
    }

    public void addRole(String string2, String string3) {
        this.userRoles.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
    }

    public Connector getConnector() {
        Service service = this.getService();
        if (service.findConnectors().length > 0) {
            return service.findConnectors()[0];
        }
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(this.port);
        service.addConnector(connector);
        return connector;
    }

    public void setConnector(Connector connector) {
        Service service = this.getService();
        boolean bl = false;
        for (Connector connector2 : service.findConnectors()) {
            if (connector != connector2) continue;
            bl = true;
            break;
        }
        if (!bl) {
            service.addConnector(connector);
        }
    }

    public Service getService() {
        return this.getServer().findServices()[0];
    }

    public void setHost(Host host) {
        Engine engine = this.getEngine();
        boolean bl = false;
        for (Container container : engine.findChildren()) {
            if (container != host) continue;
            bl = true;
            break;
        }
        if (!bl) {
            engine.addChild(host);
        }
    }

    public Host getHost() {
        Engine engine = this.getEngine();
        if (engine.findChildren().length > 0) {
            return (Host)engine.findChildren()[0];
        }
        StandardHost standardHost = new StandardHost();
        standardHost.setName(this.hostname);
        this.getEngine().addChild(standardHost);
        return standardHost;
    }

    public Engine getEngine() {
        Service service = this.getServer().findServices()[0];
        if (service.getContainer() != null) {
            return service.getContainer();
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setName("Tomcat");
        standardEngine.setDefaultHost(this.hostname);
        standardEngine.setRealm(this.createDefaultRealm());
        service.setContainer(standardEngine);
        return standardEngine;
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        System.setProperty("catalina.useNaming", "false");
        this.server = new StandardServer();
        this.initBaseDir();
        ConfigFileLoader.setSource((ConfigurationSource)new CatalinaBaseConfigurationSource(new File(this.basedir), null));
        this.server.setPort(-1);
        StandardService standardService = new StandardService();
        standardService.setName("Tomcat");
        this.server.addService(standardService);
        return this.server;
    }

    public Context addContext(Host host, String string, String string2) {
        return this.addContext(host, string, string, string2);
    }

    public Context addContext(Host host, String string, String string2, String string3) {
        this.silence(host, string2);
        Context context = this.createContext(host, string);
        context.setName(string2);
        context.setPath(string);
        context.setDocBase(string3);
        context.addLifecycleListener(new FixContextListener());
        if (host == null) {
            this.getHost().addChild(context);
        } else {
            host.addChild(context);
        }
        return context;
    }

    public Context addWebapp(Host host, String string, String string2) {
        LifecycleListener lifecycleListener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            lifecycleListener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException);
        }
        return this.addWebapp(host, string, string2, lifecycleListener);
    }

    public Context addWebapp(Host host, String string, String string2, LifecycleListener lifecycleListener) {
        this.silence(host, string);
        Context context = this.createContext(host, string);
        context.setPath(string);
        context.setDocBase(string2);
        if (this.addDefaultWebXmlToWebapp) {
            context.addLifecycleListener(this.getDefaultWebXmlListener());
        }
        context.setConfigFile(this.getWebappConfigFile(string2, string));
        context.addLifecycleListener(lifecycleListener);
        if (this.addDefaultWebXmlToWebapp && lifecycleListener instanceof ContextConfig) {
            ((ContextConfig)lifecycleListener).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild(context);
        } else {
            host.addChild(context);
        }
        return context;
    }

    public LifecycleListener getDefaultWebXmlListener() {
        return new DefaultWebXmlListener();
    }

    public String noDefaultWebXmlPath() {
        return "org/apache/catalina/startup/NO_DEFAULT_XML";
    }

    protected Realm createDefaultRealm() {
        return new SimpleRealm();
    }

    protected void initBaseDir() {
        File file;
        String string = System.getProperty("catalina.home");
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.base");
        }
        if (this.basedir == null) {
            this.basedir = string;
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir") + "/tomcat." + this.port;
        }
        if ((file = new File(this.basedir)).exists()) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException(sm.getString("tomcat.baseDirNotDir", new Object[]{file}));
            }
        } else if (!file.mkdirs()) {
            throw new IllegalStateException(sm.getString("tomcat.baseDirMakeFail", new Object[]{file}));
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        this.server.setCatalinaBase(file);
        System.setProperty("catalina.base", file.getPath());
        this.basedir = file.getPath();
        if (string == null) {
            this.server.setCatalinaHome(file);
        } else {
            File file2 = new File(string);
            if (!file2.isDirectory() && !file2.mkdirs()) {
                throw new IllegalStateException(sm.getString("tomcat.homeDirMakeFail", new Object[]{file2}));
            }
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file2.getAbsoluteFile();
            }
            this.server.setCatalinaHome(file2);
        }
        System.setProperty("catalina.home", this.server.getCatalinaHome().getPath());
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
        for (String string : silences) {
            Logger logger = Logger.getLogger(string);
            this.pinnedLoggers.put(string, logger);
            if (bl) {
                logger.setLevel(Level.WARNING);
                continue;
            }
            logger.setLevel(Level.INFO);
        }
    }

    private void silence(Host host, String string) {
        String string2 = this.getLoggerName(host, string);
        Logger logger = Logger.getLogger(string2);
        this.pinnedLoggers.put(string2, logger);
        if (this.silent) {
            logger.setLevel(Level.WARNING);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public void setAddDefaultWebXmlToWebapp(boolean bl) {
        this.addDefaultWebXmlToWebapp = bl;
    }

    private String getLoggerName(Host host, String string) {
        if (host == null) {
            host = this.getHost();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ContainerBase.class.getName());
        stringBuilder.append(".[");
        stringBuilder.append(host.getParent().getName());
        stringBuilder.append("].[");
        stringBuilder.append(host.getName());
        stringBuilder.append("].[");
        if (string == null || string.equals("")) {
            stringBuilder.append('/');
        } else if (string.startsWith("##")) {
            stringBuilder.append('/');
            stringBuilder.append(string);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Context createContext(Host host, String string) {
        String string2 = StandardContext.class.getName();
        String string3 = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            string3 = ((StandardHost)host).getContextClass();
        }
        try {
            if (string2.equals(string3)) {
                return new StandardContext();
            }
            return (Context)Class.forName(string3).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            throw new IllegalArgumentException(sm.getString("tomcat.noContextClass", new Object[]{string3, host, string}), exception);
        }
    }

    public void enableNaming() {
        this.getServer();
        this.server.addLifecycleListener(new NamingContextListener());
        System.setProperty("catalina.useNaming", "true");
        Object object = "org.apache.naming";
        String string = System.getProperty("java.naming.factory.url.pkgs");
        if (string != null) {
            object = string.contains((CharSequence)object) ? string : (String)object + ":" + string;
        }
        System.setProperty("java.naming.factory.url.pkgs", (String)object);
        object = System.getProperty("java.naming.factory.initial");
        if (object == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
    }

    public void initWebappDefaults(String string) {
        Container container = this.getHost().findChild(string);
        Tomcat.initWebappDefaults((Context)container);
    }

    public static void initWebappDefaults(Context context) {
        Wrapper wrapper = Tomcat.addServlet(context, "default", "org.apache.catalina.servlets.DefaultServlet");
        wrapper.setLoadOnStartup(1);
        wrapper.setOverridable(true);
        wrapper = Tomcat.addServlet(context, "jsp", "org.apache.jasper.servlet.JspServlet");
        wrapper.addInitParameter("fork", "false");
        wrapper.setLoadOnStartup(3);
        wrapper.setOverridable(true);
        context.addServletMappingDecoded("/", "default");
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
        context.setSessionTimeout(30);
        Tomcat.addDefaultMimeTypeMappings(context);
        context.addWelcomeFile("index.html");
        context.addWelcomeFile("index.htm");
        context.addWelcomeFile("index.jsp");
    }

    public static void addDefaultMimeTypeMappings(Context context) {
        Properties properties = new Properties();
        try (InputStream inputStream = Tomcat.class.getResourceAsStream("MimeTypeMappings.properties");){
            properties.load(inputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(sm.getString("tomcat.defaultMimeTypeMappingsFail"), iOException);
        }
    }

    protected URL getWebappConfigFile(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            return this.getWebappConfigFileFromDirectory(file, string2);
        }
        return this.getWebappConfigFileFromWar(file, string2);
    }

    private URL getWebappConfigFileFromDirectory(File file, String string) {
        URL uRL = null;
        File file2 = new File(file, "META-INF/context.xml");
        if (file2.exists()) {
            try {
                uRL = file2.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(this.getLoggerName(this.getHost(), string)).log(Level.WARNING, sm.getString("tomcat.noContextXml", new Object[]{file}), malformedURLException);
            }
        }
        return uRL;
    }

    private URL getWebappConfigFileFromWar(File file, String string) {
        URL uRL = null;
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry = jarFile.getJarEntry("META-INF/context.xml");
            if (jarEntry != null) {
                uRL = UriUtil.buildJarUrl((File)file, (String)"META-INF/context.xml");
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getLoggerName(this.getHost(), string)).log(Level.WARNING, sm.getString("tomcat.noContextXml", new Object[]{file}), iOException);
        }
        return uRL;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--no-jmx")) {
                Registry.disableRegistry();
                continue;
            }
            if (!stringArray[i].equals("--catalina")) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = i + 1; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
            stringArray2 = arrayList.toArray(new String[0]);
            break;
        }
        SecurityClassLoad.securityClassLoad(Thread.currentThread().getContextClassLoader());
        Tomcat tomcat = new Tomcat();
        tomcat.init(null, stringArray2);
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--war")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException(sm.getString("tomcat.invalidCommandLine", new Object[]{stringArray[i - 1]}));
                }
                File file = new File(stringArray[i]);
                tomcat.addWebapp(string, file.getAbsolutePath());
                continue;
            }
            if (stringArray[i].equals("--path")) {
                if (++i >= stringArray.length) {
                    throw new IllegalArgumentException(sm.getString("tomcat.invalidCommandLine", new Object[]{stringArray[i - 1]}));
                }
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("--await")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--no-jmx")) continue;
            if (stringArray[i].equals("--catalina")) break;
            throw new IllegalArgumentException(sm.getString("tomcat.invalidCommandLine", new Object[]{stringArray[i]}));
        }
        tomcat.start();
        if (bl) {
            tomcat.getServer().await();
        }
    }

    static {
        if (JreCompat.isGraalAvailable()) {
            try (FileInputStream fileInputStream = new FileInputStream(new File(System.getProperty("java.util.logging.config.file", "conf/logging.properties")));){
                LogManager.getLogManager().readConfiguration(fileInputStream);
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static class ExistingStandardWrapper
    extends StandardWrapper {
        private final Servlet existing;

        public ExistingStandardWrapper(Servlet servlet) {
            this.existing = servlet;
            this.asyncSupported = ExistingStandardWrapper.hasAsync(servlet);
        }

        private static boolean hasAsync(Servlet servlet) {
            boolean bl = false;
            Class<?> clazz = servlet.getClass();
            WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
            if (webServlet != null) {
                bl = webServlet.asyncSupported();
            }
            return bl;
        }

        @Override
        public synchronized Servlet loadServlet() throws ServletException {
            if (!this.instanceInitialized) {
                this.existing.init((ServletConfig)this.facade);
                this.instanceInitialized = true;
            }
            return this.existing;
        }

        @Override
        public long getAvailable() {
            return 0L;
        }

        @Override
        public boolean isUnavailable() {
            return false;
        }

        @Override
        public Servlet getServlet() {
            return this.existing;
        }

        @Override
        public String getServletClass() {
            return this.existing.getClass().getName();
        }
    }

    public static class DefaultWebXmlListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("before_start".equals(lifecycleEvent.getType())) {
                Tomcat.initWebappDefaults((Context)lifecycleEvent.getLifecycle());
            }
        }
    }

    public static class FixContextListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            try {
                Context context = (Context)lifecycleEvent.getLifecycle();
                if (lifecycleEvent.getType().equals("configure_start")) {
                    context.setConfigured(true);
                    WebAnnotationSet.loadApplicationAnnotations(context);
                    if (context.getLoginConfig() == null) {
                        context.setLoginConfig(new LoginConfig("NONE", null, null, null));
                        context.getPipeline().addValve(new NonLoginAuthenticator());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private class SimpleRealm
    extends RealmBase {
        private SimpleRealm() {
        }

        @Override
        protected String getPassword(String string) {
            return Tomcat.this.userPass.get(string);
        }

        @Override
        protected Principal getPrincipal(String string) {
            String string2;
            Principal principal = Tomcat.this.userPrincipals.get(string);
            if (principal == null && (string2 = Tomcat.this.userPass.get(string)) != null) {
                principal = new GenericPrincipal(string, Tomcat.this.userRoles.get(string));
                Tomcat.this.userPrincipals.put(string, principal);
            }
            return principal;
        }
    }
}

