/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class DoubleCache {
    private double[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public DoubleCache() {
        this(13);
    }

    public DoubleCache(int n) {
        this.keyTable = new double[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0.0;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(double d) {
        if (d == 0.0) {
            int n = this.elementSize;
            for (int i = 0; i < n; ++i) {
                if (this.keyTable[i] != 0.0) continue;
                long l = Double.doubleToLongBits(d);
                long l2 = Double.doubleToLongBits(this.keyTable[i]);
                if (l == Long.MIN_VALUE && l2 == Long.MIN_VALUE) {
                    return true;
                }
                if (l != 0L || l2 != 0L) continue;
                return true;
            }
        } else {
            int n = this.elementSize;
            for (int i = 0; i < n; ++i) {
                if (this.keyTable[i] != d) continue;
                return true;
            }
        }
        return false;
    }

    public int put(double d, int n) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new double[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = d;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return n;
    }

    public int putIfAbsent(double d, int n) {
        if (d == 0.0) {
            int n2 = this.elementSize;
            for (int i = 0; i < n2; ++i) {
                if (this.keyTable[i] != 0.0) continue;
                long l = Double.doubleToLongBits(d);
                long l2 = Double.doubleToLongBits(this.keyTable[i]);
                if (l == Long.MIN_VALUE && l2 == Long.MIN_VALUE) {
                    return this.valueTable[i];
                }
                if (l != 0L || l2 != 0L) continue;
                return this.valueTable[i];
            }
        } else {
            int n3 = this.elementSize;
            for (int i = 0; i < n3; ++i) {
                if (this.keyTable[i] != d) continue;
                return this.valueTable[i];
            }
        }
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new double[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = d;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return -n;
    }

    public String toString() {
        int n = this.elementSize;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] != 0.0 || this.keyTable[i] == 0.0 && this.valueTable[i] != 0) {
                stringBuilder.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i >= n) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

