"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindRelationsNotFoundError = void 0;
var tslib_1 = require("tslib");
var TypeORMError_1 = require("./TypeORMError");
/**
 * Thrown when relations specified in the find options were not found in the entities.
*/
var FindRelationsNotFoundError = /** @class */ (function (_super) {
    (0, tslib_1.__extends)(FindRelationsNotFoundError, _super);
    function FindRelationsNotFoundError(notFoundRelations) {
        var _this = _super.call(this) || this;
        if (notFoundRelations.length === 1) {
            _this.message = "Relation \"" + notFoundRelations[0] + "\" was not found; please check if it is correct and really exists in your entity.";
        }
        else {
            _this.message = "Relations " + notFoundRelations.map(function (relation) { return "\"" + relation + "\""; }).join(", ") + " were not found; please check if relations are correct and they exist in your entities.";
        }
        return _this;
    }
    return FindRelationsNotFoundError;
}(TypeORMError_1.TypeORMError));
exports.FindRelationsNotFoundError = FindRelationsNotFoundError;

//# sourceMappingURL=FindRelationsNotFoundError.js.map
