/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage.querybuilder;

import java.util.Date;
import lombok.Generated;
import org.apache.commons.math3.util.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class TimeRangeParametersResolver
extends ExpressionNodeVisitor<Void, Object> {
    private Long startTime;
    private Long endTime;

    public Pair<Long, Long> resolve(Expression filterCondition) {
        if (filterCondition == null) {
            long endTime = new Date().getTime() / 1000L;
            return Pair.create((Object)(endTime - 3600L), (Object)endTime);
        }
        filterCondition.accept((ExpressionNodeVisitor)this, null);
        if (this.startTime == null && this.endTime == null) {
            long endTime = new Date().getTime() / 1000L;
            return Pair.create((Object)(endTime - 3600L), (Object)endTime);
        }
        if (this.startTime == null) {
            return Pair.create((Object)(this.endTime - 3600L), (Object)this.endTime);
        }
        if (this.endTime == null) {
            return Pair.create((Object)this.startTime, (Object)(this.startTime + 3600L));
        }
        return Pair.create((Object)this.startTime, (Object)this.endTime);
    }

    public Void visitFunction(FunctionExpression func, Object context) {
        if (BuiltinFunctionName.LTE.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.GTE.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.LESS.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.GREATER.getName().equals((Object)func.getFunctionName())) {
            ReferenceExpression ref = (ReferenceExpression)func.getArguments().get(0);
            Expression rightExpr = (Expression)func.getArguments().get(1);
            if (ref.getAttr().equals("@timestamp")) {
                ExprValue literalValue = rightExpr.valueOf();
                if (func.getFunctionName().getFunctionName().contains(">")) {
                    this.startTime = literalValue.timestampValue().toEpochMilli() / 1000L;
                }
                if (func.getFunctionName().getFunctionName().contains("<")) {
                    this.endTime = literalValue.timestampValue().toEpochMilli() / 1000L;
                }
            }
        } else {
            func.getArguments().stream().filter(arg -> arg instanceof FunctionExpression).forEach(arg -> this.visitFunction((FunctionExpression)arg, context));
        }
        return null;
    }

    @Generated
    public TimeRangeParametersResolver() {
    }
}

