/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.metricscorrelation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.ExecuteInput;
import org.opensearch.ml.common.input.Input;

@ExecuteInput(algorithms={FunctionName.METRICS_CORRELATION})
public class MetricsCorrelationInput
implements Input {
    public static final String PARSE_FIELD_NAME = FunctionName.METRICS_CORRELATION.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> MetricsCorrelationInput.parse(it));
    public static final String METRICS_FIELD = "metrics";
    List<float[]> inputData;

    public MetricsCorrelationInput(List<float[]> inputData) {
        if (inputData == null || inputData.size() == 0) {
            throw new IllegalArgumentException("empty input data");
        }
        int expectedLength = inputData.get(0).length;
        for (int i = 1; i < inputData.size(); ++i) {
            float[] array = inputData.get(i);
            if (array.length == expectedLength) continue;
            throw new IllegalArgumentException("All the input metrics sizes should be same");
        }
        if (inputData.size() >= expectedLength) {
            throw new IllegalArgumentException("The number of metrics to correlate must be smaller than the length of each time series.");
        }
        this.inputData = inputData;
    }

    public MetricsCorrelationInput(StreamInput in) throws IOException {
        this.inputData = in.readList(StreamInput::readFloatArray);
    }

    public static MetricsCorrelationInput parse(XContentParser parser) throws IOException {
        ArrayList<float[]> inputData = new ArrayList<float[]>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "metrics": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        ArrayList<Float> inputItem = new ArrayList<Float>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            inputItem.add(Float.valueOf(parser.floatValue()));
                        }
                        float[] floatArray = new float[inputItem.size()];
                        int i = 0;
                        for (Float f : inputItem) {
                            floatArray[i++] = f != null ? f.floatValue() : Float.NaN;
                        }
                        inputData.add(floatArray);
                    }
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return new MetricsCorrelationInput(inputData);
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.METRICS_CORRELATION;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.inputData, StreamOutput::writeFloatArray);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(METRICS_FIELD, this.inputData);
        builder.endObject();
        return builder;
    }

    @Generated
    public static MetricsCorrelationInputBuilder builder() {
        return new MetricsCorrelationInputBuilder();
    }

    @Generated
    public List<float[]> getInputData() {
        return this.inputData;
    }

    @Generated
    public void setInputData(List<float[]> inputData) {
        this.inputData = inputData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsCorrelationInput)) {
            return false;
        }
        MetricsCorrelationInput other = (MetricsCorrelationInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<float[]> this$inputData = this.getInputData();
        List<float[]> other$inputData = other.getInputData();
        return !(this$inputData == null ? other$inputData != null : !((Object)this$inputData).equals(other$inputData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricsCorrelationInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<float[]> $inputData = this.getInputData();
        result = result * 59 + ($inputData == null ? 43 : ((Object)$inputData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricsCorrelationInput(inputData=" + this.getInputData() + ")";
    }

    @Generated
    public static class MetricsCorrelationInputBuilder {
        @Generated
        private List<float[]> inputData;

        @Generated
        MetricsCorrelationInputBuilder() {
        }

        @Generated
        public MetricsCorrelationInputBuilder inputData(List<float[]> inputData) {
            this.inputData = inputData;
            return this;
        }

        @Generated
        public MetricsCorrelationInput build() {
            return new MetricsCorrelationInput(this.inputData);
        }

        @Generated
        public String toString() {
            return "MetricsCorrelationInput.MetricsCorrelationInputBuilder(inputData=" + this.inputData + ")";
        }
    }
}

