/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.model_group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;

public class MLUpdateModelGroupInput
implements ToXContentObject,
Writeable {
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String MODEL_ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    private String modelGroupID;
    private String name;
    private String description;
    private List<String> backendRoles;
    private AccessMode modelAccessMode;
    private Boolean isAddAllBackendRoles;

    public MLUpdateModelGroupInput(String modelGroupID, String name, String description, List<String> backendRoles, AccessMode modelAccessMode, Boolean isAddAllBackendRoles) {
        this.modelGroupID = modelGroupID;
        this.name = name;
        this.description = description;
        this.backendRoles = backendRoles;
        this.modelAccessMode = modelAccessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
    }

    public MLUpdateModelGroupInput(StreamInput in) throws IOException {
        this.modelGroupID = in.readString();
        this.name = in.readOptionalString();
        this.description = in.readOptionalString();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.modelAccessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupID);
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.modelAccessMode != null) {
            builder.field(MODEL_ACCESS_MODE, (Object)this.modelAccessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.isAddAllBackendRoles);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelGroupID);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelAccessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelAccessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
    }

    public static MLUpdateModelGroupInput parse(XContentParser parser) throws IOException {
        String modelGroupID = null;
        String name = null;
        String description = null;
        ArrayList<String> backendRoles = null;
        AccessMode modelAccessMode = null;
        Boolean isAddAllBackendRoles = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_group_id": {
                    modelGroupID = parser.text();
                    continue block16;
                }
                case "name": {
                    name = parser.text();
                    continue block16;
                }
                case "description": {
                    description = parser.text();
                    continue block16;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block16;
                }
                case "access_mode": {
                    modelAccessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block16;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new MLUpdateModelGroupInput(modelGroupID, name, description, backendRoles, modelAccessMode, isAddAllBackendRoles);
    }

    @Generated
    public static MLUpdateModelGroupInputBuilder builder() {
        return new MLUpdateModelGroupInputBuilder();
    }

    @Generated
    public MLUpdateModelGroupInputBuilder toBuilder() {
        return new MLUpdateModelGroupInputBuilder().modelGroupID(this.modelGroupID).name(this.name).description(this.description).backendRoles(this.backendRoles).modelAccessMode(this.modelAccessMode).isAddAllBackendRoles(this.isAddAllBackendRoles);
    }

    @Generated
    public String getModelGroupID() {
        return this.modelGroupID;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public AccessMode getModelAccessMode() {
        return this.modelAccessMode;
    }

    @Generated
    public Boolean getIsAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    @Generated
    public void setModelGroupID(String modelGroupID) {
        this.modelGroupID = modelGroupID;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public void setModelAccessMode(AccessMode modelAccessMode) {
        this.modelAccessMode = modelAccessMode;
    }

    @Generated
    public void setIsAddAllBackendRoles(Boolean isAddAllBackendRoles) {
        this.isAddAllBackendRoles = isAddAllBackendRoles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLUpdateModelGroupInput)) {
            return false;
        }
        MLUpdateModelGroupInput other = (MLUpdateModelGroupInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        Boolean other$isAddAllBackendRoles = other.getIsAddAllBackendRoles();
        if (this$isAddAllBackendRoles == null ? other$isAddAllBackendRoles != null : !((Object)this$isAddAllBackendRoles).equals(other$isAddAllBackendRoles)) {
            return false;
        }
        String this$modelGroupID = this.getModelGroupID();
        String other$modelGroupID = other.getModelGroupID();
        if (this$modelGroupID == null ? other$modelGroupID != null : !this$modelGroupID.equals(other$modelGroupID)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        AccessMode this$modelAccessMode = this.getModelAccessMode();
        AccessMode other$modelAccessMode = other.getModelAccessMode();
        return !(this$modelAccessMode == null ? other$modelAccessMode != null : !((Object)((Object)this$modelAccessMode)).equals((Object)other$modelAccessMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLUpdateModelGroupInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAddAllBackendRoles = this.getIsAddAllBackendRoles();
        result = result * 59 + ($isAddAllBackendRoles == null ? 43 : ((Object)$isAddAllBackendRoles).hashCode());
        String $modelGroupID = this.getModelGroupID();
        result = result * 59 + ($modelGroupID == null ? 43 : $modelGroupID.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        AccessMode $modelAccessMode = this.getModelAccessMode();
        result = result * 59 + ($modelAccessMode == null ? 43 : ((Object)((Object)$modelAccessMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLUpdateModelGroupInput(modelGroupID=" + this.getModelGroupID() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", backendRoles=" + this.getBackendRoles() + ", modelAccessMode=" + this.getModelAccessMode() + ", isAddAllBackendRoles=" + this.getIsAddAllBackendRoles() + ")";
    }

    @Generated
    public static class MLUpdateModelGroupInputBuilder {
        @Generated
        private String modelGroupID;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode modelAccessMode;
        @Generated
        private Boolean isAddAllBackendRoles;

        @Generated
        MLUpdateModelGroupInputBuilder() {
        }

        @Generated
        public MLUpdateModelGroupInputBuilder modelGroupID(String modelGroupID) {
            this.modelGroupID = modelGroupID;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInputBuilder modelAccessMode(AccessMode modelAccessMode) {
            this.modelAccessMode = modelAccessMode;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInputBuilder isAddAllBackendRoles(Boolean isAddAllBackendRoles) {
            this.isAddAllBackendRoles = isAddAllBackendRoles;
            return this;
        }

        @Generated
        public MLUpdateModelGroupInput build() {
            return new MLUpdateModelGroupInput(this.modelGroupID, this.name, this.description, this.backendRoles, this.modelAccessMode, this.isAddAllBackendRoles);
        }

        @Generated
        public String toString() {
            return "MLUpdateModelGroupInput.MLUpdateModelGroupInputBuilder(modelGroupID=" + this.modelGroupID + ", name=" + this.name + ", description=" + this.description + ", backendRoles=" + this.backendRoles + ", modelAccessMode=" + this.modelAccessMode + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ")";
        }
    }
}

