_ruff() {
    local i cur prev opts cmd
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"
    cmd=""
    opts=""

    for i in ${COMP_WORDS[@]}
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="ruff"
                ;;
            ruff,check)
                cmd="ruff__check"
                ;;
            ruff,clean)
                cmd="ruff__clean"
                ;;
            ruff,config)
                cmd="ruff__config"
                ;;
            ruff,generate-shell-completion)
                cmd="ruff__generate__shell__completion"
                ;;
            ruff,help)
                cmd="ruff__help"
                ;;
            ruff,linter)
                cmd="ruff__linter"
                ;;
            ruff,rule)
                cmd="ruff__rule"
                ;;
            ruff__help,check)
                cmd="ruff__help__check"
                ;;
            ruff__help,clean)
                cmd="ruff__help__clean"
                ;;
            ruff__help,config)
                cmd="ruff__help__config"
                ;;
            ruff__help,generate-shell-completion)
                cmd="ruff__help__generate__shell__completion"
                ;;
            ruff__help,help)
                cmd="ruff__help__help"
                ;;
            ruff__help,linter)
                cmd="ruff__help__linter"
                ;;
            ruff__help,rule)
                cmd="ruff__help__rule"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        ruff)
            opts="-v -q -s -h -V --verbose --quiet --silent --help --version check rule config linter clean generate-shell-completion help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__check)
            opts="-w -n -e -v -q -s -h --fix --no-fix --show-source --no-show-source --show-fixes --no-show-fixes --diff --watch --fix-only --no-fix-only --format --target-version --config --select --ignore --extend-select --extend-ignore --per-file-ignores --exclude --extend-exclude --fixable --unfixable --respect-gitignore --no-respect-gitignore --force-exclude --no-force-exclude --line-length --dummy-variable-rgx --no-cache --isolated --cache-dir --stdin-filename --exit-zero --exit-non-zero-on-fix --update-check --no-update-check --statistics --add-noqa --show-files --show-settings --verbose --quiet --silent --help [FILES]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json junit grouped github gitlab pylint" -- "${cur}"))
                    return 0
                    ;;
                --target-version)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --extend-select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --extend-ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --per-file-ignores)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extend-exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --fixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --unfixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA0 ERA001 ERA00 YTT1 YTT301 YTT2 YTT20 YTT202 YTT201 YTT102 YTT101 YTT302 YTT204 YTT203 YTT3 YTT103 YTT10 YTT30 YTT303 ANN2 ANN201 ANN206 ANN002 ANN4 ANN003 ANN101 ANN40 ANN205 ANN001 ANN102 ANN0 ANN202 ANN10 ANN20 ANN00 ANN204 ANN401 ANN1 S61 S5 S7 S501 S324 S70 S105 S10 S32 S11 S506 S112 S508 S106 S108 S107 S1 S509 S103 S113 S701 S608 S6 S60 S104 S102 S3 S50 S612 S110 S101 BLE0 BLE001 BLE00 FBT0 FBT002 FBT003 FBT001 FBT00 B905 B01 B002 B013 B021 B014 B025 B03 B90 B011 B010 B004 B015 B019 B00 B023 B02 B018 B016 B003 B008 B026 B007 B029 B904 B032 B012 B022 B005 B009 B017 B020 B0 B006 B024 B027 B9 A002 A001 A0 A00 A003 COM81 COM812 COM819 COM818 COM8 C408 C40 C414 C41 C402 C410 C405 C403 C409 C415 C400 C411 C406 C413 C404 C416 C401 C417 DTZ007 DTZ00 DTZ002 DTZ011 DTZ012 DTZ005 DTZ006 DTZ003 DTZ001 DTZ004 DTZ0 DTZ01 T100 DJ013 DJ00 DJ001 DJ01 DJ008 DJ0 EM101 EM10 EM103 EM102 EM1 EXE003 EXE001 EXE004 EXE0 EXE00 EXE005 EXE002 ISC0 ISC002 ISC00 ISC001 ISC003 ICN0 ICN00 ICN001 G001 G101 G01 G010 G201 G1 G004 G202 G003 G2 G00 G0 G20 G002 G10 INP0 INP001 INP00 PIE8 PIE7 PIE807 PIE79 PIE810 PIE790 PIE81 PIE80 PIE796 PIE794 PIE800 PIE804 T203 T201 PYI008 PYI00 PYI001 PYI007 PYI0 PT018 PT02 PT006 PT017 PT0 PT023 PT021 PT016 PT00 PT004 PT019 PT020 PT007 PT012 PT009 PT001 PT002 PT013 PT010 PT026 PT003 PT015 PT005 PT024 PT022 PT025 PT01 PT011 PT008 Q00 Q000 Q002 Q003 Q0 Q001 RSE102 RSE1 RSE10 RET501 RET504 RET507 RET503 RET5 RET506 RET50 RET502 RET508 RET505 SLF0 SLF00 SLF001 SIM208 SIM117 SIM201 SIM110 SIM107 SIM223 SIM40 SIM2 SIM401 SIM10 SIM109 SIM20 SIM202 SIM221 SIM220 SIM11 SIM212 SIM3 SIM102 SIM105 SIM103 SIM114 SIM115 SIM21 SIM30 SIM300 SIM112 SIM22 SIM118 SIM108 SIM101 SIM4 SIM1 SIM222 SIM116 SIM211 SIM210 TID252 TID251 TID2 TID25 TCH005 TCH002 TCH00 TCH0 TCH003 TCH004 TCH001 ARG0 ARG001 ARG003 ARG00 ARG004 ARG002 ARG005 PTH102 PTH106 PTH11 PTH103 PTH100 PTH110 PTH120 PTH12 PTH104 PTH114 PTH113 PTH10 PTH105 PTH1 PTH118 PTH117 PTH119 PTH121 PTH123 PTH122 PTH108 PTH112 PTH111 PTH107 PTH101 PTH109 PTH124 PTH115 PTH116 I002 I0 I00 I001 C901 NPY002 NPY00 NPY001 NPY0 N816 N81 N802 N803 N813 N812 N815 N805 N806 N811 N817 N804 N818 N8 N99 N801 N999 N807 N9 N80 N814 PD012 PD007 PD009 PD004 PD9 PD008 PD003 PD002 PD010 PD015 PD00 PD0 PD01 PD013 PD901 PD011 PD90 W2 E99 W E101 E90 E741 E999 E1 E7 E721 W505 E501 E401 E73 W29 E902 E10 W50 E72 E731 E711 E402 E722 E74 E703 W292 W60 E712 E743 E742 W605 E5 E E4 E70 E702 E713 E714 E9 E71 W5 W6 E50 E40 E701 D205 D301 D203 D209 D212 D101 D214 D400 D411 D105 D403 D412 D409 D202 D407 D413 D415 D102 D204 D207 D208 D405 D417 D418 D210 D206 D20 D104 D410 D213 D419 D404 D401 D100 D211 D10 D106 D1 D2 D201 D416 D414 D4 D21 D103 D40 D408 D41 D215 D3 D30 D107 D402 D200 D406 D300 F541 F504 F523 F602 F404 F72 F405 F631 F63 F82 F821 F403 F502 F505 F706 F54 F8 F632 F522 F823 F6 F407 F81 F701 F622 F9 F503 F621 F525 F822 F601 F5 F811 F901 F406 F508 F506 F524 F707 F704 F633 F509 F521 F841 F507 F634 F501 F7 F702 F84 F402 F4 F401 F70 F722 F50 F40 F52 F62 F60 F842 F90 PGH001 PGH004 PGH00 PGH002 PGH0 PGH003 PLC3 PLR091 PLR170 PLE1205 PLW0602 PLR0912 PLE25 PLR0206 PLR2 PLW012 PLE06 PLE250 PLR09 PLE0605 PLR0133 PLR040 PLE11 PLR2004 PLR1701 PLE114 PLE13 PLR0915 PLE010 PLR172 PLE1307 PLE01 PLE1206 PLC30 PLE0100 PLE2502 PLR0911 PLC04 PLR1 PLW290 PLE0101 PLE060 PLW0120 PLE12 PLW06 PLE0604 PLR0402 PLR013 PLR01 PLW PLE130 PLR17 PLW2901 PLC3002 PLC041 PLE0117 PLE1142 PLR0913 PLW060 PLE PLE120 PLR20 PLE0118 PLC0 PLE1310 PLC PLR04 PLR0 PLW01 PLE011 PLE131 PLC300 PLR020 PLW0 PLE1 PLC0414 PLR PLW2 PLR1722 PLE0 PLW29 PLR02 PLR200 PLE2 UP007 UP003 UP014 UP001 UP030 UP015 UP032 UP0 UP012 UP00 UP008 UP017 UP026 UP009 UP005 UP010 UP021 UP018 UP036 UP020 UP004 UP013 UP019 UP034 UP024 UP029 UP035 UP033 UP01 UP011 UP023 UP02 UP022 UP006 UP028 UP037 UP025 UP03 UP031 UP027 RUF00 RUF001 RUF004 RUF006 RUF005 RUF100 RUF10 RUF003 RUF002 RUF0 RUF1 TRY200 TRY300 TRY401 TRY00 TRY40 TRY2 TRY0 TRY201 TRY002 TRY30 TRY400 TRY3 TRY4 TRY003 TRY004 TRY301 TRY20" -- "${cur}"))
                    return 0
                    ;;
                --line-length)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --dummy-variable-rgx)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cache-dir)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdin-filename)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__clean)
            opts="-v -q -s -h --verbose --quiet --silent --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__config)
            opts="-v -q -s -h --verbose --quiet --silent --help [OPTION]"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__generate__shell__completion)
            opts="-v -q -s -h --verbose --quiet --silent --help bash elvish fig fish powershell zsh"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help)
            opts="check rule config linter clean generate-shell-completion help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__check)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__clean)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__config)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__generate__shell__completion)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__linter)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__rule)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__linter)
            opts="-v -q -s -h --format --verbose --quiet --silent --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__rule)
            opts="-v -q -s -h --format --verbose --quiet --silent --help <RULE>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

complete -F _ruff -o bashdefault -o default ruff
