/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.visitor;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2ValuesStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class DB2OutputVisitor
extends SQLASTOutputVisitor
implements DB2ASTVisitor {
    public DB2OutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(DB2SelectQueryBlock x) {
        this.visit((SQLSelectQueryBlock)x);
        if (x.getFirst() != null) {
            SQLOrderBy orderBy;
            SQLObject parent = x.getParent();
            if (parent instanceof SQLSelect && (orderBy = ((SQLSelect)parent).getOrderBy()) != null && orderBy.getItems().size() > 0) {
                this.println();
                this.print("ORDER BY ");
                this.printAndAccept(orderBy.getItems(), ", ");
                ((SQLSelect)parent).setOrderBy(null);
            }
            this.println();
            this.print("FETCH FIRST ");
            x.getFirst().accept(this);
            this.print(" ROWS ONLY");
        }
        if (x.isForReadOnly()) {
            this.println();
            this.print("FOR READ ONLY");
        }
        if (x.getIsolation() != null) {
            this.println();
            this.print("WITH ");
            this.print(x.getIsolation().name());
        }
        if (x.getOptimizeFor() != null) {
            this.println();
            this.print("OPTIMIZE FOR ");
            x.getOptimizeFor().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(DB2SelectQueryBlock x) {
    }

    @Override
    public boolean visit(DB2ValuesStatement x) {
        this.print("VALUES ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(DB2ValuesStatement x) {
    }
}

