"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = require("os");
const completionProvider_1 = require("../../src/providers/completionProvider");
const chai_1 = require("chai");
function testResolveSuffixInPlaybook() {
    const tests = [
        {
            optionType: "dict",
            firstElementOfList: true,
            isPlaybook: true,
            expectedSuffix: `${os_1.EOL}\t\t`,
        },
        {
            optionType: "list",
            firstElementOfList: true,
            isPlaybook: true,
            expectedSuffix: `${os_1.EOL}\t\t- `,
        },
        {
            optionType: "string",
            firstElementOfList: true,
            isPlaybook: true,
            expectedSuffix: " ",
        },
    ];
    tests.forEach(({ optionType, firstElementOfList, isPlaybook, expectedSuffix }) => {
        it(`should provide suffix for '${optionType}' type options in a playbook`, function () {
            const actualSuffix = (0, completionProvider_1.resolveSuffix)(optionType, firstElementOfList, isPlaybook);
            (0, chai_1.expect)(actualSuffix).to.equal(expectedSuffix);
        });
    });
}
function testResolveSuffixInNonPlaybookFile() {
    const tests = [
        {
            optionType: "dict",
            firstElementOfList: true,
            isPlaybook: false,
            expectedSuffix: `${os_1.EOL}\t`,
        },
        {
            optionType: "list",
            firstElementOfList: true,
            isPlaybook: false,
            expectedSuffix: `${os_1.EOL}\t- `,
        },
        {
            optionType: "string",
            firstElementOfList: true,
            isPlaybook: false,
            expectedSuffix: " ",
        },
    ];
    tests.forEach(({ optionType, firstElementOfList, isPlaybook, expectedSuffix }) => {
        it(`should provide suffix for '${optionType}' type options in a non-playbook file`, function () {
            const actualSuffix = (0, completionProvider_1.resolveSuffix)(optionType, firstElementOfList, isPlaybook);
            (0, chai_1.expect)(actualSuffix).to.equal(expectedSuffix);
        });
    });
}
describe("resolveSuffix", function () {
    describe("Resolve suffix for completion items in a playbook", function () {
        testResolveSuffixInPlaybook();
    });
    describe("Resolve suffix for completion items in a non-playbook file", function () {
        testResolveSuffixInNonPlaybookFile();
    });
});
//# sourceMappingURL=resolveSuffixWhileCompletion.test.js.map