"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
const BASE_NODE_API_PATH = '/api/anomaly_detectors';
exports.BASE_NODE_API_PATH = BASE_NODE_API_PATH;
const AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`
});
exports.AD_NODE_API = AD_NODE_API;
const ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
exports.ALERTING_NODE_API = ALERTING_NODE_API;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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