/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.exceptions.DataSourceNotFoundException;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.GetDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.GetDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionResponse;
import org.opensearch.sql.datasources.transport.TransportCreateDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportDeleteDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportGetDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportUpdateDataSourceAction;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.datasources.utils.XContentParserUtils;

public class RestDataSourceQueryAction
extends BaseRestHandler {
    public static final String DATASOURCE_ACTIONS = "datasource_actions";
    public static final String BASE_DATASOURCE_ACTION_URL = "/_plugins/_query/_datasources";
    private static final Logger LOG = LogManager.getLogger(RestDataSourceQueryAction.class);

    public String getName() {
        return DATASOURCE_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", BASE_DATASOURCE_ACTION_URL, "dataSourceName")), (Object)new RestHandler.Route(RestRequest.Method.GET, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.PUT, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", BASE_DATASOURCE_ACTION_URL, "dataSourceName")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        switch (restRequest.method()) {
            case POST: {
                return this.executePostRequest(restRequest, nodeClient);
            }
            case GET: {
                return this.executeGetRequest(restRequest, nodeClient);
            }
            case PUT: {
                return this.executeUpdateRequest(restRequest, nodeClient);
            }
            case DELETE: {
                return this.executeDeleteRequest(restRequest, nodeClient);
            }
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(restRequest.contentParser());
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportCreateDataSourceAction.ACTION_TYPE, (ActionRequest)new CreateDataSourceActionRequest(dataSourceMetadata), (ActionListener)new ActionListener<CreateDataSourceActionResponse>(){

            public void onResponse(CreateDataSourceActionResponse createDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, "application/json; charset=UTF-8", createDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeGetRequest(RestRequest restRequest, NodeClient nodeClient) {
        String dataSourceName = restRequest.param("dataSourceName");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportGetDataSourceAction.ACTION_TYPE, (ActionRequest)new GetDataSourceActionRequest(dataSourceName), (ActionListener)new ActionListener<GetDataSourceActionResponse>(){

            public void onResponse(GetDataSourceActionResponse getDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", getDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeUpdateRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(restRequest.contentParser());
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportUpdateDataSourceAction.ACTION_TYPE, (ActionRequest)new UpdateDataSourceActionRequest(dataSourceMetadata), (ActionListener)new ActionListener<UpdateDataSourceActionResponse>(){

            public void onResponse(UpdateDataSourceActionResponse updateDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", updateDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest restRequest, NodeClient nodeClient) {
        String dataSourceName = restRequest.param("dataSourceName");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportDeleteDataSourceAction.ACTION_TYPE, (ActionRequest)new DeleteDataSourceActionRequest(dataSourceName), (ActionListener)new ActionListener<DeleteDataSourceActionResponse>(){

            public void onResponse(DeleteDataSourceActionResponse deleteDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NO_CONTENT, "application/json; charset=UTF-8", deleteDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private void handleException(Exception e, RestChannel restChannel) {
        if (e instanceof DataSourceNotFoundException) {
            this.reportError(restChannel, e, RestStatus.NOT_FOUND);
        } else if (e instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestDataSourceQueryAction.isClientError(e)) {
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
            } else {
                this.reportError(restChannel, e, RestStatus.SERVICE_UNAVAILABLE);
            }
        }
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage(e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IllegalStateException;
    }
}

