/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.service.DataSourceLoaderCache;
import org.opensearch.sql.storage.DataSourceFactory;

public class DataSourceLoaderCacheImpl
implements DataSourceLoaderCache {
    private final Map<DataSourceType, DataSourceFactory> dataSourceFactoryMap;
    private final Cache<DataSourceMetadata, DataSource> dataSourceCache;

    public DataSourceLoaderCacheImpl(Set<DataSourceFactory> dataSourceFactorySet) {
        this.dataSourceFactoryMap = dataSourceFactorySet.stream().collect(Collectors.toMap(DataSourceFactory::getDataSourceType, f -> f));
        this.dataSourceCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(24L, TimeUnit.HOURS).build();
    }

    @Override
    public DataSource getOrLoadDataSource(DataSourceMetadata dataSourceMetadata) {
        DataSource dataSource = (DataSource)this.dataSourceCache.getIfPresent((Object)dataSourceMetadata);
        if (dataSource == null) {
            dataSource = this.dataSourceFactoryMap.get(dataSourceMetadata.getConnector()).createDataSource(dataSourceMetadata);
            this.dataSourceCache.put((Object)dataSourceMetadata, (Object)dataSource);
            return dataSource;
        }
        return dataSource;
    }
}

