/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.analysis.ExpressionReferenceOptimizer;
import org.opensearch.sql.analysis.QualifierAnalyzer;
import org.opensearch.sql.analysis.TypeEnvironment;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.NestedAllTupleFields;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;

public class SelectExpressionAnalyzer
extends AbstractNodeVisitor<List<NamedExpression>, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private ExpressionReferenceOptimizer optimizer;

    public List<NamedExpression> analyze(List<UnresolvedExpression> selectList, AnalysisContext analysisContext, ExpressionReferenceOptimizer optimizer) {
        this.optimizer = optimizer;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (UnresolvedExpression unresolvedExpression : selectList) {
            builder.addAll((Iterable)unresolvedExpression.accept(this, analysisContext));
        }
        return builder.build();
    }

    @Override
    public List<NamedExpression> visitField(Field node, AnalysisContext context) {
        return Collections.singletonList(DSL.named(node.accept(this.expressionAnalyzer, context)));
    }

    @Override
    public List<NamedExpression> visitAlias(Alias node, AnalysisContext context) {
        if (node.getDelegated() instanceof NestedAllTupleFields) {
            return node.getDelegated().accept(this, context);
        }
        Expression expr = this.referenceIfSymbolDefined(node, context);
        return Collections.singletonList(DSL.named(this.unqualifiedNameIfFieldOnly(node, context), expr, node.getAlias()));
    }

    private Expression referenceIfSymbolDefined(Alias expr, AnalysisContext context) {
        UnresolvedExpression delegatedExpr = expr.getDelegated();
        return this.optimizer.optimize(DSL.named(expr.getName(), delegatedExpr.accept(this.expressionAnalyzer, context), expr.getAlias()), context);
    }

    @Override
    public List<NamedExpression> visitAllFields(AllFields node, AnalysisContext context) {
        TypeEnvironment environment = context.peek();
        Map<String, ExprType> lookupAllFields = environment.lookupAllFields(Namespace.FIELD_NAME);
        return lookupAllFields.entrySet().stream().map(entry -> DSL.named((String)entry.getKey(), new ReferenceExpression((String)entry.getKey(), (ExprType)entry.getValue()))).collect(Collectors.toList());
    }

    @Override
    public List<NamedExpression> visitNestedAllTupleFields(NestedAllTupleFields node, AnalysisContext context) {
        TypeEnvironment environment = context.peek();
        Map<String, ExprType> lookupAllTupleFields = environment.lookupAllTupleFields(Namespace.FIELD_NAME);
        environment.resolve(new Symbol(Namespace.FIELD_NAME, node.getPath()));
        Pattern p = Pattern.compile(node.getPath() + "\\.[^\\.]+$");
        return lookupAllTupleFields.entrySet().stream().filter(field -> p.matcher((CharSequence)field.getKey()).find()).map(entry -> {
            Expression nestedFunc = new Function("nested", List.of(new QualifiedName(List.of(((String)entry.getKey()).split("\\."))))).accept(this.expressionAnalyzer, context);
            return DSL.named("nested(" + (String)entry.getKey() + ")", nestedFunc);
        }).collect(Collectors.toList());
    }

    private String unqualifiedNameIfFieldOnly(Alias node, AnalysisContext context) {
        UnresolvedExpression selectItem = node.getDelegated();
        if (selectItem instanceof QualifiedName) {
            QualifierAnalyzer qualifierAnalyzer = new QualifierAnalyzer(context);
            return qualifierAnalyzer.unqualified((QualifiedName)selectItem);
        }
        return node.getName();
    }

    @Generated
    public SelectExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer) {
        this.expressionAnalyzer = expressionAnalyzer;
    }
}

