# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepOffsetAPI module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_brepoffsetapi.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepOffsetAPI
else:
    import _BRepOffsetAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepOffsetAPI.delete_SwigPyIterator

    def value(self):
        return _BRepOffsetAPI.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepOffsetAPI.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepOffsetAPI.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepOffsetAPI.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepOffsetAPI.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepOffsetAPI.SwigPyIterator_copy(self)

    def next(self):
        return _BRepOffsetAPI.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepOffsetAPI.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepOffsetAPI.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepOffsetAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepOffsetAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepOffsetAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepOffsetAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepOffsetAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepOffsetAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepOffsetAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepOffsetAPI:
_BRepOffsetAPI.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepOffsetAPI.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.BRepBuilderAPI
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.TopTools
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Geom2d
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.Draft
import OCC.Core.BRepFill
import OCC.Core.MAT
import OCC.Core.AppParCurves
import OCC.Core.math
import OCC.Core.GeomPlate
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.TColGeom2d
import OCC.Core.GeomLProp
import OCC.Core.Law
import OCC.Core.AdvApp2Var
import OCC.Core.AdvApprox
import OCC.Core.PLib
import OCC.Core.Plate
import OCC.Core.GeomFill
import OCC.Core.Convert
import OCC.Core.AppBlend
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.TColGeom
import OCC.Core.BRepMAT2d
import OCC.Core.Bisector
import OCC.Core.IntRes2d
import OCC.Core.BRepOffset
import OCC.Core.ChFiDS
import OCC.Core.BRepAdaptor
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.BRepAlgo
import OCC.Core.BRepPrimAPI
import OCC.Core.BRepPrim
import OCC.Core.BRepSweep
import OCC.Core.Sweep

from enum import IntEnum
from OCC.Core.Exception import *



class BRepOffsetAPI_SequenceOfSequenceOfReal(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_begin(self)

    def end(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_end(self)

    def cbegin(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_cbegin(self)

    def cend(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_cend(self)

    def __init__(self, *args):
        _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_SequenceOfSequenceOfReal(*args))

    def Size(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Size(self)

    def Length(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Length(self)

    def Lower(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Lower(self)

    def Upper(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Upper(self)

    def IsEmpty(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_IsEmpty(self)

    def Reverse(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Reverse(self)

    def Exchange(self, I, J):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Assign(self, theOther)

    def Set(self, theOther):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Set(self, theOther)

    def Remove(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Remove(self, *args)

    def Append(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Append(self, *args)

    def Prepend(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Split(self, theIndex, theSeq)

    def First(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_First(self)

    def ChangeFirst(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_ChangeFirst(self)

    def Last(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Last(self)

    def ChangeLast(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_ChangeLast(self)

    def Value(self, theIndex):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_SequenceOfSequenceOfReal

    def __len__(self):
        return self.Size()


# Register BRepOffsetAPI_SequenceOfSequenceOfReal in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfReal_swigregister(BRepOffsetAPI_SequenceOfSequenceOfReal)
class BRepOffsetAPI_SequenceOfSequenceOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_begin(self)

    def end(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_end(self)

    def cbegin(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_cbegin(self)

    def cend(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_cend(self)

    def __init__(self, *args):
        _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_SequenceOfSequenceOfShape(*args))

    def Size(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Size(self)

    def Length(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Length(self)

    def Lower(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Lower(self)

    def Upper(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Upper(self)

    def IsEmpty(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_IsEmpty(self)

    def Reverse(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Reverse(self)

    def Exchange(self, I, J):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Assign(self, theOther)

    def Set(self, theOther):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Set(self, theOther)

    def Remove(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Remove(self, *args)

    def Append(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Append(self, *args)

    def Prepend(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Split(self, theIndex, theSeq)

    def First(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_First(self)

    def ChangeFirst(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_ChangeFirst(self)

    def Last(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Last(self)

    def ChangeLast(self):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_ChangeLast(self)

    def Value(self, theIndex):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_SequenceOfSequenceOfShape

    def __len__(self):
        return self.Size()


# Register BRepOffsetAPI_SequenceOfSequenceOfShape in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_SequenceOfSequenceOfShape_swigregister(BRepOffsetAPI_SequenceOfSequenceOfShape)
class BRepOffsetAPI_DraftAngle(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_ModifyShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty algorithm to perform taper-adding transformations on faces of a shape. use the init function to define the shape to be tapered.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm to perform taper-adding transformations on faces of the shape s. s will be referred to as the initial shape of the algorithm.

        """
        _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_DraftAngle(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        Direction: gp_Dir
        Angle: float
        NeutralPlane: gp_Pln
        Flag: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Adds the face f, the direction direction, the angle angle, the plane neutralplane, and the flag flag to the framework created at construction time, and with this data, defines the taper-adding transformation. f is a face, which belongs to the initial shape of this algorithm or to the shape loaded by the function init. only planar, cylindrical or conical faces can be tapered: - if the face f is planar, it is tapered by inclining it through the angle angle about the line of intersection between the plane neutralplane and f. direction indicates the side of neutralplane from which matter is removed if angle is positive or added if angle is negative. - if f is cylindrical or conical, it is transformed in the same way on a single face, resulting in a conical face if f is cylindrical, and a conical or cylindrical face if it is already conical. the taper-adding transformation is propagated from the face f along the series of planar, cylindrical or conical faces containing f, which are tangential to one another. use the function adddone to check if this taper-adding transformation is successful. warning nothing is done if: - the face f does not belong to the initial shape of this algorithm, or - the face f is not planar, cylindrical or conical. exceptions - standard_nullobject if the initial shape is not defined, i.e. if this algorithm has not been initialized with the non-empty constructor or the init function. - standard_constructionerror if the previous call to add has failed. the function adddone ought to have been used to check for this, and the function remove to cancel the results of the unsuccessful taper-adding transformation and to retrieve the previous shape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_Add(self, *args)

    def AddDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the previous taper-adding transformation performed by this algorithm in the last call to add, was successful. if adddone returns false: - the function problematicshape returns the face on which the error occurred, - the function remove has to be used to cancel the results of the unsuccessful taper-adding transformation and to retrieve the previous shape. exceptions standard_nullobject if the initial shape has not been defined, i.e. if this algorithm has not been initialized with the non-empty constructor or the .init function.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_AddDone(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Cancels the results of all taper-adding transformations performed by this algorithm on the initial shape. these results will have been defined by successive calls to the function add.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_Clear(self, *args)

    def ConnectedFaces(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns all the faces which have been added together with the face <f>.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_ConnectedFaces(self, *args)

    def CorrectWires(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_CorrectWires(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initializes, or reinitializes this taper-adding algorithm with the shape s. s will be referred to as the initial shape of this algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_Init(self, *args)

    def ModifiedFaces(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns all the faces on which a modification has been given.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_ModifiedFaces(self, *args)

    def ProblematicShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the shape on which an error occurred after an unsuccessful call to add or when isdone returns false. exceptions standard_nullobject if the initial shape has not been defined, i.e. if this algorithm has not been initialized with the non-empty constructor or the init function.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_ProblematicShape(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Cancels the taper-adding transformation previously performed by this algorithm on the face f and the series of tangential faces which contain f, and retrieves the shape before the last taper-adding transformation. warning you will have to use this function if the previous call to add fails. use the function adddone to check it. exceptions - standard_nullobject if the initial shape has not been defined, i.e. if this algorithm has not been initialized with the non-empty constructor or the init function. - standard_nosuchobject if f has not been added or has already been removed.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_Remove(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        Draft_ErrorStatus

        Description
        -----------
        Returns an error status when an error has occurred (face, edge or vertex recomputation problem). otherwise returns draft_noerror. the method may be called if adddone returns standard_false, or when isdone returns standard_false.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_DraftAngle_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_DraftAngle

# Register BRepOffsetAPI_DraftAngle in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_DraftAngle_swigregister(BRepOffsetAPI_DraftAngle)
class BRepOffsetAPI_FindContigousEdges(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        tolerance: float (optional, default to 1.0e-06)
        option: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm for identifying contiguous edges on shapes with tolerance as the tolerance of contiguity (defaulted to 1.0e-6). this tolerance value is used to determine whether two edges or sections of edges are coincident. use the function add to define the shapes to be checked. set option to false. this argument (defaulted to true) will serve in subsequent software releases for performing an analysis of degenerated shapes.

        """
        _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_FindContigousEdges(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the shape shape to the list of shapes to be checked by this algorithm. once all the shapes to be checked have been added, use the function perform to find the contiguous edges and the function contigousedge to return these edges.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_Add(self, *args)

    def ContigousEdge(self, *args):
        r"""

        Parameters
        ----------
        index: int

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the contiguous edge of index index found by the function perform on the shapes added to this algorithm. exceptions standard_outofrange if: - index is less than 1, or - index is greater than the number of contiguous edges found by the function perform on the shapes added to this algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_ContigousEdge(self, *args)

    def ContigousEdgeCouple(self, *args):
        r"""

        Parameters
        ----------
        index: int

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns a list of edges coincident with the contiguous edge of index index found by the function perform. there are as many edges in the list as there are faces adjacent to this contiguous edge. exceptions standard_outofrange if: - index is less than 1, or - index is greater than the number of contiguous edges found by the function perform on the shapes added to this algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_ContigousEdgeCouple(self, *args)

    def DegeneratedShape(self, *args):
        r"""

        Parameters
        ----------
        index: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Gives a degenerated shape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_DegeneratedShape(self, *args)

    def Dump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Dump properties of resulting shape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_Dump(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        tolerance: float
        option: bool

        Return
        -------
        None

        Description
        -----------
        Initializes this algorithm for identifying contiguous edges on shapes using the tolerance of contiguity tolerance. this tolerance value is used to determine whether two edges or sections of edges are coincident. use the function add to define the shapes to be checked. sets <option> to false.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_Init(self, *args)

    def IsDegenerated(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Indicates if a input shape is degenerated.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_IsDegenerated(self, *args)

    def IsModified(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if the copy of the initial shape shape was modified by the function perform (i.e. if one or more of its edges was broken down into contiguous and non-contiguous sections). warning returns false if shape is not one of the initial shapes added to this algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_IsModified(self, *args)

    def Modified(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Gives a modifieded shape raises nosuchobject if shape has not been modified.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_Modified(self, *args)

    def NbContigousEdges(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of contiguous edges found by the function perform on the shapes added to this algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_NbContigousEdges(self, *args)

    def NbDegeneratedShapes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives the number of degenerated shapes.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_NbDegeneratedShapes(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Finds coincident parts of edges of two or more shapes added to this algorithm and breaks down these edges into contiguous and non-contiguous sections on copies of the initial shapes. the function contigousedge returns contiguous edges. the function modified can be used to return modified copies of the initial shapes where one or more edges were broken down into contiguous and non-contiguous sections. warning this function must be used once all the shapes to be checked have been added. it is not possible to add further shapes subsequently and then to repeat the call to perform.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_Perform(self, *args)

    def SectionToBoundary(self, *args):
        r"""

        Parameters
        ----------
        section: TopoDS_Edge

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the edge on the initial shape, of which the modified copy contains the edge section. section is coincident with a contiguous edge found by the function perform. use the function contigousedgecouple to obtain a valid section. this information is useful for verification purposes, since it provides a means of determining the surface to which the contiguous edge belongs. exceptions standard_nosuchobject if section is not coincident with a contiguous edge. use the function contigousedgecouple to obtain a valid section.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_SectionToBoundary(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def NbEdges(self):
    	pass

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_FindContigousEdges

# Register BRepOffsetAPI_FindContigousEdges in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_FindContigousEdges_swigregister(BRepOffsetAPI_FindContigousEdges)
class BRepOffsetAPI_MakeDraft(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Shape: TopoDS_Shape
        Dir: gp_Dir
        Angle: float

        Return
        -------
        None

        Description
        -----------
        Constructs the draft surface object defined by the shape shape, the direction dir, and the angle angle. shape must be a topods_wire, topo_ds_face or topods_shell with free boundaries. exceptions standard_notdone if shape is not a topods_wire, topo_ds_face or topods_shell with free boundaries.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeDraft_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeDraft(*args))

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        LengthMax: float

        Return
        -------
        None

        Description
        -----------
        Performs the draft using the length lengthmax as the maximum length for the corner edge between two draft faces.

        Parameters
        ----------
        Surface: Geom_Surface
        KeepInsideSurface: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Performs the draft up to the surface surface. if keepinsidesurface is true, the part of surface inside the draft is kept in the result.

        Parameters
        ----------
        StopShape: TopoDS_Shape
        KeepOutSide: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Performs the draft up to the shape stopshape. if keepoutside is true, the part of stopshape which is outside the draft is kept in the result.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeDraft_Perform(self, *args)

    def SetDraft(self, *args):
        r"""

        Parameters
        ----------
        IsInternal: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Sets the direction of the draft for this object. if isinternal is true, the draft is internal to the argument shape used in the constructor.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeDraft_SetDraft(self, *args)

    def SetOptions(self, *args):
        r"""

        Parameters
        ----------
        Style: BRepBuilderAPI_TransitionMode (optional, default to BRepBuilderAPI_RightCorner)
        AngleMin: float (optional, default to 0.01)
        AngleMax: float (optional, default to 3.0)

        Return
        -------
        None

        Description
        -----------
        Sets the options of this draft tool. if a transition has to be performed, it can be defined by the mode style as rightcorner or roundcorner, rightcorner being a corner defined by a sharp angle, and roundcorner being a rounded corner. anglemin is an angular tolerance used to detect whether a transition has to be performed or not. anglemax sets the maximum value within which a rightcorner transition can be performed. anglemin and anglemax are expressed in radians.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeDraft_SetOptions(self, *args)

    def Shell(self, *args):
        r"""
        Return
        -------
        TopoDS_Shell

        Description
        -----------
        Returns the shell resulting from performance of the draft along the wire.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeDraft_Shell(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeDraft

# Register BRepOffsetAPI_MakeDraft in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeDraft_swigregister(BRepOffsetAPI_MakeDraft)
class BRepOffsetAPI_MakeEvolved(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theSpine: TopoDS_Shape
        theProfile: TopoDS_Wire
        theJoinType: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        theIsAxeProf: bool (optional, default to Standard_True)
        theIsSolid: bool (optional, default to Standard_False)
        theIsProfOnSpine: bool (optional, default to Standard_False)
        theTol: float (optional, default to 0.0000001)
        theIsVolume: bool (optional, default to Standard_False)
        theRunInParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs an evolved shape by sweeping the profile (theprofile) along the spine (thespine). thespine can be shape only of type wire or face. see description to this class for detailed information.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeEvolved(*args))

    def Bottom(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return the face bottom if <solid> is true in the constructor.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_Bottom(self, *args)

    def Evolved(self, *args):
        r"""
        Return
        -------
        BRepFill_Evolved

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_Evolved(self, *args)

    def GeneratedShapes(self, *args):
        r"""

        Parameters
        ----------
        SpineShape: TopoDS_Shape
        ProfShape: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the shapes created from a subshape <spineshape> of the spine and a subshape <profshape> on the profile.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_GeneratedShapes(self, *args)

    def Top(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return the face top if <solid> is true in the constructor.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_Top(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeEvolved

# Register BRepOffsetAPI_MakeEvolved in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeEvolved_swigregister(BRepOffsetAPI_MakeEvolved)
class BRepOffsetAPI_MakeFilling(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Degree: int (optional, default to 3)
        NbPtsOnCur: int (optional, default to 15)
        NbIter: int (optional, default to 2)
        Anisotropie: bool (optional, default to Standard_False)
        Tol2d: float (optional, default to 0.00001)
        Tol3d: float (optional, default to 0.0001)
        TolAng: float (optional, default to 0.01)
        TolCurv: float (optional, default to 0.1)
        MaxDeg: int (optional, default to 8)
        MaxSegments: int (optional, default to 9)

        Return
        -------
        None

        Description
        -----------
        Constructs a wire filling object defined by - the energy minimizing criterion degree - the number of points on the curve nbpntsoncur - the number of iterations nbiter - the boolean anisotropie - the 2d tolerance tol2d - the 3d tolerance tol3d - the angular tolerance tolang - the tolerance for curvature tolcur - the highest polynomial degree maxdeg - the greatest number of segments maxseg. if the boolean anistropie is true, the algorithm's performance is better in cases where the ratio of the length u and the length v indicate a great difference between the two. in other words, when the surface is, for example, extremely long.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeFilling(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Constr: TopoDS_Edge
        Order: GeomAbs_Shape
        IsBound: bool (optional, default to Standard_True)

        Return
        -------
        int

        Description
        -----------
        Adds a new constraint which also defines an edge of the wire of the face order: order of the constraint: geomabs_c0: the surface has to pass by 3d representation of the edge geomabs_g1: the surface has to pass by 3d representation of the edge and to respect tangency with the first face of the edge geomabs_g2: the surface has to pass by 3d representation of the edge and to respect tangency and curvature with the first face of the edge. raises constructionerror if the edge has no representation on a face and order is geomabs_g1 or geomabs_g2.

        Parameters
        ----------
        Constr: TopoDS_Edge
        Support: TopoDS_Face
        Order: GeomAbs_Shape
        IsBound: bool (optional, default to Standard_True)

        Return
        -------
        int

        Description
        -----------
        Adds a new constraint which also defines an edge of the wire of the face order: order of the constraint: geomabs_c0: the surface has to pass by 3d representation of the edge geomabs_g1: the surface has to pass by 3d representation of the edge and to respect tangency with the given face geomabs_g2: the surface has to pass by 3d representation of the edge and to respect tangency and curvature with the given face. raises constructionerror if the edge has no 2d representation on the given face.

        Parameters
        ----------
        Support: TopoDS_Face
        Order: GeomAbs_Shape

        Return
        -------
        int

        Description
        -----------
        Adds a free constraint on a face. the corresponding edge has to be automatically recomputed. it is always a bound.

        Parameters
        ----------
        Point: gp_Pnt

        Return
        -------
        int

        Description
        -----------
        Adds a punctual constraint.

        Parameters
        ----------
        U: float
        V: float
        Support: TopoDS_Face
        Order: GeomAbs_Shape

        Return
        -------
        int

        Description
        -----------
        Adds a punctual constraint.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_Add(self, *args)

    def G0Error(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the result and the constraints. this is set at construction time.

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance attained between the result and the constraint index. this is set at construction time.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_G0Error(self, *args)

    def G1Error(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum angle between the result and the constraints. this is set at construction time.

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the maximum angle between the result and the constraints. this is set at construction time.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_G1Error(self, *args)

    def G2Error(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum angle between the result and the constraints. this is set at construction time.

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the greatest difference in curvature found between the result and the constraint index.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_G2Error(self, *args)

    def LoadInitSurface(self, *args):
        r"""

        Parameters
        ----------
        Surf: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Loads the initial surface surf to begin the construction of the surface. this optional function is useful if the surface resulting from construction for the algorithm is likely to be complex. the support surface of the face under construction is computed by a deformation of surf which satisfies the given constraints. the set of bounding edges defines the wire of the face. if no initial surface is given, the algorithm computes it automatically. if the set of edges is not connected (free constraint), missing edges are automatically computed. important: the initial surface must have orthogonal local coordinates, i.e. partial derivatives ds/du and ds/dv must be orthogonal at each point of surface. if this condition breaks, distortions of resulting surface are possible.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_LoadInitSurface(self, *args)

    def SetApproxParam(self, *args):
        r"""

        Parameters
        ----------
        MaxDeg: int (optional, default to 8)
        MaxSegments: int (optional, default to 9)

        Return
        -------
        None

        Description
        -----------
        Sets the parameters used to approximate the filling surface. these include: - maxdeg - the highest degree which the polynomial defining the filling surface can have - maxsegments - the greatest number of segments which the filling surface can have.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_SetApproxParam(self, *args)

    def SetConstrParam(self, *args):
        r"""

        Parameters
        ----------
        Tol2d: float (optional, default to 0.00001)
        Tol3d: float (optional, default to 0.0001)
        TolAng: float (optional, default to 0.01)
        TolCurv: float (optional, default to 0.1)

        Return
        -------
        None

        Description
        -----------
        Sets the values of tolerances used to control the constraint. tol2d: tol3d: it is the maximum distance allowed between the support surface and the constraints tolang: it is the maximum angle allowed between the normal of the surface and the constraints tolcurv: it is the maximum difference of curvature allowed between the surface and the constraint.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_SetConstrParam(self, *args)

    def SetResolParam(self, *args):
        r"""

        Parameters
        ----------
        Degree: int (optional, default to 3)
        NbPtsOnCur: int (optional, default to 15)
        NbIter: int (optional, default to 2)
        Anisotropie: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Sets the parameters used for resolution. the default values of these parameters have been chosen for a good ratio quality/performance. degree: it is the order of energy criterion to minimize for computing the deformation of the surface. the default value is 3 the recommended value is i+2 where i is the maximum order of the constraints. nbptsoncur: it is the average number of points for discretisation of the edges. nbiter: it is the maximum number of iterations of the process. for each iteration the number of discretisation points is increased. anisotropie:.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeFilling_SetResolParam(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeFilling

# Register BRepOffsetAPI_MakeFilling in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeFilling_swigregister(BRepOffsetAPI_MakeFilling)
class BRepOffsetAPI_MakeOffset(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an algorithm for creating an empty offset.

        Parameters
        ----------
        Spine: TopoDS_Face
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        IsOpenResult: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs an algorithm for creating an algorithm to build parallels to the spine spine.

        Parameters
        ----------
        Spine: TopoDS_Wire
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        IsOpenResult: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeOffset(*args))

    def AddWire(self, *args):
        r"""

        Parameters
        ----------
        Spine: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Initializes the algorithm to construct parallels to the wire spine.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_AddWire(self, *args)

    @staticmethod
    def ConvertFace(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theAngleTolerance: float

        Return
        -------
        TopoDS_Face

        Description
        -----------
        Converts each wire of the face into contour consisting only of arcs and segments. new 3d curves are built too.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_ConvertFace(*args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Spine: TopoDS_Face
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        IsOpenResult: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the algorithm to construct parallels to the spine spine. join defines the type of parallel generated by the salient vertices of the spine. the default type is geomabs_arc where the vertices generate sections of a circle. if join type is geomabs_intersection, the edges that intersect in a salient vertex generate the edges prolonged until intersection.

        Parameters
        ----------
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        IsOpenResult: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initialize the evaluation of offsetting.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Offset: float
        Alt: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Computes a parallel to the spine at distance offset and at an altitude alt from the plane of the spine in relation to the normal to the spine. exceptions: stdfail_notdone if the offset is not built.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_Perform(self, *args)

    def SetApprox(self, *args):
        r"""

        Parameters
        ----------
        ToApprox: bool

        Return
        -------
        None

        Description
        -----------
        Set approximation flag for convertion input contours into ones consisting of 2d circular arcs and 2d linear segments only.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffset_SetApprox(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeOffset

# Register BRepOffsetAPI_MakeOffset in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeOffset_swigregister(BRepOffsetAPI_MakeOffset)
class BRepOffsetAPI_MakeOffsetShape(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor does nothing.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeOffsetShape(*args))

    def GetJoinType(self, *args):
        r"""
        Return
        -------
        GeomAbs_JoinType

        Description
        -----------
        Returns offset join type.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_GetJoinType(self, *args)

    def MakeOffset(self, *args):
        r"""
        Return
        -------
        BRepOffset_MakeOffset

        Description
        -----------
        Returns instance of the unrelying intersection / arc algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_MakeOffset(self, *args)

    def PerformByJoin(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        Offset: float
        Tol: float
        Mode: BRepOffset_Mode (optional, default to BRepOffset_Skin)
        Intersection: bool (optional, default to Standard_False)
        SelfInter: bool (optional, default to Standard_False)
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        RemoveIntEdges: bool (optional, default to Standard_False)
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Constructs a shape parallel to the shape s, where - s may be a face, a shell, a solid or a compound of these shape kinds; - offset is the offset value. the offset shape is constructed: - outside s, if offset is positive, - inside s, if offset is negative; - tol defines the coincidence tolerance criterion for generated shapes; - mode defines the construction type of parallels applied to the free edges of shape s; currently, only one construction type is implemented, namely the one where the free edges do not generate parallels; this corresponds to the default value brepoffset_skin; - intersection specifies how the algorithm must work in order to limit the parallels to two adjacent shapes: - if intersection is false (default value), the intersection is calculated with the parallels to the two adjacent shapes, - if intersection is true, the intersection is calculated by taking all generated parallels into account; this computation method is more general as it avoids some self-intersections generated in the offset shape from features of small dimensions on shape s, however this method has not been completely implemented and therefore is not recommended for use; - selfinter tells the algorithm whether a computation to eliminate self-intersections must be applied to the resulting shape; however, as this functionality is not yet implemented, it is recommended to use the default value (false); - join defines how to fill the holes that may appear between parallels to the two adjacent faces. it may take values geomabs_arc or geomabs_intersection: - if join is equal to geomabs_arc, then pipes are generated between two free edges of two adjacent parallels, and spheres are generated on 'images' of vertices; it is the default value, - if join is equal to geomabs_intersection, then the parallels to the two adjacent faces are enlarged and intersected, so that there are no free edges on parallels to faces. removeintedges flag defines whether to remove the internal edges from the result or not. warnings 1. all the faces of the shape s should be based on the surfaces with continuity at least c1. 2. the offset value should be sufficiently small to avoid self-intersections in resulting shape. otherwise these self-intersections may appear inside an offset face if its initial surface is not plane or sphere or cylinder, also some non-adjacent offset faces may intersect each other. also, some offset surfaces may 'turn inside out'. 3. the algorithm may fail if the shape s contains vertices where more than 3 edges converge. 4. since 3d-offset algorithm involves intersection of surfaces, it is under limitations of surface intersection algorithm. 5. a result cannot be generated if the underlying geometry of s is bspline with continuity c0. exceptions geom_undefinedderivative if the underlying geometry of s is bspline with continuity c0.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_PerformByJoin(self, *args)

    def PerformBySimple(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theOffsetValue: float

        Return
        -------
        None

        Description
        -----------
        Constructs offset shape for the given one using simple algorithm without intersections computation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_PerformBySimple(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeOffsetShape

# Register BRepOffsetAPI_MakeOffsetShape in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeOffsetShape_swigregister(BRepOffsetAPI_MakeOffsetShape)
class BRepOffsetAPI_MakePipe(OCC.Core.BRepPrimAPI.BRepPrimAPI_MakeSweep):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Spine: TopoDS_Wire
        Profile: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Constructs a pipe by sweeping the shape profile along the wire spine.the angle made by the spine with the profile is maintained along the length of the pipe. warning spine must be g1 continuous; that is, on the connection vertex of two edges of the wire, the tangent vectors on the left and on the right must have the same direction, though not necessarily the same magnitude. exceptions standard_domainerror if the profile is a solid or a composite solid.

        Parameters
        ----------
        Spine: TopoDS_Wire
        Profile: TopoDS_Shape
        aMode: GeomFill_Trihedron
        ForceApproxC1: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The same as previous but with setting of mode of sweep and the flag that indicates attempt to approximate a c1-continuous surface if a swept surface proved to be c0.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakePipe_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakePipe(*args))

    def ErrorOnSurface(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipe_ErrorOnSurface(self, *args)

    def Generated(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        SSpine: TopoDS_Shape
        SProfile: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipe_Generated(self, *args)

    def Pipe(self, *args):
        r"""
        Return
        -------
        BRepFill_Pipe

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipe_Pipe(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakePipe

# Register BRepOffsetAPI_MakePipe in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakePipe_swigregister(BRepOffsetAPI_MakePipe)
class BRepOffsetAPI_MakePipeShell(OCC.Core.BRepPrimAPI.BRepPrimAPI_MakeSweep):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Spine: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Constructs the shell-generating framework defined by the wire spine. sets an sweep's mode if no mode are set, the mode use in makepipe is used.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakePipeShell(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Profile: TopoDS_Shape
        WithContact: bool (optional, default to Standard_False)
        WithCorrection: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Adds the section profile to this framework. first and last sections may be punctual, so the shape profile may be both wire and vertex. correspondent point on spine is computed automatically. if withcontact is true, the section is translated to be in contact with the spine. if withcorrection is true, the section is rotated to be orthogonal to the spine?s tangent in the correspondent point. this option has no sense if the section is punctual (profile is of type topods_vertex).

        Parameters
        ----------
        Profile: TopoDS_Shape
        Location: TopoDS_Vertex
        WithContact: bool (optional, default to Standard_False)
        WithCorrection: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Adds the section profile to this framework. correspondent point on the spine is given by location. warning: to be effective, it is not recommended to combine methods add and setlaw.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_Add(self, *args)

    def Delete(self, *args):
        r"""

        Parameters
        ----------
        Profile: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Removes the section profile from this framework.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_Delete(self, *args)

    def ErrorOnSurface(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_ErrorOnSurface(self, *args)

    def GetStatus(self, *args):
        r"""
        Return
        -------
        BRepBuilderAPI_PipeError

        Description
        -----------
        Get a status, when simulate or build failed. it can be brepbuilderapi_pipedone, brepbuilderapi_pipenotdone, brepbuilderapi_planenotintersectguide, brepbuilderapi_impossiblecontact.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_GetStatus(self, *args)

    def IsReady(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this tool object is ready to build the shape, i.e. has a definition for the wire section profile.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_IsReady(self, *args)

    def MakeSolid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Transforms the sweeping shell in solid. if a propfile is not closed returns false.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_MakeSolid(self, *args)

    def Profiles(self, *args):
        r"""

        Parameters
        ----------
        theProfiles: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Returns the list of original profiles.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_Profiles(self, *args)

    def SetDiscreteMode(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets a discrete trihedron to perform the sweeping.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetDiscreteMode(self, *args)

    def SetForceApproxC1(self, *args):
        r"""

        Parameters
        ----------
        ForceApproxC1: bool

        Return
        -------
        None

        Description
        -----------
        Set the flag that indicates attempt to approximate a c1-continuous surface if a swept surface proved to be c0.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetForceApproxC1(self, *args)

    def SetLaw(self, *args):
        r"""

        Parameters
        ----------
        Profile: TopoDS_Shape
        L: Law_Function
        WithContact: bool (optional, default to Standard_False)
        WithCorrection: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Sets the evolution law defined by the wire profile with its position (location, withcontact, withcorrection are the same options as in methods add) and a homotetic law defined by the function l. warning: to be effective, it is not recommended to combine methods add and setlaw.

        Parameters
        ----------
        Profile: TopoDS_Shape
        L: Law_Function
        Location: TopoDS_Vertex
        WithContact: bool (optional, default to Standard_False)
        WithCorrection: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Sets the evolution law defined by the wire profile with its position (location, withcontact, withcorrection are the same options as in methods add) and a homotetic law defined by the function l. warning: to be effective, it is not recommended to combine methods add and setlaw.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetLaw(self, *args)

    def SetMaxDegree(self, *args):
        r"""

        Parameters
        ----------
        NewMaxDegree: int

        Return
        -------
        None

        Description
        -----------
        Define the maximum v degree of resulting surface.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetMaxDegree(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        NewMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Define the maximum number of spans in v-direction on resulting surface.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetMaxSegments(self, *args)

    def SetMode(self, *args):
        r"""

        Parameters
        ----------
        IsFrenet: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Sets a frenet or a correctedfrenet trihedron to perform the sweeping if isfrenet is false, a corrected frenet trihedron is used.

        Parameters
        ----------
        Axe: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Sets a fixed trihedron to perform the sweeping all sections will be parallel.

        Parameters
        ----------
        BiNormal: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Sets a fixed binormal direction to perform the -- sweeping. angular relations between the section(s) and <binormal> will be constant.

        Parameters
        ----------
        SpineSupport: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Sets support to the spine to define the binormal of the trihedron, like the normal to the surfaces. warning: to be effective, each edge of the <spine> must have a representation on one face of<spinesupport>.

        Parameters
        ----------
        AuxiliarySpine: TopoDS_Wire
        CurvilinearEquivalence: bool
        KeepContact: BRepFill_TypeOfContact (optional, default to BRepFill_NoContact)

        Return
        -------
        None

        Description
        -----------
        Sets an auxiliary spine to define the normal for each point of the spine p, an point q is evalued on <auxiliaryspine> if <curvilinearequivalence> q split <auxiliaryspine> with the same length ratio than p split <spline>. else the plan define by p and the tangent to the <spine> intersect <auxiliaryspine> in q. if <keepcontact> equals brepfill_nocontact: the normal is defined by the vector pq. if <keepcontact> equals brepfill_contact: the normal is defined to achieve that the sweeped section is in contact to the auxiliaryspine. the width of section is constant all along the path. in other words, the auxiliary spine lies on the swept surface, but not necessarily is a boundary of this surface. however, the auxiliary spine has to be close enough to the main spine to provide intersection with any section all along the path. if <keepcontact> equals brepfill_contactonborder: the auxiliary spine becomes a boundary of the swept surface and the width of section varies along the path. give section to sweep. possibilities are: - give one or sevral section - give one profile and an homotetic law. - automatic compute of correspondence between spine, and section on the sweeped shape - correspondence between spine, and section on the sweeped shape defined by a vertex of the spine.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetMode(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol3d: float (optional, default to 1.0e-4)
        BoundTol: float (optional, default to 1.0e-4)
        TolAngular: float (optional, default to 1.0e-2)

        Return
        -------
        None

        Description
        -----------
        Sets the following tolerance values - 3d tolerance tol3d - boundary tolerance boundtol - angular tolerance tolangular.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetTolerance(self, *args)

    def SetTransitionMode(self, *args):
        r"""

        Parameters
        ----------
        Mode: BRepBuilderAPI_TransitionMode (optional, default to BRepBuilderAPI_Transformed)

        Return
        -------
        None

        Description
        -----------
        Sets the transition mode to manage discontinuities on the swept shape caused by fractures on the spine. the transition mode can be brepbuilderapi_transformed (default value), brepbuilderapi_rightcorner, brepbuilderapi_roundcorner: -  repbuilderapi_transformed: discontinuities are treated by modification of the sweeping mode. the pipe is 'transformed' at the fractures of the spine. this mode assumes building a self-intersected shell. -  brepbuilderapi_rightcorner: discontinuities are treated like right corner. two pieces of the pipe corresponding to two adjacent segments of the spine are extended and intersected at a fracture of the spine. -  brepbuilderapi_roundcorner: discontinuities are treated like round corner. the corner is treated as rotation of the profile around an axis which passes through the point of the spine's fracture. this axis is based on cross product of directions tangent to the adjacent segments of the spine at their common point. warnings the mode brepbuilderapi_rightcorner provides a valid result if intersection of two pieces of the pipe (corresponding to two adjacent segments of the spine) in the neighborhood of the spine?s fracture is connected and planar. this condition can be violated if the spine is non-linear in some neighborhood of the fracture or if the profile was set with a scaling law. the last mode, brepbuilderapi_roundcorner, will assuredly provide a good result only if a profile was set with option withcorrection = true, i.e. it is strictly orthogonal to the spine.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_SetTransitionMode(self, *args)

    def Simulate(self, *args):
        r"""

        Parameters
        ----------
        NumberOfSection: int
        Result: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Simulates the resulting shape by calculating its cross-sections. the spine is divided by this cross-sections into (numberofsection - 1) equal parts, the number of cross-sections is numberofsection. the cross-sections are wires and they are returned in the list result. this gives a rapid preview of the resulting shape, which will be obtained using the settings you have provided. raises notdone if <self> it is not ready.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_Simulate(self, *args)

    def Spine(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Returns the spine.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_Spine(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakePipeShell

# Register BRepOffsetAPI_MakePipeShell in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakePipeShell_swigregister(BRepOffsetAPI_MakePipeShell)
class BRepOffsetAPI_MiddlePath(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aShape: TopoDS_Shape
        StartShape: TopoDS_Shape
        EndShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        General constructor. startshape and endshape may be a wire or a face.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MiddlePath_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MiddlePath(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MiddlePath

# Register BRepOffsetAPI_MiddlePath in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MiddlePath_swigregister(BRepOffsetAPI_MiddlePath)
class BRepOffsetAPI_NormalProjection(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty framework to define projection on a shape according to the normal from each point to be projected to the shape.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Constructs a framework to define projection onto the basis shape s according to the normal from each point to be projected from the shape added to this framework by add. default parameters of the algorithm: tol3d = 1.e-04, tol2d =sqr(tol3d) , internalcontinuity = geomabs_c2, maxdegree = 14, maxseg = 16.

        """
        _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_NormalProjection(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        ToProj: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the shape toproj to the framework for calculation of the projection by compute3d. toproj is an edge or a wire and will be projected onto the basis shape. exceptions standard_constructionerror if toproj is not added.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Add(self, *args)

    def Ancestor(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the initial edge corresponding to the edge e resulting from the computation of the projection. exceptions stdfail_notdone if no edge was found. standard_nosuchobject if an edge corresponding to e has already been found.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Ancestor(self, *args)

    def BuildWire(self, *args):
        r"""

        Parameters
        ----------
        Liste: TopTools_ListOfShape

        Return
        -------
        bool

        Description
        -----------
        Build the result as a list of wire if possible in -- a first returns a wire only if there is only a wire.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_BuildWire(self, *args)

    def Compute3d(self, *args):
        r"""

        Parameters
        ----------
        With3d: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Returns true if a 3d curve is computed. if not, false is returned and an initial 3d curve is kept to build the resulting edges.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Compute3d(self, *args)

    def Couple(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the initial face corresponding to the projected edge e. exceptions stdfail_notdone if no face was found. standard_nosuchobject if a face corresponding to e has already been found.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Couple(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initializes the empty constructor framework with the shape s.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Init(self, *args)

    def Projection(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Performs the projection. the construction of the result is performed by build. exceptions stdfail_notdone if the projection was not performed.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_Projection(self, *args)

    def SetLimit(self, *args):
        r"""

        Parameters
        ----------
        FaceBoundaries: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Manage limitation of projected edges.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_SetLimit(self, *args)

    def SetMaxDistance(self, *args):
        r"""

        Parameters
        ----------
        MaxDist: float

        Return
        -------
        None

        Description
        -----------
        Sets the maximum distance between target shape and shape to project. if this condition is not satisfied then corresponding part of solution is discarded. if maxdist < 0 then this method does not affect the algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_SetMaxDistance(self, *args)

    def SetParams(self, *args):
        r"""

        Parameters
        ----------
        Tol3D: float
        Tol2D: float
        InternalContinuity: GeomAbs_Shape
        MaxDegree: int
        MaxSeg: int

        Return
        -------
        None

        Description
        -----------
        Sets the parameters used for computation tol3 is the required tolerance between the 3d projected curve and its 2d representation internalcontinuity is the order of constraints used for approximation maxdeg and maxseg are the maximum degree and the maximum number of segment for bspline resulting of an approximation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_NormalProjection_SetParams(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_NormalProjection

# Register BRepOffsetAPI_NormalProjection in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_NormalProjection_swigregister(BRepOffsetAPI_NormalProjection)
class BRepOffsetAPI_ThruSections(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        isSolid: bool (optional, default to Standard_False)
        ruled: bool (optional, default to Standard_False)
        pres3d: float (optional, default to 1.0e-06)

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm for building a shell or a solid passing through a set of sections, where: - issolid is set to true if the construction algorithm is required to build a solid or to false if it is required to build a shell (the default value), - ruled is set to true if the faces generated between the edges of two consecutive wires are ruled surfaces or to false (the default value) if they are smoothed out by approximation, - pres3d defines the precision criterion used by the approximation algorithm; the default value is 1.0e-6. use addwire and addvertex to define the successive sections of the shell or solid to be built.

        """
        _BRepOffsetAPI.BRepOffsetAPI_ThruSections_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_ThruSections(*args))

    def AddVertex(self, *args):
        r"""

        Parameters
        ----------
        aVertex: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Adds the vertex vertex (punctual section) to the set of sections through which the shell or solid is built. a vertex may be added to the set of sections only as first or last section. at least one wire must be added to the set of sections by the method addwire. use the build function to construct the shape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_AddVertex(self, *args)

    def AddWire(self, *args):
        r"""

        Parameters
        ----------
        wire: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Adds the wire wire to the set of sections through which the shell or solid is built. use the build function to construct the shape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_AddWire(self, *args)

    def CheckCompatibility(self, *args):
        r"""

        Parameters
        ----------
        check: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets/unsets the option to compute origin and orientation on wires to avoid twisted results and update wires to have same number of edges.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_CheckCompatibility(self, *args)

    def Continuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns the continuity used in the approximation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_Continuity(self, *args)

    def CriteriumWeight(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        W1: float
        W2: float
        W3: float

        Description
        -----------
        Returns the weights associed to the criterium used in the optimization.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_CriteriumWeight(self, *args)

    def FirstShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the topods shape of the bottom of the loft if solid.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_FirstShape(self, *args)

    def GeneratedFace(self, *args):
        r"""

        Parameters
        ----------
        Edge: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        If ruled returns the face generated by each edge except the last wire if smoothed returns the face generated by each edge of the first wire.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_GeneratedFace(self, *args)

    def GetStatus(self, *args):
        r"""
        Return
        -------
        BRepFill_ThruSectionErrorStatus

        Description
        -----------
        Returns the status of thrusection operation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_GetStatus(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        isSolid: bool (optional, default to Standard_False)
        ruled: bool (optional, default to Standard_False)
        pres3d: float (optional, default to 1.0e-06)

        Return
        -------
        None

        Description
        -----------
        Initializes this algorithm for building a shell or a solid passing through a set of sections, where: - issolid is set to true if this construction algorithm is required to build a solid or to false if it is required to build a shell. false is the default value; - ruled is set to true if the faces generated between the edges of two consecutive wires are ruled surfaces or to false (the default value) if they are smoothed out by approximation, - pres3d defines the precision criterion used by the approximation algorithm; the default value is 1.0e-6. use addwire and addvertex to define the successive sections of the shell or solid to be built.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_Init(self, *args)

    def IsMutableInput(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the current mutable input state.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_IsMutableInput(self, *args)

    def LastShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the topods shape of the top of the loft if solid.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_LastShape(self, *args)

    def MaxDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximal u degree of result surface.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_MaxDegree(self, *args)

    def ParType(self, *args):
        r"""
        Return
        -------
        Approx_ParametrizationType

        Description
        -----------
        Returns the type of parametrization used in the approximation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_ParType(self, *args)

    def SetContinuity(self, *args):
        r"""

        Parameters
        ----------
        C: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Define the continuity used in the approximation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetContinuity(self, *args)

    def SetCriteriumWeight(self, *args):
        r"""

        Parameters
        ----------
        W1: float
        W2: float
        W3: float

        Return
        -------
        None

        Description
        -----------
        Define the weights associed to the criterium used in the optimization. //! if wi <= 0.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetCriteriumWeight(self, *args)

    def SetMaxDegree(self, *args):
        r"""

        Parameters
        ----------
        MaxDeg: int

        Return
        -------
        None

        Description
        -----------
        Define the maximal u degree of result surface.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetMaxDegree(self, *args)

    def SetMutableInput(self, *args):
        r"""

        Parameters
        ----------
        theIsMutableInput: bool

        Return
        -------
        None

        Description
        -----------
        Sets the mutable input state. if true then the input profile can be modified inside the thrusection operation. default value is true.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetMutableInput(self, *args)

    def SetParType(self, *args):
        r"""

        Parameters
        ----------
        ParType: Approx_ParametrizationType

        Return
        -------
        None

        Description
        -----------
        Define the type of parametrization used in the approximation.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetParType(self, *args)

    def SetSmoothing(self, *args):
        r"""

        Parameters
        ----------
        UseSmoothing: bool

        Return
        -------
        None

        Description
        -----------
        Define the approximation algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_SetSmoothing(self, *args)

    def UseSmoothing(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Define the approximation algorithm.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_UseSmoothing(self, *args)

    def Wires(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of original wires.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_ThruSections_Wires(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_ThruSections

# Register BRepOffsetAPI_ThruSections in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_ThruSections_swigregister(BRepOffsetAPI_ThruSections)
class BRepOffsetAPI_MakeThickSolid(BRepOffsetAPI_MakeOffsetShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor does nothing.

        """
        _BRepOffsetAPI.BRepOffsetAPI_MakeThickSolid_swiginit(self, _BRepOffsetAPI.new_BRepOffsetAPI_MakeThickSolid(*args))

    def MakeThickSolidByJoin(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        ClosingFaces: TopTools_ListOfShape
        Offset: float
        Tol: float
        Mode: BRepOffset_Mode (optional, default to BRepOffset_Skin)
        Intersection: bool (optional, default to Standard_False)
        SelfInter: bool (optional, default to Standard_False)
        Join: GeomAbs_JoinType (optional, default to GeomAbs_Arc)
        RemoveIntEdges: bool (optional, default to Standard_False)
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Constructs a hollowed solid from the solid s by removing the set of faces closingfaces from s, where: offset defines the thickness of the walls. its sign indicates which side of the surface of the solid the hollowed shape is built on; - tol defines the tolerance criterion for coincidence in generated shapes; - mode defines the construction type of parallels applied to free edges of shape s. currently, only one construction type is implemented, namely the one where the free edges do not generate parallels; this corresponds to the default value brepoffset_skin; intersection specifies how the algorithm must work in order to limit the parallels to two adjacent shapes: - if intersection is false (default value), the intersection is calculated with the parallels to the two adjacent shapes, - if intersection is true, the intersection is calculated by taking account of all parallels generated; this computation method is more general as it avoids self-intersections generated in the offset shape from features of small dimensions on shape s, however this method has not been completely implemented and therefore is not recommended for use; - selfinter tells the algorithm whether a computation to eliminate self-intersections needs to be applied to the resulting shape. however, as this functionality is not yet implemented, you should use the default value (false); - join defines how to fill the holes that may appear between parallels to the two adjacent faces. it may take values geomabs_arc or geomabs_intersection: - if join is equal to geomabs_arc, then pipes are generated between two free edges of two adjacent parallels, and spheres are generated on 'images' of vertices; it is the default value, - if join is equal to geomabs_intersection, then the parallels to the two adjacent faces are enlarged and intersected, so that there are no free edges on parallels to faces. removeintedges flag defines whether to remove the internal edges from the result or not. warnings since the algorithm of makethicksolid is based on makeoffsetshape algorithm, the warnings are the same as for makeoffsetshape.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeThickSolid_MakeThickSolidByJoin(self, *args)

    def MakeThickSolidBySimple(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theOffsetValue: float

        Return
        -------
        None

        Description
        -----------
        Constructs solid using simple algorithm. according to its nature it is not possible to set list of the closing faces. this algorithm does not support faces removing. it is caused by fact that intersections are not computed during offset creation. non-closed shell or face is expected as input.

        """
        return _BRepOffsetAPI.BRepOffsetAPI_MakeThickSolid_MakeThickSolidBySimple(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepOffsetAPI.delete_BRepOffsetAPI_MakeThickSolid

# Register BRepOffsetAPI_MakeThickSolid in _BRepOffsetAPI:
_BRepOffsetAPI.BRepOffsetAPI_MakeThickSolid_swigregister(BRepOffsetAPI_MakeThickSolid)

BRepOffsetAPI_Sewing=OCC.Core.BRepBuilderAPI.BRepBuilderAPI_Sewing


@deprecated
def BRepOffsetAPI_MakeOffset_ConvertFace(*args):
	return BRepOffsetAPI_MakeOffset.ConvertFace(*args)



