# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
GCPnts module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_gcpnts.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _GCPnts
else:
    import _GCPnts

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _GCPnts.delete_SwigPyIterator

    def value(self):
        return _GCPnts.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _GCPnts.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _GCPnts.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _GCPnts.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _GCPnts.SwigPyIterator_equal(self, x)

    def copy(self):
        return _GCPnts.SwigPyIterator_copy(self)

    def next(self):
        return _GCPnts.SwigPyIterator_next(self)

    def __next__(self):
        return _GCPnts.SwigPyIterator___next__(self)

    def previous(self):
        return _GCPnts.SwigPyIterator_previous(self)

    def advance(self, n):
        return _GCPnts.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _GCPnts.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _GCPnts.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _GCPnts.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _GCPnts.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _GCPnts.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _GCPnts.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _GCPnts:
_GCPnts.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _GCPnts.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *

GCPnts_LengthParametrized = _GCPnts.GCPnts_LengthParametrized
GCPnts_Parametrized = _GCPnts.GCPnts_Parametrized
GCPnts_AbsComposite = _GCPnts.GCPnts_AbsComposite
GCPnts_Linear = _GCPnts.GCPnts_Linear
GCPnts_Circular = _GCPnts.GCPnts_Circular
GCPnts_Curved = _GCPnts.GCPnts_Curved
GCPnts_DefComposite = _GCPnts.GCPnts_DefComposite


class GCPnts_AbscissaType(IntEnum):
	GCPnts_LengthParametrized = 0
	GCPnts_Parametrized = 1
	GCPnts_AbsComposite = 2
GCPnts_LengthParametrized = GCPnts_AbscissaType.GCPnts_LengthParametrized
GCPnts_Parametrized = GCPnts_AbscissaType.GCPnts_Parametrized
GCPnts_AbsComposite = GCPnts_AbscissaType.GCPnts_AbsComposite

class GCPnts_DeflectionType(IntEnum):
	GCPnts_Linear = 0
	GCPnts_Circular = 1
	GCPnts_Curved = 2
	GCPnts_DefComposite = 3
GCPnts_Linear = GCPnts_DeflectionType.GCPnts_Linear
GCPnts_Circular = GCPnts_DeflectionType.GCPnts_Circular
GCPnts_Curved = GCPnts_DeflectionType.GCPnts_Curved
GCPnts_DefComposite = GCPnts_DeflectionType.GCPnts_DefComposite

class GCPnts_AbscissaPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU0: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0.

        Parameters
        ----------
        theTol: float
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU0: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0 with the given tolerance.

        Parameters
        ----------
        theTol: float
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU0: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0 with the given tolerance.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU0: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU0: float
        theUi: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0. theui is the starting value used in the iterative process which find the solution, it must be close to the final solution.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU0: float
        theUi: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0. theui is the starting value used in the iterative process which find the solution, it must be closed to the final solution.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU0: float
        theUi: float
        theTol: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0. theui is the starting value used in the iterative process which find the solution, it must be close to the final solution.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU0: float
        theUi: float
        theTol: float

        Return
        -------
        None

        Description
        -----------
        The algorithm computes a point on a curve at the distance theabscissa from the point of parameter theu0. theui is the starting value used in the iterative process which find the solution, it must be close to the final solution.

        """
        _GCPnts.GCPnts_AbscissaPoint_swiginit(self, _GCPnts.new_GCPnts_AbscissaPoint(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        True if the computation was successful, false otherwise. isdone is a protection against: - non-convergence of the algorithm - querying the results before computation.

        """
        return _GCPnts.GCPnts_AbscissaPoint_IsDone(self, *args)

    @staticmethod
    def Length(*args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 3d curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 2d curve.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theTol: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 3d curve with the given tolerance.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theTol: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 2d curve with the given tolerance.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theU1: float
        theU2: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 3d curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theU1: float
        theU2: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 2d curve.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theU1: float
        theU2: float
        theTol: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the 3d curve with the given tolerance.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theU1: float
        theU2: float
        theTol: float

        Return
        -------
        float

        Description
        -----------
        Computes the length of the curve with the given tolerance.

        """
        return _GCPnts.GCPnts_AbscissaPoint_Length(*args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the curve of the point solution of this algorithm. exceptions stdfail_notdone if the computation was not successful, or was not done.

        """
        return _GCPnts.GCPnts_AbscissaPoint_Parameter(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_AbscissaPoint

# Register GCPnts_AbscissaPoint in _GCPnts:
_GCPnts.GCPnts_AbscissaPoint_swigregister(GCPnts_AbscissaPoint)
class GCPnts_DistFunction2dMV(OCC.Core.math.math_MultipleVarFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theCurvLinDist: GCPnts_DistFunction2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GCPnts.GCPnts_DistFunction2dMV_swiginit(self, _GCPnts.new_GCPnts_DistFunction2dMV(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_DistFunction2dMV

# Register GCPnts_DistFunction2dMV in _GCPnts:
_GCPnts.GCPnts_DistFunction2dMV_swigregister(GCPnts_DistFunction2dMV)
class GCPnts_DistFunctionMV(OCC.Core.math.math_MultipleVarFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theCurvLinDist: GCPnts_DistFunction

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GCPnts.GCPnts_DistFunctionMV_swiginit(self, _GCPnts.new_GCPnts_DistFunctionMV(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_DistFunctionMV

# Register GCPnts_DistFunctionMV in _GCPnts:
_GCPnts.GCPnts_DistFunctionMV_swigregister(GCPnts_DistFunctionMV)
class GCPnts_QuasiUniformAbscissa(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty algorithm. to define the problem to be solved, use the function initialize.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points - on the curve where abscissa is the curvilinear distance between two consecutive points of the distribution.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theU1: float
        theU2: float

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the part of curve limited by the two parameter values theu1 and theu2, where abscissa is the curvilinear distance between two consecutive points of the distribution. the first point of the distribution is either the origin of curve or the point of parameter theu1. the following points are computed such that the curvilinear distance between two consecutive points is equal to abscissa. the last point of the distribution is either the end point of curve or the point of parameter theu2. however the curvilinear distance between this last point and the point just preceding it in the distribution is, of course, generally not equal to abscissa. use the function isdone() to verify that the computation was successful, the function nbpoints() to obtain the number of points of the computed distribution, and the function parameter() to read the parameter of each point. //! warning the roles of theu1 and theu2 are inverted if theu1 > theu2. warning thec is an adapted curve, that is, an object which is an interface between: - the services provided by either a 2d curve from the package geom2d (in the case of an adaptor2d_curve2d curve) or a 3d curve from the package geom (in the case of an adaptor3d_curve curve), - and those required on the curve by the computation algorithm. @param thec [in] input 3d curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the 2d curve. @param thec [in] input 2d curve @param thenbpoints [in] defines the number of desired points.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theU1: float
        theU2: float

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on a part of the 2d curve. @param thec [in] input 2d curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve.

        """
        _GCPnts.GCPnts_QuasiUniformAbscissa_swiginit(self, _GCPnts.new_GCPnts_QuasiUniformAbscissa(*args))

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve and target number of points. @param thec [in] input 3d curve @param thenbpoints [in] defines the number of desired points.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theU1: float
        theU2: float

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, target number of points and curve parameter range. @param thec [in] input 3d curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve and target number of points. @param thec [in] input 2d curve @param thenbpoints [in] defines the number of desired points.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theU1: float
        theU2: float

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve, target number of points and curve parameter range. @param thec [in] input 2d curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve.

        """
        return _GCPnts.GCPnts_QuasiUniformAbscissa_Initialize(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful. isdone is a protection against: - non-convergence of the algorithm - querying the results before computation.

        """
        return _GCPnts.GCPnts_QuasiUniformAbscissa_IsDone(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points of the distribution computed by this algorithm. this value is either: - the one imposed on the algorithm at the time of construction (or initialization), or - the one computed by the algorithm when the curvilinear distance between two consecutive points of the distribution is imposed on the algorithm at the time of construction (or initialization). exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformAbscissa_NbPoints(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter of the point of index index in the distribution computed by this algorithm. warning index must be greater than or equal to 1, and less than or equal to the number of points of the distribution. however, pay particular attention as this condition is not checked by this function. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformAbscissa_Parameter(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_QuasiUniformAbscissa

# Register GCPnts_QuasiUniformAbscissa in _GCPnts:
_GCPnts.GCPnts_QuasiUniformAbscissa_swigregister(GCPnts_QuasiUniformAbscissa)
class GCPnts_QuasiUniformDeflection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty algorithm. to define the problem to be solved, use the function initialize().

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Computes a quasiuniform deflection distribution of points on the curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Computes a quasiuniform deflection distribution of points on the curve.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theU1: float
        theU2: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Computes a quasiuniform deflection distribution of points on a part of the curve.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theU1: float
        theU2: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Computes a quasiuniform deflection distribution of points on a part of the curve. this and the above algorithms compute a distribution of points: - on the curve thec, or - on the part of curve thec limited by the two parameter values theu1 and theu2, where the deflection resulting from the distributed points is not greater than thedeflection. //! the first point of the distribution is either the origin of curve thec or the point of parameter theu1. the last point of the distribution is either the end point of curve thec or the point of parameter theu2. //! intermediate points of the distribution are built such that the deflection is not greater than thedeflection. using the following evaluation of the deflection: if pi and pj are two consecutive points of the distribution, respectively of parameter ui and uj on the curve, the deflection is the distance between: - the mid-point of pi and pj (the center of the chord joining these two points) - and the point of mid-parameter of these two points (the point of parameter [(ui+uj) / 2] on curve thec). thecontinuity, defaulted to geomabs_c1, gives the degree of continuity of the curve thec. (note that c is an adaptor3d_curve or an adaptor2d_curve2d object, and does not know the degree of continuity of the underlying curve). use the function isdone() to verify that the computation was successful, the function nbpoints() to obtain the number of points of the computed distribution, and the function parameter() to read the parameter of each point. //! warning - the roles of theu1 and theu2 are inverted if theu1 > theu2. - derivative functions on the curve are called according to thecontinuity. an error may occur if thecontinuity is greater than the real degree of continuity of the curve. //! warning thec is an adapted curve, i.e. an object which is an interface between: - the services provided by either a 2d curve from the package geom2d (in the case of an adaptor2d_curve2d curve) or a 3d curve from the package geom (in the case of an adaptor3d_curve curve), - and those required on the curve by the computation algorithm.

        """
        _GCPnts.GCPnts_QuasiUniformDeflection_swiginit(self, _GCPnts.new_GCPnts_QuasiUniformDeflection(*args))

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection between the curve and the polygon resulting from the points of the distribution computed by this algorithm. this is the value given to the algorithm at the time of construction (or initialization). exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_Deflection(self, *args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve and deflection.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve and deflection.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theU1: float
        theU2: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, deflection and parameter range.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theU1: float
        theU2: float
        theContinuity: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with thec, thedeflection, theu1, theu2. this and the above algorithms initialize (or reinitialize) this algorithm and compute a distribution of points: - on the curve thec, or - on the part of curve thec limited by the two parameter values theu1 and theu2, where the deflection resulting from the distributed points is not greater than thedeflection. //! the first point of the distribution is either the origin of curve thec or the point of parameter theu1. the last point of the distribution is either the end point of curve thec or the point of parameter theu2. //! intermediate points of the distribution are built in such a way that the deflection is not greater than thedeflection. using the following evaluation of the deflection: if pi and pj are two consecutive points of the distribution, respectively of parameter ui and uj on the curve, the deflection is the distance between: - the mid-point of pi and pj (the center of the chord joining these two points) - and the point of mid-parameter of these two points (the point of parameter [(ui+uj) / 2] on curve thec). thecontinuity, defaulted to geomabs_c1, gives the degree of continuity of the curve thec. (note that c is an adaptor3d_curve or an adaptor2d_curve2d object, and does not know the degree of continuity of the underlying curve). use the function isdone to verify that the computation was successful, the function nbpoints() to obtain the number of points of the computed distribution, and the function parameter() to read the parameter of each point. //! warning - the roles of theu1 and theu2 are inverted if theu1 > theu2. - derivative functions on the curve are called according to thecontinuity. an error may occur if thecontinuity is greater than the real degree of continuity of the curve. //! warning thec is an adapted curve, i.e. an object which is an interface between: - the services provided by either a 2d curve from the package geom2d (in the case of an adaptor2d_curve2d curve) or a 3d curve from the package geom (in the case of an adaptor3d_curve curve), and those required on the curve by the computation algorithm.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_Initialize(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful. isdone is a protection against: - non-convergence of the algorithm - querying the results before computation.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_IsDone(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points of the distribution computed by this algorithm. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_NbPoints(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter of the point of index index in the distribution computed by this algorithm. warning index must be greater than or equal to 1, and less than or equal to the number of points of the distribution. however, pay particular attention as this condition is not checked by this function. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_Parameter(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point of index index in the distribution computed by this algorithm. warning index must be greater than or equal to 1, and less than or equal to the number of points of the distribution. however, pay particular attention as this condition is not checked by this function. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_QuasiUniformDeflection_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_QuasiUniformDeflection

# Register GCPnts_QuasiUniformDeflection in _GCPnts:
_GCPnts.GCPnts_QuasiUniformDeflection_swigregister(GCPnts_QuasiUniformDeflection)
class GCPnts_TangentialDeflection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor. @sa initialize().

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Constructor for 3d curve. @param thec [in] 3d curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theFirstParameter: float
        theLastParameter: float
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Constructor for 3d curve with restricted range. @param thec [in] 3d curve @param thefirstparameter [in] first parameter on curve @param thelastparameter [in] last parameter on curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theuto l [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Constructor for 2d curve. @param thec [in] 2d curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theFirstParameter: float
        theLastParameter: float
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Constructor for 2d curve with restricted range. @param thec [in] 2d curve @param thefirstparameter [in] first parameter on curve @param thelastparameter [in] last parameter on curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        """
        _GCPnts.GCPnts_TangentialDeflection_swiginit(self, _GCPnts.new_GCPnts_TangentialDeflection(*args))

    def AddPoint(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_Pnt
        theParam: float
        theIsReplace: bool (optional, default to Standard_True)

        Return
        -------
        int

        Description
        -----------
        Add point to already calculated points (or replace existing) returns index of new added point or founded with parametric tolerance (replaced if theisreplace is true).

        """
        return _GCPnts.GCPnts_TangentialDeflection_AddPoint(self, *args)

    @staticmethod
    def ArcAngularStep(*args):
        r"""

        Parameters
        ----------
        theRadius: float
        theLinearDeflection: float
        theAngularDeflection: float
        theMinLength: float

        Return
        -------
        float

        Description
        -----------
        Computes angular step for the arc using the given parameters.

        """
        return _GCPnts.GCPnts_TangentialDeflection_ArcAngularStep(*args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Initialize algorithm for 3d curve. @param thec [in] 3d curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theFirstParameter: float
        theLastParameter: float
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Initialize algorithm for 3d curve with restricted range. @param thec [in] 3d curve @param thefirstparameter [in] first parameter on curve @param thelastparameter [in] last parameter on curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Initialize algorithm for 2d curve. @param thec [in] 2d curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theFirstParameter: float
        theLastParameter: float
        theAngularDeflection: float
        theCurvatureDeflection: float
        theMinimumOfPoints: int (optional, default to 2)
        theUTol: float (optional, default to 1.0e-9)
        theMinLen: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        Initialize algorithm for 2d curve with restricted range. @param thec [in] 2d curve @param thefirstparameter [in] first parameter on curve @param thelastparameter [in] last parameter on curve @param theangulardeflection [in] angular deflection in radians @param thecurvaturedeflection [in] linear deflection @param theminimumofpoints [in] minimum number of points @param theutol [in] tolerance in curve parametric scope @param theminlen [in] minimal length.

        """
        return _GCPnts.GCPnts_TangentialDeflection_Initialize(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _GCPnts.GCPnts_TangentialDeflection_NbPoints(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _GCPnts.GCPnts_TangentialDeflection_Parameter(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _GCPnts.GCPnts_TangentialDeflection_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_TangentialDeflection

# Register GCPnts_TangentialDeflection in _GCPnts:
_GCPnts.GCPnts_TangentialDeflection_swigregister(GCPnts_TangentialDeflection)
class GCPnts_UniformAbscissa(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creation of a indefinite uniformabscissa.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the 3d curve. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on a part of the 3d curve. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the 3d curve. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on a part of the 3d curve. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the 2d curve. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on a part of the 2d curve. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on the 2d curve. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform abscissa distribution of points on a part of the 2d curve. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        """
        _GCPnts.GCPnts_UniformAbscissa_swiginit(self, _GCPnts.new_GCPnts_UniformAbscissa(*args))

    def Abscissa(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the current abscissa, i.e. the distance between two consecutive points.

        """
        return _GCPnts.GCPnts_UniformAbscissa_Abscissa(self, *args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, abscissa, and tolerance. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theAbscissa: float
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, abscissa, tolerance, and parameter range. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, number of points, and tolerance. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theNbPoints: int
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, number of points, tolerance, and parameter range. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve, abscissa, and tolerance. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theAbscissa: float
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve, abscissa, tolerance, and parameter range. @param thec [in] input curve @param theabscissa [in] abscissa (distance between two consecutive points) @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve, number of points, and tolerance. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theNbPoints: int
        theU1: float
        theU2: float
        theToler: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve, number of points, tolerance, and parameter range. @param thec [in] input curve @param thenbpoints [in] defines the number of desired points @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thetoler [in] used for more precise calculation of curve length  (precision::confusion() by default).

        """
        return _GCPnts.GCPnts_UniformAbscissa_Initialize(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _GCPnts.GCPnts_UniformAbscissa_IsDone(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _GCPnts.GCPnts_UniformAbscissa_NbPoints(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the computed parameter of index <index>.

        """
        return _GCPnts.GCPnts_UniformAbscissa_Parameter(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_UniformAbscissa

# Register GCPnts_UniformAbscissa in _GCPnts:
_GCPnts.GCPnts_UniformAbscissa_swigregister(GCPnts_UniformAbscissa)
class GCPnts_UniformDeflection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty algorithm. to define the problem to be solved, use the function initialize.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform deflection distribution of points on the curve. @param thec [in] input 3d curve @param thedeflection [in] target deflection @param thewithcontrol [in] when true, the algorithm controls the estimate deflection.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform deflection distribution of points on the curve. @param thec [in] input 2d curve @param thedeflection [in] target deflection @param thewithcontrol [in] when true, the algorithm controls the estimate deflection.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theU1: float
        theU2: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform deflection distribution of points on a part of the curve. @param thec [in] input 3d curve @param thedeflection [in] target deflection @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thewithcontrol [in] when true, the algorithm controls the estimate deflection.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theU1: float
        theU2: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Computes a uniform deflection distribution of points on a part of the curve. @param thec [in] input 2d curve @param thedeflection [in] target deflection @param theu1 [in] first parameter on curve @param theu2 [in] last parameter on curve @param thewithcontrol [in] when true, the algorithm controls the estimate deflection.

        """
        _GCPnts.GCPnts_UniformDeflection_swiginit(self, _GCPnts.new_GCPnts_UniformDeflection(*args))

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection between the curve and the polygon resulting from the points of the distribution computed by this algorithm. this value is the one given to the algorithm at the time of construction (or initialization). exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_UniformDeflection_Deflection(self, *args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve and deflection.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 2d curve and deflection.

        Parameters
        ----------
        theC: Adaptor3d_Curve
        theDeflection: float
        theU1: float
        theU2: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with 3d curve, deflection, parameter range.

        Parameters
        ----------
        theC: Adaptor2d_Curve2d
        theDeflection: float
        theU1: float
        theU2: float
        theWithControl: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithms with curve, deflection, parameter range. this and the above methods initialize (or reinitialize) this algorithm and compute a distribution of points: - on the curve thec, or - on the part of curve thec limited by the two parameter values theu1 and theu2, where the maximum distance between thec and the polygon that results from the points of the distribution is not greater than thedeflection. the first point of the distribution is either the origin of curve thec or the point of parameter theu1. the last point of the distribution is either the end point of curve thec or the point of parameter theu2. intermediate points of the distribution are built using interpolations of segments of the curve limited at the 2nd degree. the construction ensures, in a first step, that the chordal deviation for this interpolation of the curve is less than or equal to thedeflection. however, it does not ensure that the chordal deviation for the curve itself is less than or equal to thedeflection. to do this a check is necessary, which may generate (second step) additional intermediate points. this check is time consuming, and can be avoided by setting thewithcontrol to false. note that by default thewithcontrol is true and check is performed. use the function isdone to verify that the computation was successful, the function nbpoints() to obtain the number of points of the computed distribution, and the function parameter to read the parameter of each point. //! warning - thec is necessary, 'c2' continuous. this property is not checked at construction time. - the roles of theu1 and theu2 are inverted if theu1 > theu2. //! warning thec is an adapted curve, i.e. an object which is an interface between: - the services provided by either a 2d curve from the package geom2d (in the case of an adaptor2d_curve2d curve) or a 3d curve from the package geom (in the case of an adaptor3d_curve curve), - and those required on the curve by the computation algorithm.

        """
        return _GCPnts.GCPnts_UniformDeflection_Initialize(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful. isdone is a protection against: - non-convergence of the algorithm - querying the results before computation.

        """
        return _GCPnts.GCPnts_UniformDeflection_IsDone(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points of the distribution computed by this algorithm. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_UniformDeflection_NbPoints(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter of the point of index index in the distribution computed by this algorithm. warning index must be greater than or equal to 1, and less than or equal to the number of points of the distribution. however, pay particular attention as this condition is not checked by this function. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_UniformDeflection_Parameter(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point of index index in the distribution computed by this algorithm. warning index must be greater than or equal to 1, and less than or equal to the number of points of the distribution. however, pay particular attention as this condition is not checked by this function. exceptions stdfail_notdone if this algorithm has not been initialized, or if the computation was not successful.

        """
        return _GCPnts.GCPnts_UniformDeflection_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GCPnts.delete_GCPnts_UniformDeflection

# Register GCPnts_UniformDeflection in _GCPnts:
_GCPnts.GCPnts_UniformDeflection_swigregister(GCPnts_UniformDeflection)

@classnotwrapped
class GCPnts_DistFunction:
	pass

@classnotwrapped
class GCPnts_DistFunction2d:
	pass

@classnotwrapped
class GCPnts_TCurveTypes:
	pass





@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_AbscissaPoint_Length(*args):
	return GCPnts_AbscissaPoint.Length(*args)

@deprecated
def GCPnts_TangentialDeflection_ArcAngularStep(*args):
	return GCPnts_TangentialDeflection.ArcAngularStep(*args)



