from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *


class Intrv_SequenceOfInterval:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Intrv_Interval: ...
    def Last(self) -> Intrv_Interval: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Intrv_Interval) -> Intrv_Interval: ...
    def Prepend(self, theItem: Intrv_Interval) -> Intrv_Interval: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Intrv_Interval: ...
    def SetValue(self, theIndex: int, theValue: Intrv_Interval) -> None: ...

class Intrv_Position(IntEnum):
    Intrv_Before: int = ...
    Intrv_JustBefore: int = ...
    Intrv_OverlappingAtStart: int = ...
    Intrv_JustEnclosingAtEnd: int = ...
    Intrv_Enclosing: int = ...
    Intrv_JustOverlappingAtStart: int = ...
    Intrv_Similar: int = ...
    Intrv_JustEnclosingAtStart: int = ...
    Intrv_Inside: int = ...
    Intrv_JustOverlappingAtEnd: int = ...
    Intrv_OverlappingAtEnd: int = ...
    Intrv_JustAfter: int = ...
    Intrv_After: int = ...

Intrv_Before = Intrv_Position.Intrv_Before
Intrv_JustBefore = Intrv_Position.Intrv_JustBefore
Intrv_OverlappingAtStart = Intrv_Position.Intrv_OverlappingAtStart
Intrv_JustEnclosingAtEnd = Intrv_Position.Intrv_JustEnclosingAtEnd
Intrv_Enclosing = Intrv_Position.Intrv_Enclosing
Intrv_JustOverlappingAtStart = Intrv_Position.Intrv_JustOverlappingAtStart
Intrv_Similar = Intrv_Position.Intrv_Similar
Intrv_JustEnclosingAtStart = Intrv_Position.Intrv_JustEnclosingAtStart
Intrv_Inside = Intrv_Position.Intrv_Inside
Intrv_JustOverlappingAtEnd = Intrv_Position.Intrv_JustOverlappingAtEnd
Intrv_OverlappingAtEnd = Intrv_Position.Intrv_OverlappingAtEnd
Intrv_JustAfter = Intrv_Position.Intrv_JustAfter
Intrv_After = Intrv_Position.Intrv_After

class Intrv_Interval:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Start: float, End: float) -> None: ...
    @overload
    def __init__(self, Start: float, TolStart: float, End: float, TolEnd: float) -> None: ...
    def Bounds(self) -> Tuple[float, float, float, float]: ...
    def CutAtEnd(self, End: float, TolEnd: float) -> None: ...
    def CutAtStart(self, Start: float, TolStart: float) -> None: ...
    def End(self) -> float: ...
    def FuseAtEnd(self, End: float, TolEnd: float) -> None: ...
    def FuseAtStart(self, Start: float, TolStart: float) -> None: ...
    def IsAfter(self, Other: Intrv_Interval) -> bool: ...
    def IsBefore(self, Other: Intrv_Interval) -> bool: ...
    def IsEnclosing(self, Other: Intrv_Interval) -> bool: ...
    def IsInside(self, Other: Intrv_Interval) -> bool: ...
    def IsJustAfter(self, Other: Intrv_Interval) -> bool: ...
    def IsJustBefore(self, Other: Intrv_Interval) -> bool: ...
    def IsJustEnclosingAtEnd(self, Other: Intrv_Interval) -> bool: ...
    def IsJustEnclosingAtStart(self, Other: Intrv_Interval) -> bool: ...
    def IsJustOverlappingAtEnd(self, Other: Intrv_Interval) -> bool: ...
    def IsJustOverlappingAtStart(self, Other: Intrv_Interval) -> bool: ...
    def IsOverlappingAtEnd(self, Other: Intrv_Interval) -> bool: ...
    def IsOverlappingAtStart(self, Other: Intrv_Interval) -> bool: ...
    def IsProbablyEmpty(self) -> bool: ...
    def IsSimilar(self, Other: Intrv_Interval) -> bool: ...
    def Position(self, Other: Intrv_Interval) -> Intrv_Position: ...
    def SetEnd(self, End: float, TolEnd: float) -> None: ...
    def SetStart(self, Start: float, TolStart: float) -> None: ...
    def Start(self) -> float: ...
    def TolEnd(self) -> float: ...
    def TolStart(self) -> float: ...

class Intrv_Intervals:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Int: Intrv_Interval) -> None: ...
    @overload
    def Intersect(self, Tool: Intrv_Interval) -> None: ...
    @overload
    def Intersect(self, Tool: Intrv_Intervals) -> None: ...
    def NbIntervals(self) -> int: ...
    @overload
    def Subtract(self, Tool: Intrv_Interval) -> None: ...
    @overload
    def Subtract(self, Tool: Intrv_Intervals) -> None: ...
    @overload
    def Unite(self, Tool: Intrv_Interval) -> None: ...
    @overload
    def Unite(self, Tool: Intrv_Intervals) -> None: ...
    def Value(self, Index: int) -> Intrv_Interval: ...
    @overload
    def XUnite(self, Tool: Intrv_Interval) -> None: ...
    @overload
    def XUnite(self, Tool: Intrv_Intervals) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes

