# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wl_surface import WlSurface


class WlTouch(Interface):
    """Touchscreen input device

    The :class:`WlTouch` interface represents a touchscreen associated with a
    seat.

    Touch interactions can consist of one or more contacts. For each contact, a
    series of events is generated, starting with a down event, followed by zero
    or more motion events, and ending with an up event. Events relating to the
    same contact point can be identified by the ID of the sequence.
    """

    name = "wl_touch"
    version = 9


class WlTouchProxy(Proxy[WlTouch]):
    interface = WlTouch

    @WlTouch.request(version=3)
    def release(self) -> None:
        """Release the touch object
        """
        self._marshal(0)
        self._destroy()


class WlTouchResource(Resource):
    interface = WlTouch

    @WlTouch.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def down(self, serial: int, time: int, surface: WlSurface, id: int, x: float, y: float) -> None:
        """Touch down event and beginning of a touch sequence

        A new touch point has appeared on the surface. This touch point is
        assigned a unique ID. Future events from this touch point reference
        this ID. The ID ceases to be valid after a touch up event and may be
        reused in the future.

        :param serial:
            serial number of the touch down event
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param surface:
            surface touched
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param id:
            the unique ID of this touch point
        :type id:
            `ArgumentType.Int`
        :param x:
            surface-local x coordinate
        :type x:
            `ArgumentType.Fixed`
        :param y:
            surface-local y coordinate
        :type y:
            `ArgumentType.Fixed`
        """
        self._post_event(0, serial, time, surface, id, x, y)

    @WlTouch.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
    )
    def up(self, serial: int, time: int, id: int) -> None:
        """End of a touch event sequence

        The touch point has disappeared. No further events will be sent for
        this touch point and the touch point's ID is released and may be reused
        in a future touch down event.

        :param serial:
            serial number of the touch up event
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param id:
            the unique ID of this touch point
        :type id:
            `ArgumentType.Int`
        """
        self._post_event(1, serial, time, id)

    @WlTouch.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def motion(self, time: int, id: int, x: float, y: float) -> None:
        """Update of touch point coordinates

        A touch point has changed coordinates.

        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param id:
            the unique ID of this touch point
        :type id:
            `ArgumentType.Int`
        :param x:
            surface-local x coordinate
        :type x:
            `ArgumentType.Fixed`
        :param y:
            surface-local y coordinate
        :type y:
            `ArgumentType.Fixed`
        """
        self._post_event(2, time, id, x, y)

    @WlTouch.event()
    def frame(self) -> None:
        """End of touch frame event

        Indicates the end of a set of events that logically belong together. A
        client is expected to accumulate the data in all events within the
        frame before proceeding.

        A :func:`WlTouch.frame()` terminates at least one event but otherwise
        no guarantee is provided about the set of events within a frame. A
        client must assume that any state not updated in a frame is unchanged
        from the previously known state.
        """
        self._post_event(3)

    @WlTouch.event()
    def cancel(self) -> None:
        """Touch session cancelled

        Sent if the compositor decides the touch stream is a global gesture. No
        further events are sent to the clients from that particular gesture.
        Touch cancellation applies to all touch points currently active on this
        client's surface. The client is responsible for finalizing the touch
        points, future touch points on this surface may reuse the touch point
        ID.
        """
        self._post_event(4)

    @WlTouch.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        version=6,
    )
    def shape(self, id: int, major: float, minor: float) -> None:
        """Update shape of touch point

        Sent when a touchpoint has changed its shape.

        This event does not occur on its own. It is sent before a
        :func:`WlTouch.frame()` event and carries the new shape information for
        any previously reported, or new touch points of that frame.

        Other events describing the touch point such as :func:`WlTouch.down()`,
        :func:`WlTouch.motion()` or :func:`WlTouch.orientation()` may be sent
        within the same :func:`WlTouch.frame()`. A client should treat these
        events as a single logical touch point update. The order of
        :func:`WlTouch.shape()`, :func:`WlTouch.orientation()` and
        :func:`WlTouch.motion()` is not guaranteed. A :func:`WlTouch.down()`
        event is guaranteed to occur before the first :func:`WlTouch.shape()`
        event for this touch ID but both events may occur within the same
        :func:`WlTouch.frame()`.

        A touchpoint shape is approximated by an ellipse through the major and
        minor axis length. The major axis length describes the longer diameter
        of the ellipse, while the minor axis length describes the shorter
        diameter. Major and minor are orthogonal and both are specified in
        surface-local coordinates. The center of the ellipse is always at the
        touchpoint location as reported by :func:`WlTouch.down()` or
        :func:`WlTouch.move()`.

        This event is only sent by the compositor if the touch device supports
        shape reports. The client has to make reasonable assumptions about the
        shape if it did not receive this event.

        :param id:
            the unique ID of this touch point
        :type id:
            `ArgumentType.Int`
        :param major:
            length of the major axis in surface-local coordinates
        :type major:
            `ArgumentType.Fixed`
        :param minor:
            length of the minor axis in surface-local coordinates
        :type minor:
            `ArgumentType.Fixed`
        """
        self._post_event(5, id, major, minor)

    @WlTouch.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Fixed),
        version=6,
    )
    def orientation(self, id: int, orientation: float) -> None:
        """Update orientation of touch point

        Sent when a touchpoint has changed its orientation.

        This event does not occur on its own. It is sent before a
        :func:`WlTouch.frame()` event and carries the new shape information for
        any previously reported, or new touch points of that frame.

        Other events describing the touch point such as :func:`WlTouch.down()`,
        :func:`WlTouch.motion()` or :func:`WlTouch.shape()` may be sent within
        the same :func:`WlTouch.frame()`. A client should treat these events as
        a single logical touch point update. The order of
        :func:`WlTouch.shape()`, :func:`WlTouch.orientation()` and
        :func:`WlTouch.motion()` is not guaranteed. A :func:`WlTouch.down()`
        event is guaranteed to occur before the first
        :func:`WlTouch.orientation()` event for this touch ID but both events
        may occur within the same :func:`WlTouch.frame()`.

        The orientation describes the clockwise angle of a touchpoint's major
        axis to the positive surface y-axis and is normalized to the -180 to
        +180 degree range. The granularity of orientation depends on the touch
        device, some devices only support binary rotation values between 0 and
        90 degrees.

        This event is only sent by the compositor if the touch device supports
        orientation reports.

        :param id:
            the unique ID of this touch point
        :type id:
            `ArgumentType.Int`
        :param orientation:
            angle between major axis and positive surface y-axis in degrees
        :type orientation:
            `ArgumentType.Fixed`
        """
        self._post_event(6, id, orientation)


class WlTouchGlobal(Global):
    interface = WlTouch


WlTouch._gen_c()
WlTouch.proxy_class = WlTouchProxy
WlTouch.resource_class = WlTouchResource
WlTouch.global_class = WlTouchGlobal
