"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.comparePosition = exports.isAfter = exports.isBeforeOrEqual = exports.isBefore = exports.translatePosition = exports.isPosition = exports.arePositionsEqual = void 0;
function arePositionsEqual(a, b) {
    return a.line === b.line && a.character === b.character;
}
exports.arePositionsEqual = arePositionsEqual;
function isPosition(other) {
    if (!other) {
        return false;
    }
    const { line, character } = other;
    return typeof line === 'number' && typeof character === 'number';
}
exports.isPosition = isPosition;
function translatePosition(pos, change) {
    return {
        line: pos.line + (change.lineDelta ?? 0),
        character: pos.character + (change.characterDelta ?? 0),
    };
}
exports.translatePosition = translatePosition;
function isBefore(pos, other) {
    if (pos.line < other.line) {
        return true;
    }
    if (other.line < pos.line) {
        return false;
    }
    return pos.character < other.character;
}
exports.isBefore = isBefore;
function isBeforeOrEqual(pos, other) {
    if (pos.line < other.line) {
        return true;
    }
    if (other.line < pos.line) {
        return false;
    }
    return pos.character <= other.character;
}
exports.isBeforeOrEqual = isBeforeOrEqual;
function isAfter(pos, other) {
    return !isBeforeOrEqual(pos, other);
}
exports.isAfter = isAfter;
function comparePosition(a, b) {
    if (a.line < b.line) {
        return -1;
    }
    else if (a.line > b.line) {
        return 1;
    }
    else {
        // equal line
        if (a.character < b.character) {
            return -1;
        }
        else if (a.character > b.character) {
            return 1;
        }
        else {
            // equal line and character
            return 0;
        }
    }
}
exports.comparePosition = comparePosition;
//# sourceMappingURL=position.js.map