"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const nls = __importStar(require("vscode-nls"));
const resolve_1 = require("./resolve");
const localize = nls.loadMessageBundle(); // TODO: not working
const defaultJsDoc = `/**\n * $0\n */`;
function register(ctx) {
    return (uri, position) => {
        const document = ctx.getTextDocument(uri);
        if (!document)
            return;
        if (!isPotentiallyValidDocCompletionPosition(document, position))
            return;
        const fileName = ctx.env.uriToFileName(document.uri);
        const offset = document.offsetAt(position);
        const docCommentTemplate = ctx.typescript.languageService.getDocCommentTemplateAtPosition(fileName, offset);
        if (!docCommentTemplate)
            return;
        let insertText;
        // Workaround for #43619
        // docCommentTemplate previously returned undefined for empty jsdoc templates.
        // TS 2.7 now returns a single line doc comment, which breaks indentation.
        if (docCommentTemplate.newText === '/** */') {
            insertText = defaultJsDoc;
        }
        else {
            insertText = templateToSnippet(docCommentTemplate.newText);
        }
        const item = createCompletionItem(document, position, insertText);
        return item;
    };
}
exports.register = register;
function createCompletionItem(document, position, insertText) {
    const item = { label: '/** */' };
    item.kind = 1;
    item.detail = localize('typescript.jsDocCompletionItem.documentation', 'JSDoc comment');
    item.sortText = '\0';
    item.insertTextFormat = 2;
    const line = (0, resolve_1.getLineText)(document, position.line);
    const prefix = line.slice(0, position.character).match(/\/\**\s*$/);
    const suffix = line.slice(position.character).match(/^\s*\**\//);
    const start = { line: position.line, character: position.character + (prefix ? -prefix[0].length : 0) };
    const end = { line: position.line, character: position.character + (suffix ? suffix[0].length : 0) };
    const range = { start, end };
    item.textEdit = { range, newText: insertText };
    return item;
}
function isPotentiallyValidDocCompletionPosition(document, position) {
    // Only show the JSdoc completion when the everything before the cursor is whitespace
    // or could be the opening of a comment
    const line = (0, resolve_1.getLineText)(document, position.line);
    const prefix = line.slice(0, position.character);
    if (!/^\s*$|\/\*\*\s*$|^\s*\/\*\*+\s*$/.test(prefix)) {
        return false;
    }
    // And everything after is possibly a closing comment or more whitespace
    const suffix = line.slice(position.character);
    return /^\s*(\*+\/)?\s*$/.test(suffix);
}
function templateToSnippet(template) {
    // TODO: use append placeholder
    let snippetIndex = 1;
    template = template.replace(/\$/g, '\\$');
    template = template.replace(/^[ \t]*(?=(\/|[ ]\*))/gm, '');
    template = template.replace(/^(\/\*\*\s*\*[ ]*)$/m, (x) => x + `\$0`);
    template = template.replace(/\* @param([ ]\{\S+\})?\s+(\S+)[ \t]*$/gm, (_param, type, post) => {
        let out = '* @param ';
        if (type === ' {any}' || type === ' {*}') {
            out += `{\$\{${snippetIndex++}:*\}} `;
        }
        else if (type) {
            out += type + ' ';
        }
        out += post + ` \${${snippetIndex++}}`;
        return out;
    });
    template = template.replace(/\* @returns[ \t]*$/gm, `* @returns \${${snippetIndex++}}`);
    return template;
}
//# sourceMappingURL=jsDoc.js.map