"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDirectoryContents = void 0;
var path_posix_1 = __importDefault(require("path-posix"));
var url_1 = require("../tools/url");
var path_1 = require("../tools/path");
var dav_1 = require("../tools/dav");
var request_1 = require("../request");
var response_1 = require("../response");
function getDirectoryContents(context, remotePath, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var requestOptions, response, davResp, files;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    requestOptions = (0, request_1.prepareRequestOptions)({
                        url: (0, url_1.joinURL)(context.remoteURL, (0, path_1.encodePath)(remotePath), "/"),
                        method: "PROPFIND",
                        headers: {
                            Accept: "text/plain",
                            Depth: options.deep ? "infinity" : "1"
                        },
                        responseType: "text"
                    }, context, options);
                    return [4 /*yield*/, (0, request_1.request)(requestOptions)];
                case 1:
                    response = _a.sent();
                    (0, response_1.handleResponseCode)(context, response);
                    return [4 /*yield*/, (0, dav_1.parseXML)(response.data)];
                case 2:
                    davResp = _a.sent();
                    files = getDirectoryFiles(davResp, context.remotePath, remotePath, options.details);
                    if (options.glob) {
                        files = (0, response_1.processGlobFilter)(files, options.glob);
                    }
                    return [2 /*return*/, (0, response_1.processResponsePayload)(response, files, options.details)];
            }
        });
    });
}
exports.getDirectoryContents = getDirectoryContents;
function getDirectoryFiles(result, serverBasePath, requestPath, isDetailed) {
    if (isDetailed === void 0) { isDetailed = false; }
    var serverBase = path_posix_1.default.join(serverBasePath, "/");
    // Extract the response items (directory contents)
    var responseItems = result.multistatus.response;
    return (responseItems
        // Map all items to a consistent output structure (results)
        .map(function (item) {
        // HREF is the file path (in full)
        var href = (0, url_1.normaliseHREF)(item.href);
        // Each item should contain a stat object
        var props = item.propstat.prop;
        // Process the true full filename (minus the base server path)
        var filename = serverBase === "/"
            ? decodeURIComponent((0, path_1.normalisePath)(href))
            : decodeURIComponent((0, path_1.normalisePath)(path_posix_1.default.relative(serverBase, href)));
        return (0, dav_1.prepareFileFromProps)(props, filename, isDetailed);
    })
        // Filter out the item pointing to the current directory (not needed)
        .filter(function (item) {
        return item.basename &&
            (item.type === "file" || item.filename !== requestPath.replace(/\/$/, ""));
    }));
}
