/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.SourceInfo;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.babel.BabelFilterPanel;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;
import tim.prune.save.GpxExporter;

public abstract class BabelLoadFunction
extends GenericFunction {
    private boolean _gpsBabelChecked = false;
    protected JDialog _dialog = null;
    protected JCheckBox _waypointCheckbox = null;
    protected JCheckBox _trackCheckbox = null;
    protected JCheckBox _saveCheckbox = null;
    private JButton _okButton = null;
    protected JProgressBar _progressBar = null;
    protected File _saveFile = null;
    protected boolean _cancelled = false;
    protected BabelFilterPanel _filterPanel = null;

    public BabelLoadFunction(App app) {
        super(app);
    }

    @Override
    public void begin() {
        if (this._gpsBabelChecked || ExternalTools.isToolInstalled(1) || JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.gpsload.nogpsbabel"), this.getName(), 0, 2) == 0) {
            this._gpsBabelChecked = true;
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, this.getName(), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._okButton = new JButton(I18nManager.getText("button.ok"));
                this._okButton.addActionListener(actionEvent -> this.okPressed());
                this._dialog.getContentPane().add(this.makeDialogComponents(this._okButton));
                this._dialog.pack();
            }
            this.enableOkButton();
            this.setupProgressBar(true);
            this.initDialog();
            this._dialog.setVisible(true);
        }
    }

    protected void okPressed() {
        this._cancelled = false;
        new Thread(this::run).start();
    }

    protected abstract JPanel makeDialogComponents(JButton var1);

    protected void initDialog() {
        this._filterPanel.setFilterString(Config.getConfigString("prune.gpsbabelfilter"));
    }

    private void setupProgressBar(boolean bl) {
        this._progressBar.setVisible(!bl);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
    }

    protected void enableOkButton() {
        this._okButton.setEnabled(this.isInputOk());
    }

    protected abstract boolean isInputOk();

    public void run() {
        this._okButton.setEnabled(false);
        this.setupProgressBar(false);
        if (this.isInputOk()) {
            this._progressBar.setIndeterminate(true);
            this._saveFile = null;
            try {
                this.callGpsBabel();
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), exception.getMessage());
                this._cancelled = true;
            }
        }
        this.setupProgressBar(true);
        this.enableOkButton();
        if (!this._cancelled) {
            this._dialog.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void callGpsBabel() throws Exception {
        Object object;
        String[] stringArray = this.getCommandArray();
        this.saveConfigValues();
        String string = "";
        String string2 = "";
        XmlHandler xmlHandler = null;
        Process process = Runtime.getRuntime().exec(stringArray);
        String string3 = null;
        if (this._saveFile != null) {
            process.waitFor();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    string = String.valueOf(string) + string3 + "\n";
                }
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {}
            if (process.exitValue() == 0) {
                SwingUtilities.invokeLater(() -> {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    arrayList.add(this._saveFile);
                    this._app.loadDataFiles(arrayList);
                });
                return;
            }
            if (string.length() <= 0) throw new Exception(I18nManager.getText("error.gpsload.unknown"));
            throw new Exception(string);
        }
        try {
            object = new XmlFileLoader(this._app);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(process.getInputStream(), (DefaultHandler)object);
            xmlHandler = ((XmlFileLoader)object).getHandler();
            if (xmlHandler == null) {
                string = "Null handler";
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        object = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((string3 = ((BufferedReader)object).readLine()) != null) {
            string2 = String.valueOf(string2) + string3 + "\n";
        }
        try {
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {}
        if (string2.length() > 0) {
            string = string2;
        }
        if (string.length() > 0) {
            throw new Exception(string);
        }
        new FileTypeLoader(this._app).loadData(xmlHandler, this.getSourceInfo(), false, null);
    }

    private String[] getCommandArray() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Config.getConfigString("prune.gpsbabelpath");
        arrayList.add(string2);
        boolean bl = this._waypointCheckbox.isSelected();
        boolean bl2 = this._trackCheckbox.isSelected();
        if (bl) {
            arrayList.add("-w");
        }
        if (bl2) {
            arrayList.add("-t");
        }
        arrayList.add("-i");
        arrayList.add(this.getInputFormat());
        arrayList.add("-f");
        arrayList.add(this.getFilePath());
        String string3 = this._filterPanel.getFilterString();
        if (string3 != null && !string3.equals("")) {
            String[] stringArray = string3.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray[n2];
                if (string.length() > 0) {
                    arrayList.add(string);
                }
                ++n2;
            }
        }
        arrayList.add("-o");
        arrayList.add("gpx");
        arrayList.add("-F");
        string = "-";
        if (this._saveCheckbox.isSelected()) {
            this._saveFile = GpxExporter.chooseGpxFile(this._parentFrame, "");
            if (this._saveFile != null) {
                string = this._saveFile.getAbsolutePath();
            }
        }
        arrayList.add(string);
        String[] stringArray = new String[]{};
        return arrayList.toArray(stringArray);
    }

    protected abstract SourceInfo getSourceInfo();

    protected abstract String getFilePath();

    protected abstract String getInputFormat();

    protected abstract void saveConfigValues();
}

