/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceBlockCipherImpl
implements TlsBlockCipherImpl {
    private static final int BUF_SIZE = 32768;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private SecretKey key;

    public JceBlockCipherImpl(Cipher cipher, String string, int n, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = string;
        this.keySize = n;
        this.cipherMode = bl ? 1 : 2;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) {
        if (this.keySize != n2) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    @Override
    public void init(byte[] byArray, int n, int n2) {
        try {
            this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(byArray, n, n2), null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            int n4 = 0;
            while (n2 > 32768) {
                n4 += this.cipher.update(byArray, n, 32768, byArray2, n3 + n4);
                n += 32768;
                n2 -= 32768;
            }
            n4 += this.cipher.update(byArray, n, n2, byArray2, n3 + n4);
            n4 += this.cipher.doFinal(byArray2, n3 + n4);
            return n4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

