/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jcodings.Encoding;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class BuildCompoundStringInstr
extends NOperandResultBaseInstr {
    private final Encoding encoding;
    private final boolean frozen;
    private final String file;
    private final int line;
    private final int estimatedSize;

    public BuildCompoundStringInstr(Variable result2, Operand[] pieces, Encoding encoding2, int estimatedSize, boolean frozen, String file2, int line) {
        super(Operation.BUILD_COMPOUND_STRING, result2, pieces);
        this.encoding = encoding2;
        this.frozen = frozen;
        this.file = file2;
        this.line = line;
        this.estimatedSize = estimatedSize;
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public int getInitialSize() {
        return this.estimatedSize * 3 / 2;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildCompoundStringInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.encoding, this.estimatedSize, this.frozen, this.file, this.line);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
        e.encode(this.encoding);
        e.encode(this.estimatedSize);
        e.encode(this.frozen);
        e.encode(this.file);
        e.encode(this.line);
    }

    public static BuildCompoundStringInstr decode(IRReaderDecoder d) {
        boolean debuggingFrozenStringLiteral = d.getCurrentScope().getManager().getInstanceConfig().isDebuggingFrozenStringLiteral();
        return new BuildCompoundStringInstr(d.decodeVariable(), d.decodeOperandArray(), d.decodeEncoding(), d.decodeInt(), d.decodeBoolean(), d.decodeString(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyString str = RubyString.newStringLight(context.runtime, this.getInitialSize(), this.encoding);
        for (Operand p2 : this.getOperands()) {
            if (p2 instanceof StringLiteral) {
                StringLiteral strLiteral = (StringLiteral)((Object)p2);
                ByteList byteList = strLiteral.getByteList();
                int cr = strLiteral.getCodeRange();
                str.cat(byteList, cr);
                continue;
            }
            IRubyObject pval = (IRubyObject)p2.retrieve(context, self2, currScope, currDynScope, temp);
            str.appendAsDynamicString(pval);
        }
        if (this.frozen) {
            return IRRuntimeHelpers.freezeLiteralString(str);
        }
        return str;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildCompoundStringInstr(this);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }
}

