/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class EQQInstr
extends CallInstr
implements FixedArityInstr {
    private final boolean splattedValue;

    protected EQQInstr(IRScope scope, Variable result2, Operand v1, Operand v2, boolean splattedValue, boolean isPotentiallyRefined, CallSite callSite, long callSiteID) {
        super(scope, Operation.EQQ, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol("==="), v1, new Operand[]{v2}, NullBlock.INSTANCE, 0, isPotentiallyRefined, callSite, callSiteID);
        this.splattedValue = splattedValue;
    }

    public EQQInstr(IRScope scope, Variable result2, Operand v1, Operand v2, boolean splattedValue, boolean isPotentiallyRefined) {
        super(scope, Operation.EQQ, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol("==="), v1, new Operand[]{v2}, NullBlock.INSTANCE, 0, isPotentiallyRefined);
        assert (result2 != null) : "EQQInstr result is null";
        this.splattedValue = splattedValue;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"splat: " + this.splattedValue};
    }

    public boolean isSplattedValue() {
        return this.splattedValue;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new EQQInstr(ii.getScope(), ii.getRenamedVariable(this.result), this.getReceiver().cloneForInlining(ii), this.getArg1().cloneForInlining(ii), this.isSplattedValue(), this.isPotentiallyRefined(), this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.splattedValue);
    }

    public static EQQInstr decode(IRReaderDecoder d) {
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call");
        }
        int callTypeOrdinal = d.decodeInt();
        CallType callType = CallType.fromOrdinal(callTypeOrdinal);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, calltype(ord):  " + (Object)((Object)callType));
        }
        RubySymbol methAddr = d.decodeSymbol();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + methAddr);
        }
        Operand receiver2 = d.decodeOperand();
        d.decodeInt();
        Operand arg1 = d.decodeOperand();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("before result");
        }
        d.decodeInt();
        Variable result2 = d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, result:  " + result2);
        }
        return new EQQInstr(d.getCurrentScope(), result2, receiver2, arg1, d.decodeBoolean(), d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject recv2 = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject value2 = (IRubyObject)this.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.isEQQ(context, recv2, value2, this.callSite, this.isSplattedValue());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.EQQInstr(this);
    }
}

