/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.resource;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.executor.join.MetaSearchResult;
import org.opensearch.sql.legacy.query.join.BackOffRetryStrategy;
import org.opensearch.sql.legacy.query.planner.core.Config;
import org.opensearch.sql.legacy.query.planner.resource.Stats;
import org.opensearch.sql.legacy.query.planner.resource.monitor.Monitor;
import org.opensearch.sql.legacy.query.planner.resource.monitor.TotalMemoryMonitor;

public class ResourceManager {
    private static final Logger LOG = LogManager.getLogger();
    private final List<Monitor> monitors = new ArrayList<Monitor>();
    private final int timeout;
    private final Instant startTime;
    private final MetaSearchResult metaResult;

    public ResourceManager(Stats stats, Config config) {
        this.monitors.add(new TotalMemoryMonitor(stats, config));
        this.timeout = config.timeout();
        this.startTime = Instant.now();
        this.metaResult = new MetaSearchResult();
    }

    public boolean isHealthy() {
        return BackOffRetryStrategy.isHealthy();
    }

    public boolean isTimeout() {
        return Duration.between(this.startTime, Instant.now()).getSeconds() >= (long)this.timeout;
    }

    public MetaSearchResult getMetaResult() {
        return this.metaResult;
    }
}

