/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.rings;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class RingOfEvasion
extends Ring {
    public RingOfEvasion() {
        this.icon = ItemSpriteSheet.Icons.RING_EVASION;
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            String info = Messages.get(this, "stats", Messages.decimalFormat("#.##", 100.0 * (Math.pow(1.125, this.soloBuffedBonus()) - 1.0)));
            if (this.isEquipped(Dungeon.hero) && this.soloBuffedBonus() != RingOfEvasion.combinedBuffedBonus(Dungeon.hero, Evasion.class)) {
                info = info + "\n\n" + Messages.get(this, "combined_stats", Messages.decimalFormat("#.##", 100.0 * (Math.pow(1.125, RingOfEvasion.combinedBuffedBonus(Dungeon.hero, Evasion.class)) - 1.0)));
            }
            return info;
        }
        return Messages.get(this, "typical_stats", Messages.decimalFormat("#.##", 12.5));
    }

    @Override
    protected Ring.RingBuff buff() {
        return new Evasion();
    }

    public static float evasionMultiplier(Char target) {
        return (float)Math.pow(1.125, RingOfEvasion.getBuffedBonus(target, Evasion.class));
    }

    public class Evasion
    extends Ring.RingBuff {
    }
}

