/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLevitation;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;

public class FeatherFall
extends Spell {
    public FeatherFall() {
        this.image = ItemSpriteSheet.FEATHER_FALL;
    }

    @Override
    protected void onCast(Hero hero) {
        Buff.append(hero, FeatherBuff.class, 30.0f);
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/read.mp3");
        hero.sprite.emitter().burst(Speck.factory(106), 20);
        GLog.p(Messages.get(this, "light", new Object[0]), new Object[0]);
        this.detach(FeatherFall.curUser.belongings.backpack);
        FeatherFall.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int value() {
        return (int)(70.0f * ((float)this.quantity / 2.0f));
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfLevitation.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 8;
            this.output = FeatherFall.class;
            this.outQuantity = 2;
        }
    }

    public static class FeatherBuff
    extends FlavourBuff {
        public static final float DURATION = 30.0f;

        public FeatherBuff() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 1;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 2.0f, 1.25f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (30.0f - this.visualcooldown()) / 30.0f);
        }
    }
}

