/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MonkEnergy;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Flail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.HeroIcon;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class MeleeWeapon
extends Weapon {
    public static String AC_ABILITY = "ABILITY";
    public int tier;
    private static boolean evaluatingTwinUpgrades = false;

    @Override
    public void activate(Char ch) {
        super.activate(ch);
        if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.DUELIST) {
            Buff.affect(ch, Charger.class);
        }
    }

    @Override
    public String defaultAction() {
        if (Dungeon.hero != null && (Dungeon.hero.heroClass == HeroClass.DUELIST || Dungeon.hero.hasTalent(Talent.SWIFT_EQUIP))) {
            return AC_ABILITY;
        }
        return super.defaultAction();
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero) && hero.heroClass == HeroClass.DUELIST) {
            actions.add(AC_ABILITY);
        }
        return actions;
    }

    @Override
    public String actionName(String action, Hero hero) {
        if (action.equals(AC_ABILITY)) {
            return Messages.upperCase(Messages.get(this, "ability_name", new Object[0]));
        }
        return super.actionName(action, hero);
    }

    @Override
    public void execute(final Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_ABILITY)) {
            this.usesTargeting = false;
            if (!this.isEquipped(hero)) {
                if (hero.hasTalent(Talent.SWIFT_EQUIP)) {
                    if (hero.buff(Talent.SwiftEquipCooldown.class) == null || hero.buff(Talent.SwiftEquipCooldown.class).hasSecondUse()) {
                        this.execute(hero, "EQUIP");
                    } else if (hero.heroClass == HeroClass.DUELIST) {
                        GLog.w(Messages.get(this, "ability_need_equip", new Object[0]), new Object[0]);
                    }
                } else if (hero.heroClass == HeroClass.DUELIST) {
                    GLog.w(Messages.get(this, "ability_need_equip", new Object[0]), new Object[0]);
                }
            } else if (hero.heroClass == HeroClass.DUELIST) {
                if (this.STRReq() > hero.STR()) {
                    GLog.w(Messages.get(this, "ability_low_str", new Object[0]), new Object[0]);
                } else if (hero.belongings.weapon == this && (float)Buff.affect((Char)hero, Charger.class).charges + Buff.affect((Char)hero, Charger.class).partialCharge < this.abilityChargeUse(hero, null)) {
                    GLog.w(Messages.get(this, "ability_no_charge", new Object[0]), new Object[0]);
                } else if (hero.belongings.secondWep == this && (float)Buff.affect((Char)hero, Charger.class).secondCharges + Buff.affect((Char)hero, Charger.class).secondPartialCharge < this.abilityChargeUse(hero, null)) {
                    GLog.w(Messages.get(this, "ability_no_charge", new Object[0]), new Object[0]);
                } else if (this.targetingPrompt() == null) {
                    this.duelistAbility(hero, hero.pos);
                    MeleeWeapon.updateQuickslot();
                } else {
                    this.usesTargeting = this.useTargeting();
                    GameScene.selectCell(new CellSelector.Listener(){

                        @Override
                        public void onSelect(Integer cell) {
                            if (cell != null) {
                                MeleeWeapon.this.duelistAbility(hero, cell);
                                Item.updateQuickslot();
                            }
                        }

                        @Override
                        public String prompt() {
                            return MeleeWeapon.this.targetingPrompt();
                        }
                    });
                }
            }
        }
    }

    @Override
    public boolean doEquip(Hero hero) {
        if (super.doEquip(hero)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean equipSecondary(Hero hero) {
        if (super.equipSecondary(hero)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    public String targetingPrompt() {
        return null;
    }

    public boolean useTargeting() {
        return this.targetingPrompt() != null;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return dst;
    }

    protected void duelistAbility(Hero hero, Integer target) {
    }

    protected void beforeAbilityUsed(Hero hero, Char target) {
        hero.belongings.abilityWeapon = this;
        Charger charger = Buff.affect(hero, Charger.class);
        if (Dungeon.hero.belongings.weapon == this) {
            charger.partialCharge -= this.abilityChargeUse(hero, target);
            while (charger.partialCharge < 0.0f && charger.charges > 0) {
                --charger.charges;
                charger.partialCharge += 1.0f;
            }
        } else {
            charger.secondPartialCharge -= this.abilityChargeUse(hero, target);
            while (charger.secondPartialCharge < 0.0f && charger.secondCharges > 0) {
                --charger.secondCharges;
                charger.secondPartialCharge += 1.0f;
            }
        }
        if (hero.heroClass == HeroClass.DUELIST && hero.hasTalent(Talent.AGGRESSIVE_BARRIER) && (float)hero.HP / (float)hero.HT < 0.2f * (float)(1 + hero.pointsInTalent(Talent.AGGRESSIVE_BARRIER))) {
            Buff.affect(hero, Barrier.class).setShield(3);
        }
        if (hero.buff(Talent.CombinedLethalityAbilityTracker.class) != null && hero.buff(Talent.CombinedLethalityAbilityTracker.class).weapon != null && hero.buff(Talent.CombinedLethalityAbilityTracker.class).weapon != this) {
            Buff.affect(hero, Talent.CombinedLethalityTriggerTracker.class, 5.0f);
        }
        MeleeWeapon.updateQuickslot();
    }

    protected void afterAbilityUsed(Hero hero) {
        FlavourBuff tracker;
        hero.belongings.abilityWeapon = null;
        if (hero.hasTalent(Talent.PRECISE_ASSAULT)) {
            Buff.prolong(hero, Talent.PreciseAssaultTracker.class, hero.cooldown() + 4.0f);
        }
        if (hero.hasTalent(Talent.COMBINED_LETHALITY)) {
            tracker = hero.buff(Talent.CombinedLethalityAbilityTracker.class);
            if (tracker == null || ((Talent.CombinedLethalityAbilityTracker)tracker).weapon == this || ((Talent.CombinedLethalityAbilityTracker)tracker).weapon == null) {
                Buff.affect((Char)hero, Talent.CombinedLethalityAbilityTracker.class, (float)hero.cooldown()).weapon = this;
            } else {
                tracker.detach();
            }
        }
        if (hero.hasTalent(Talent.COMBINED_ENERGY)) {
            tracker = hero.buff(Talent.CombinedEnergyAbilityTracker.class);
            if (tracker == null || ((Talent.CombinedEnergyAbilityTracker)tracker).energySpent == -1) {
                Buff.prolong((Char)hero, Talent.CombinedEnergyAbilityTracker.class, (float)hero.cooldown()).wepAbilUsed = true;
            } else {
                ((Talent.CombinedEnergyAbilityTracker)tracker).wepAbilUsed = true;
                Buff.affect(hero, MonkEnergy.class).processCombinedEnergy((Talent.CombinedEnergyAbilityTracker)tracker);
            }
        }
        if (hero.buff(Talent.CounterAbilityTacker.class) != null) {
            hero.buff(Talent.CounterAbilityTacker.class).detach();
        }
    }

    public static void onAbilityKill(Hero hero, Char killed) {
        if (killed.alignment == Char.Alignment.ENEMY && hero.hasTalent(Talent.LETHAL_HASTE)) {
            Buff.prolong(hero, Haste.class, 1.67f + (float)hero.pointsInTalent(Talent.LETHAL_HASTE));
        }
    }

    protected int baseChargeUse(Hero hero, Char target) {
        return 1;
    }

    public final float abilityChargeUse(Hero hero, Char target) {
        float chargeUse = this.baseChargeUse(hero, target);
        if (hero.buff(Talent.CounterAbilityTacker.class) != null) {
            chargeUse = Math.max(0.0f, chargeUse - 0.5f * (float)hero.pointsInTalent(Talent.COUNTER_ABILITY));
        }
        return chargeUse;
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 5 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    @Override
    public int STRReq(int lvl) {
        return MeleeWeapon.STRReq(this.tier, lvl);
    }

    @Override
    public int buffedLvl() {
        if (!evaluatingTwinUpgrades && this.isEquipped(Dungeon.hero) && Dungeon.hero.hasTalent(Talent.TWIN_UPGRADES)) {
            KindOfWeapon other = null;
            if (Dungeon.hero.belongings.weapon() != this) {
                other = Dungeon.hero.belongings.weapon();
            }
            if (Dungeon.hero.belongings.secondWep() != this) {
                other = Dungeon.hero.belongings.secondWep();
            }
            if (other instanceof MeleeWeapon) {
                evaluatingTwinUpgrades = true;
                int otherLevel = other.buffedLvl();
                evaluatingTwinUpgrades = false;
                if (this.tier + (3 - Dungeon.hero.pointsInTalent(Talent.TWIN_UPGRADES)) <= ((MeleeWeapon)other).tier && otherLevel > super.buffedLvl()) {
                    return otherLevel;
                }
            }
        }
        return super.buffedLvl();
    }

    @Override
    public float accuracyFactor(Char owner, Char target) {
        float ACC = super.accuracyFactor(owner, target);
        if (owner instanceof Hero && ((Hero)owner).hasTalent(Talent.PRECISE_ASSAULT) && ((Hero)owner).belongings.abilityWeapon != this) {
            if (((Hero)owner).heroClass != HeroClass.DUELIST) {
                ACC *= 1.0f + 0.1f * (float)((Hero)owner).pointsInTalent(Talent.PRECISE_ASSAULT);
            } else if (!(this instanceof Flail && owner.buff(Flail.SpinAbilityTracker.class) != null || owner.buff(Talent.PreciseAssaultTracker.class) == null)) {
                ACC = (float)((double)ACC * Math.pow(2.0, ((Hero)owner).pointsInTalent(Talent.PRECISE_ASSAULT)));
                owner.buff(Talent.PreciseAssaultTracker.class).detach();
            }
        }
        return ACC;
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    public String info() {
        String info = this.desc();
        if (this.levelKnown) {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_known", this.tier, this.augment.damageFactor(this.min()), this.augment.damageFactor(this.max()), this.STRReq());
            if (this.STRReq() > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
            } else if (Dungeon.hero.STR() > this.STRReq()) {
                info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
            }
        } else {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_unknown", this.tier, this.min(0), this.max(0), this.STRReq(0));
            if (this.STRReq(0) > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(MeleeWeapon.class, "probably_too_heavy", new Object[0]);
            }
        }
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        switch (this.augment) {
            case SPEED: {
                info = info + " " + Messages.get(Weapon.class, "faster", new Object[0]);
                break;
            }
            case DAMAGE: {
                info = info + " " + Messages.get(Weapon.class, "stronger", new Object[0]);
                break;
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.capitalize(Messages.get(Weapon.class, "enchanted", this.enchantment.name()));
            if (this.enchantHardened) {
                info = info + " " + Messages.get(Weapon.class, "enchant_hardened", new Object[0]);
            }
            info = info + " " + this.enchantment.desc();
        } else if (this.enchantHardened) {
            info = info + "\n\n" + Messages.get(Weapon.class, "hardened_no_enchant", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = this.enchantment != null && this.enchantment.curse() ? info + "\n\n" + Messages.get(Weapon.class, "weak_cursed", new Object[0]) : info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        if (Dungeon.hero.heroClass == HeroClass.DUELIST && !(this instanceof MagesStaff)) {
            info = info + "\n\n" + Messages.get(this, "ability_desc", new Object[0]);
        }
        return info;
    }

    public String statsInfo() {
        return Messages.get(this, "stats_desc", new Object[0]);
    }

    @Override
    public String status() {
        if (this.isEquipped(Dungeon.hero) && Dungeon.hero.buff(Charger.class) != null) {
            Charger buff = Dungeon.hero.buff(Charger.class);
            if (Dungeon.hero.belongings.weapon == this) {
                return buff.charges + "/" + buff.chargeCap();
            }
            return buff.secondCharges + "/" + buff.secondChargeCap();
        }
        return super.status();
    }

    @Override
    public int value() {
        int price = 20 * this.tier;
        if (this.hasGoodEnchant()) {
            price = (int)((double)price * 1.5);
        }
        if (this.cursedKnown && (this.cursed || this.hasCurseEnchant())) {
            price /= 2;
        }
        if (this.levelKnown && this.level() > 0) {
            price *= this.level() + 1;
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    public static class Charger
    extends Buff
    implements ActionIndicator.Action {
        public int charges = 3;
        public float partialCharge;
        public int secondCharges = 3;
        public float secondPartialCharge;
        public static final String CHARGES = "charges";
        private static final String PARTIALCHARGE = "partialCharge";
        public static final String SECOND_CHARGES = "second_charges";
        private static final String SECOND_PARTIALCHARGE = "second_partialCharge";

        @Override
        public boolean act() {
            if (this.charges < this.chargeCap()) {
                int points;
                if (Regeneration.regenOn()) {
                    this.partialCharge += 1.0f / (40.0f - (float)(this.chargeCap() - this.charges));
                }
                if ((points = ((Hero)this.target).pointsInTalent(Talent.WEAPON_RECHARGING)) > 0 && this.target.buff(Recharging.class) != null || this.target.buff(ArtifactRecharge.class) != null) {
                    this.partialCharge += 1.0f / (14.0f - 4.0f * (float)points);
                }
                if (this.partialCharge >= 1.0f) {
                    ++this.charges;
                    this.partialCharge -= 1.0f;
                    Item.updateQuickslot();
                }
            } else {
                this.partialCharge = 0.0f;
            }
            if (Dungeon.hero.subClass == HeroSubClass.CHAMPION && this.secondCharges < this.secondChargeCap()) {
                if (Regeneration.regenOn()) {
                    this.secondPartialCharge += this.secondChargeMultiplier() / (40.0f - (float)(this.secondChargeCap() - this.secondCharges));
                }
                if (this.secondPartialCharge >= 1.0f) {
                    ++this.secondCharges;
                    this.secondPartialCharge -= 1.0f;
                    Item.updateQuickslot();
                }
            } else {
                this.secondPartialCharge = 0.0f;
            }
            if (ActionIndicator.action != this && Dungeon.hero.subClass == HeroSubClass.CHAMPION) {
                ActionIndicator.setAction(this);
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void fx(boolean on) {
            if (on && Dungeon.hero.subClass == HeroSubClass.CHAMPION) {
                ActionIndicator.setAction(this);
            }
        }

        @Override
        public void detach() {
            super.detach();
            ActionIndicator.clearAction(this);
        }

        public int chargeCap() {
            return Math.min(10, 3 + (Dungeon.hero.lvl - 1) / 3);
        }

        public int secondChargeCap() {
            return Math.round((float)this.chargeCap() * this.secondChargeMultiplier());
        }

        public float secondChargeMultiplier() {
            return 0.5f + 0.0834f * (float)Dungeon.hero.pointsInTalent(Talent.SECONDARY_CHARGE);
        }

        public void gainCharge(float charge) {
            if (this.charges < this.chargeCap()) {
                this.partialCharge += charge;
                while (this.partialCharge >= 1.0f) {
                    ++this.charges;
                    this.partialCharge -= 1.0f;
                }
                this.charges = Math.min(this.charges, this.chargeCap());
                Item.updateQuickslot();
            }
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(CHARGES, this.charges);
            bundle.put(PARTIALCHARGE, this.partialCharge);
            bundle.put(SECOND_CHARGES, this.secondCharges);
            bundle.put(SECOND_PARTIALCHARGE, this.secondPartialCharge);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.charges = bundle.getInt(CHARGES);
            this.partialCharge = bundle.getFloat(PARTIALCHARGE);
            this.secondCharges = bundle.getInt(SECOND_CHARGES);
            this.secondPartialCharge = bundle.getFloat(SECOND_PARTIALCHARGE);
        }

        @Override
        public String actionName() {
            return Messages.get(MeleeWeapon.class, "swap", new Object[0]);
        }

        @Override
        public int actionIcon() {
            return 37;
        }

        @Override
        public Visual primaryVisual() {
            Image ico = Dungeon.hero.belongings.weapon == null ? new HeroIcon(this) : new ItemSprite(Dungeon.hero.belongings.weapon);
            ico.width += 4.0f;
            return ico;
        }

        @Override
        public Visual secondaryVisual() {
            Image ico = Dungeon.hero.belongings.secondWep == null ? new HeroIcon(this) : new ItemSprite(Dungeon.hero.belongings.secondWep);
            ico.scale.set(PixelScene.align(0.51f));
            ico.brightness(0.6f);
            return ico;
        }

        @Override
        public int indicatorColor() {
            return 0x5500BB;
        }

        @Override
        public void doAction() {
            if (Dungeon.hero.subClass != HeroSubClass.CHAMPION) {
                return;
            }
            if (Dungeon.hero.belongings.secondWep == null && Dungeon.hero.belongings.backpack.items.size() >= Dungeon.hero.belongings.backpack.capacity()) {
                GLog.w(Messages.get(MeleeWeapon.class, "swap_full", new Object[0]), new Object[0]);
                return;
            }
            KindOfWeapon temp = Dungeon.hero.belongings.weapon;
            Dungeon.hero.belongings.weapon = Dungeon.hero.belongings.secondWep;
            Dungeon.hero.belongings.secondWep = temp;
            Dungeon.hero.sprite.operate(Dungeon.hero.pos);
            Sample.INSTANCE.play("sounds/unlock.mp3");
            ActionIndicator.setAction(this);
            Item.updateQuickslot();
            AttackIndicator.updateState();
        }
    }
}

