/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ComponentInfoWithAnnotation;
import org.eclipse.jdt.internal.compiler.classfmt.ComponentInfoWithTypeAnnotation;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.impl.Constant;

public class RecordComponentInfo
extends ClassFileStruct
implements IRecordComponent,
Comparable {
    protected int attributeBytes;
    protected char[] descriptor;
    protected char[] name;
    protected char[] signature;
    protected int signatureUtf8Offset = -1;
    protected long tagBits;
    protected long version;

    public static RecordComponentInfo createComponent(byte[] byArray, int[] nArray, int n, long l) {
        RecordComponentInfo recordComponentInfo = new RecordComponentInfo(byArray, nArray, n, l);
        int n2 = recordComponentInfo.u2At(4);
        int n3 = 6;
        ClassFileStruct[] classFileStructArray = null;
        ClassFileStruct[] classFileStructArray2 = null;
        for (int i = 0; i < n2; ++i) {
            int n4 = recordComponentInfo.constantPoolOffsets[recordComponentInfo.u2At(n3)] - recordComponentInfo.structOffset;
            char[] cArray = recordComponentInfo.utf8At(n4 + 3, recordComponentInfo.u2At(n4 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        recordComponentInfo.signatureUtf8Offset = recordComponentInfo.constantPoolOffsets[recordComponentInfo.u2At(n3 + 6)] - recordComponentInfo.structOffset;
                        break;
                    }
                    case 'R': {
                        ClassFileStruct[] classFileStructArray3;
                        int n5;
                        AnnotationInfo[] annotationInfoArray = null;
                        TypeAnnotationInfo[] typeAnnotationInfoArray = null;
                        if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            annotationInfoArray = recordComponentInfo.decodeAnnotations(n3, true);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            annotationInfoArray = recordComponentInfo.decodeAnnotations(n3, false);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = recordComponentInfo.decodeTypeAnnotations(n3, true);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = recordComponentInfo.decodeTypeAnnotations(n3, false);
                        }
                        if (annotationInfoArray != null) {
                            if (classFileStructArray == null) {
                                classFileStructArray = annotationInfoArray;
                                break;
                            }
                            n5 = classFileStructArray.length;
                            classFileStructArray3 = new AnnotationInfo[n5 + annotationInfoArray.length];
                            System.arraycopy(classFileStructArray, 0, classFileStructArray3, 0, n5);
                            System.arraycopy(annotationInfoArray, 0, classFileStructArray3, n5, annotationInfoArray.length);
                            classFileStructArray = classFileStructArray3;
                            break;
                        }
                        if (typeAnnotationInfoArray == null) break;
                        if (classFileStructArray2 == null) {
                            classFileStructArray2 = typeAnnotationInfoArray;
                            break;
                        }
                        n5 = classFileStructArray2.length;
                        classFileStructArray3 = new TypeAnnotationInfo[n5 + typeAnnotationInfoArray.length];
                        System.arraycopy(classFileStructArray2, 0, classFileStructArray3, 0, n5);
                        System.arraycopy(typeAnnotationInfoArray, 0, classFileStructArray3, n5, typeAnnotationInfoArray.length);
                        classFileStructArray2 = classFileStructArray3;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + recordComponentInfo.u4At(n3 + 2)));
        }
        recordComponentInfo.attributeBytes = n3;
        if (classFileStructArray2 != null) {
            return new ComponentInfoWithTypeAnnotation(recordComponentInfo, (AnnotationInfo[])classFileStructArray, (TypeAnnotationInfo[])classFileStructArray2);
        }
        if (classFileStructArray != null) {
            return new ComponentInfoWithAnnotation(recordComponentInfo, (AnnotationInfo[])classFileStructArray);
        }
        return recordComponentInfo;
    }

    protected RecordComponentInfo(byte[] byArray, int[] nArray, int n, long l) {
        super(byArray, nArray, n);
        this.version = l;
    }

    private AnnotationInfo[] decodeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            AnnotationInfo[] annotationInfoArray = null;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                AnnotationInfo annotationInfo = new AnnotationInfo(this.reference, this.constantPoolOffsets, n3 + this.structOffset, bl, false);
                n3 += annotationInfo.readOffset;
                long l = annotationInfo.standardAnnotationTagBits;
                if (l != 0L) {
                    this.tagBits |= l;
                    if (this.version < 0x350000L || (l & 0x400000000000L) == 0L) continue;
                }
                if (annotationInfoArray == null) {
                    annotationInfoArray = new AnnotationInfo[n2 - i];
                }
                annotationInfoArray[n4++] = annotationInfo;
            }
            if (annotationInfoArray != null) {
                if (n4 != annotationInfoArray.length) {
                    AnnotationInfo[] annotationInfoArray2 = annotationInfoArray;
                    annotationInfoArray = new AnnotationInfo[n4];
                    System.arraycopy(annotationInfoArray2, 0, annotationInfoArray, 0, n4);
                }
                return annotationInfoArray;
            }
        }
        return null;
    }

    TypeAnnotationInfo[] decodeTypeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            TypeAnnotationInfo[] typeAnnotationInfoArray = new TypeAnnotationInfo[n2];
            for (int i = 0; i < n2; ++i) {
                TypeAnnotationInfo typeAnnotationInfo = new TypeAnnotationInfo(this.reference, this.constantPoolOffsets, n3 + this.structOffset, bl, false);
                n3 += typeAnnotationInfo.readOffset;
                typeAnnotationInfoArray[i] = typeAnnotationInfo;
            }
            return typeAnnotationInfoArray;
        }
        return null;
    }

    public int compareTo(Object object) {
        return new String(this.getName()).compareTo(new String(((RecordComponentInfo)object).getName()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordComponentInfo)) {
            return false;
        }
        return CharOperation.equals(this.getName(), ((RecordComponentInfo)object).getName());
    }

    public int hashCode() {
        return CharOperation.hashCode(this.getName());
    }

    @Override
    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    @Override
    public char[] getName() {
        if (this.name == null) {
            int n = this.constantPoolOffsets[this.u2At(0)] - this.structOffset;
            this.name = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.name;
    }

    @Override
    public long getTagBits() {
        return this.tagBits;
    }

    @Override
    public char[] getTypeName() {
        if (this.descriptor == null) {
            int n = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.descriptor = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.descriptor;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    protected void initialize() {
        this.getName();
        this.getTypeName();
        this.getGenericSignature();
        this.reset();
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(29);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        stringBuffer.append('{').append(this.getTypeName()).append(' ').append(this.getName()).append(' ').append('}').toString();
    }

    @Override
    public Constant getConstant() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 0;
    }
}

