/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.interceptor;

import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import java.io.Serializable;
import java.util.Arrays;

public class ParametersKey
implements Serializable {
    public static final ParametersKey ZERO_ARG_KEY = new ParametersKey(new Object[0]);
    private final Object[] params;
    private final int hashCode;

    public ParametersKey(Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            this.params = ArrayUtils.EMPTY_OBJECT_ARRAY;
            this.hashCode = ClassUtils.EMPTY_OBJECT_ARRAY_HASH_CODE;
        } else {
            this.params = new Object[params.length];
            System.arraycopy(params, 0, this.params, 0, params.length);
            this.hashCode = Arrays.deepHashCode(this.params);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ParametersKey && Arrays.deepEquals(this.params, ((ParametersKey)o).params);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return ParametersKey.class.getSimpleName() + ": " + ArrayUtils.toString((Object[])this.params);
    }
}

