### Copyright  (C) 2019 Intel Corporation. All rights reserved.
###
### The information and source code contained herein is the exclusive
### property of Intel Corporation and may not be disclosed, examined
### or reproduced in whole or in part without explicit written authorization
### from the company.
###
###

# Definition file for
#   host:    Linux
#   target:  Android

include(def_util)
def_init_install_subsets()

#compiler header files common for 64/32 bit targets
if (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)
  set( compiler_header_files
        complex
        complex.h
        dvec.h
        fenv.h
        float.h
        fvec.h
        ivec.h
        limits.h
        math_common_define.h
        math_common_undefine.h
        math.h
        mathimf.h
        sse2mmx.h
        tbk_traceback.h
        xmm_func.h
        xmm_utils.h )

  def_add_install_subset( cmplr_headers INC
        SRCDIR "efi2/linux_test/include"
        INSTDIR "compiler/include"
        ${compiler_header_files} )

endif() # (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)

if (DO_COPY_EFI2_TARGET_FILES)

  set( lib64_files
        libimf.so
        libintlc.so.5 )

  def_add_install_subset( lib_intel64 LIB
        SRCDIR "efi2/linux_test/lib_lin"
        INSTDIR "compiler/lib/intel64_lin"
        ${lib64_files} )

  set( lib64and_files
        Copyrights.txt
        Notices.txt
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf.so
        libintlc.so
        libipgo.a
        libirc.a
        libirc.so
        libirc_s.a
        libirng.a
        libirng.so
        libsvml.a
        libsvml.so )

  def_add_install_subset( lib_intel64and LIB
        SRCDIR "efi2/linux_test/lib_and"
        INSTDIR "compiler/lib/intel64_and"
        ${lib64and_files} )

endif (DO_COPY_EFI2_TARGET_FILES)

if (DO_COPY_IA32_TARGET_FILES)

  set( lib32and_files
        Copyrights.txt
        Notices.txt
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf.so
        libimf_pic.a
        libintlc.so
        libipgo.a
        libipgo_pic.a
        libirc.a
        libirc.so
        libirc_pic.a
        libirc_s.a
        libirc_s_pic.a
        libirng.a
        libirng.so
        libsvml.a
        libsvml.so )

  def_add_install_subset( lib_ia32and LIB
        SRCDIR "ia32/linux_RH7.1_test/lib_and"
        INSTDIR "compiler/lib/ia32_and"
        ${lib32and_files} )

endif(DO_COPY_IA32_TARGET_FILES)

def_add_install_targets()

