/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.collections.IntList;

public class CoverageModule {
    @JRubyMethod(module=true, optional=1, keywords=true, checkArity=false)
    public static IRubyObject setup(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        Ruby runtime2 = context.runtime;
        int mode2 = 0;
        CoverageData data2 = runtime2.getCoverageData();
        if (data2.getCurrentState() != CoverageData.CoverageDataState.IDLE) {
            throw runtime2.newRuntimeError("coverage measurement is already setup");
        }
        if (argc != 0) {
            boolean keyword = ThreadContext.hasKeywords(context.resetCallInfo());
            if (keyword) {
                RubyHash keywords = (RubyHash)TypeConverter.convertToType(args2[0], runtime2.getHash(), "to_hash");
                if (ArgsUtil.extractKeywordArg(context, "lines", keywords).isTrue()) {
                    mode2 |= 1;
                }
                if (ArgsUtil.extractKeywordArg(context, "branches", keywords).isTrue()) {
                    runtime2.getWarnings().warn("branch coverage is not supported");
                    mode2 |= 2;
                }
                if (ArgsUtil.extractKeywordArg(context, "methods", keywords).isTrue()) {
                    runtime2.getWarnings().warn("method coverage is not supported");
                    mode2 |= 4;
                }
                if (ArgsUtil.extractKeywordArg(context, "oneshot_lines", keywords).isTrue()) {
                    if ((mode2 & 1) != 0) {
                        throw runtime2.newRuntimeError("cannot enable lines and oneshot_lines simultaneously");
                    }
                    mode2 |= 1;
                    mode2 |= 8;
                }
            } else if (args2[0] instanceof RubySymbol && args2[0] == runtime2.newSymbol("all")) {
                mode2 |= 7;
            }
        }
        int currentMode = mode2;
        if (data2.getCoverage() == null) {
            if (mode2 == 0) {
                mode2 |= 1;
            }
            data2.setCoverage(mode2, currentMode, CoverageData.CoverageDataState.SUSPENDED);
        } else if (currentMode != data2.getCurrentMode()) {
            throw runtime2.newRuntimeError("cannot change the measuring target during coverage measurement");
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject resume(ThreadContext context, IRubyObject self2) {
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() == CoverageData.CoverageDataState.IDLE) {
            throw context.runtime.newRuntimeError("coverage measurement is not set up yet");
        }
        if (data2.getCurrentState() == CoverageData.CoverageDataState.RUNNING) {
            throw context.runtime.newRuntimeError("coverage measurement is already running");
        }
        data2.resumeCoverage();
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject suspend(ThreadContext context, IRubyObject self2) {
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() != CoverageData.CoverageDataState.RUNNING) {
            throw context.runtime.newRuntimeError("coverage measurement is not running");
        }
        data2.suspendCoverage();
        return context.nil;
    }

    @JRubyMethod(module=true, optional=1, keywords=true, checkArity=false)
    public static IRubyObject start(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        CoverageModule.setup(context, self2, args2);
        CoverageModule.resume(context, self2);
        return context.nil;
    }

    @JRubyMethod(module=true, optional=1, keywords=true, checkArity=false)
    public static IRubyObject result(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        Ruby runtime2 = context.runtime;
        CoverageData data2 = runtime2.getCoverageData();
        if (data2.getCurrentState() == CoverageData.CoverageDataState.IDLE) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        boolean stop2 = true;
        boolean clear2 = true;
        if (argc > 0 && ThreadContext.hasKeywords(context.resetCallInfo())) {
            RubyHash keywords = (RubyHash)TypeConverter.convertToType(args2[0], runtime2.getHash(), "to_hash");
            stop2 = ArgsUtil.extractKeywordArg(context, "stop", keywords).isTrue();
            clear2 = ArgsUtil.extractKeywordArg(context, "clear", keywords).isTrue();
        }
        IRubyObject result2 = CoverageModule.peek_result(context, self2);
        if (stop2 && !clear2) {
            runtime2.getWarnings().warn("stop implies clear");
            clear2 = true;
        }
        if (clear2) {
            data2.clearCoverage();
        }
        if (stop2) {
            if (data2.getCurrentState() == CoverageData.CoverageDataState.RUNNING) {
                data2.suspendCoverage();
            }
            data2.resetCoverage();
            data2.setCurrentState(CoverageData.CoverageDataState.IDLE);
        }
        return result2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject peek_result(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        CoverageData coverageData = runtime2.getCoverageData();
        if (!coverageData.isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        return CoverageModule.convertCoverageToRuby(context, runtime2, coverageData.getCoverage(), coverageData.getCurrentMode());
    }

    @JRubyMethod(name={"running?"}, module=true)
    public static IRubyObject running_p(ThreadContext context, IRubyObject self2) {
        return context.runtime.getCoverageData().getCurrentState() == CoverageData.CoverageDataState.RUNNING ? context.tru : context.fals;
    }

    @JRubyMethod(module=true)
    public static IRubyObject state(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        switch (runtime2.getCoverageData().getCurrentState()) {
            case IDLE: {
                return runtime2.newSymbol("idle");
            }
            case SUSPENDED: {
                return runtime2.newSymbol("suspended");
            }
            case RUNNING: {
                return runtime2.newSymbol("running");
            }
        }
        return context.nil;
    }

    private static IRubyObject convertCoverageToRuby(ThreadContext context, Ruby runtime2, Map<String, IntList> coverage2, int mode2) {
        RubyHash covHash = RubyHash.newHash(runtime2);
        if (coverage2 != null) {
            for (Map.Entry<String, IntList> entry : coverage2.entrySet()) {
                IntList val = entry.getValue();
                boolean oneshot = (mode2 & 8) != 0;
                RubyArray ary = RubyArray.newArray(runtime2, val.size());
                for (int i2 = 0; i2 < val.size(); ++i2) {
                    int integer = val.get(i2);
                    if (oneshot) {
                        ary.push(runtime2.newFixnum(integer + 1));
                        continue;
                    }
                    ary.store(i2, integer == -1 ? context.nil : runtime2.newFixnum(integer));
                }
                RubyString key2 = RubyString.newString(runtime2, entry.getKey());
                RubyObject value2 = ary;
                if (mode2 != 0) {
                    RubyHash oneshotHash = RubyHash.newSmallHash(runtime2);
                    RubySymbol linesKey = runtime2.newSymbol(oneshot ? "oneshot_lines" : "lines");
                    oneshotHash.fastASetSmall(linesKey, ary);
                    value2 = oneshotHash;
                }
                covHash.fastASetCheckString(runtime2, key2, value2);
            }
        }
        return covHash;
    }
}

